/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.debugmgr.ExecutionEvent;
import bluej.extensions2.ExtensionBridge;
import bluej.extensions2.ExternalFileLauncher;
import bluej.extensions2.event.ExtensionEvent;
import bluej.extensions2.event.InvocationFinishedEvent;
import bluej.extensions2.event.PackageEvent;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionPrefManager;
import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.ExtensionsDialog;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.javafx.FXPlatformSupplier;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;

public class ExtensionsManager
implements BlueJEventListener {
    private static ExtensionsManager instance;
    private List<ExtensionWrapper> extensions = new ArrayList<ExtensionWrapper>();
    private ExtensionPrefManager prefManager = null;

    public static synchronized ExtensionsManager getInstance() {
        if (instance == null) {
            instance = new ExtensionsManager();
            instance.loadExtensions();
        }
        return instance;
    }

    private ExtensionsManager() {
        BlueJEvent.addListener(this);
    }

    private void loadExtensions() {
        File systemDir = new File(Config.getBlueJLibDir(), "extensions2");
        String dirPath = Config.getPropString("bluej.extensions.systempath", null);
        if (dirPath != null) {
            systemDir = new File(dirPath);
        }
        this.loadDirectoryExtensions(systemDir, null);
        this.loadDirectoryExtensions(Config.getUserConfigFile("extensions2"), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadExtensions() {
        List<ExtensionWrapper> list = this.extensions;
        synchronized (list) {
            Iterator<ExtensionWrapper> iter = this.extensions.iterator();
            while (iter.hasNext()) {
                ExtensionWrapper aWrapper = iter.next();
                aWrapper.terminate();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDirectoryExtensions(File directory, Project project) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (int index = 0; index < files.length; ++index) {
            ExtensionWrapper aWrapper;
            File thisFile = files[index];
            if (thisFile.isDirectory() || !thisFile.getName().endsWith(".jar") || Config.isGreenfoot() || !(aWrapper = new ExtensionWrapper(this.getPrefManager(), thisFile)).isJarValid() || this.isWrapperAlreadyLoaded(aWrapper)) continue;
            aWrapper.newExtension(project);
            if (!aWrapper.isValid()) continue;
            List<ExtensionWrapper> list = this.extensions;
            synchronized (list) {
                this.extensions.add(aWrapper);
                continue;
            }
        }
        this.getPrefManager().panelRevalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWrapperAlreadyLoaded(ExtensionWrapper thisWrapper) {
        String thisClassName = thisWrapper.getExtensionClassName();
        String thisJarName = thisWrapper.getExtensionFileName();
        List<ExtensionWrapper> list = this.extensions;
        synchronized (list) {
            for (ExtensionWrapper aWrapper : this.extensions) {
                String aClassName = aWrapper.getExtensionClassName();
                if (aClassName == null || !thisClassName.equals(aClassName)) continue;
                Debug.message("Extension is already loaded: " + thisClassName + " jarName=" + thisJarName);
                return true;
            }
        }
        return false;
    }

    public ExtensionPrefManager getPrefManager() {
        if (this.prefManager == null) {
            this.prefManager = new ExtensionPrefManager(this.extensions);
        }
        return this.prefManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showHelp(FXPlatformSupplier<Window> parentFrame) {
        ArrayList<ExtensionWrapper> extensionsList = new ArrayList<ExtensionWrapper>();
        List<ExtensionWrapper> list = this.extensions;
        synchronized (list) {
            extensionsList.addAll(this.extensions);
        }
        ExtensionsDialog dialog = new ExtensionsDialog(extensionsList, parentFrame);
        Platform.runLater(dialog::showAndWait);
    }

    public void projectOpening(Project project) {
        File exts = new File(project.getProjectDir(), "extensions2");
        this.loadDirectoryExtensions(exts, project);
    }

    public void packageOpened(Package pkg) {
        this.delegateEvent(new PackageEvent(PackageEvent.EventType.PACKAGE_OPENED, pkg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packageClosing(Package pkg) {
        this.delegateEvent(new PackageEvent(PackageEvent.EventType.PACKAGE_CLOSING, pkg));
        boolean invalidateExtension = false;
        Project thisProject = pkg.getProject();
        if (thisProject == null) {
            return;
        }
        PkgMgrFrame[] frameArray = PkgMgrFrame.getAllProjectFrames(thisProject);
        if (frameArray == null) {
            invalidateExtension = true;
        } else {
            boolean bl = invalidateExtension = frameArray.length <= 1;
        }
        if (!invalidateExtension) {
            return;
        }
        List<ExtensionWrapper> list = this.extensions;
        synchronized (list) {
            Iterator<ExtensionWrapper> iter = this.extensions.iterator();
            while (iter.hasNext()) {
                ExtensionWrapper aWrapper = iter.next();
                if (thisProject != aWrapper.getProject()) continue;
                aWrapper.terminate();
                iter.remove();
            }
        }
    }

    private boolean skipThisMenu(Project onThisProject, Project extensionProject) {
        if (onThisProject == null && extensionProject == null) {
            return false;
        }
        if (onThisProject == null && extensionProject != null) {
            return true;
        }
        if (onThisProject != null && extensionProject == null) {
            return false;
        }
        return onThisProject != extensionProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedList<MenuItem> getMenuItems(ExtensionMenu attachedObject, Project onThisProject) {
        LinkedList<MenuItem> menuItems = new LinkedList<MenuItem>();
        List<ExtensionWrapper> list = this.extensions;
        synchronized (list) {
            for (ExtensionWrapper aWrapper : this.extensions) {
                List<MenuItem> items;
                if (!aWrapper.isValid() || this.skipThisMenu(onThisProject, aWrapper.getProject()) || (items = aWrapper.safeGetMenuItems(attachedObject)) == null || items.isEmpty()) continue;
                for (MenuItem item : items) {
                    item.getProperties().put((Object)"bluej.extmgr.ExtensionWrapper", (Object)aWrapper);
                    menuItems.add(item);
                }
            }
        }
        return menuItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delegateEvent(ExtensionEvent event) {
        List<ExtensionWrapper> list = this.extensions;
        synchronized (list) {
            for (ExtensionWrapper wrapper : this.extensions) {
                wrapper.safeEventOccurred(event);
            }
        }
    }

    @Override
    public void blueJEvent(int eventId, Object arg, Project prj) {
        if (eventId == 5) {
            ExecutionEvent exevent = (ExecutionEvent)arg;
            this.delegateEvent(new InvocationFinishedEvent(exevent));
            return;
        }
    }

    public List<ExtensionWrapper> getLoadedExtensions(Project proj) {
        ArrayList<ExtensionWrapper> r = new ArrayList<ExtensionWrapper>();
        for (ExtensionWrapper ext : this.extensions) {
            if (ext.getProject() != proj) continue;
            r.add(ext);
        }
        return r;
    }

    public Map<String, ExternalFileLauncher.OpenExternalFileHandler> getExtFileOpenMap(Project onThisProject) {
        HashMap<Object, ExternalFileLauncher.OpenExternalFileHandler> resMap = new HashMap<Object, ExternalFileLauncher.OpenExternalFileHandler>();
        List<String> nativeBlueJExts = ExtensionBridge.getBlueJNativeFileExtensions();
        for (ExtensionWrapper extension : this.extensions) {
            if (this.skipThisMenu(onThisProject, extension.getProject())) continue;
            for (ExternalFileLauncher extFileLauncher : extension.safeGetExternalFileLaunchers()) {
                Object cleanedExtension = extFileLauncher.getFileExtension().toLowerCase().trim();
                if (((String)cleanedExtension).startsWith("*")) {
                    cleanedExtension = ((String)cleanedExtension).substring(1);
                }
                if (!((String)cleanedExtension).startsWith(".")) {
                    cleanedExtension = "." + (String)cleanedExtension;
                }
                if (((String)cleanedExtension).length() <= 1 || nativeBlueJExts.contains(cleanedExtension)) continue;
                resMap.put(cleanedExtension, extFileLauncher.getLauncher());
            }
        }
        return Collections.unmodifiableMap(resMap);
    }
}

