/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions2;

import bluej.collect.DataCollector;
import bluej.editor.stride.FXTabbedEditor;
import bluej.extensions2.BPackage;
import bluej.extensions2.ExtensionException;
import bluej.extensions2.Identifier;
import bluej.extensions2.PackageAlreadyExistsException;
import bluej.extensions2.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import java.io.File;
import java.net.URLClassLoader;
import java.util.List;
import java.util.ListIterator;

public class BProject {
    private Identifier projectId;

    BProject(Identifier i_projectId) {
        this.projectId = i_projectId;
    }

    public String getName() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        return thisProject.getProjectName();
    }

    public File getDir() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        return thisProject.getProjectDir();
    }

    public void save() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        thisProject.saveAll();
    }

    public void close() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        thisProject.saveAll();
        PkgMgrFrame.closeProject(thisProject);
    }

    public void restartVM() throws ProjectNotOpenException {
        this.projectId.getBluejProject().restartVM();
        DataCollector.debuggerTerminate(this.projectId.getBluejProject());
    }

    public BPackage newPackage(String fullyQualifiedName) throws ProjectNotOpenException, PackageAlreadyExistsException {
        Project bluejProject = this.projectId.getBluejProject();
        int result = bluejProject.newPackage(fullyQualifiedName);
        if (result == 2) {
            throw new IllegalArgumentException("newPackage: Bad package name '" + fullyQualifiedName + "'");
        }
        if (result == 1) {
            throw new PackageAlreadyExistsException("newPackage: Package '" + fullyQualifiedName + "' already exists");
        }
        if (result == 3) {
            throw new IllegalStateException("newPackage: Package '" + fullyQualifiedName + "' has no parent package");
        }
        if (result != 0) {
            throw new IllegalStateException("newPackage: Unknown result code=" + result);
        }
        Package pkg = bluejProject.getPackage(fullyQualifiedName);
        if (pkg == null) {
            throw new Error("newPackage: getPackage '" + fullyQualifiedName + "' returned null");
        }
        Package reloadPkg = pkg;
        for (int index = 0; index < 10 && reloadPkg != null; reloadPkg = reloadPkg.getParent(), ++index) {
            reloadPkg.reload();
        }
        return pkg.getBPackage();
    }

    public BPackage getPackage(String name) throws ProjectNotOpenException {
        Project bluejProject = this.projectId.getBluejProject();
        Package pkg = bluejProject.getPackage(name);
        if (pkg == null) {
            return null;
        }
        return pkg.getBPackage();
    }

    public BPackage[] getPackages() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        List<String> names = thisProject.getPackageNames();
        BPackage[] packages = new BPackage[names.size()];
        ListIterator<String> li = names.listIterator();
        while (li.hasNext()) {
            int i = li.nextIndex();
            String name = li.next();
            packages[i] = this.getPackage(name);
        }
        return packages;
    }

    public URLClassLoader getClassLoader() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        return thisProject.getClassLoader();
    }

    public String toString() {
        try {
            Project thisProject = this.projectId.getBluejProject();
            return "BProject: " + thisProject.getProjectName();
        }
        catch (ExtensionException exc) {
            return "BProject: INVALID";
        }
    }

    void clearObjectBench() throws ProjectNotOpenException {
        Project thisProject = this.projectId.getBluejProject();
        thisProject.clearObjectBenches();
    }

    Project getProject() throws ProjectNotOpenException {
        return this.projectId.getBluejProject();
    }

    public void openWebViewTab(String url) throws ProjectNotOpenException {
        Project bjProject = this.projectId.getBluejProject();
        FXTabbedEditor fXTabbedEditor = bjProject.getDefaultFXTabbedEditor();
        fXTabbedEditor.openWebViewTab(url);
    }
}

