/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;

public class WindowOverlayPane {
    private final Pane pane = new Pane();
    private ObservableDoubleValue x;
    private ObservableDoubleValue y;
    private NumberBinding xBinding;
    private NumberBinding paneWidthBinding;
    private ReadOnlyDoubleProperty nodeWidthBinding;

    public WindowOverlayPane() {
        this.pane.pickOnBoundsProperty().set(false);
    }

    public void addOverlay(Node node, ObservableDoubleValue x, ObservableDoubleValue y) {
        this.addOverlay(node, x, y, false);
    }

    public void addOverlay(Node node, ObservableDoubleValue x, ObservableDoubleValue y, boolean moveLeftIfNeeded) {
        this.pane.getChildren().add((Object)node);
        this.x = x;
        this.y = y;
        this.nodeWidthBinding = node instanceof Rectangle ? ((Rectangle)node).widthProperty() : ((Region)node).widthProperty();
        this.paneWidthBinding = this.pane.widthProperty().subtract((ObservableNumberValue)this.nodeWidthBinding);
        if (moveLeftIfNeeded) {
            this.xBinding = Bindings.min((ObservableNumberValue)x, (ObservableNumberValue)this.paneWidthBinding);
            node.layoutXProperty().bind((ObservableValue)this.xBinding);
        } else {
            node.layoutXProperty().bind((ObservableValue)this.x);
        }
        node.layoutYProperty().bind((ObservableValue)this.y);
    }

    public void removeOverlay(Node node) {
        this.pane.getChildren().remove((Object)node);
    }

    public double sceneXToWindowOverlayX(double sceneX) {
        return this.pane.sceneToLocal(sceneX, 0.0).getX();
    }

    public double sceneYToWindowOverlayY(double sceneY) {
        return this.pane.sceneToLocal(0.0, sceneY).getY();
    }

    public Node getNode() {
        return this.pane;
    }

    public boolean contains(Node node) {
        return this.pane.getChildren().contains((Object)node);
    }
}

