/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.stride.generic.InteractionManager;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
class ImageCompletion
implements InteractionManager.FileCompletion {
    private final File file;

    public ImageCompletion(File file) {
        this.file = file;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getType() {
        return "Image";
    }

    @Override
    public Node getPreview(double maxWidth, double maxHeight) {
        try {
            Image img = new Image(this.file.toURI().toURL().toString());
            ImageView view = new ImageView(img);
            if (img.getWidth() > maxWidth || img.getHeight() > maxHeight) {
                view.setFitHeight(maxHeight);
                view.setFitWidth(maxWidth);
                view.setPreserveRatio(true);
            } else {
                view.setFitHeight(0.0);
                view.setFitWidth(0.0);
                view.setPreserveRatio(true);
            }
            return view;
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            return new Label("Error loading image");
        }
    }

    @Override
    public Map<KeyCode, Runnable> getShortcuts() {
        return null;
    }
}

