/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.utility.javafx.dialog.InputDialog;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class GoToLineDialog
extends InputDialog<Integer> {
    private static final String goToLineTitle = Config.getString("editor.gotoline.title");
    private static final String goToLineLabel = Config.getString("editor.gotoline.label");
    private static final String notNumericMessage = Config.getString("editor.gotoline.notNumericMessage");
    private int rangeMax;

    public GoToLineDialog(Window parent) {
        super(goToLineTitle, goToLineLabel, Config.getString("editor.gotoline.prompt"), "goto-line-dialog");
        this.initOwner(parent);
        this.setOKEnabled(false);
    }

    public void setRangeMax(int max) {
        this.rangeMax = max;
        this.setPrompt(goToLineLabel + " ( 1 - " + max + " )");
    }

    @Override
    protected Integer convert(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    protected boolean validate(String oldInput, String newInput) {
        Integer n = this.convert(newInput);
        if (n == null) {
            this.setErrorText(notNumericMessage);
            this.setOKEnabled(!oldInput.equals(""));
            return newInput.equals("");
        }
        if (n >= 1 && n <= this.rangeMax) {
            this.setErrorText("");
            this.setOKEnabled(true);
            return true;
        }
        this.setErrorText("");
        this.setOKEnabled(!oldInput.equals(""));
        return false;
    }
}

