/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.base;

import bluej.Config;
import bluej.editor.base.TextLine;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import javafx.beans.binding.StringExpression;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class MarginAndTextLine
extends Region {
    private final int TEXT_LEFT_EDGE;
    private final double LINE_X;
    private final double MARGIN_BACKGROUND_WIDTH;
    private final double MARGIN_RIGHT;
    private final boolean showLeftMargin;
    private final Line dividerLine;
    private final int lineNumberToDisplay;
    private boolean hoveringMargin = false;
    private final EnumSet<MarginDisplay> displayItems = EnumSet.noneOf(MarginDisplay.class);
    private final Tooltip breakpointHoverTooltip;
    private final Region backgroundNode;
    private final EnumMap<MarginDisplay, Node> cachedIcons = new EnumMap(MarginDisplay.class);
    public final TextLine textLine;

    public static int textLeftEdge(boolean showLeftMargin) {
        return showLeftMargin ? 27 : 2;
    }

    public MarginAndTextLine(int lineNumberToDisplay, TextLine textLine, boolean showLeftMargin, FXPlatformSupplier<Boolean> onClick, FXPlatformSupplier<ContextMenu> getContextMenuToShow, FXPlatformConsumer<ScrollEvent> onScroll) {
        this.showLeftMargin = showLeftMargin;
        if (showLeftMargin) {
            this.MARGIN_BACKGROUND_WIDTH = 24.0;
            this.LINE_X = 24.5;
            this.TEXT_LEFT_EDGE = MarginAndTextLine.textLeftEdge(true);
            this.MARGIN_RIGHT = 23.0;
        } else {
            this.MARGIN_BACKGROUND_WIDTH = 0.0;
            this.LINE_X = 0.0;
            this.TEXT_LEFT_EDGE = MarginAndTextLine.textLeftEdge(false);
            this.MARGIN_RIGHT = 0.0;
        }
        this.dividerLine = new Line(this.LINE_X, 0.5, this.LINE_X, 1.0);
        this.dividerLine.getStyleClass().add((Object)"flow-margin-line");
        this.lineNumberToDisplay = lineNumberToDisplay;
        this.backgroundNode = new Region();
        this.backgroundNode.getStyleClass().add((Object)"flow-margin-background");
        this.textLine = textLine;
        if (showLeftMargin) {
            this.getChildren().setAll((Object[])new Node[]{this.backgroundNode, textLine, this.dividerLine});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.backgroundNode, textLine});
        }
        this.getStyleClass().add((Object)"margin-and-text-line");
        String breakpointHoverUsualText = Config.getString("editor.set.breakpoint.hint");
        String breakpointHoverFailText = Config.getString("editor.set.breakpoint.fail");
        this.breakpointHoverTooltip = new Tooltip(breakpointHoverUsualText);
        this.breakpointHoverTooltip.setShowDelay(Duration.seconds((double)1.0));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            if (e.getX() < this.LINE_X && e.getButton() == MouseButton.PRIMARY && !e.isShiftDown()) {
                if (!((Boolean)onClick.get()).booleanValue()) {
                    this.breakpointHoverTooltip.setText(breakpointHoverFailText);
                    this.breakpointHoverTooltip.setShowDelay(Duration.ZERO);
                } else {
                    this.breakpointHoverTooltip.setText(breakpointHoverUsualText);
                    this.breakpointHoverTooltip.setShowDelay(Duration.seconds((double)1.0));
                }
                e.consume();
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_MOVED, e -> {
            this.hoveringMargin = e.getX() < this.LINE_X;
            this.setMarginGraphics(EnumSet.copyOf(this.displayItems));
        });
        this.addEventHandler(MouseEvent.MOUSE_EXITED, e -> {
            this.hoveringMargin = false;
            this.breakpointHoverTooltip.setText(breakpointHoverUsualText);
            this.breakpointHoverTooltip.setShowDelay(Duration.seconds((double)1.0));
            this.setMarginGraphics(EnumSet.copyOf(this.displayItems));
        });
        this.addEventHandler(ScrollEvent.ANY, e -> onScroll.accept((ScrollEvent)e));
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().add((Object)JavaFXUtil.makeMenuItem(Config.getString("editor.toggle-breakpointLabel"), () -> onClick.get(), null));
        contextMenu.getItems().add((Object)JavaFXUtil.makeMenuItem(Config.getString("prefmgr.edit.displaylinenumbers"), () -> PrefMgr.setFlag("bluej.editor.displayLineNumbers", !PrefMgr.getFlag("bluej.editor.displayLineNumbers")), null));
        this.backgroundNode.setOnContextMenuRequested(e -> {
            if (contextMenu.isShowing()) {
                contextMenu.hide();
            }
            contextMenu.show((Node)this.backgroundNode, e.getScreenX(), e.getScreenY());
            e.consume();
        });
        this.setOnContextMenuRequested(e -> {
            ((ContextMenu)getContextMenuToShow.get()).show((Node)this, e.getScreenX(), e.getScreenY());
            e.consume();
        });
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected void layoutChildren() {
        for (Node child : this.getChildren()) {
            if (child == this.textLine) {
                this.textLine.resizeRelocate(this.TEXT_LEFT_EDGE, 0.0, this.getWidth() - (double)this.TEXT_LEFT_EDGE, this.getHeight());
                continue;
            }
            if (child == this.dividerLine) {
                this.dividerLine.setEndY(this.getHeight() - 0.5);
                continue;
            }
            if (child == this.backgroundNode) {
                this.backgroundNode.resizeRelocate(0.0, 0.0, this.MARGIN_BACKGROUND_WIDTH, this.getHeight());
                continue;
            }
            double height = child.prefHeight(-1.0);
            double width = child.prefWidth(-1.0);
            child.resizeRelocate(this.MARGIN_RIGHT - width, (this.getHeight() - height) / 2.0, width, height);
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computePrefWidth(double height) {
        return this.textLine.prefWidth(height) + (double)this.TEXT_LEFT_EDGE;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computePrefHeight(double width) {
        return this.textLine.prefHeight(width - (double)this.TEXT_LEFT_EDGE);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computeMinWidth(double height) {
        return this.textLine.minWidth(height) + (double)this.TEXT_LEFT_EDGE;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computeMinHeight(double width) {
        return this.textLine.minHeight(width - (double)this.TEXT_LEFT_EDGE);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computeMaxWidth(double height) {
        return this.textLine.maxWidth(height) + (double)this.TEXT_LEFT_EDGE;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computeMaxHeight(double width) {
        return this.textLine.maxHeight(width - (double)this.TEXT_LEFT_EDGE);
    }

    public void fontSizeChanged(StringExpression fontCSS) {
        this.textLine.fontSizeChanged(fontCSS);
    }

    @OnThread(value=Tag.FX)
    public void setMarginGraphics(EnumSet<MarginDisplay> displayItems) {
        if (!this.showLeftMargin) {
            return;
        }
        this.displayItems.clear();
        this.displayItems.addAll(displayItems);
        EnumSet<MarginDisplay> toAdd = EnumSet.copyOf(displayItems);
        if (this.hoveringMargin && !toAdd.contains((Object)MarginDisplay.BREAKPOINT)) {
            toAdd.add(MarginDisplay.BREAKPOINT_HOVER);
            toAdd.remove((Object)MarginDisplay.LINE_NUMBER);
        }
        ArrayList<Object> content = new ArrayList<Object>();
        content.add(this.backgroundNode);
        content.add((Object)this.textLine);
        content.add(this.dividerLine);
        for (MarginDisplay display : toAdd) {
            Node item = this.cachedIcons.computeIfAbsent(display, d -> {
                switch (d) {
                    case LINE_NUMBER: {
                        Label label = new Label(Integer.toString(this.lineNumberToDisplay));
                        label.setEllipsisString("\u2026");
                        label.setTextOverrun(OverrunStyle.LEADING_ELLIPSIS);
                        JavaFXUtil.addStyleClass((Styleable)label, "flow-line-label");
                        label.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(PrefMgr.FontCSS.LINE_NUMBER_SIZE_ONLY));
                        label.setMouseTransparent(true);
                        return label;
                    }
                    case STEP_MARK: {
                        return MarginAndTextLine.makeStepMarkIcon();
                    }
                    case BREAKPOINT: {
                        return MarginAndTextLine.makeBreakpointIcon();
                    }
                    case BREAKPOINT_HOVER: {
                        Node icon = MarginAndTextLine.makeBreakpointIcon();
                        icon.setOpacity(0.3);
                        Tooltip.install((Node)icon, (Tooltip)this.breakpointHoverTooltip);
                        return icon;
                    }
                    case ERROR: {
                        return null;
                    }
                    case UNCOMPILED: {
                        return null;
                    }
                }
                return null;
            });
            if (item == null) continue;
            content.add(item);
        }
        if (!content.equals(this.getChildren())) {
            this.getChildren().setAll(content);
        }
        for (MarginDisplay marginDisplay : MarginDisplay.values()) {
            if (marginDisplay.pseudoClass == null) continue;
            JavaFXUtil.setPseudoclass(marginDisplay.pseudoClass, displayItems.contains((Object)marginDisplay), new Node[]{this});
        }
    }

    private static Node makeBreakpointIcon() {
        Node icon = Config.makeStopIcon(false);
        JavaFXUtil.addStyleClass((Styleable)icon, "moe-breakpoint-icon");
        icon.setMouseTransparent(true);
        return icon;
    }

    private static Node makeStepMarkIcon() {
        Polygon arrow = Config.makeArrowShape(false);
        JavaFXUtil.addStyleClass((Styleable)arrow, "moe-step-mark-icon");
        arrow.setMouseTransparent(true);
        return arrow;
    }

    @OnThread(value=Tag.Any)
    public static enum MarginDisplay {
        UNCOMPILED("bj-margin-uncompiled"),
        ERROR("bj-margin-error"),
        LINE_NUMBER,
        BREAKPOINT_HOVER,
        BREAKPOINT,
        STEP_MARK;

        public final String pseudoClass;

        private MarginDisplay(String pseudoClass) {
            this.pseudoClass = pseudoClass;
        }

        private MarginDisplay() {
            this(null);
        }
    }
}

