/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.inspector.ObjectBackground;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.testmgr.record.ArrayElementGetRecord;
import bluej.testmgr.record.ArrayElementInspectorRecord;
import bluej.testmgr.record.GetInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.javafx.JavaFXUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ObjectInspector
extends Inspector {
    protected static final String inspectTitle = Config.getString("debugger.inspector.object.title");
    protected static final String noFieldsMsg = Config.getString("debugger.inspector.object.noFields");
    protected static final String numFields = Config.getString("debugger.inspector.numFields");
    public static final int CORNER_SIZE = 40;
    protected DebuggerObject obj;
    protected String objName;
    protected boolean queryArrayElementSelected = false;
    private int selectedIndex;
    private List<Integer> extraArrayIndexesToShow = new ArrayList<Integer>();
    private int extraArrayIndexInList = -1;
    private int extraArraySlotIndex = -1;
    protected List<Integer> indexToSlotList = null;
    private StackPane stackPane;
    private static final int VISIBLE_ARRAY_START = 40;
    private static final int VISIBLE_ARRAY_TAIL = 5;
    private static final int ARRAY_QUERY_SLOT_VALUE = -2;
    private static final int ARRAY_LENGTH_SLOT_VALUE = -1;

    public ObjectInspector(DebuggerObject obj, InspectorManager inspectorManager, String name, Package pkg, InvokerRecord ir, Window parent) {
        super(inspectorManager, pkg, ir, StageStyle.TRANSPARENT);
        this.obj = obj;
        this.objName = name;
        this.makeFrame();
        this.update();
        this.setMinWidth(500.0);
        this.setMinHeight(260.0);
        if (parent instanceof Inspector) {
            this.setX(parent.getX() + 40.0);
            this.setY(parent.getY() + 40.0);
        }
        this.installListenersForMoveDrag(20.0);
    }

    protected void makeFrame() {
        VBox header = new VBox();
        GenTypeClass objType = this.obj.getGenType();
        String className = objType != null ? objType.toString(true) : "";
        String fullTitle = null;
        if (this.objName != null) {
            fullTitle = this.objName + " : " + className;
            this.setTitle(inspectTitle + " - " + this.objName + ", " + className + " " + numFields + " " + this.getListData().size());
        } else {
            fullTitle = " : " + className;
            this.setTitle(inspectTitle);
        }
        Label headerLabel = new Label(fullTitle);
        header.getChildren().add((Object)headerLabel);
        BorderPane mainPanel = new BorderPane();
        mainPanel.setCenter((Node)this.fieldList);
        this.fieldList.setPlaceHolderText("  " + noFieldsMsg);
        mainPanel.setRight(this.createInspectAndGetButtons());
        VBox bottomPanel = new VBox();
        BorderPane buttonPanel = new BorderPane();
        Button button = this.createCloseButton();
        buttonPanel.setRight((Node)button);
        Button classButton = new Button(showClassLabel);
        classButton.setOnAction(e -> this.showClass());
        buttonPanel.setLeft((Node)classButton);
        bottomPanel.getChildren().add((Object)buttonPanel);
        VBox contentPane = new VBox();
        contentPane.setBackground(null);
        contentPane.getChildren().addAll((Object[])new Node[]{header, mainPanel, bottomPanel});
        VBox.setVgrow((Node)mainPanel, (Priority)Priority.ALWAYS);
        JavaFXUtil.addStyleClass((Styleable)contentPane, "inspector", "inspector-object");
        JavaFXUtil.addStyleClass((Styleable)header, "inspector-object-header", "inspector-header");
        button.setDefaultButton(true);
        this.stackPane = new StackPane(new Node[]{new ObjectBackground(40.0, (ObservableDoubleValue)new ReadOnlyDoubleWrapper(3.0)), contentPane});
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.stackPane.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.stackPane.heightProperty());
        clip.setArcWidth(40.0);
        clip.setArcHeight(40.0);
        this.stackPane.setClip((Node)clip);
        this.stackPane.setBackground(null);
        BorderPane root = new BorderPane((Node)this.stackPane);
        root.setBackground(null);
        root.setMaxHeight(Screen.getScreens().stream().mapToDouble(s -> s.getBounds().getHeight() - 150.0).max().orElse(1000.0));
        Scene scene = new Scene((Parent)root);
        scene.setFill(null);
        this.setScene(scene);
    }

    @Override
    public Region getContent() {
        return this.stackPane;
    }

    @Override
    protected boolean shouldAutoUpdate() {
        return Config.isGreenfoot();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected List<FieldInfo> getListData() {
        if (this.obj.isArray()) {
            return this.compressArrayList(this.obj);
        }
        List<DebuggerField> fields = this.obj.getFields();
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>(fields.size());
        for (DebuggerField field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            String desc = Inspector.fieldToString(field);
            String value = field.getValueString();
            fieldInfos.add(new FieldInfo(desc, value));
        }
        return fieldInfos;
    }

    @Override
    protected void listElementSelected(int slot) {
        if (slot == -1) {
            this.setCurrentObj(null, null, null);
            this.setButtonsEnabled(false, false);
            return;
        }
        if (this.obj.isArray()) {
            if ((slot = this.indexToSlot(slot)) >= 0) {
                this.selectedIndex = slot;
            }
            if (slot == -1) {
                this.setCurrentObj(null, null, null);
                this.setButtonsEnabled(false, false);
                return;
            }
            boolean bl = this.queryArrayElementSelected = slot == -2;
            if (this.queryArrayElementSelected) {
                this.setCurrentObj(null, null, null);
                if (!this.obj.getElementType().isPrimitive()) {
                    this.setButtonsEnabled(true, false);
                } else {
                    this.setButtonsEnabled(false, false);
                }
            } else {
                DebuggerObject elementObj;
                if (!this.obj.getElementType().isPrimitive() && !(elementObj = this.obj.getElementObject(slot)).isNullObject()) {
                    this.setCurrentObj(elementObj, "[" + slot + "]", this.obj.getElementType().toString());
                    this.setButtonsEnabled(true, true);
                    return;
                }
                this.setCurrentObj(null, null, null);
                this.setButtonsEnabled(false, false);
            }
            return;
        }
        DebuggerField field = this.obj.getInstanceField(slot);
        if (field != null && field.isReferenceType() && !field.isNull()) {
            this.setCurrentObj(field.getValueObject(null), field.getName(), field.getType().toString());
            if (Modifier.isPublic(field.getModifiers())) {
                this.setButtonsEnabled(true, true);
            } else {
                boolean canGet = false;
                if (!Modifier.isPrivate(field.getModifiers())) {
                    String fieldPkg = JavaNames.getPrefix(field.getDeclaringClassName());
                    String pkgName = this.pkg == null ? "" : this.pkg.getQualifiedName();
                    canGet = fieldPkg.equals(pkgName);
                }
                this.setButtonsEnabled(true, canGet);
            }
        } else {
            this.setCurrentObj(null, null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    protected void showClass() {
        this.inspectorManager.getClassInspectorInstance(this.obj.getClassRef(), this.pkg, (Window)this, null);
    }

    @Override
    protected void doInspect() {
        if (this.queryArrayElementSelected) {
            this.selectArrayElement();
        } else if (this.selectedField != null) {
            boolean isPublic;
            boolean bl = isPublic = !this.getButton.isDisable();
            if (!this.obj.isArray()) {
                ObjectInspectInvokerRecord newIr = new ObjectInspectInvokerRecord(this.selectedFieldName, this.ir);
                this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, (Window)this, null);
            } else {
                ArrayElementInspectorRecord newIr = new ArrayElementInspectorRecord(this.ir, this.selectedIndex);
                this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, (Window)this, null);
            }
        }
    }

    @Override
    protected void doGet() {
        if (this.selectedField != null) {
            InvokerRecord getIr = !this.obj.isArray() ? new GetInvokerRecord(this.selectedFieldType, this.selectedFieldName, this.ir) : new ArrayElementGetRecord(this.selectedFieldType, this.selectedIndex, this.ir);
            DebuggerObject selField = this.selectedField;
            PackageEditor pkgEd = this.pkg.getEditor();
            pkgEd.recordInteraction(getIr);
            pkgEd.raisePutOnBenchEvent((Window)this, selField, selField.getGenType(), getIr, true, Optional.empty());
        }
    }

    @Override
    protected void remove() {
        if (this.inspectorManager != null) {
            this.inspectorManager.removeInspector(this.obj);
        }
    }

    private void selectArrayElement() {
        block9: {
            String response = DialogManager.askStringFX((Window)this, "ask-index");
            if (response != null) {
                try {
                    int slot = Integer.parseInt(response);
                    if (slot >= 0 && slot < this.obj.getElementCount()) {
                        if (!this.obj.getElementType().isPrimitive() && !this.obj.getElementObject(slot).isNullObject()) {
                            boolean isPublic = !this.getButton.isDisable();
                            ArrayElementInspectorRecord newIr = new ArrayElementInspectorRecord(this.ir, slot);
                            this.setCurrentObj(this.obj.getElementObject(slot), "[" + slot + "]", this.obj.getElementType().toString());
                            this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, (Window)this, null);
                        } else {
                            this.extraArraySlotIndex = slot;
                            if (!this.extraArrayIndexesToShow.contains(slot)) {
                                this.extraArrayIndexesToShow.add(slot);
                                this.update();
                                JavaFXUtil.runAfterNextLayout(this.getScene(), () -> JavaFXUtil.runAfterNextLayout(this.getScene(), () -> {
                                    if (this.fieldList != null) {
                                        int currentSelectIndex = this.fieldList.selectedIndexProperty().get();
                                        this.fieldList.select(-1);
                                        this.fieldList.select(currentSelectIndex);
                                    }
                                }));
                            } else {
                                this.extraArrayIndexInList = this.indexToSlotList.indexOf(this.extraArraySlotIndex);
                            }
                            this.fieldList.select(-1);
                            this.fieldList.select(this.extraArrayIndexInList);
                            this.extraArraySlotIndex = -1;
                            this.extraArrayIndexInList = -1;
                        }
                        break block9;
                    }
                    DialogManager.showErrorFX((Window)this, "out-of-bounds");
                }
                catch (NumberFormatException e) {
                    this.setCurrentObj(null, null, null);
                    DialogManager.showErrorFX((Window)this, "cannot-access-element");
                }
            } else {
                this.setCurrentObj(null, null, null);
            }
        }
    }

    private List<FieldInfo> compressArrayList(DebuggerObject arrayObject) {
        this.indexToSlotList = new LinkedList<Integer>();
        this.indexToSlotList.add(0, -1);
        int arrayTotalLength = arrayObject.getElementCount();
        if (arrayTotalLength > 45 + this.extraArrayIndexesToShow.size() + 2) {
            int i;
            ArrayList<FieldInfo> newArray = new ArrayList<FieldInfo>(47);
            newArray.add(0, new FieldInfo("int length", "" + arrayTotalLength));
            for (int i2 = 0; i2 <= 40; ++i2) {
                newArray.add(new FieldInfo("[" + i2 + "]", arrayObject.getElementValueString(i2)));
                this.indexToSlotList.add(i2);
                if (i2 != this.extraArraySlotIndex) continue;
                this.extraArrayIndexInList = newArray.size() - 1;
            }
            boolean hasExpansion = false;
            for (i = 41; i < arrayTotalLength - 5; ++i) {
                if (this.extraArrayIndexesToShow.contains(i)) {
                    newArray.add(new FieldInfo("[" + i + "]", arrayObject.getElementValueString(i)));
                    this.indexToSlotList.add(i);
                    hasExpansion = false;
                    if (i != this.extraArraySlotIndex) continue;
                    this.extraArrayIndexInList = newArray.size() - 1;
                    continue;
                }
                if (hasExpansion) continue;
                newArray.add(new FieldInfo("[...]", ""));
                this.indexToSlotList.add(-2);
                hasExpansion = true;
            }
            for (i = 5; i > 0; --i) {
                int elNum = arrayTotalLength - i;
                newArray.add(new FieldInfo("[" + elNum + "]", arrayObject.getElementValueString(elNum)));
                this.indexToSlotList.add(arrayTotalLength - i);
                if (arrayTotalLength - i != this.extraArraySlotIndex) continue;
                this.extraArrayIndexInList = newArray.size() - 1;
            }
            return newArray;
        }
        ArrayList<FieldInfo> fullArrayFieldList = new ArrayList<FieldInfo>(arrayObject.getElementCount() + 1);
        fullArrayFieldList.add(0, new FieldInfo("int length", "" + arrayObject.getElementCount()));
        for (int i = 0; i < arrayObject.getElementCount(); ++i) {
            fullArrayFieldList.add(new FieldInfo("[" + i + "]", arrayObject.getElementValueString(i)));
            this.indexToSlotList.add(i);
        }
        return fullArrayFieldList;
    }

    private int indexToSlot(int listIndexPosition) {
        Integer slot = this.indexToSlotList.get(listIndexPosition);
        return slot;
    }

    @Override
    protected int getPreferredRows() {
        return 8;
    }
}

