/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GenTypeDeclTpar
extends GenTypeTpar {
    protected GenTypeSolid[] upperBounds;

    public GenTypeDeclTpar(String parname) {
        super(parname);
    }

    public GenTypeDeclTpar(String parname, GenTypeSolid bound) {
        super(parname);
        this.upperBounds = new GenTypeSolid[]{bound};
    }

    public GenTypeDeclTpar(String parname, GenTypeSolid[] bounds) {
        super(parname);
        this.upperBounds = bounds;
    }

    public GenTypeDeclTpar(String parname, GenTypeSolid[] ubounds, GenTypeSolid lbound) {
        super(parname);
        this.upperBounds = ubounds;
    }

    public void setBounds(GenTypeSolid[] ubounds) {
        this.upperBounds = ubounds;
    }

    @OnThread(value=Tag.FXPlatform)
    public GenTypeSolid getBound() {
        return IntersectionType.getIntersection(this.upperBounds);
    }

    public GenTypeSolid[] upperBounds() {
        GenTypeSolid[] r = new GenTypeSolid[this.upperBounds.length];
        System.arraycopy(this.upperBounds, 0, r, 0, this.upperBounds.length);
        return r;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public GenTypeParameter mapTparsToTypes(Map<String, ? extends GenTypeParameter> tparams) {
        if (tparams == null) {
            GenTypeSolid[] mappedBounds = new GenTypeSolid[this.upperBounds.length];
            for (int i = 0; i < this.upperBounds.length; ++i) {
                mappedBounds[i] = this.upperBounds[i].mapTparsToTypes(null).getUpperBound().asSolid();
            }
            return IntersectionType.getIntersection(mappedBounds);
        }
        GenTypeParameter newType = tparams.get(this.getTparName());
        if (newType == null) {
            return this;
        }
        return newType;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public String toString(boolean stripPrefix) {
        String bound = this.getBound().toString(false);
        if (bound.equals("java.lang.Object")) {
            return this.getTparName();
        }
        return this.getTparName() + " extends " + this.getBound().toString(stripPrefix);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public String arrayComponentName() {
        return this.getErasedType().arrayComponentName();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaType getErasedType() {
        return this.upperBounds[0].getErasedType();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void erasedSuperTypes(Set<Reflective> s) {
        for (int i = 0; i < this.upperBounds.length; ++i) {
            this.upperBounds[i].erasedSuperTypes(s);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public GenTypeClass[] getReferenceSupertypes() {
        ArrayList<GenTypeClass> al = new ArrayList<GenTypeClass>();
        for (int i = 0; i < this.upperBounds.length; ++i) {
            GenTypeClass[] brs = this.upperBounds[i].getReferenceSupertypes();
            for (int j = 0; j < brs.length; ++j) {
                al.add(brs[j]);
            }
        }
        return al.toArray(new GenTypeClass[0]);
    }

    @Override
    public boolean isAssignableFrom(JavaType t) {
        return super.isAssignableFrom(t);
    }
}

