/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.Boot;
import bluej.collect.DataSubmissionFailedDialog;
import bluej.collect.Event;
import bluej.collect.FileKey;
import bluej.extensions2.event.ApplicationEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Project;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import threadchecker.OnThread;
import threadchecker.Tag;

class DataSubmitter {
    private static final String submitUrl = "https://blackbox.bluej.org/master_events";
    private static AtomicBoolean givenUp = new AtomicBoolean(false);
    private static boolean isRunning = false;
    private static List<Event> queue = new LinkedList<Event>();
    private static int sequenceNum;
    private static Map<FileKey, List<String>> fileVersions;

    DataSubmitter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void submitEvent(Event evt) {
        if (givenUp.get()) {
            return;
        }
        List<Event> list = queue;
        synchronized (list) {
            queue.add(evt);
            if (!isRunning) {
                new Thread("Process Blackbox queue"){

                    @Override
                    @OnThread(value=Tag.Worker, ignoreParent=true)
                    public void run() {
                        DataSubmitter.processQueue();
                    }
                }.start();
                isRunning = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Worker)
    private static void processQueue() {
        while (true) {
            Event evt;
            List<Event> list = queue;
            synchronized (list) {
                if (queue.isEmpty()) {
                    isRunning = false;
                    queue.notifyAll();
                    return;
                }
                evt = queue.remove(0);
            }
            if (givenUp.get()) continue;
            givenUp.set(!DataSubmitter.postData(evt));
            if (!givenUp.get()) continue;
            Platform.runLater(() -> {
                ExtensionsManager.getInstance().delegateEvent(new ApplicationEvent(ApplicationEvent.EventType.DATA_SUBMISSION_FAILED_EVENT));
                if (Boot.isTrialRecording()) {
                    new DataSubmissionFailedDialog().show();
                    Project.getProjects().forEach(project -> project.setAllEditorStatus(" - NOT RECORDING"));
                }
            });
        }
    }

    @OnThread(value=Tag.Worker)
    private static boolean postData(Event evt) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)(Boot.isTrialRecording() ? 30000 : 10000));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)(Boot.isTrialRecording() ? 30000 : 10000));
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        try {
            HttpPost post = new HttpPost(submitUrl);
            MultipartEntity mpe = evt.makeData(sequenceNum, fileVersions);
            if (mpe == null) {
                return true;
            }
            ++sequenceNum;
            post.setEntity((HttpEntity)mpe);
            HttpResponse response = client.execute((HttpUriRequest)post);
            for (Header h : response.getAllHeaders()) {
                if (!"X-Status".equals(h.getName()) || "Created".equals(h.getValue())) continue;
                return false;
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                return false;
            }
            evt.success(fileVersions);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException cpe) {
            return false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForQueueFlush(int maxMillis) {
        long endTime = System.currentTimeMillis() + (long)maxMillis;
        try {
            List<Event> list = queue;
            synchronized (list) {
                long waitTime;
                while ((!queue.isEmpty() || isRunning) && (waitTime = endTime - System.currentTimeMillis()) > 0L) {
                    queue.wait(waitTime);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void initSequence() {
        sequenceNum = 1;
    }

    public static boolean hasGivenUp() {
        return givenUp.get();
    }

    static {
        fileVersions = new HashMap<FileKey, List<String>>();
    }
}

