/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import bluej.Config;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import threadchecker.OnThread;
import threadchecker.Tag;

public class SoundUtils {
    public static float convertMinMax(int val, float min, float max) {
        float range = max - min;
        float newVal = (float)val / (100.0f / range);
        return newVal + min;
    }

    public static int logToLin(int level) {
        return (int)(Math.log(level) / Math.log(100.0) * 100.0);
    }

    public static long getTimeToPlayBytes(long bytes, AudioFormat format) {
        return SoundUtils.getTimeToPlayFrames(bytes / (long)format.getFrameSize(), format);
    }

    public static long getTimeToPlayFrames(long frames, AudioFormat format) {
        if (format.getFrameRate() != -1.0f) {
            return (long)((float)(1000L * frames) / format.getFrameRate());
        }
        return -1L;
    }

    public static int getBufferSizeToHold(AudioFormat format, double seconds) {
        int bufferSize = format.getFrameRate() != -1.0f ? (int)Math.ceil((double)((float)format.getFrameSize() * format.getFrameRate()) * seconds) : (format.getSampleRate() != -1.0f ? (int)Math.ceil((double)((float)(format.getSampleSizeInBits() / 8 * format.getChannels()) * format.getSampleRate()) * seconds) : -1);
        return bufferSize;
    }

    @OnThread(value=Tag.Any)
    public static Mixer loadMixer(boolean input) {
        return SoundUtils.loadMixer(Arrays.stream(AudioSystem.getMixerInfo()).map(i -> AudioSystem.getMixer(i)).toList(), input);
    }

    @OnThread(value=Tag.Any)
    static Mixer loadMixer(List<Mixer> possibles, boolean input) {
        String stored = Config.getPropString((String)(input ? "greenfoot.sound.device.input" : "greenfoot.sound.device.output"));
        for (Mixer mixer : possibles) {
            if ((mixer != null || !stored.isBlank()) && (mixer == null || !mixer.getMixerInfo().toString().equals(stored))) continue;
            return mixer;
        }
        return null;
    }
}

