/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.sound;

import greenfoot.event.SimulationListener;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundPlaybackListener;
import java.util.HashSet;
import java.util.Set;
import threadchecker.OnThread;
import threadchecker.Tag;

public class SoundCollection
implements SimulationListener,
SoundPlaybackListener {
    private Set<Sound> playingSounds = new HashSet<Sound>();
    private Set<Sound> pausedSounds = new HashSet<Sound>();
    private Set<Sound> stoppedSounds = new HashSet<Sound>();
    private volatile boolean ignoreEvents = false;

    @Override
    @OnThread(value=Tag.Any)
    public void simulationChangedAsync(SimulationListener.AsyncEvent e) {
        if (e == SimulationListener.AsyncEvent.DISABLED) {
            this.close();
        }
    }

    @Override
    @OnThread(value=Tag.Simulation)
    public void simulationChangedSync(SimulationListener.SyncEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        SoundCollection soundCollection = this;
        synchronized (soundCollection) {
            this.ignoreEvents = true;
        }
        for (Sound sound : this.playingSounds) {
            sound.close();
        }
        for (Sound sound : this.pausedSounds) {
            sound.close();
        }
        for (Sound sound : this.stoppedSounds) {
            sound.close();
        }
        this.playingSounds.clear();
        this.pausedSounds.clear();
        this.stoppedSounds.clear();
        SoundCollection soundCollection2 = this;
        synchronized (soundCollection2) {
            this.ignoreEvents = false;
        }
    }

    @Override
    public synchronized void playbackStarted(Sound sound) {
        if (!this.ignoreEvents) {
            this.playingSounds.add(sound);
            this.pausedSounds.remove(sound);
            this.stoppedSounds.remove(sound);
        }
    }

    @Override
    public synchronized void playbackStopped(Sound sound) {
        if (!this.ignoreEvents) {
            this.playingSounds.remove(sound);
            this.pausedSounds.remove(sound);
            this.stoppedSounds.add(sound);
        }
    }

    @Override
    public synchronized void playbackPaused(Sound sound) {
        if (!this.ignoreEvents) {
            this.pausedSounds.add(sound);
            this.playingSounds.remove(sound);
            this.stoppedSounds.remove(sound);
        }
    }

    @Override
    public synchronized void soundClosed(Sound sound) {
        if (!this.ignoreEvents) {
            this.pausedSounds.remove(sound);
            this.playingSounds.remove(sound);
            this.stoppedSounds.remove(sound);
        }
    }
}

