/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.images;

import bluej.utility.Debug;
import java.io.File;
import java.net.MalformedURLException;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImageListEntry {
    private final File imageFile;
    private final boolean inProjectList;
    private ImageView icon;
    private long lastModified;

    public ImageListEntry(File file, boolean inProjectList) {
        this.imageFile = file;
        if (this.imageFile != null) {
            this.lastModified = file.lastModified();
        }
        this.inProjectList = inProjectList;
    }

    public String getImageName() {
        return this.imageFile.getName();
    }

    public ImageView getIcon() {
        if (this.icon == null && this.imageFile != null) {
            this.icon = this.getImageView();
        }
        return this.icon;
    }

    private ImageView getImageView() {
        try {
            int maxWidth;
            Image image = new Image(this.imageFile.toURI().toURL().toExternalForm());
            ImageView view = new ImageView(image);
            int n = maxWidth = this.inProjectList ? 40 : 60;
            if (image.getWidth() > (double)maxWidth) {
                view.setFitWidth((double)maxWidth);
                view.setPreserveRatio(true);
            }
            return view;
        }
        catch (MalformedURLException e) {
            Debug.reportError((Throwable)e);
            return new ImageView();
        }
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public boolean isInProjectList() {
        return this.inProjectList;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ImageListEntry)) {
            return false;
        }
        ImageListEntry otherEntry = (ImageListEntry)other;
        File otherImageFile = otherEntry.imageFile;
        if (otherImageFile == null && this.imageFile == null) {
            return true;
        }
        if (otherImageFile == null || this.imageFile == null) {
            return false;
        }
        return otherImageFile.equals(this.imageFile) && otherEntry.lastModified == this.lastModified;
    }

    public int hashCode() {
        return this.imageFile.hashCode();
    }
}

