/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.export;

import bluej.Config;
import greenfoot.export.Exporter;
import greenfoot.export.mygame.ExportInfo;
import greenfoot.export.mygame.ScenarioInfo;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Tab;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform, ignoreParent=true)
public abstract class ExportTab
extends Tab {
    protected final CheckBox lockScenario = new CheckBox(Config.getString((String)"export.lock.label"));
    protected final CheckBox hideControls = new CheckBox(Config.getString((String)"export.controls.label"));
    protected final ScenarioInfo scenarioInfo;
    protected final BooleanProperty validProperty = new SimpleBooleanProperty(true);

    public ExportTab(ScenarioInfo scenarioInfo, String iconName) {
        this.setClosable(false);
        this.scenarioInfo = scenarioInfo;
        ImageView imageView = new ImageView(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(iconName)));
        imageView.setPreserveRatio(true);
        this.setGraphic((Node)imageView);
        this.lockScenario.setSelected(true);
        this.lockScenario.setTooltip(new Tooltip(Config.getString((String)"export.lock.description")));
        this.hideControls.setSelected(false);
        this.hideControls.setTooltip(new Tooltip(Config.getString((String)"export.controls.description")));
        this.getStyleClass().add((Object)"export-tab");
    }

    public boolean prePublish() {
        this.updateInfoFromFields();
        return true;
    }

    public void postPublish(boolean success) {
    }

    public boolean isLockScenario() {
        return this.lockScenario.isSelected();
    }

    public boolean isHideControls() {
        return this.hideControls.isSelected();
    }

    protected void applySharedStyle() {
        this.getContent().getStyleClass().add((Object)"export-tab-content");
    }

    public abstract Exporter.ExportFunction getFunction();

    protected abstract void updateInfoFromFields();

    protected abstract ExportInfo getExportInfo();
}

