/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.classes;

import greenfoot.guifx.GreenfootStage;
import greenfoot.guifx.classes.ClassDisplay;
import greenfoot.guifx.classes.GClassNode;
import greenfoot.guifx.classes.InheritArrow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ClassGroup
extends Pane
implements ChangeListener<Number> {
    public static final int VERTICAL_SPACING = 8;
    private final List<GClassNode> topLevel = new ArrayList<GClassNode>();
    private final GreenfootStage greenfootStage;

    public ClassGroup(GreenfootStage greenfootStage) {
        this.greenfootStage = greenfootStage;
        this.getStyleClass().add((Object)"class-group");
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.setMaxWidth(Double.MAX_VALUE);
        this.setMaxHeight(Double.MAX_VALUE);
    }

    public void setClasses(List<GClassNode> topLevel) {
        for (Node child : this.getChildren()) {
            if (!(child instanceof ClassDisplay)) continue;
            ((ClassDisplay)child).widthProperty().removeListener((ChangeListener)this);
            ((ClassDisplay)child).heightProperty().removeListener((ChangeListener)this);
        }
        this.getChildren().clear();
        for (GClassNode classInfo : this.topLevel) {
            classInfo.tidyup();
        }
        this.topLevel.clear();
        this.topLevel.addAll(topLevel);
        this.updateAfterAdd();
    }

    public List<GClassNode> getLiveTopLevelClasses() {
        return this.topLevel;
    }

    public Stream<GClassNode> streamAllClasses() {
        return this.topLevel.stream().flatMap(c -> ClassGroup.streamInclSubclasses(c));
    }

    private static Stream<GClassNode> streamInclSubclasses(GClassNode item) {
        return Stream.concat(Stream.of(item), item.getSubClasses().stream().flatMap(c -> ClassGroup.streamInclSubclasses(c)));
    }

    public void updateAfterAdd() {
        Collections.sort(this.topLevel, Comparator.comparing(GClassNode::getDisplayName));
        this.redisplay();
    }

    private void redisplay() {
        int leftIndent = 8;
        this.redisplay(null, this.topLevel, leftIndent, 0);
        this.requestLayout();
    }

    private int redisplay(InheritArrow arrowToSuper, List<GClassNode> stratum, int x, int y) {
        int startY = y;
        ArrayList<Double> arrowArms = new ArrayList<Double>();
        for (GClassNode classInfo : stratum) {
            y += 8;
            ClassDisplay classDisplay = classInfo.getDisplay(this.greenfootStage);
            if (!this.getChildren().contains((Object)classDisplay)) {
                this.getChildren().add((Object)classDisplay);
                classDisplay.widthProperty().addListener((ChangeListener)this);
                classDisplay.heightProperty().addListener((ChangeListener)this);
            }
            double halfHeight = Math.floor(classDisplay.getHeight() / 2.0);
            arrowArms.add((double)y + halfHeight - (double)startY);
            classDisplay.setLayoutX(x);
            classDisplay.setLayoutY(y);
            y = (int)((double)y + classDisplay.getHeight());
            if (!classInfo.getSubClasses().isEmpty()) {
                if (!this.getChildren().contains((Object)classInfo.getArrowFromSub())) {
                    this.getChildren().add((Object)classInfo.getArrowFromSub());
                }
                classInfo.getArrowFromSub().setLayoutX((double)(x + 5) + 0.5);
                classInfo.getArrowFromSub().setLayoutY((double)y + 0.5);
                y = this.redisplay(classInfo.getArrowFromSub(), classInfo.getSubClasses(), x + 20, y);
                continue;
            }
            this.getChildren().remove((Object)classInfo.getArrowFromSub());
        }
        if (arrowToSuper != null) {
            arrowToSuper.setArmLocations(15.0, arrowArms);
        }
        return y;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computePrefHeight(double width) {
        return this.getChildren().stream().filter(c -> c instanceof ClassDisplay).mapToDouble(c -> 8.0 + c.prefHeight(width)).sum();
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    protected @OnThread(value=Tag.FXPlatform, ignoreParent=true) double computePrefWidth(double height) {
        return this.getChildren().stream().filter(c -> c instanceof ClassDisplay).mapToDouble(c -> c.getLayoutX() + c.prefWidth(-1.0)).max().orElse(0.0) + 8.0;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.redisplay();
    }

    public void saveImageSelections(Properties p) {
        for (GClassNode gcn : this.topLevel) {
            this.saveImageSelections(gcn, p);
        }
    }

    private void saveImageSelections(GClassNode gcn, Properties p) {
        String imageName = gcn.getImageFilename();
        if (imageName != null) {
            p.put("class." + gcn.getQualifiedName() + ".image", imageName);
        }
        for (GClassNode gcnSubclass : gcn.getSubClasses()) {
            this.saveImageSelections(gcnSubclass, p);
        }
    }
}

