/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx;

import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.javafx.FXCustomizedDialog;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.glavo.png.javafx.PNGJavaFXUtils;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class PastedImageNameDialog
extends FXCustomizedDialog<File> {
    private final File projImagesDir;
    private final Image image;
    private final TextField fileNameField = new TextField();

    public PastedImageNameDialog(Window parent, Image image, File projImagesDir) {
        super(parent, Config.getString((String)"editor.paste.image.title"), "");
        this.projImagesDir = projImagesDir;
        this.image = image;
        this.buildUI();
    }

    private void buildUI() {
        this.fileNameField.setAlignment(Pos.BASELINE_LEFT);
        this.fileNameField.setPromptText(Config.getString((String)"editor.paste.image.name.prompt"));
        this.fileNameField.requestFocus();
        HBox fileNameRow = new HBox(new Node[]{new Label(Config.getString((String)"editor.paste.image.prompt")), this.fileNameField, new Label(".png")});
        fileNameRow.setAlignment(Pos.BASELINE_LEFT);
        HBox.setHgrow((Node)this.fileNameField, (Priority)Priority.ALWAYS);
        VBox bodyPanel = new VBox(20.0, new Node[]{new ImageView(this.image), fileNameRow});
        bodyPanel.setAlignment(Pos.CENTER);
        ScrollPane sp = new ScrollPane();
        sp.setContent((Node)bodyPanel);
        this.setContentPane((Node)sp);
        Window window = this.getDialogPane().getScene().getWindow();
        Stage stage = (Stage)window;
        stage.setMinWidth(350.0);
        stage.setMinHeight(300.0);
        this.getDialogPane().setMaxWidth(900.0);
        this.getDialogPane().setMaxHeight(900.0);
        stage.setX(this.getOwner().getX() + 50.0);
        stage.setY(this.getOwner().getY() + 50.0);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)this.fileNameField.textProperty().isEmpty());
        this.setResultConverter(bt -> bt == ButtonType.OK ? this.createImageFile() : null);
    }

    private File createImageFile() {
        File file = new File(this.projImagesDir, this.fileNameField.getText() + ".png");
        if (file.exists()) {
            boolean overwrite = DialogManager.askQuestionFX((Window)this.asWindow(), (String)"file-exists-overwrite", (String[])new String[]{file.getName()}) == 0;
            return overwrite && this.writeImage(file) ? file : null;
        }
        return this.writeImage(file) ? file : null;
    }

    private boolean writeImage(File file) {
        try {
            PNGJavaFXUtils.writeImage((Image)this.image, (Path)file.toPath());
            return true;
        }
        catch (IOException ex) {
            DialogManager.showErrorFX((Window)this.asWindow(), (String)"imagelib-writing-image-failed");
            return false;
        }
    }
}

