/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui;

import greenfoot.Actor;
import greenfoot.ActorVisitor;
import greenfoot.GreenfootImage;
import greenfoot.ImageVisitor;
import greenfoot.TreeActorSet;
import greenfoot.World;
import greenfoot.WorldVisitor;
import greenfoot.core.TextLabel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Simulation)
public class WorldRenderer {
    private static final Color BACKGROUND = Color.WHITE;
    private Actor dragActor;
    private Point dragLocation;
    private BufferedImage dragImage;

    @OnThread(value=Tag.Any)
    public WorldRenderer() {
    }

    public void renderWorld(World drawWorld, BufferedImage worldImage) {
        Graphics2D g2 = (Graphics2D)worldImage.getGraphics();
        if (drawWorld == null) {
            g2.setColor(BACKGROUND);
            g2.fillRect(0, 0, worldImage.getWidth(), worldImage.getHeight());
        } else {
            this.paintBackground(g2, drawWorld, worldImage.getWidth(), worldImage.getHeight());
            this.paintObjects(g2, drawWorld);
            this.paintDraggedObject(g2, drawWorld);
            WorldVisitor.paintDebug(drawWorld, g2);
            this.paintWorldText(g2, drawWorld);
        }
    }

    private void paintObjects(Graphics2D g, World drawWorld) {
        if (drawWorld == null) {
            return;
        }
        TreeActorSet objects = WorldVisitor.getObjectsListInPaintOrder(drawWorld);
        int paintSeq = 0;
        for (Actor thing : objects) {
            int cellSize = WorldVisitor.getCellSize(drawWorld);
            GreenfootImage image = ActorVisitor.getDisplayImage(thing);
            if (image == null) continue;
            ActorVisitor.setLastPaintSeqNum(thing, paintSeq++);
            double halfWidth = (double)image.getWidth() / 2.0;
            double halfHeight = (double)image.getHeight() / 2.0;
            AffineTransform oldTx = null;
            try {
                int ax = ActorVisitor.getX(thing);
                int ay = ActorVisitor.getY(thing);
                double xCenter = (double)(ax * cellSize) + (double)cellSize / 2.0;
                int paintX = (int)Math.floor(xCenter - halfWidth);
                double yCenter = (double)(ay * cellSize) + (double)cellSize / 2.0;
                int paintY = (int)Math.floor(yCenter - halfHeight);
                int rotation = ActorVisitor.getRotation(thing);
                if (rotation != 0) {
                    oldTx = g.getTransform();
                    g.rotate(Math.toRadians(rotation), xCenter, yCenter);
                }
                ImageVisitor.drawImage(image, g, paintX, paintY, null, true);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (oldTx == null) continue;
            g.setTransform(oldTx);
        }
    }

    private void paintBackground(Graphics2D g, World drawWorld, int width, int height) {
        if (drawWorld != null) {
            GreenfootImage backgroundImage = WorldVisitor.getBackgroundImage(drawWorld);
            if (backgroundImage != null) {
                ImageVisitor.drawImage(backgroundImage, g, 0, 0, null, true);
            } else {
                Color oldColor = g.getColor();
                g.setColor(BACKGROUND);
                g.fillRect(0, 0, width, height);
                g.setColor(oldColor);
            }
        }
    }

    private void paintWorldText(Graphics2D g, World drawWorld) {
        List<TextLabel> labels = WorldVisitor.getTextLabels(drawWorld);
        if (labels.isEmpty()) {
            return;
        }
        Font origFont = g.getFont();
        Color orig = g.getColor();
        Object origAntiAliasing = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        int cellsize = WorldVisitor.getCellSize(drawWorld);
        for (TextLabel label : labels) {
            label.draw(g, cellsize);
        }
        g.setFont(origFont);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, origAntiAliasing);
        g.setColor(orig);
    }

    private void paintDraggedObject(Graphics g, World drawWorld) {
        if (this.dragImage != null) {
            int x = (int)this.dragLocation.getX();
            int y = (int)this.dragLocation.getY();
            int xCell = WorldVisitor.toCellFloor(drawWorld, x);
            int yCell = WorldVisitor.toCellFloor(drawWorld, y);
            int cellSize = WorldVisitor.getCellSize(drawWorld);
            x = (int)(((double)xCell + 0.5) * (double)cellSize - (double)(this.dragImage.getWidth() / 2));
            y = (int)(((double)yCell + 0.5) * (double)cellSize - (double)(this.dragImage.getHeight() / 2));
            g.drawImage(this.dragImage, x, y, null);
        }
    }
}

