/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import greenfoot.GreenfootImage;
import greenfoot.util.GreenfootUtil;
import threadchecker.OnThread;
import threadchecker.Tag;

public interface ReadOnlyProjectProperties {
    public String getString(String var1, String var2);

    default public String getString(String key) {
        return this.getString(key, null);
    }

    default public int getInt(String key) throws NumberFormatException {
        String number = this.getString(key);
        return Integer.parseInt(number);
    }

    default public boolean getBoolean(String key, boolean defaultValue) {
        String bool = this.getString(key, Boolean.toString(defaultValue));
        return Boolean.parseBoolean(bool);
    }

    @OnThread(value=Tag.Simulation)
    default public GreenfootImage getImage(String className) {
        return GreenfootUtil.getGreenfootImage(className, this.getString("class." + className + ".image"));
    }
}

