/*
 * Decompiled with CFR 0.152.
 */
package greenfoot;

import greenfoot.Actor;
import greenfoot.GreenfootImage;
import greenfoot.World;
import greenfoot.collision.ibsp.Rect;
import greenfoot.platforms.ActorDelegate;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ActorVisitor {
    public static void setLocationInPixels(Actor actor, int dragBeginX, int dragBeginY) {
        actor.setLocationInPixels(dragBeginX, dragBeginY);
    }

    public static int getX(Actor actor) {
        return actor.x;
    }

    public static int getY(Actor actor) {
        return actor.y;
    }

    public static int getRotation(Actor actor) {
        return actor.rotation;
    }

    public static World getWorld(Actor actor) {
        return actor.world;
    }

    public static boolean containsPoint(Actor actor, int px, int py) {
        return actor.containsPoint(px, py);
    }

    public static boolean intersects(Actor actor, Actor other) {
        return actor.intersects(other);
    }

    public static int toPixel(Actor actor, int x) {
        return actor.toPixel(x);
    }

    public static Rect getBoundingRect(Actor actor) {
        return actor.getBoundingRect();
    }

    public static void setData(Actor actor, Object n) {
        actor.setData(n);
    }

    public static Object getData(Actor actor) {
        return actor.getData();
    }

    public static GreenfootImage getDisplayImage(Actor actor) {
        return actor.getImage();
    }

    public static GreenfootImage getDragImage(Actor actor) {
        GreenfootImage image = actor.getImage();
        if (image == null) {
            image = Actor.greenfootImage;
        }
        return image;
    }

    @OnThread(value=Tag.Any)
    public static void setDelegate(ActorDelegate instance) {
        Actor.setDelegate(instance);
    }

    public static int getSequenceNumber(Actor actor) {
        return actor.getSequenceNumber();
    }

    public static int getLastPaintSeqNum(Actor actor) {
        return actor.getLastPaintSeqNum();
    }

    public static void setLastPaintSeqNum(Actor actor, int num) {
        actor.setLastPaintSeqNum(num);
    }

    public static boolean decrementSleepForIfPositive(Actor actor) {
        int s = actor.getSleepingFor();
        if (s > 0) {
            actor.setSleepingFor(s - 1);
        }
        return s == 0;
    }
}

