/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.utility.JavaUtils;
import bluej.views.CallableView;
import bluej.views.Comment;
import bluej.views.FormattedPrintWriter;
import bluej.views.View;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

public class MethodView
extends CallableView
implements Comparable<MethodView> {
    protected final @OnThread(value=Tag.Any) Method method;
    protected View returnType;
    private JavaType jtReturnType;

    public MethodView(View view, Method method) throws ClassNotFoundException {
        super(view);
        this.method = method;
        this.jtReturnType = JavaUtils.getJavaUtils().getReturnType(method);
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String toString() {
        return this.method.toString();
    }

    @Override
    @OnThread(value=Tag.Any)
    public int getModifiers() {
        return this.method.getModifiers();
    }

    @Override
    public boolean hasParameters() {
        return this.method.getParameterTypes().length > 0;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public String getSignature() {
        return JavaUtils.getSignature(this.method);
    }

    public String getCallSignature() {
        StringBuffer name = new StringBuffer();
        name.append(this.method.getName());
        name.append('(');
        Class<?>[] params = this.method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            name.append(params[i].getName());
            if (i == params.length - 1) continue;
            name.append(',');
        }
        name.append(')');
        return name.toString();
    }

    @Override
    public String getShortDesc() {
        try {
            return JavaUtils.getJavaUtils().getShortDesc(this.method, this.getParamNames());
        }
        catch (ClassNotFoundException cnfe) {
            return "";
        }
    }

    @Override
    public String getLongDesc() {
        try {
            return JavaUtils.getJavaUtils().getLongDesc(this.method, this.getParamNames());
        }
        catch (ClassNotFoundException cnfe) {
            return "";
        }
    }

    public String getLongDesc(Map<String, GenTypeParameter> genericParams) {
        try {
            if (genericParams == null && this.isStatic()) {
                return JavaUtils.getJavaUtils().getLongDesc(this.method, this.getParamNames());
            }
            return JavaUtils.getJavaUtils().getLongDesc(this.method, this.getParamNames(), genericParams);
        }
        catch (ClassNotFoundException cnfe) {
            return "";
        }
    }

    @Override
    public Class<?>[] getParameters() {
        return this.method.getParameterTypes();
    }

    @Override
    public JavaType[] getParamTypes(boolean raw) {
        try {
            JavaUtils jutils = JavaUtils.getJavaUtils();
            JavaType[] ptypes = jutils.getParamGenTypes(this.method, raw);
            return ptypes;
        }
        catch (ClassNotFoundException cnfe) {
            return new JavaType[0];
        }
    }

    @Override
    public GenTypeDeclTpar[] getTypeParams() throws ClassNotFoundException {
        JavaUtils jutils = JavaUtils.getJavaUtils();
        List<GenTypeDeclTpar> tparams = jutils.getTypeParams(this.method);
        return tparams.toArray(new GenTypeDeclTpar[0]);
    }

    @Override
    public String[] getParamTypeStrings() {
        try {
            return JavaUtils.getJavaUtils().getParameterTypes(this.method);
        }
        catch (ClassNotFoundException cnfe) {
            return new String[0];
        }
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isVoid() {
        return this.method.getReturnType() == Void.TYPE;
    }

    public boolean isMain() {
        if (!this.isVoid()) {
            return false;
        }
        if ("main".equals(this.getName())) {
            Class<?>[] c = this.getParameters();
            if (c.length != 1) {
                return false;
            }
            if (c[0].isArray() && String.class.equals(c[0].getComponentType()) && Modifier.isStatic(this.getModifiers()) && Modifier.isPublic(this.getModifiers())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isVarArgs() {
        return JavaUtils.getJavaUtils().isVarArgs(this.method);
    }

    @Override
    public boolean isGeneric() {
        return !JavaUtils.getJavaUtils().getTypeParams(this.method).isEmpty();
    }

    public View getReturnType() {
        if (this.returnType == null) {
            this.returnType = View.getView(this.method.getReturnType());
        }
        return this.returnType;
    }

    public JavaType getGenericReturnType() {
        return this.jtReturnType;
    }

    @OnThread(value=Tag.FXPlatform)
    public void print(FormattedPrintWriter out, Map<String, GenTypeParameter> typeParams, int indents) {
        Comment comment = this.getComment();
        if (comment != null) {
            comment.print(out, indents);
        }
        out.setItalic(false);
        out.setBold(false);
        out.setSize(FormattedPrintWriter.SizeScheme.DEFAULT);
        out.setColor(FormattedPrintWriter.ColorScheme.DEFAULT);
        for (int i = 0; i < indents; ++i) {
            out.indentLine();
        }
        out.println(this.getLongDesc(typeParams));
    }

    @Override
    public int compareTo(MethodView other) {
        return this.method.getName().compareTo(other.method.getName());
    }
}

