/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class HangingFlowPane
extends Pane {
    private static final String MARGIN_CONSTRAINT = "flowpane-margin";
    private SimpleStyleableDoubleProperty hangingIndentProperty = new SimpleStyleableDoubleProperty(StyleableProperties.HANGING_INDENT, Double.valueOf(0.0));
    private SimpleStyleableDoubleProperty rowSpacingProperty = new SimpleStyleableDoubleProperty(StyleableProperties.ROW_SPACING, Double.valueOf(0.0));
    private DoubleProperty prefWrapLength;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<VPos> rowValignment;
    private List<Run> runs = null;
    private double lastMaxRunLength = -1.0;
    boolean computingRuns = false;
    private static final String ALIGNMENT = "hangingflowpane-alignment";
    private static final String BREAK_BEFORE = "hangingflowpane-breakbefore";

    public static void setMargin(Node child, Insets value) {
        FlowPane.setMargin((Node)child, (Insets)value);
    }

    public static Insets getMargin(Node child) {
        return FlowPane.getMargin((Node)child);
    }

    public static void clearConstraints(Node child) {
        HangingFlowPane.setMargin(child, null);
    }

    public HangingFlowPane() {
        this.getStyleClass().add((Object)"hanging-flow-pane");
    }

    public HangingFlowPane(Node ... children) {
        this();
        this.getChildren().addAll((Object[])children);
    }

    public SimpleStyleableDoubleProperty hangingIndentProperty() {
        return this.hangingIndentProperty;
    }

    public void setHangingIndent(double pixels) {
        this.hangingIndentProperty.set(pixels);
    }

    public final DoubleProperty prefWrapLengthProperty() {
        if (this.prefWrapLength == null) {
            this.prefWrapLength = new DoublePropertyBase(400.0){

                protected void invalidated() {
                    HangingFlowPane.this.requestLayout();
                }

                public Object getBean() {
                    return HangingFlowPane.this;
                }

                public String getName() {
                    return "prefWrapLength";
                }
            };
        }
        return this.prefWrapLength;
    }

    public final void setPrefWrapLength(double value) {
        this.prefWrapLengthProperty().set(value);
    }

    public final double getPrefWrapLength() {
        return this.prefWrapLength == null ? 400.0 : this.prefWrapLength.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new StyleableObjectProperty<Pos>(Pos.TOP_LEFT){

                public void invalidated() {
                    HangingFlowPane.this.requestLayout();
                }

                public CssMetaData<HangingFlowPane, Pos> getCssMetaData() {
                    return StyleableProperties.ALIGNMENT;
                }

                public Object getBean() {
                    return HangingFlowPane.this;
                }

                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos value) {
        this.alignmentProperty().set((Object)value);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)this.alignment.get();
    }

    private Pos getAlignmentInternal() {
        Pos localPos = this.getAlignment();
        return localPos == null ? Pos.TOP_LEFT : localPos;
    }

    public final ObjectProperty<VPos> rowValignmentProperty() {
        if (this.rowValignment == null) {
            this.rowValignment = new StyleableObjectProperty<VPos>(VPos.CENTER){

                public void invalidated() {
                    HangingFlowPane.this.requestLayout();
                }

                public CssMetaData<HangingFlowPane, VPos> getCssMetaData() {
                    return StyleableProperties.ROW_VALIGNMENT;
                }

                public Object getBean() {
                    return HangingFlowPane.this;
                }

                public String getName() {
                    return "rowValignment";
                }
            };
        }
        return this.rowValignment;
    }

    public final void setRowValignment(VPos value) {
        this.rowValignmentProperty().set((Object)value);
    }

    public final VPos getRowValignment() {
        return this.rowValignment == null ? VPos.CENTER : (VPos)this.rowValignment.get();
    }

    private VPos getRowValignmentInternal() {
        VPos localPos = this.getRowValignment();
        return localPos == null ? VPos.CENTER : localPos;
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    protected double computeMinWidth(double height) {
        double maxPref = 0.0;
        ObservableList children = this.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Node child = (Node)children.get(i);
            if (!child.isManaged()) continue;
            maxPref = Math.max(maxPref, child.prefWidth(-1.0));
        }
        Insets insets = this.getInsets();
        return insets.getLeft() + this.snapSize(maxPref) + insets.getRight();
    }

    protected double computeMinHeight(double width) {
        return this.computePrefHeight(width);
    }

    protected double computePrefWidth(double forHeight) {
        Insets insets = this.getInsets();
        double maxRunWidth = this.getPrefWrapLength();
        List<Run> hruns = this.getRuns(maxRunWidth);
        double w = this.computeContentWidth(hruns);
        w = this.getPrefWrapLength() > w ? this.getPrefWrapLength() : w;
        return insets.getLeft() + this.snapSize(w) + insets.getRight();
    }

    protected double computePrefHeight(double forWidth) {
        Insets insets = this.getInsets();
        double maxRunWidth = forWidth != -1.0 ? forWidth - insets.getLeft() - insets.getRight() : this.getPrefWrapLength();
        List<Run> hruns = this.getRuns(maxRunWidth);
        return insets.getTop() + this.computeContentHeight(hruns) + insets.getBottom();
    }

    public void requestLayout() {
        if (!this.computingRuns) {
            this.runs = null;
        }
        super.requestLayout();
    }

    private List<Run> getRuns(double maxRunLength) {
        if (this.runs == null || maxRunLength != this.lastMaxRunLength) {
            this.computingRuns = true;
            this.lastMaxRunLength = maxRunLength;
            this.runs = new ArrayList<Run>();
            double runLength = 0.0;
            double runOffset = 0.0;
            Run run = new Run();
            double vgap = this.rowSpacingProperty.get();
            double hgap = 0.0;
            ObservableList children = this.getChildren();
            boolean goingBackwards = false;
            int furthestReached = 0;
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                Node child = (Node)children.get(i);
                if (!child.isManaged()) continue;
                LayoutRect nodeRect = new LayoutRect();
                nodeRect.node = child;
                Insets margin = HangingFlowPane.getMargin(child);
                nodeRect.width = this.computeChildPrefAreaWidth(child, margin);
                nodeRect.height = this.computeChildPrefAreaHeight(child, margin);
                nodeRect.alignment = HangingFlowPane.getAlignment(child);
                double nodeLength = nodeRect.width;
                if (goingBackwards || runLength + nodeLength > maxRunLength && run.rects.size() >= 1) {
                    if (goingBackwards) {
                        runLength -= run.rects.get((int)(run.rects.size() - 1)).width + hgap;
                        run.rects.remove(run.rects.size() - 1);
                    }
                    if (!HangingFlowPane.canBreakBefore(child) && run.rects.size() > 0 && (goingBackwards || i > furthestReached)) {
                        furthestReached = Math.max(i, furthestReached);
                        goingBackwards = true;
                        i -= 2;
                        continue;
                    }
                    if (run.rects.size() > 0) {
                        this.normalizeRun(run, runOffset);
                        runOffset += run.height + vgap;
                        this.runs.add(run);
                        runLength = this.hangingIndentProperty.get();
                        run = new Run();
                    }
                }
                goingBackwards = false;
                nodeRect.x = runLength;
                runLength += nodeRect.width + hgap;
                run.rects.add(nodeRect);
            }
            this.normalizeRun(run, runOffset);
            this.runs.add(run);
            this.computingRuns = false;
        }
        return this.runs;
    }

    private void normalizeRun(Run run, double runOffset) {
        ArrayList<Node> rownodes = new ArrayList<Node>();
        double hgap = 0.0;
        run.width = (double)(run.rects.size() - 1) * this.snapSpace(hgap);
        int max = run.rects.size();
        for (int i = 0; i < max; ++i) {
            LayoutRect lrect = run.rects.get(i);
            rownodes.add(lrect.node);
            run.width += lrect.width;
            lrect.y = runOffset;
        }
        run.height = this.computeMaxPrefAreaHeight(rownodes, this.getRowValignment());
        run.baselineOffset = this.getRowValignment() == VPos.BASELINE ? this.getAreaBaselineOffset(rownodes, run.rects, run.height, true) : 0.0;
    }

    private double computeContentWidth(List<Run> runs) {
        double cwidth = 0.0;
        int max = runs.size();
        for (int i = 0; i < max; ++i) {
            Run run = runs.get(i);
            cwidth = Math.max(cwidth, run.width);
        }
        return cwidth;
    }

    private double computeContentHeight(List<Run> runs) {
        double vgap = this.rowSpacingProperty.get();
        double cheight = (double)(runs.size() - 1) * this.snapSpace(vgap);
        int max = runs.size();
        for (int i = 0; i < max; ++i) {
            Run run = runs.get(i);
            cheight += run.height;
        }
        return cheight;
    }

    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double width = this.getWidth();
        double height = this.getHeight();
        double top = insets.getTop();
        double left = insets.getLeft();
        double bottom = insets.getBottom();
        double right = insets.getRight();
        double insideWidth = width - left - right;
        double insideHeight = height - top - bottom;
        List<Run> runs = this.getRuns(insideWidth);
        int max = runs.size();
        for (int i = 0; i < max; ++i) {
            int leftNode;
            Run run = runs.get(i);
            double xoffset = left + HangingFlowPane.computeXOffset(insideWidth, run.width, this.getAlignmentInternal().getHpos());
            double yoffset = top + HangingFlowPane.computeYOffset(insideHeight, this.computeContentHeight(runs), this.getAlignmentInternal().getVpos());
            for (leftNode = 0; leftNode < run.rects.size() && run.rects.get((int)leftNode).alignment == FlowAlignment.LEFT; ++leftNode) {
                LayoutRect lrect = run.rects.get(leftNode);
                double x = xoffset + lrect.x;
                double y = yoffset + lrect.y;
                this.layoutInArea(lrect.node, x, y, lrect.width, run.height, run.baselineOffset, HangingFlowPane.getMargin(lrect.node), HPos.LEFT, this.getRowValignmentInternal());
            }
            if (leftNode >= run.rects.size()) continue;
            double rightOffset = HangingFlowPane.computeXOffset(insideWidth, 0.0, HPos.RIGHT) - (run.rects.get((int)(run.rects.size() - 1)).x + run.rects.get((int)(run.rects.size() - 1)).width);
            for (int rightNode = leftNode; rightNode < run.rects.size(); ++rightNode) {
                LayoutRect lrect = run.rects.get(rightNode);
                double x = xoffset + rightOffset + lrect.x;
                double y = yoffset + lrect.y;
                this.layoutInArea(lrect.node, x, y, lrect.width, run.height, run.baselineOffset, HangingFlowPane.getMargin(lrect.node), HPos.LEFT, this.getRowValignmentInternal());
            }
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return HangingFlowPane.getClassCssMetaData();
    }

    static double computeXOffset(double width, double contentWidth, HPos hpos) {
        switch (hpos) {
            case LEFT: {
                return 0.0;
            }
            case CENTER: {
                return (width - contentWidth) / 2.0;
            }
            case RIGHT: {
                return width - contentWidth;
            }
        }
        throw new AssertionError((Object)"Unhandled hPos");
    }

    static double computeYOffset(double height, double contentHeight, VPos vpos) {
        switch (vpos) {
            case BASELINE: 
            case TOP: {
                return 0.0;
            }
            case CENTER: {
                return (height - contentHeight) / 2.0;
            }
            case BOTTOM: {
                return height - contentHeight;
            }
        }
        throw new AssertionError((Object)"Unhandled vPos");
    }

    double getAreaBaselineOffset(List<Node> children, ArrayList<LayoutRect> positionToWidth, double areaHeight, boolean fillHeight) {
        return HangingFlowPane.getAreaBaselineOffset(children, positionToWidth, areaHeight, fillHeight, this.isSnapToPixel());
    }

    static double getAreaBaselineOffset(List<Node> children, ArrayList<LayoutRect> positionToWidth, double areaHeight, boolean fillHeight, boolean snapToPixel) {
        return HangingFlowPane.getAreaBaselineOffset(children, positionToWidth, areaHeight, fillHeight, HangingFlowPane.getMinBaselineComplement(children), snapToPixel);
    }

    static double getAreaBaselineOffset(List<Node> children, ArrayList<LayoutRect> positionToWidth, double areaHeight, boolean fillHeight, double minComplement, boolean snapToPixel) {
        double b = 0.0;
        for (int i = 0; i < children.size(); ++i) {
            Node n = children.get(i);
            Insets margin = HangingFlowPane.getMargin(n);
            double top = margin != null ? HangingFlowPane.snapSpace(margin.getTop(), snapToPixel) : 0.0;
            double bottom = margin != null ? HangingFlowPane.snapSpace(margin.getBottom(), snapToPixel) : 0.0;
            double bo = n.getBaselineOffset();
            if (bo == Double.NEGATIVE_INFINITY) {
                double alt = -1.0;
                if (n.getContentBias() == Orientation.HORIZONTAL) {
                    alt = positionToWidth.get((int)i).width;
                }
                if (fillHeight) {
                    b = Math.max(b, top + HangingFlowPane.boundedSize(n.minHeight(alt), areaHeight - minComplement - top - bottom, n.maxHeight(alt)));
                    continue;
                }
                b = Math.max(b, top + HangingFlowPane.boundedSize(n.minHeight(alt), n.prefHeight(alt), Math.min(n.maxHeight(alt), areaHeight - minComplement - top - bottom)));
                continue;
            }
            b = Math.max(b, top + bo);
        }
        return b;
    }

    static double getMinBaselineComplement(List<Node> children) {
        return HangingFlowPane.getBaselineComplement(children, true, false);
    }

    private static double getBaselineComplement(List<Node> children, boolean min, boolean max) {
        double bc = 0.0;
        for (Node n : children) {
            double bo = n.getBaselineOffset();
            if (bo == Double.NEGATIVE_INFINITY) continue;
            if (n.isResizable()) {
                bc = Math.max(bc, (min ? n.minHeight(-1.0) : (max ? n.maxHeight(-1.0) : n.prefHeight(-1.0))) - bo);
                continue;
            }
            bc = Math.max(bc, n.getLayoutBounds().getHeight() - bo);
        }
        return bc;
    }

    static double boundedSize(double min, double pref, double max) {
        double a = pref >= min ? pref : min;
        double b = min >= max ? min : max;
        return a <= b ? a : b;
    }

    private static double snapSpace(double value, boolean snapToPixel) {
        return snapToPixel ? (double)Math.round(value) : value;
    }

    double computeChildPrefAreaWidth(Node child, Insets margin) {
        return this.computeChildPrefAreaWidth(child, -1.0, margin, -1.0, false);
    }

    double computeChildPrefAreaWidth(Node child, double baselineComplement, Insets margin, double height, boolean fillHeight) {
        boolean snap = this.isSnapToPixel();
        double left = margin != null ? HangingFlowPane.snapSpace(margin.getLeft(), snap) : 0.0;
        double right = margin != null ? HangingFlowPane.snapSpace(margin.getRight(), snap) : 0.0;
        double alt = -1.0;
        if (height != -1.0 && child.isResizable() && child.getContentBias() == Orientation.VERTICAL) {
            double top = margin != null ? HangingFlowPane.snapSpace(margin.getTop(), snap) : 0.0;
            double bottom = margin != null ? HangingFlowPane.snapSpace(margin.getBottom(), snap) : 0.0;
            double bo = child.getBaselineOffset();
            double contentHeight = bo == Double.NEGATIVE_INFINITY && baselineComplement != -1.0 ? height - top - bottom - baselineComplement : height - top - bottom;
            alt = fillHeight ? this.snapSize(HangingFlowPane.boundedSize(child.minHeight(-1.0), contentHeight, child.maxHeight(-1.0))) : this.snapSize(HangingFlowPane.boundedSize(child.minHeight(-1.0), child.prefHeight(-1.0), Math.min(child.maxHeight(-1.0), contentHeight)));
        }
        return left + this.snapSize(HangingFlowPane.boundedSize(child.minWidth(alt), child.prefWidth(alt), child.maxWidth(alt))) + right;
    }

    double computeChildPrefAreaHeight(Node child, Insets margin) {
        return this.computeChildPrefAreaHeight(child, -1.0, margin, -1.0);
    }

    double computeChildPrefAreaHeight(Node child, double prefBaselineComplement, Insets margin, double width) {
        boolean snap = this.isSnapToPixel();
        double top = margin != null ? HangingFlowPane.snapSpace(margin.getTop(), snap) : 0.0;
        double bottom = margin != null ? HangingFlowPane.snapSpace(margin.getBottom(), snap) : 0.0;
        double alt = -1.0;
        if (child.isResizable() && child.getContentBias() == Orientation.HORIZONTAL) {
            double left = margin != null ? HangingFlowPane.snapSpace(margin.getLeft(), snap) : 0.0;
            double right = margin != null ? HangingFlowPane.snapSpace(margin.getRight(), snap) : 0.0;
            alt = this.snapSize(HangingFlowPane.boundedSize(child.minWidth(-1.0), width != -1.0 ? width - left - right : child.prefWidth(-1.0), child.maxWidth(-1.0)));
        }
        if (prefBaselineComplement != -1.0) {
            double baseline = child.getBaselineOffset();
            if (child.isResizable() && baseline == Double.NEGATIVE_INFINITY) {
                return top + this.snapSize(HangingFlowPane.boundedSize(child.minHeight(alt), child.prefHeight(alt), child.maxHeight(alt))) + bottom + prefBaselineComplement;
            }
            return top + baseline + prefBaselineComplement + bottom;
        }
        return top + this.snapSize(HangingFlowPane.boundedSize(child.minHeight(alt), child.prefHeight(alt), child.maxHeight(alt))) + bottom;
    }

    double computeMaxPrefAreaHeight(List<Node> children, VPos valignment) {
        return this.getMaxAreaHeight(children, null, valignment, false);
    }

    private double getMaxAreaHeight(List<Node> children, double[] childWidths, VPos valignment, boolean minimum) {
        double singleChildWidth;
        double d = childWidths == null ? -1.0 : (singleChildWidth = childWidths.length == 1 ? childWidths[0] : Double.NaN);
        if (valignment == VPos.BASELINE) {
            double maxAbove = 0.0;
            double maxBelow = 0.0;
            int maxPos = children.size();
            for (int i = 0; i < maxPos; ++i) {
                double childHeight;
                Node child = children.get(i);
                double childWidth = Double.isNaN(singleChildWidth) ? childWidths[i] : singleChildWidth;
                Insets margin = HangingFlowPane.getMargin(child);
                double top = margin != null ? this.snapSpace(margin.getTop()) : 0.0;
                double bottom = margin != null ? this.snapSpace(margin.getBottom()) : 0.0;
                double baseline = child.getBaselineOffset();
                double d2 = childHeight = minimum ? this.snapSize(child.minHeight(childWidth)) : this.snapSize(child.prefHeight(childWidth));
                if (baseline == Double.NEGATIVE_INFINITY) {
                    maxAbove = Math.max(maxAbove, childHeight + top);
                    continue;
                }
                maxAbove = Math.max(maxAbove, baseline + top);
                maxBelow = Math.max(maxBelow, this.snapSpace(minimum ? this.snapSize(child.minHeight(childWidth)) : this.snapSize(child.prefHeight(childWidth))) - baseline + bottom);
            }
            return maxAbove + maxBelow;
        }
        double max = 0.0;
        int maxPos = children.size();
        for (int i = 0; i < maxPos; ++i) {
            Node child = children.get(i);
            Insets margin = HangingFlowPane.getMargin(child);
            double childWidth = Double.isNaN(singleChildWidth) ? childWidths[i] : singleChildWidth;
            max = Math.max(max, minimum ? this.computeChildMinAreaHeight(child, -1.0, margin, childWidth) : this.computeChildPrefAreaHeight(child, -1.0, margin, childWidth));
        }
        return max;
    }

    double computeChildMinAreaHeight(Node child, double minBaselineComplement, Insets margin, double width) {
        boolean snap = this.isSnapToPixel();
        double top = margin != null ? HangingFlowPane.snapSpace(margin.getTop(), snap) : 0.0;
        double bottom = margin != null ? HangingFlowPane.snapSpace(margin.getBottom(), snap) : 0.0;
        double alt = -1.0;
        if (child.isResizable() && child.getContentBias() == Orientation.HORIZONTAL) {
            double left = margin != null ? HangingFlowPane.snapSpace(margin.getLeft(), snap) : 0.0;
            double right = margin != null ? HangingFlowPane.snapSpace(margin.getRight(), snap) : 0.0;
            alt = this.snapSize(width != -1.0 ? HangingFlowPane.boundedSize(child.minWidth(-1.0), width - left - right, child.maxWidth(-1.0)) : child.maxWidth(-1.0));
        }
        if (minBaselineComplement != -1.0) {
            double baseline = child.getBaselineOffset();
            if (child.isResizable() && baseline == Double.NEGATIVE_INFINITY) {
                return top + this.snapSize(child.minHeight(alt)) + bottom + minBaselineComplement;
            }
            return baseline + minBaselineComplement;
        }
        return top + this.snapSize(child.minHeight(alt)) + bottom;
    }

    public static void setAlignment(Node child, FlowAlignment value) {
        HangingFlowPane.setConstraint(child, ALIGNMENT, (Object)value);
    }

    private static FlowAlignment getAlignment(Node child) {
        FlowAlignment a = (FlowAlignment)((Object)HangingFlowPane.getConstraint(child, ALIGNMENT));
        if (a != null) {
            return a;
        }
        return FlowAlignment.LEFT;
    }

    public static void setBreakBefore(Node child, Boolean canBreakBefore) {
        HangingFlowPane.setConstraint(child, BREAK_BEFORE, canBreakBefore);
    }

    private static boolean canBreakBefore(Node child) {
        Boolean b = (Boolean)HangingFlowPane.getConstraint(child, BREAK_BEFORE);
        if (b == null) {
            return true;
        }
        return b;
    }

    private static void setConstraint(Node node, Object key, Object value) {
        if (value == null) {
            node.getProperties().remove(key);
        } else {
            node.getProperties().put(key, value);
        }
        if (node.getParent() != null) {
            node.getParent().requestLayout();
        }
    }

    private static Object getConstraint(Node node, Object key) {
        if (node.hasProperties()) {
            return node.getProperties().get(key);
        }
        return null;
    }

    private static class StyleableProperties {
        private static final CssMetaData<HangingFlowPane, Pos> ALIGNMENT = new CssMetaData<HangingFlowPane, Pos>("-fx-alignment", (StyleConverter)new EnumConverter(Pos.class), Pos.TOP_LEFT){

            public boolean isSettable(HangingFlowPane node) {
                return node.alignment == null || !node.alignment.isBound();
            }

            public StyleableProperty<Pos> getStyleableProperty(HangingFlowPane node) {
                return (StyleableProperty)node.alignmentProperty();
            }
        };
        private static final CssMetaData<HangingFlowPane, Number> HANGING_INDENT = JavaFXUtil.cssSize("-bj-hanging-indent", hfp -> hfp.hangingIndentProperty);
        private static final CssMetaData<HangingFlowPane, Number> ROW_SPACING = JavaFXUtil.cssSize("-bj-row-spacing", hfp -> hfp.rowSpacingProperty);
        private static final CssMetaData<HangingFlowPane, VPos> ROW_VALIGNMENT = new CssMetaData<HangingFlowPane, VPos>("-fx-row-valignment", (StyleConverter)new EnumConverter(VPos.class), VPos.CENTER){

            public boolean isSettable(HangingFlowPane node) {
                return node.rowValignment == null || !node.rowValignment.isBound();
            }

            public StyleableProperty<VPos> getStyleableProperty(HangingFlowPane node) {
                return (StyleableProperty)node.rowValignmentProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(Region.getClassCssMetaData());
            styleables.add(ALIGNMENT);
            styleables.add(ROW_VALIGNMENT);
            styleables.add(HANGING_INDENT);
            styleables.add(ROW_SPACING);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private static class Run {
        ArrayList<LayoutRect> rects = new ArrayList();
        double width;
        double height;
        double baselineOffset;

        private Run() {
        }
    }

    private static class LayoutRect {
        public Node node;
        double x;
        double y;
        double width;
        double height;
        FlowAlignment alignment;

        private LayoutRect() {
        }

        public String toString() {
            return "LayoutRect node id=" + this.node.getId() + " " + this.x + "," + this.y + " " + this.width + "x" + this.height;
        }
    }

    public static enum FlowAlignment {
        LEFT,
        RIGHT;

    }
}

