/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ScalableHeightTextField;
import bluej.utility.javafx.TextFieldDelegate;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import threadchecker.OnThread;
import threadchecker.Tag;

public class DelegableScalableTextField<DELEGATE_IDENT>
extends ScalableHeightTextField {
    private final SimpleStyleableDoubleProperty bjMinWidthProperty = new SimpleStyleableDoubleProperty(BJ_MIN_WIDTH_META_DATA);
    private boolean inNextWord = false;
    private static final CssMetaData<DelegableScalableTextField<?>, Number> BJ_MIN_WIDTH_META_DATA = JavaFXUtil.cssSize("-bj-min-width", DelegableScalableTextField::bjMinWidthProperty);
    private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList = JavaFXUtil.extendCss(TextField.getClassCssMetaData()).add(BJ_MIN_WIDTH_META_DATA).build();
    private final TextFieldDelegate<DELEGATE_IDENT> delegate;
    private final DELEGATE_IDENT delegateId;

    private final SimpleStyleableDoubleProperty bjMinWidthProperty() {
        return this.bjMinWidthProperty;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return cssMetaDataList;
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void insertText(int index, String text) {
        this.delegate.insert(this.delegateId, index, text);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) boolean deletePreviousChar() {
        if (this.delegate.deleteSelection() || this.delegate.deletePrevious(this.delegateId, this.getCaretPosition(), this.getCaretPosition() == 0)) {
            return true;
        }
        return super.deletePreviousChar();
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public @OnThread(value=Tag.FXPlatform, ignoreParent=true) boolean deleteNextChar() {
        if (this.delegate.deleteSelection() || this.delegate.deleteNext(this.delegateId, this.getCaretPosition(), this.getCaretPosition() == this.getLength())) {
            return true;
        }
        return super.deleteNextChar();
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void previousWord() {
        if (!this.delegate.previousWord(this.delegateId, this.getCaretPosition() == 0)) {
            super.previousWord();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void nextWord() {
        if (!this.delegate.nextWord(this.delegateId, this.getCaretPosition() == this.getLength())) {
            this.inNextWord = true;
            super.nextWord();
            this.inNextWord = false;
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void endOfNextWord() {
        if (!this.delegate.endOfNextWord(this.delegateId, this.getCaretPosition() == this.getLength())) {
            super.endOfNextWord();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void backward() {
        this.delegate.deselect();
        if (this.getCaretPosition() == 0) {
            this.delegate.backwardAtStart(this.delegateId);
        } else {
            super.backward();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void cut() {
        if (!this.delegate.cut()) {
            super.cut();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void copy() {
        if (!this.delegate.copy()) {
            super.copy();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void forward() {
        this.delegate.deselect();
        if (this.getCaretPosition() == this.getText().length()) {
            this.delegate.forwardAtEnd(this.delegateId);
        } else {
            super.forward();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void appendText(String text) {
        this.insertText(this.getText().length(), text);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void replaceText(IndexRange range, String text) {
        this.replaceText(range.getStart(), range.getEnd(), text);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void replaceText(int start, int end, String text) {
        this.insertText(start, text);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void deleteText(IndexRange range) {
        super.deleteText(range.getStart(), range.getEnd());
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void deleteText(int start, int end) {
        this.delegate.delete(this.delegateId, start, end);
        this.positionCaret(start);
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void selectBackward() {
        if (!this.delegate.selectBackward(this.delegateId, this.getCaretPosition())) {
            super.selectBackward();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void deselect() {
        this.delegate.deselect();
        super.deselect();
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void selectForward() {
        if (!this.delegate.selectForward(this.delegateId, this.getCaretPosition(), this.getCaretPosition() == this.getLength())) {
            super.selectForward();
        }
    }

    public DelegableScalableTextField(final TextFieldDelegate<DELEGATE_IDENT> delegate, DELEGATE_IDENT ident, String content) {
        super(content);
        this.delegate = delegate;
        this.delegateId = ident;
        JavaFXUtil.addStyleClass((Styleable)this, "delegable-scalable-text-field");
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.prefWidthProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind(new Observable[]{DelegableScalableTextField.this.promptTextProperty()});
                super.bind(new Observable[]{DelegableScalableTextField.this.fontProperty()});
                super.bind(new Observable[]{DelegableScalableTextField.this.focusedProperty()});
                super.bind(new Observable[]{DelegableScalableTextField.this.paddingProperty()});
                super.bind(new Observable[]{DelegableScalableTextField.this.bjMinWidthProperty()});
            }

            protected double computeValue() {
                if (DelegableScalableTextField.this.getPromptText().isEmpty() && DelegableScalableTextField.this.getText().isEmpty()) {
                    return DelegableScalableTextField.this.bjMinWidthProperty.get();
                }
                double minWidth = DelegableScalableTextField.this.getPromptText().isEmpty() || !DelegableScalableTextField.this.getText().isEmpty() ? DelegableScalableTextField.this.bjMinWidthProperty.get() : JavaFXUtil.measureString((TextInputControl)DelegableScalableTextField.this, DelegableScalableTextField.this.getPromptText());
                return Math.max(minWidth, 2.0 + JavaFXUtil.measureString((TextInputControl)DelegableScalableTextField.this, DelegableScalableTextField.this.getText()));
            }
        });
        this.setOnMousePressed(e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 1) {
                delegate.clicked();
                delegate.moveTo(e.getSceneX(), e.getSceneY(), true);
                e.consume();
            }
        });
        this.setOnDragDetected(e -> e.consume());
        this.setOnMouseDragged(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                delegate.selectTo(e.getSceneX(), e.getSceneY());
                e.consume();
            }
        });
        this.setOnMouseReleased(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                delegate.selected();
                e.consume();
            }
        });
        this.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                e.consume();
            }
        });
        this.caretPositionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            @OnThread(value=Tag.FXPlatform, ignoreParent=true)
            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                delegate.caretMoved();
            }
        });
        this.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                delegate.escape();
            }
        });
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void selectNextWord() {
        if (!this.delegate.selectNextWord(this.delegateId)) {
            super.selectNextWord();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void selectEndOfNextWord() {
        if (!this.delegate.selectNextWord(this.delegateId)) {
            super.selectEndOfNextWord();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void selectPreviousWord() {
        if (!this.delegate.selectPreviousWord(this.delegateId)) {
            super.selectPreviousWord();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void selectAll() {
        if (!this.delegate.selectAll(this.delegateId)) {
            super.selectAll();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void home() {
        this.delegate.deselect();
        if (!this.delegate.home(this.delegateId)) {
            super.home();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void end() {
        this.delegate.deselect();
        if (!this.delegate.end(this.delegateId, this.inNextWord)) {
            super.end();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void selectHome() {
        if (!this.delegate.selectHome(this.delegateId, this.getCaretPosition())) {
            super.selectHome();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void selectEnd() {
        if (!this.delegate.selectEnd(this.delegateId, this.getCaretPosition())) {
            super.selectEnd();
        }
    }

    @OnThread(value=Tag.FXPlatform, ignoreParent=true)
    public void paste() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard.hasString()) {
            this.delegate.deleteSelection();
            this.insertText(this.getCaretPosition(), clipboard.getString());
        }
    }

    public double calculateSceneX(int caretPos) {
        double borderLeft = 0.0;
        if (this.getBorder() != null && this.getBorder().getInsets() != null) {
            borderLeft = this.getBorder().getInsets().getLeft();
        }
        double localX = this.getPadding().getLeft() + borderLeft + JavaFXUtil.measureString((TextInputControl)this, this.getText().substring(0, Math.min(caretPos, this.getText().length())), true, false);
        return this.localToScene(localX, 0.0).getX();
    }
}

