/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.slots;

import bluej.stride.framedjava.ast.JavaFragment;
import bluej.stride.framedjava.ast.Parser;
import bluej.stride.framedjava.ast.links.PossibleLink;
import bluej.stride.framedjava.ast.links.PossibleMethodUseLink;
import bluej.stride.framedjava.ast.links.PossibleTypeLink;
import bluej.stride.framedjava.ast.links.PossibleVarLink;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.slots.BracketedStructured;
import bluej.stride.framedjava.slots.CaretPos;
import bluej.stride.framedjava.slots.ExpressionSlot;
import bluej.stride.framedjava.slots.InfixStructured;
import bluej.stride.framedjava.slots.Operator;
import bluej.stride.framedjava.slots.StructuredSlot;
import bluej.stride.framedjava.slots.StructuredSlotComponent;
import bluej.stride.framedjava.slots.StructuredSlotField;
import bluej.stride.generic.InteractionManager;
import bluej.utility.javafx.FXConsumer;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public class InfixExpression
extends InfixStructured<ExpressionSlot<?>, InfixExpression> {
    private boolean queuedUpdatePrompts;

    private InfixExpression(InteractionManager editor, ExpressionSlot<?> slot, String initialContent, BracketedStructured wrapper, StructuredSlot.ModificationToken token, Character ... closingChars) {
        super(editor, slot, initialContent, wrapper, token, closingChars);
    }

    InfixExpression(InteractionManager editor, ExpressionSlot<?> slot, StructuredSlot.ModificationToken token) {
        super(editor, slot, token);
    }

    static boolean isExpressionOperator(String s) {
        switch (s) {
            case "+": 
            case "-": 
            case "*": 
            case "/": 
            case "==": 
            case "!=": 
            case ">": 
            case ">=": 
            case "<=": 
            case "<": 
            case "%": 
            case "&": 
            case "&&": 
            case "|": 
            case "||": 
            case "^": 
            case "~": 
            case "!": 
            case ".": 
            case "..": 
            case "<:": 
            case ",": 
            case "<<": 
            case ">>": 
            case ">>>": 
            case "->": 
            case "::": {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean isOperator(String s) {
        return InfixExpression.isExpressionOperator(s);
    }

    static boolean beginsExpressionOperator(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean beginsOperator(char c) {
        return InfixExpression.beginsExpressionOperator(c);
    }

    @Override
    boolean canBeUnary(String s) {
        if (s == null) {
            return false;
        }
        switch (s) {
            case "+": 
            case "-": 
            case "~": 
            case "!": 
            case "new ": {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isOpeningBracket(char c) {
        return c == '(' || c == '[' || c == '{';
    }

    @Override
    protected boolean isClosingBracket(char c) {
        return c == ')' || c == ']' || c == '}';
    }

    @Override
    protected boolean isDisallowed(char c) {
        return c == ';';
    }

    @Override
    InfixExpression newInfix(InteractionManager editor, ExpressionSlot<?> slot, String initialContent, BracketedStructured<?, ExpressionSlot<?>> wrapper, StructuredSlot.ModificationToken token, Character ... closingChars) {
        return new InfixExpression(editor, slot, initialContent, wrapper, token, closingChars);
    }

    @OnThread(value=Tag.FXPlatform)
    void treatAsConstructorParams_updatePrompts() {
        List<StructuredSlotField> params = this.getSimpleParameters();
        if (params.stream().allMatch(p -> p == null)) {
            return;
        }
        ((ExpressionSlot)this.slot).withParamNamesForConstructor(poss -> this.setPromptsFromParamNames((List<List<String>>)poss));
    }

    @OnThread(value=Tag.FXPlatform)
    void treatAsParams_updatePrompts(String methodName, CaretPos absPosOfMethodName) {
        List<StructuredSlotField> params = this.getSimpleParameters();
        if (params.stream().allMatch(p -> p == null)) {
            return;
        }
        if (this.slot == null) {
            return;
        }
        ((ExpressionSlot)this.slot).withParamNamesForPos(absPosOfMethodName, methodName, poss -> this.setPromptsFromParamNames((List<List<String>>)poss));
    }

    @OnThread(value=Tag.FXPlatform)
    private void setPromptsFromParamNames(List<List<String>> possibilities) {
        List<StructuredSlotField> curParams = this.getSimpleParameters();
        int curArity = curParams.size() == 1 && curParams.get(0) != null && curParams.get(0).isEmpty() ? 0 : curParams.size();
        boolean arityFlexible = curParams.stream().allMatch(f -> f != null && f.isEmpty());
        List matchedPoss = possibilities.stream().filter(ps -> arityFlexible || ps.size() == curArity).sorted(Comparator.comparing(List::size)).collect(Collectors.toList());
        if (matchedPoss.size() != 1) {
            if (arityFlexible && !this.isEmpty()) {
                this.modification(this::blank);
            }
            curParams.stream().filter(f -> f != null).forEach(f -> f.setPromptText(""));
        } else {
            List match = (List)matchedPoss.get(0);
            if (arityFlexible && match.size() != curArity) {
                boolean wasFocused = this.isFocused();
                this.modificationPlatform(token -> {
                    this.blank((StructuredSlot.ModificationToken)token);
                    for (int i = 0; i < match.size() - 1; ++i) {
                        this.insertChar(this.getEndPos(), ',', false, (StructuredSlot.ModificationToken)token);
                    }
                });
                curParams = this.getSimpleParameters();
                if (wasFocused) {
                    this.getFirstField().requestFocus();
                }
            }
            for (int i = 0; i < match.size(); ++i) {
                String prompt = (String)match.get(i);
                if (prompt == null || Parser.isDummyName(prompt)) {
                    prompt = "";
                }
                if (i >= curParams.size() || curParams.get(i) == null) continue;
                curParams.get(i).setPromptText(prompt);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void updatePromptsInMethodCalls() {
        this.queuedUpdatePrompts = false;
        for (int i = 0; i < this.fields.size(); ++i) {
            if (i >= this.fields.size() - 1 || !(this.fields.get(i) instanceof StructuredSlotField) || ((StructuredSlotComponent)this.fields.get(i)).isFieldAndEmpty() || !(this.fields.get(i + 1) instanceof BracketedStructured) || ((BracketedStructured)this.fields.get(i + 1)).getOpening() != '(') continue;
            BracketedStructured bracketedParams = (BracketedStructured)this.fields.get(i + 1);
            CaretPos absPos = this.absolutePos(new CaretPos(i, new CaretPos(0, null)));
            ((InfixExpression)bracketedParams.getContent()).treatAsParams_updatePrompts(((StructuredSlotComponent)this.fields.get(i)).getCopyText(null, null), absPos);
        }
    }

    void queueUpdatePromptsInMethodCalls() {
        if (!this.queuedUpdatePrompts && this.slot != null && Platform.isFxApplicationThread()) {
            this.queuedUpdatePrompts = true;
            ((ExpressionSlot)this.slot).afterCurrentModification(this::updatePromptsInMethodCalls);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void calculateTooltipFor(StructuredSlotField expressionSlotField, FXConsumer<String> handler) {
        int slotIndex = this.fields.indexOf(expressionSlotField);
        if (!expressionSlotField.getText().equals("") && slotIndex + 1 < this.fields.size() && this.fields.get(slotIndex + 1) instanceof BracketedStructured) {
            CaretPos relPos = new CaretPos(slotIndex, new CaretPos(0, null));
            ((ExpressionSlot)this.slot).withMethodHint(this.absolutePos(relPos), ((StructuredSlotComponent)this.fields.get(slotIndex)).getCopyText(null, null), methodHints -> {
                if (methodHints.size() == 1) {
                    handler.accept((String)methodHints.get(0));
                } else {
                    handler.accept("");
                }
            });
        } else if (this.parent != null || ((ExpressionSlot)this.slot).isConstructorParams()) {
            int paramIndex = 0;
            int totalParams = 1;
            for (int i = 0; i < this.operators.size(); ++i) {
                if (this.operators.get(i) == null || !((Operator)this.operators.get(i)).getCopyText().equals(",")) continue;
                ++totalParams;
                if (i >= slotIndex) continue;
                ++paramIndex;
            }
            if (this.parent != null) {
                ((InfixExpression)this.parent.getParent()).withTooltipForParam(this.parent, paramIndex, handler);
            } else {
                int finalParamIndex = paramIndex;
                ((ExpressionSlot)this.slot).withParamHintsForConstructor(totalParams, conHints -> {
                    if (conHints.size() == 1 && finalParamIndex < ((List)conHints.get(0)).size()) {
                        handler.accept((String)((List)conHints.get(0)).get(finalParamIndex));
                    }
                });
            }
        } else {
            handler.accept("");
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void withTooltipForParam(BracketedStructured bracketedExpression, int paramPos, FXConsumer<String> handler) {
        int expIndex = this.fields.indexOf(bracketedExpression);
        if (((StructuredSlotComponent)this.fields.get(expIndex - 1)).getCopyText(null, null).equals("")) {
            handler.accept("");
        } else {
            CaretPos relPos = new CaretPos(expIndex - 1, new CaretPos(0, null));
            ((ExpressionSlot)this.slot).withParamHintsForPos(this.absolutePos(relPos), ((StructuredSlotComponent)this.fields.get(expIndex - 1)).getCopyText(null, null), paramHints -> {
                if (paramHints.size() == 1 && paramPos < ((List)paramHints.get(0)).size()) {
                    handler.accept((String)((List)paramHints.get(0)).get(paramPos));
                    return;
                }
                handler.accept("");
            });
        }
    }

    @Override
    protected StructuredSlotField makeNewField(String content, boolean stringLiteral) {
        StructuredSlotField field = super.makeNewField(content, stringLiteral);
        JavaFXUtil.addChangeListener(field.textProperty(), t -> this.queueUpdatePromptsInMethodCalls());
        return field;
    }

    public List<? extends PossibleLink> findLinks(Optional<Character> surroundingBracket, Map<String, CodeElement> vars, Function<Integer, JavaFragment.PosInSourceDoc> posCalculator, int offset) {
        int cur;
        ArrayList<? extends PossibleLink> r = new ArrayList<PossibleLink>();
        int beginningSlot = cur = 0;
        int endSlot = cur;
        int endLength = -1;
        Object curOperand = "";
        while (cur < this.fields.size()) {
            if (this.fields.get(cur) instanceof StructuredSlotField) {
                StructuredSlotField expressionSlotField = (StructuredSlotField)this.fields.get(cur);
                if (expressionSlotField.getText().equals("class") && ((String)curOperand).endsWith(".")) {
                    r.add(new PossibleTypeLink(((String)curOperand).substring(0, ((String)curOperand).length() - 1), offset + this.caretPosToStringPos(new CaretPos(beginningSlot, new CaretPos(0, null)), false), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(endLength, null)), false), this.getSlot()));
                }
                if (((String)curOperand).equals("")) {
                    beginningSlot = cur;
                }
                curOperand = (String)curOperand + expressionSlotField.getText();
                endSlot = cur;
                endLength = expressionSlotField.getText().length();
                if (cur >= this.operators.size() || this.operators.get(cur) != null) {
                    if (cur < this.operators.size() && ((Operator)this.operators.get(cur)).get().equals(".")) {
                        curOperand = (String)curOperand + ".";
                    } else {
                        CodeElement el;
                        if (cur == this.operators.size() && beginningSlot == 0 && surroundingBracket.isPresent() && surroundingBracket.get().charValue() == '(') {
                            r.add(new PossibleTypeLink((String)curOperand, offset + this.caretPosToStringPos(new CaretPos(beginningSlot, new CaretPos(0, null)), false), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(endLength, null)), false), this.getSlot()));
                        }
                        if (cur == beginningSlot && vars != null && (el = vars.get(curOperand)) != null) {
                            r.add(new PossibleVarLink((String)curOperand, el, offset + this.caretPosToStringPos(new CaretPos(beginningSlot, new CaretPos(0, null)), false), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(endLength, null)), false), this.getSlot()));
                        }
                        curOperand = "";
                    }
                }
            } else if (this.fields.get(cur) instanceof BracketedStructured) {
                StructuredSlotField prev = (StructuredSlotField)this.fields.get(cur - 1);
                int innerOffset = 1 + offset + this.caretPosToStringPos(new CaretPos(cur - 1, new CaretPos(prev.getText().length(), null)), false);
                BracketedStructured be = (BracketedStructured)this.fields.get(cur);
                r.addAll(((InfixExpression)be.getContent()).findLinks(Optional.of(Character.valueOf(be.getOpening())), vars, posCalculator, innerOffset));
                if (!((String)curOperand).equals("") && be.getOpening() == '(') {
                    int endSlotFinal = endSlot;
                    r.add(new PossibleMethodUseLink(((String)curOperand).substring(((String)curOperand).indexOf(".") + 1), ((InfixExpression)be.getContent()).getSimpleParameters().size(), () -> (JavaFragment.PosInSourceDoc)posCalculator.apply(offset + this.caretPosToStringPos(new CaretPos(endSlotFinal, new CaretPos(0, null)), true)), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(0, null)), false), offset + this.caretPosToStringPos(new CaretPos(endSlot, new CaretPos(endLength, null)), false), this.getSlot()));
                }
            }
            ++cur;
        }
        return r;
    }

    @Override
    protected boolean supportsFloatLiterals() {
        return true;
    }
}

