/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.convert;

import bluej.parser.lexer.LocatableToken;
import bluej.stride.framedjava.convert.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

interface Modifier {
    public boolean isKeyword(String var1);

    public boolean isAnnotation(String var1);

    public LocatableToken getStart();

    public LocatableToken getEnd();

    public static class AnnotationModifier
    implements Modifier {
        private final String annotation;
        private final LocatableToken start;
        private final LocatableToken end;
        private List<Expression> params;

        public AnnotationModifier(List<LocatableToken> annotation) {
            this.annotation = annotation.stream().map(LocatableToken::getText).collect(Collectors.joining());
            this.start = annotation.get(0);
            this.end = annotation.get(annotation.size() - 1);
        }

        public void setParams(List<Expression> params) {
            this.params = new ArrayList<Expression>(params);
        }

        @Override
        public boolean isKeyword(String modifier) {
            return false;
        }

        @Override
        public boolean isAnnotation(String annotation) {
            if (annotation.startsWith("@")) {
                return this.annotation.equals(annotation.substring(1));
            }
            return this.annotation.equals(annotation);
        }

        public String toString() {
            return "@" + this.annotation + (this.params == null ? "" : this.params.stream().map(Expression::toString).collect(Collectors.joining(" , ")));
        }

        @Override
        public LocatableToken getEnd() {
            return this.end;
        }

        @Override
        public LocatableToken getStart() {
            return this.start;
        }
    }

    public static class KeywordModifier
    implements Modifier {
        private final LocatableToken keyword;

        KeywordModifier(LocatableToken keyword) {
            this.keyword = keyword;
        }

        @Override
        public boolean isKeyword(String modifier) {
            return this.keyword.getText().equals(modifier);
        }

        @Override
        public boolean isAnnotation(String annotation) {
            return false;
        }

        @Override
        public LocatableToken getStart() {
            return this.keyword;
        }

        @Override
        public LocatableToken getEnd() {
            return this.keyword;
        }

        public String toString() {
            return this.keyword.getText();
        }
    }
}

