/*
 * Decompiled with CFR 0.152.
 */
package bluej.stride.framedjava.convert;

import bluej.Config;
import bluej.utility.Utility;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;

public class ConvertResultDialog {
    private final Alert alert;

    public ConvertResultDialog(String xmlParseError, String convertError) {
        this.alert = new Alert(Alert.AlertType.ERROR, Config.getString("stride.convert.paste.errors"), new ButtonType[]{ButtonType.OK});
        this.alert.setTitle(Config.getString("stride.convert.paste.errors.title"));
        this.alert.setHeaderText(this.alert.getTitle());
        StringBuilder s = new StringBuilder();
        s.append(Config.getString("stride.convert.error.stride") + ":\n  " + xmlParseError + "\n\n");
        s.append(Config.getString("stride.convert.error.java") + ":\n  " + convertError);
        this.addDetails(s.toString());
    }

    public ConvertResultDialog(String convertError) {
        this.alert = new Alert(Alert.AlertType.ERROR, Config.getString("stride.convert.whole.errors"), new ButtonType[]{ButtonType.OK});
        this.alert.setTitle(Config.getString("stride.convert.whole.errors.title"));
        this.alert.setHeaderText(this.alert.getTitle());
        StringBuilder s = new StringBuilder();
        s.append(Config.getString("stride.convert.error.java") + ":\n  " + convertError);
        this.addDetails(s.toString());
    }

    public ConvertResultDialog(List<String> warnings) {
        this.alert = new Alert(Alert.AlertType.WARNING, Config.getString("stride.convert.warnings"), new ButtonType[]{ButtonType.OK});
        this.alert.setTitle(Config.getString("stride.convert.warnings.title"));
        this.alert.setHeaderText(this.alert.getTitle());
        this.alert.setOnShown(e -> Utility.bringToFrontFX(this.alert.getDialogPane().getScene().getWindow()));
        this.addDetails(warnings.stream().collect(Collectors.joining("\n")));
    }

    private void addDetails(String extra) {
        this.alert.getDialogPane().setMaxWidth(600.0);
        TextArea extraDisplay = new TextArea(extra);
        extraDisplay.setWrapText(true);
        extraDisplay.setPrefRowCount(8);
        extraDisplay.setEditable(false);
        Label label = new Label(this.alert.getContentText());
        label.setWrapText(true);
        VBox vBox = new VBox(new Node[]{label, extraDisplay});
        vBox.setSpacing(20.0);
        this.alert.getDialogPane().setContent((Node)vBox);
    }

    public void showAndWait() {
        this.alert.showAndWait();
    }
}

