/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.Config;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableNumberValue;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class PrefMgr {
    public static final String HIGHLIGHTING = "bluej.editor.syntaxHilighting";
    public static final String AUTO_INDENT = "bluej.editor.autoIndent";
    public static final String CLOSE_CURLY = "bluej.editor.autoAddClosingCurly";
    public static final String LINENUMBERS = "bluej.editor.displayLineNumbers";
    public static final String MATCH_BRACKETS = "bluej.editor.matchBrackets";
    public static final String CHECK_DISKFILECHANGES = "bluej.editor.checkDiskFileChanges";
    public static final String LINK_LIB = "doctool.linkToStandardLib";
    public static final String SHOW_TEST_TOOLS = "bluej.testing.showtools";
    public static final String SHOW_TEAM_TOOLS = "bluej.teamwork.showtools";
    public static final String SHOW_TEXT_EVAL = "bluej.startWithTextEval";
    public static final String SHOW_UNCHECKED = "bluej.compiler.showunchecked";
    public static final String SCOPE_HIGHLIGHTING_STRENGTH = "bluej.editor.scopeHilightingStrength";
    public static final String NAVIVIEW_EXPANDED = "bluej.naviviewExpanded.default";
    public static final String ACCESSIBILITY_SUPPORT = "bluej.accessibility.support";
    public static final String NEWS_TESTING = "bluej.news.testing";
    public static final String START_WITH_SUDO = "bluej.startWithSudo";
    public static final String STRIDE_SIDEBAR_SHOWING = "bluej.editor.stride.sidebarShowing";
    public static final String PACKAGE_PRINT_SOURCE = "bluej.packagePrint.source";
    public static final String PACKAGE_PRINT_DIAGRAM = "bluej.packagePrint.diagram";
    public static final String PACKAGE_PRINT_README = "bluej.packagePrint.readme";
    public static final String PRINT_LINE_NUMBERS = "bluej.print.lineNumbers";
    public static final String PRINT_SCOPE_HIGHLIGHTING = "bluej.print.scopeHighlighting";
    public static final String PRINT_FONT_SIZE = "bluej.print.fontSize";
    public static final String GREENFOOT_SOUND_INPUT_DEVICE = "greenfoot.sound.device.input";
    public static final String GREENFOOT_SOUND_OUTPUT_DEVICE = "greenfoot.sound.device.output";
    public static final int MIN_EDITOR_FONT_SIZE = 6;
    public static final int MAX_EDITOR_FONT_SIZE = 160;
    public static final int DEFAULT_STRIDE_FONT_SIZE = 11;
    public static final int DEFAULT_JAVA_FONT_SIZE = 10;
    public static final String DEFAULT_TEXTFILE_EXTENSIONS = ".txt, .md";
    private static final String editorFontPropertyName = "bluej.editor.font";
    private static final String editorMacFontPropertyName = "bluej.editor.MacOS.font";
    private static final String editorFontSizePropertyName = "bluej.editor.fontsize";
    private static final int NUM_RECENT_PROJECTS = Config.getPropInteger("bluej.numberOfRecentProjects", 12);
    private static final @OnThread(value=Tag.FX) IntegerProperty editorFontSize = new SimpleIntegerProperty(10);
    private static final @OnThread(value=Tag.FX) NumberBinding editorLineNumberFontSize = Bindings.multiply((ObservableNumberValue)editorFontSize, (double)0.75);
    private static final @OnThread(value=Tag.FX) StringProperty editorStandardFont = new SimpleStringProperty("Roboto Mono");
    private static final StringProperty editorFallbackFont = new SimpleStringProperty("monospace");
    private static @OnThread(value=Tag.FX) IntegerProperty strideFontSize = null;
    private static PrintSize printFontSize = PrintSize.STANDARD;
    private static @OnThread(value=Tag.FX) String editorTextFileExtensions = ".txt, .md";
    private static final @OnThread(value=Tag.FXPlatform) IntegerProperty highlightStrength = new SimpleIntegerProperty(0);
    private static boolean isNaviviewExpanded = true;
    private static @OnThread(value=Tag.Any) String projectDirectory;
    private static @OnThread(value=Tag.Any, requireSynchronized=true) List<String> recentProjects;
    private static @OnThread(value=Tag.Any, requireSynchronized=true) HashMap<String, String> flags;
    private static @OnThread(value=Tag.FXPlatform) HashMap<String, BooleanProperty> flagProperties;
    private static @OnThread(value=Tag.FX) StringExpression editorFontCSS;
    private static @OnThread(value=Tag.FX) StringExpression editorFontSizeOnlyCSS;
    private static @OnThread(value=Tag.FX) StringExpression editorLineNumberFontSizeOnlyCSS;
    private static StringProperty playerName;
    private static final String editorTextFileExtensionsPropertyName = "bluej.editor.textfileextensions";

    private PrefMgr() {
    }

    @OnThread(value=Tag.Any)
    public static File getProjectDirectory() {
        File dir = new File(projectDirectory);
        if (dir.exists() && dir.isDirectory()) {
            return dir;
        }
        return new File(System.getProperty("user.home"));
    }

    @OnThread(value=Tag.Any)
    public static void setProjectDirectory(String newDir) {
        projectDirectory = newDir;
        Config.putPropString("bluej.projectPath", newDir);
    }

    @OnThread(value=Tag.Any)
    public static synchronized List<String> getRecentProjects() {
        return new ArrayList<String>(recentProjects);
    }

    public static synchronized void addRecentProject(File projectDir) {
        if (Config.isGreenfoot() && Config.isGreenfootStartupProject(projectDir)) {
            return;
        }
        String projectName = projectDir.getAbsolutePath();
        recentProjects.remove(projectName);
        if (recentProjects.size() == NUM_RECENT_PROJECTS) {
            recentProjects.remove(NUM_RECENT_PROJECTS - 1);
        }
        recentProjects.add(0, projectName);
        for (int i = 0; i < recentProjects.size(); ++i) {
            Config.putPropString("bluej.recentProject" + i, recentProjects.get(i));
        }
    }

    @OnThread(value=Tag.Any)
    public static synchronized boolean getFlag(String flag) {
        String value = flags.get(flag);
        if (value == null) {
            return false;
        }
        return value.equals("true");
    }

    @OnThread(value=Tag.FXPlatform)
    public static BooleanExpression flagProperty(String flagName) {
        return (BooleanExpression)flagProperties.computeIfAbsent(flagName, f -> new SimpleBooleanProperty(PrefMgr.getFlag(f)));
    }

    @OnThread(value=Tag.Any)
    public static synchronized void setFlag(String flag, boolean enabled) {
        String value = String.valueOf(enabled);
        String systemDefault = Config.getDefaultPropString(flag, "");
        if (systemDefault.length() > 0 && Boolean.valueOf(systemDefault) == enabled) {
            Config.removeProperty(flag);
        } else {
            Config.putPropString(flag, value);
        }
        flags.put(flag, value);
        JavaFXUtil.runNowOrLater(() -> {
            BooleanProperty prop = flagProperties.get(flag);
            if (prop != null) {
                prop.set(enabled);
            }
        });
    }

    private static List<String> readRecentProjects() {
        ArrayList<String> projects = new ArrayList<String>(NUM_RECENT_PROJECTS);
        for (int i = 0; i < NUM_RECENT_PROJECTS; ++i) {
            String projectName = Config.getPropString("bluej.recentProject" + i, "");
            if (projectName.length() <= 0) continue;
            projects.add(projectName);
        }
        return projects;
    }

    public static void setEditorFontSize(int size) {
        if (size > 0) {
            PrefMgr.initEditorFontSize(size);
        }
    }

    private static void initEditorFontSize(int size) {
        if (size > 0 && size != editorFontSize.get()) {
            editorFontSize.set(size);
            Config.putPropInteger(editorFontSizePropertyName, size);
            String font = Config.isMacOS() ? Config.getPropString(editorMacFontPropertyName, "Roboto Mono") : Config.getPropString(editorFontPropertyName, "Roboto Mono");
            editorStandardFont.set((Object)font);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static IntegerProperty getEditorFontSize() {
        return editorFontSize;
    }

    @OnThread(value=Tag.FX)
    public static StringExpression getEditorFontCSS(FontCSS type) {
        if (editorFontCSS == null) {
            editorFontSizeOnlyCSS = Bindings.concat((Object[])new Object[]{"-fx-font-size: ", editorFontSize, "pt;"});
            editorFontCSS = Bindings.concat((Object[])new Object[]{"-fx-font-size: ", editorFontSize, "pt;", "-fx-font-family: \"", editorStandardFont, "\";"});
            editorLineNumberFontSizeOnlyCSS = Bindings.concat((Object[])new Object[]{"-fx-font-size: ", editorLineNumberFontSize, "pt;"});
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FontCSS.EDITOR_SIZE_ONLY -> editorFontSizeOnlyCSS;
            case FontCSS.EDITOR_SIZE_AND_FAMILY -> editorFontCSS;
            case FontCSS.LINE_NUMBER_SIZE_ONLY -> editorLineNumberFontSizeOnlyCSS;
        };
    }

    public static String getEditorFontFamilyCSS() {
        return "-fx-font-family: \"" + (String)editorStandardFont.get() + "\", " + (String)editorFallbackFont.get() + ";";
    }

    public static String getEditorFontFamily() {
        return (String)editorStandardFont.get();
    }

    @OnThread(value=Tag.FXPlatform)
    public static ObservableIntegerValue getScopeHighlightStrength() {
        return highlightStrength;
    }

    public static void setScopeHighlightStrength(int strength) {
        highlightStrength.set(strength);
        Config.putPropInteger(SCOPE_HIGHLIGHTING_STRENGTH, strength);
    }

    public static boolean getNaviviewExpanded() {
        return isNaviviewExpanded;
    }

    public static void setNaviviewExpanded(boolean expanded) {
        isNaviviewExpanded = expanded;
        Config.putPropString(NAVIVIEW_EXPANDED, String.valueOf(expanded));
    }

    @OnThread(value=Tag.FX)
    public static IntegerProperty strideFontSizeProperty() {
        if (strideFontSize == null) {
            String fontSizePropName = "bluej.stride.editor.fontSize";
            int sizeFromConfig = Config.getPropInteger(fontSizePropName, 11);
            int clampedSize = Math.max(6, Math.min(160, sizeFromConfig));
            strideFontSize = new SimpleIntegerProperty(clampedSize);
            strideFontSize.addListener((a, b, newVal) -> Config.putPropInteger(fontSizePropName, newVal.intValue()));
        }
        return strideFontSize;
    }

    public static StringProperty getPlayerName() {
        return playerName;
    }

    public static PrintSize getPrintFontSize() {
        return printFontSize;
    }

    public static void setPrintFontSize(PrintSize size) {
        printFontSize = size;
        switch (size) {
            case SMALL: {
                Config.putPropInteger(PRINT_FONT_SIZE, 3);
                break;
            }
            case STANDARD: {
                Config.putPropInteger(PRINT_FONT_SIZE, 4);
                break;
            }
            case LARGE: {
                Config.putPropInteger(PRINT_FONT_SIZE, 5);
            }
        }
    }

    public static void setEditorTextFileExtensions(String value) {
        if (!editorTextFileExtensions.equals(value)) {
            editorTextFileExtensions = value;
            Config.putPropString(editorTextFileExtensionsPropertyName, value);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static String getEditorTextFileExtensionsString() {
        return editorTextFileExtensions;
    }

    @OnThread(value=Tag.FXPlatform)
    public static List<String> getEditorFormattedTextFileExtensionsList() {
        ArrayList<Object> res = new ArrayList<Object>();
        String extensionsStr = PrefMgr.getEditorTextFileExtensionsString();
        if (extensionsStr.trim().length() > 0) {
            for (String extensionCandidate : extensionsStr.split(" |,|;")) {
                Object formattedExtension;
                if (extensionCandidate.trim().length() <= 0) continue;
                Object object = formattedExtension = extensionCandidate.startsWith("*") ? extensionCandidate.trim().toLowerCase().substring(1) : extensionCandidate.trim().toLowerCase();
                if (!((String)formattedExtension).startsWith(".")) {
                    formattedExtension = "." + (String)formattedExtension;
                }
                if (res.contains(formattedExtension)) continue;
                res.add(formattedExtension);
            }
        }
        return Collections.unmodifiableList(res);
    }

    static {
        flags = new HashMap();
        flagProperties = new HashMap();
        PrefMgr.initEditorFontSize(Config.getPropInteger(editorFontSizePropertyName, 12));
        JavaFXUtil.addChangeListener(editorFontSize, size -> Config.putPropInteger(editorFontSizePropertyName, size.intValue()));
        PrefMgr.setEditorTextFileExtensions(Config.getPropString(editorTextFileExtensionsPropertyName, DEFAULT_TEXTFILE_EXTENSIONS));
        highlightStrength.set(Config.getPropInteger(SCOPE_HIGHLIGHTING_STRENGTH, 20));
        projectDirectory = Config.getPropString("bluej.projectPath", System.getProperty("user.home"));
        recentProjects = PrefMgr.readRecentProjects();
        flags.put(HIGHLIGHTING, Config.getPropString(HIGHLIGHTING, "true"));
        flags.put(AUTO_INDENT, Config.getPropString(AUTO_INDENT, "false"));
        flags.put(CLOSE_CURLY, Config.getPropString(CLOSE_CURLY, "true"));
        flags.put(LINENUMBERS, Config.getPropString(LINENUMBERS, "false"));
        flags.put(MATCH_BRACKETS, Config.getPropString(MATCH_BRACKETS, "true"));
        flags.put(CHECK_DISKFILECHANGES, Config.getPropString(CHECK_DISKFILECHANGES, "true"));
        flags.put(LINK_LIB, Config.getPropString(LINK_LIB, "true"));
        flags.put(SHOW_TEST_TOOLS, Config.getPropString(SHOW_TEST_TOOLS, "false"));
        flags.put(SHOW_TEAM_TOOLS, Config.getPropString(SHOW_TEAM_TOOLS, "false"));
        flags.put(SHOW_TEXT_EVAL, Config.getPropString(SHOW_TEXT_EVAL, "false"));
        flags.put(SHOW_UNCHECKED, Config.getPropString(SHOW_UNCHECKED, "true"));
        flags.put(ACCESSIBILITY_SUPPORT, Config.getPropString(ACCESSIBILITY_SUPPORT, "false"));
        flags.put(START_WITH_SUDO, Config.getPropString(START_WITH_SUDO, "true"));
        flags.put(STRIDE_SIDEBAR_SHOWING, Config.getPropString(STRIDE_SIDEBAR_SHOWING, "true"));
        flags.put(NEWS_TESTING, Config.getPropString(NEWS_TESTING, "false"));
        flags.put(PRINT_LINE_NUMBERS, Config.getPropString(PRINT_LINE_NUMBERS, "false"));
        flags.put(PRINT_SCOPE_HIGHLIGHTING, Config.getPropString(PRINT_SCOPE_HIGHLIGHTING, "true"));
        flags.put(PACKAGE_PRINT_DIAGRAM, Config.getPropString(PACKAGE_PRINT_DIAGRAM, "true"));
        flags.put(PACKAGE_PRINT_README, Config.getPropString(PACKAGE_PRINT_README, "true"));
        flags.put(PACKAGE_PRINT_SOURCE, Config.getPropString(PACKAGE_PRINT_SOURCE, "true"));
        switch (Config.getPropInteger(PRINT_FONT_SIZE, 4)) {
            case 3: {
                printFontSize = PrintSize.SMALL;
                break;
            }
            case 5: {
                printFontSize = PrintSize.LARGE;
                break;
            }
            default: {
                printFontSize = PrintSize.STANDARD;
            }
        }
        if (Config.isGreenfoot()) {
            playerName = new SimpleStringProperty(Config.getPropString("greenfoot.player.name", "Player1"));
            JavaFXUtil.addChangeListener(playerName, name -> Config.putPropString("greenfoot.player.name", name));
        }
    }

    public static enum FontCSS {
        EDITOR_SIZE_ONLY,
        EDITOR_SIZE_AND_FAMILY,
        LINE_NUMBER_SIZE_ONLY;

    }

    public static enum PrintSize {
        SMALL,
        STANDARD,
        LARGE;


        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        public @OnThread(value=Tag.FXPlatform, ignoreParent=true) String toString() {
            return Config.getString("editor.printDialog.fontSize." + this.name().toLowerCase());
        }
    }
}

