/*
 * Decompiled with CFR 0.152.
 */
package bluej.prefmgr;

import bluej.Boot;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.RunOnThread;
import bluej.pkgmgr.Project;
import bluej.prefmgr.MiscPrefPanelItem;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.javafx.JavaFXUtil;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class MiscPrefPanel
extends VBox
implements PrefPanelListener {
    private final int normalChildren;
    private CheckBox showUncheckedBox;
    private TextField playerNameField;
    private TextField participantIdentifierField;
    private TextField experimentIdentifierField;
    private Label statusLabel;
    private ComboBox<RunOnThread> runOnThread;
    private Node threadRunSetting;
    private List<MiscPrefPanelItem> extraItems;

    public MiscPrefPanel() {
        JavaFXUtil.addStyleClass((Styleable)this, "prefmgr-pref-panel");
        if (Config.isGreenfoot()) {
            this.getChildren().add((Object)this.makePlayerNamePanel());
            if (Boot.isTrialRecording()) {
                this.getChildren().add((Object)this.makeDataCollectionPanel());
            }
        } else {
            this.getChildren().add((Object)this.makeVMPanel());
            this.getChildren().add((Object)this.makeDataCollectionPanel());
        }
        this.normalChildren = this.getChildren().size();
    }

    private Node makeDataCollectionPanel() {
        ArrayList<Node> dataCollectionPanel = new ArrayList<Node>();
        this.statusLabel = new Label(DataCollector.getOptInOutStatus());
        this.statusLabel.setMinWidth(100.0);
        Button optButton = new Button(Config.getString("prefmgr.collection.change"));
        optButton.setOnAction(e -> {
            DataCollector.changeOptInOut(false);
            this.statusLabel.setText(DataCollector.getOptInOutStatus());
        });
        optButton.setMinWidth(Double.NEGATIVE_INFINITY);
        dataCollectionPanel.add(PrefMgrDialog.labelledItem(this.statusLabel, (Node)optButton));
        Label identifierLabel = new Label(Config.getString("prefmgr.collection.identifier.explanation") + ":");
        dataCollectionPanel.add((Node)identifierLabel);
        GridPane experimentParticipantPanel = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)experimentParticipantPanel, "prefmgr-experiment-participant");
        Label experimentLabel = new Label(Config.getString("prefmgr.collection.identifier.experiment"));
        experimentParticipantPanel.add((Node)experimentLabel, 0, 0);
        this.experimentIdentifierField = new TextField();
        experimentParticipantPanel.add((Node)this.experimentIdentifierField, 1, 0);
        Label participantLabel = new Label(Config.getString("prefmgr.collection.identifier.participant"));
        experimentParticipantPanel.add((Node)participantLabel, 0, 1);
        this.participantIdentifierField = new TextField();
        experimentParticipantPanel.add((Node)this.participantIdentifierField, 1, 1);
        dataCollectionPanel.add((Node)experimentParticipantPanel);
        return PrefMgrDialog.headedVBox("prefmgr.collection.title", dataCollectionPanel);
    }

    private Node makeVMPanel() {
        this.showUncheckedBox = new CheckBox(Config.getString("prefmgr.misc.showUnchecked"));
        ObservableList runOnThreadPoss = FXCollections.observableArrayList((Object[])new RunOnThread[]{RunOnThread.DEFAULT, RunOnThread.FX, RunOnThread.SWING});
        this.runOnThread = new ComboBox(runOnThreadPoss);
        this.threadRunSetting = PrefMgrDialog.labelledItem("prefmgr.misc.runOnThread", this.runOnThread);
        return PrefMgrDialog.headedVBox("prefmgr.misc.vm.title", Arrays.asList(this.showUncheckedBox, this.threadRunSetting));
    }

    private Node makePlayerNamePanel() {
        ArrayList<Node> contents = new ArrayList<Node>();
        KeyCodeCombination accelerator = Config.GREENFOOT_SET_PLAYER_NAME_SHORTCUT;
        String shortcutText = " " + accelerator.getDisplayText();
        this.playerNameField = new TextField((String)PrefMgr.getPlayerName().get());
        this.playerNameField.setPrefColumnCount(20);
        contents.add(PrefMgrDialog.labelledItem("playername.dialog.help", (Node)this.playerNameField));
        contents.add(PrefMgrDialog.wrappedLabel(Config.getString("prefmgr.misc.playerNameNote") + shortcutText));
        return PrefMgrDialog.headedVBox("prefmgr.misc.playername.title", contents);
    }

    @Override
    public void beginEditing(Project project) {
        if (!Config.isGreenfoot()) {
            this.showUncheckedBox.setSelected(PrefMgr.getFlag("bluej.compiler.showunchecked"));
            if (project == null) {
                this.threadRunSetting.setVisible(false);
                this.threadRunSetting.setManaged(false);
            } else {
                this.runOnThread.getSelectionModel().select((Object)project.getRunOnThread());
                this.threadRunSetting.setVisible(true);
                this.threadRunSetting.setManaged(true);
            }
            this.statusLabel.setText(DataCollector.getOptInOutStatus());
            this.experimentIdentifierField.setText(DataCollector.getExperimentIdentifier());
            this.participantIdentifierField.setText(DataCollector.getParticipantIdentifier());
        } else {
            this.playerNameField.setText((String)PrefMgr.getPlayerName().get());
        }
        this.extraItems.forEach(p -> p.beginEditing(project));
    }

    @Override
    public void revertEditing(Project project) {
        this.extraItems.forEach(p -> p.revertEditing(project));
    }

    @Override
    public void commitEditing(Project project) {
        if (!Config.isGreenfoot()) {
            PrefMgr.setFlag("bluej.compiler.showunchecked", this.showUncheckedBox.isSelected());
            if (project != null) {
                project.setRunOnThread((RunOnThread)((Object)this.runOnThread.getSelectionModel().getSelectedItem()));
            }
            String expId = this.experimentIdentifierField.getText();
            String partId = this.participantIdentifierField.getText();
            DataCollector.setExperimentIdentifier(expId);
            DataCollector.setParticipantIdentifier(partId);
        }
        if (Config.isGreenfoot()) {
            PrefMgr.getPlayerName().set((Object)this.playerNameField.getText());
        }
        this.extraItems.forEach(p -> p.commitEditing(project));
    }

    public void setExtraItems(List<MiscPrefPanelItem> miscPrefPanelItems) {
        this.getChildren().remove(this.normalChildren, this.getChildren().size());
        for (MiscPrefPanelItem miscPrefPanelItem : miscPrefPanelItems) {
            this.getChildren().add((Object)PrefMgrDialog.headedVBoxTranslated(miscPrefPanelItem.getMiscPanelTitle(), miscPrefPanelItem.getMiscPanelContents()));
        }
        this.extraItems = ImmutableList.copyOf(miscPrefPanelItems);
    }
}

