/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.role;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.editor.TextEditor;
import bluej.parser.SourceLocation;
import bluej.parser.SourceSpan;
import bluej.parser.UnitTestAnalyzer;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.TestRunnerThread;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.actions.ClassTargetOperation;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.terminal.Terminal;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.ExistingFixtureInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.JavaUtils;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.FXPlatformSupplier;
import bluej.utility.javafx.dialog.InputDialog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.stage.Window;
import org.junit.Test;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.params.ParameterizedTest;
import threadchecker.OnThread;
import threadchecker.Tag;

public class UnitTestClassRole
extends ClassRole {
    public static final String UNITTEST_ROLE_NAME = "UnitTestTarget";
    public static final String UNITTEST_ROLE_NAME_JUNIT4 = "UnitTestTargetJunit4";
    public static final String UNITTEST_ROLE_NAME_JUNIT5 = "UnitTestTargetJunit5";
    private static final String testAll = Config.getString("pkgmgr.test.popup.testAll");
    private static final String createTest = Config.getString("pkgmgr.test.popup.createTest");
    private static final String benchToFixture = Config.getString("pkgmgr.test.popup.benchToFixture");
    private static final String fixtureToBench = Config.getString("pkgmgr.test.popup.fixtureToBench");
    private @OnThread(value=Tag.Any) UnitTestFramework unitTestFramework;
    private static final String spaces = "                                 ";

    public UnitTestClassRole(UnitTestFramework framework) {
        this.unitTestFramework = framework;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getRoleName() {
        String roleName = null;
        switch (this.unitTestFramework) {
            case JUnit5: {
                roleName = UNITTEST_ROLE_NAME_JUNIT5;
                break;
            }
            case JUnit4: {
                roleName = UNITTEST_ROLE_NAME_JUNIT4;
                break;
            }
            case JUnit3: {
                roleName = UNITTEST_ROLE_NAME;
            }
        }
        return roleName;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getStereotypeLabel() {
        return "unit test";
    }

    @OnThread(value=Tag.Any)
    private boolean isJUnitTestMethod(Method m) {
        Class<?> cl = m.getDeclaringClass();
        ClassLoader classLoader = cl.getClassLoader();
        switch (this.unitTestFramework) {
            case JUnit5: {
                try {
                    Class disabledTestClassJU5;
                    Class repeatedTestClassJU5;
                    Class paramTestClassJU5;
                    Class testClassJU5;
                    if (classLoader == null) {
                        testClassJU5 = org.junit.jupiter.api.Test.class;
                        paramTestClassJU5 = ParameterizedTest.class;
                        repeatedTestClassJU5 = RepeatedTest.class;
                        disabledTestClassJU5 = Disabled.class;
                    } else {
                        testClassJU5 = classLoader.loadClass("org.junit.jupiter.api.Test");
                        paramTestClassJU5 = classLoader.loadClass("org.junit.jupiter.params.ParameterizedTest");
                        repeatedTestClassJU5 = classLoader.loadClass("org.junit.jupiter.api.RepeatedTest");
                        disabledTestClassJU5 = classLoader.loadClass("org.junit.jupiter.api.Disabled");
                    }
                    if (m.getAnnotation(disabledTestClassJU5) == null && (m.getAnnotation(testClassJU5) != null || m.getAnnotation(paramTestClassJU5) != null || m.getAnnotation(repeatedTestClassJU5) != null)) {
                        if (!Modifier.isPublic(m.getModifiers())) {
                            return false;
                        }
                        return m.getAnnotation(paramTestClassJU5) == null || m.getParameterTypes().length != 0;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError linkageError) {}
                break;
            }
            case JUnit4: {
                cl = m.getDeclaringClass();
                classLoader = cl.getClassLoader();
                try {
                    Class testClassJU4 = classLoader == null ? Test.class : classLoader.loadClass("org.junit.Test");
                    if (m.getAnnotation(testClassJU4) != null) {
                        if (!Modifier.isPublic(m.getModifiers())) {
                            return false;
                        }
                        return m.getParameterTypes().length == 0;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (LinkageError linkageError) {}
                break;
            }
            case JUnit3: {
                if (!m.getName().startsWith("test")) {
                    return false;
                }
                if (!Modifier.isPublic(m.getModifiers())) {
                    return false;
                }
                if (m.getParameterTypes().length != 0) {
                    return false;
                }
                return m.getReturnType().equals(Void.TYPE);
            }
        }
        return false;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<ClassTargetOperation> getRoleOperationsBegin(ClassTarget ct, Class<?> cl, DependentTarget.State state) {
        boolean enableTestAll = false;
        if (!ct.getPackage().getProject().inTestMode() && state == DependentTarget.State.COMPILED && cl != null && !ct.isAbstract()) {
            boolean bl = enableTestAll = Arrays.stream(cl.getMethods()).filter(this::isJUnitTestMethod).count() > 0L;
        }
        if (enableTestAll) {
            return List.of(new TestAction(testAll, AbstractOperation.MenuItemOrder.TEST_ALL, ct.getPackage().getEditor(), null));
        }
        return List.of();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<ClassTargetOperation> getClassConstructorOperations(ClassTarget ct, Class<?> cl) {
        boolean hasEntries = false;
        Stream<Method> allMethods = Arrays.stream(cl.getMethods()).filter(this::isJUnitTestMethod).sorted(Comparator.comparing(Method::getName));
        ArrayList<ClassTargetOperation> ops = new ArrayList<ClassTargetOperation>();
        if (!ct.isAbstract()) {
            int itemHeight = 28;
            int itemsOnScreen = (int)Config.getScreenBounds().getHeight() / itemHeight;
            int sizeLimit = itemsOnScreen / 2;
            for (Method m : allMethods.collect(Collectors.toList())) {
                String rtype;
                try {
                    rtype = JavaUtils.getJavaUtils().getReturnType(m).toString(true);
                }
                catch (ClassNotFoundException cnfe) {
                    rtype = m.getReturnType().getName();
                }
                StringBuilder args = new StringBuilder("(");
                if (m.getParameterTypes().length > 0) {
                    args.append(Arrays.stream(m.getParameterTypes()).map(Class::getName).collect(Collectors.joining(", ")));
                }
                args.append(")");
                TestAction testAction = new TestAction(rtype + " " + m.getName() + args, AbstractOperation.MenuItemOrder.RUN_METHOD, ct.getPackage().getEditor(), m.getName() + args);
                ops.add(testAction);
                hasEntries = true;
            }
            if (!hasEntries) {
                ops.add(new DummyDisabledOperation(Config.getString("pkgmgr.test.popup.noTests"), AbstractOperation.MenuItemOrder.RUN_METHOD));
            }
        } else {
            ops.add(new DummyDisabledOperation(Config.getString("pkgmgr.test.popup.abstract"), AbstractOperation.MenuItemOrder.RUN_METHOD));
        }
        return ops;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public List<ClassTargetOperation> getClassStaticOperations(ClassTarget ct, Class<?> cl) {
        if (!ct.getPackage().getProject().inTestMode() && ct.hasSourceCode() && !ct.isAbstract()) {
            return List.of(new MakeTestCaseAction(ct.getPackage().getEditor()), new BenchToFixtureAction(ct.getPackage().getEditor()), new FixtureToBenchAction(ct.getPackage().getEditor()));
        }
        return List.of();
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean canConvertToStride() {
        return false;
    }

    @Override
    public void run(PkgMgrFrame pmf, ClassTarget ct, String param) {
        Terminal terminal = pmf.getPackage().getProject().getTerminal();
        if (terminal.clearOnMethodCall()) {
            terminal.clear();
        }
        if (param != null) {
            Project proj = pmf.getProject();
            TestDisplayFrame.getTestDisplay().startTest(proj, 1);
        }
        new TestRunnerThread(pmf, ct, param).start();
    }

    public List<String> startRunTest(PkgMgrFrame pmf, ClassTarget ct, TestRunnerThread trt) {
        Class<?> cl = pmf.getPackage().loadClass(ct.getQualifiedName());
        if (cl == null) {
            return null;
        }
        List<String> testMethods = Arrays.stream(cl.getMethods()).filter(this::isJUnitTestMethod).map(Method::getName).sorted().collect(Collectors.toList());
        Project proj = pmf.getProject();
        TestDisplayFrame.getTestDisplay().startTest(proj, testMethods.size());
        return testMethods;
    }

    public int getTestCount(ClassTarget ct) {
        if (!ct.isCompiled()) {
            return 0;
        }
        Class<?> cl = ct.getPackage().loadClass(ct.getQualifiedName());
        if (cl == null) {
            return 0;
        }
        return (int)Arrays.stream(cl.getMethods()).filter(this::isJUnitTestMethod).count();
    }

    @OnThread(value=Tag.FXPlatform)
    public void doMakeTestCase(PkgMgrFrame pmf, ClassTarget ct) {
        String newTestName = new TestNameDialog("unittest-new-test-method", "").showAndWait().orElse(null);
        if (newTestName == null) {
            return;
        }
        try {
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            SourceSpan existingSpan = uta.getMethodBlockSpan(newTestName);
            if (existingSpan != null) {
                if (DialogManager.askQuestionFX((Window)pmf.getWindow(), "unittest-method-present") != 1) {
                    this.finishTestCase(pmf, ct, newTestName);
                }
            } else {
                this.finishTestCase(pmf, ct, newTestName);
            }
        }
        catch (IOException ioe) {
            DialogManager.showErrorWithTextFX((Window)pmf.getWindow(), "unittest-io-error", ioe.getLocalizedMessage());
            Debug.reportError("Error reading unit test source", ioe);
            this.finishTestCase(pmf, ct, newTestName);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void finishTestCase(PkgMgrFrame pmf, ClassTarget ct, String newTestName) {
        pmf.testRecordingStarted(Config.getString("pkgmgr.test.recording") + " " + ct.getBaseName() + "." + newTestName + "()");
        pmf.getProject().removeClassLoader();
        this.runTestSetup(pmf, ct, false);
        pmf.getObjectBench().resetRecordingInteractions();
        pmf.setTestInfo(newTestName, ct);
    }

    private UnitTestAnalyzer analyzeUnitTest(ClassTarget ct, Charset fileEncoding) throws IOException {
        ct.ensureSaved();
        UnitTestAnalyzer uta = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(ct.getSourceFile());
            InputStreamReader reader = new InputStreamReader((InputStream)fis, fileEncoding);
            uta = new UnitTestAnalyzer(reader);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    Debug.reportError(ioe);
                }
            }
        }
        return uta;
    }

    private void runTestSetup(final PkgMgrFrame pmf, final ClassTarget ct, final boolean recordAsFixtureToBench) {
        final Project project = pmf.getProject();
        new Thread("Run test setup"){

            @Override
            @OnThread(value=Tag.Worker, ignoreParent=true)
            public void run() {
                FXPlatformSupplier<Map<String, DebuggerObject>> dobs = project.getDebugger().runTestSetUp(ct.getQualifiedName());
                Platform.runLater(() -> {
                    ArrayList<DataCollector.NamedTyped> recordObjects = new ArrayList<DataCollector.NamedTyped>();
                    for (Map.Entry mapent : ((Map)dobs.get()).entrySet()) {
                        DebuggerObject objVal = (DebuggerObject)mapent.getValue();
                        if (objVal.isNullObject()) continue;
                        String actualName = pmf.putObjectOnBench((String)mapent.getKey(), objVal, objVal.getGenType(), null, Optional.empty());
                        recordObjects.add(new DataCollector.NamedTyped(actualName, objVal.getClassName()));
                    }
                    if (recordAsFixtureToBench) {
                        DataCollector.fixtureToObjectBench(pmf.getPackage(), ct.getSourceFile(), recordObjects);
                    }
                });
            }
        }.start();
    }

    private String getIndentString() {
        int ts = Math.min(Config.getPropInteger("bluej.editor.tabsize", 4), spaces.length());
        return spaces.substring(0, ts);
    }

    public void doEndMakeTestCase(PkgMgrFrame pmf, ClassTarget ct, String name) {
        TextEditor ed = ct.getEditor().assumeText();
        String ts = this.getIndentString();
        try {
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            SourceSpan existingSpan = uta.getMethodBlockSpan(name);
            if (existingSpan != null) {
                ed.setSelection(new SourceLocation(existingSpan.getStartLine(), existingSpan.getStartColumn()), new SourceLocation(existingSpan.getEndLine(), existingSpan.getEndColumn()));
                ed.insertText("{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}", false);
            } else {
                SourceLocation methodInsert = uta.getNewMethodInsertLocation();
                if (methodInsert != null) {
                    ed.setSelection(new SourceLocation(methodInsert.getLine(), methodInsert.getColumn()), new SourceLocation(methodInsert.getLine(), methodInsert.getColumn() + 1));
                    switch (this.unitTestFramework) {
                        case JUnit5: 
                        case JUnit4: {
                            ed.insertText("\n" + ts + "@Test\n" + ts + "public void " + name + "()\n" + ts + "{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}\n}\n", false);
                            break;
                        }
                        case JUnit3: {
                            ed.insertText("\n" + ts + "public void " + name + "()\n" + ts + "{\n" + pmf.getObjectBench().getTestMethod(ts + ts) + ts + "}\n}\n", false);
                        }
                    }
                }
            }
            ed.save();
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
    }

    public void doFixtureToBench(PkgMgrFrame pmf, ClassTarget ct) {
        TextEditor ed = ct.getEditor().assumeText();
        ExistingFixtureInvokerRecord existing = new ExistingFixtureInvokerRecord();
        try {
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            List<SourceSpan> fixtureSpans = uta.getFieldSpans();
            ListIterator<SourceSpan> it = fixtureSpans.listIterator();
            while (it.hasNext()) {
                SourceSpan variableSpan = it.next();
                String fieldDecl = ed.getText(variableSpan.getStartLocation(), variableSpan.getEndLocation());
                existing.addFieldDeclaration(fieldDecl);
            }
            SourceSpan setUpSpan = uta.getMethodBlockSpan("setUp");
            if (setUpSpan != null) {
                String setUpWithBrackets = ed.getText(setUpSpan.getStartLocation(), setUpSpan.getEndLocation());
                String setUpWithoutBrackets = setUpWithBrackets.substring(setUpWithBrackets.indexOf(123) + 1, setUpWithBrackets.lastIndexOf(125)).trim();
                existing.setSetupMethod(setUpWithoutBrackets);
            }
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
        this.runTestSetup(pmf, ct, true);
        pmf.getObjectBench().addInteraction(existing);
    }

    public void doBenchToFixture(PkgMgrFrame pmf, ClassTarget ct) {
        if (pmf.getObjectBench().getObjectCount() == 0) {
            return;
        }
        TextEditor ed = ct.getEditor().assumeText();
        try {
            SourceLocation fixtureInsertLocation;
            Charset charset = pmf.getProject().getProjectCharset();
            UnitTestAnalyzer uta = this.analyzeUnitTest(ct, charset);
            List<SourceSpan> variables = uta.getFieldSpans();
            if (variables != null && variables.size() > 0) {
                boolean shouldContinue;
                boolean bl = shouldContinue = DialogManager.askQuestionFX(null, "unittest-fixture-present") != 1;
                if (!shouldContinue) {
                    return;
                }
            }
            if (variables != null) {
                ListIterator<SourceSpan> it = variables.listIterator(variables.size());
                while (it.hasPrevious()) {
                    SourceSpan variableSpan = it.previous();
                    ed.setSelection(new SourceLocation(variableSpan.getStartLine(), variableSpan.getStartColumn()), new SourceLocation(variableSpan.getEndLine(), variableSpan.getEndColumn()));
                    ed.insertText("", false);
                }
                uta = this.analyzeUnitTest(ct, charset);
            }
            if ((fixtureInsertLocation = uta.getFixtureInsertLocation()) == null) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (ObjectWrapper obj : pmf.getObjectBench().getObjects()) {
                names.add(obj.getName());
            }
            DataCollector.objectBenchToFixture(pmf.getPackage(), ct.getSourceFile(), names);
            SourceSpan setupSpan = uta.getMethodBlockSpan("setUp");
            String ts = this.getIndentString();
            if (setupSpan != null) {
                ed.setSelection(new SourceLocation(setupSpan.getStartLine(), setupSpan.getStartColumn()), new SourceLocation(setupSpan.getEndLine(), setupSpan.getEndColumn()));
            } else {
                ed.setSelection(new SourceLocation(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn()), new SourceLocation(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn() + 1));
                switch (this.unitTestFramework) {
                    case JUnit5: {
                        ed.insertText("{\n" + ts + "@BeforeEach\n" + ts + "public void setUp()\n" + ts, false);
                        break;
                    }
                    case JUnit4: {
                        ed.insertText("{\n" + ts + "@Before\n" + ts + "public void setUp()\n" + ts, false);
                        break;
                    }
                    case JUnit3: {
                        ed.insertText("{\n" + ts + "public void setUp()\n" + ts, false);
                    }
                }
            }
            ed.insertText("{\n" + pmf.getObjectBench().getFixtureSetup(ts + ts) + ts + "}", false);
            ed.setSelection(new SourceLocation(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn()), new SourceLocation(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn() + 1));
            ed.insertText("{\n" + pmf.getObjectBench().getFixtureDeclaration(ts), false);
            ed.save();
        }
        catch (IOException ioe) {
            PkgMgrFrame.showMessageWithText(pmf.getPackage(), "generic-file-save-error", ioe.getLocalizedMessage());
        }
        pmf.getPackage().compileQuiet(ct, CompileReason.MODIFIED, CompileType.INTERNAL_COMPILE);
        pmf.getProject().removeClassLoader();
        pmf.getProject().newRemoteClassLoaderLeavingBreakpoints();
    }

    public static enum UnitTestFramework {
        JUnit5,
        JUnit4,
        JUnit3;

    }

    @OnThread(value=Tag.FXPlatform)
    private class TestAction
    extends TargetAbstractAction {
        private String testName;

        public TestAction(String label, AbstractOperation.MenuItemOrder menuItemOrder, PackageEditor ped, String testName) {
            super("test_" + testName, label, menuItemOrder, ped);
            this.testName = testName;
        }

        @Override
        protected void execute(ClassTarget target) {
            this.ped.runTest(target, this.testName);
        }
    }

    public static class DummyDisabledOperation
    extends ClassTargetOperation {
        public DummyDisabledOperation(String label, AbstractOperation.MenuItemOrder menuItemOrder) {
            super(label, AbstractOperation.Combine.ONE, null, label, menuItemOrder, new String[0]);
            this.enabled = false;
        }

        @Override
        protected void execute(ClassTarget target) {
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class MakeTestCaseAction
    extends TargetAbstractAction {
        public MakeTestCaseAction(PackageEditor ped) {
            super("makeTestCase", createTest, AbstractOperation.MenuItemOrder.MAKE_TEST_CASE, ped);
        }

        @Override
        protected void execute(ClassTarget target) {
            this.ped.makeTestCase(target);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class BenchToFixtureAction
    extends TargetAbstractAction {
        public BenchToFixtureAction(PackageEditor ped) {
            super("benchToFixture", benchToFixture, AbstractOperation.MenuItemOrder.BENCH_TO_FIXTURE, ped);
        }

        @Override
        protected void execute(ClassTarget target) {
            this.ped.benchToFixture(target);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class FixtureToBenchAction
    extends TargetAbstractAction {
        public FixtureToBenchAction(PackageEditor ped) {
            super("fixtureToBench", fixtureToBench, AbstractOperation.MenuItemOrder.FIXTURE_TO_BENCH, ped);
        }

        @Override
        protected void execute(ClassTarget target) {
            this.ped.fixtureToBench(target);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class TestNameDialog
    extends InputDialog<String> {
        public TestNameDialog(String dialogLabel, String prompt) {
            super(dialogLabel, prompt, "test-name-dialog");
            this.setOKEnabled(false);
        }

        @Override
        protected String convert(String newTestName) {
            if (UnitTestClassRole.this.unitTestFramework == UnitTestFramework.JUnit3 && !newTestName.startsWith("test")) {
                return "test" + Character.toTitleCase(newTestName.charAt(0)) + newTestName.substring(1);
            }
            return newTestName;
        }

        @Override
        protected boolean validate(String oldInput, String newTestName) {
            if (newTestName.length() == 0) {
                this.setOKEnabled(false);
            } else if (!JavaNames.isIdentifier(this.convert(newTestName))) {
                this.setErrorText(Config.getString("pkgmgr.test.invalidTestName"));
                this.setOKEnabled(false);
            } else {
                this.setErrorText("");
                this.setOKEnabled(true);
            }
            return true;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private abstract class TargetAbstractAction
    extends ClassTargetOperation {
        protected PackageEditor ped;

        public TargetAbstractAction(String name, String label, AbstractOperation.MenuItemOrder menuItemOrder, PackageEditor ped) {
            super(name, AbstractOperation.Combine.ONE, null, label, menuItemOrder, "class-action-inbuilt");
            this.ped = ped;
        }
    }
}

