/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.MethodReflective;
import bluej.debugger.gentype.Reflective;
import bluej.extensions2.SourceType;
import bluej.parser.ConstructorOrMethodReflective;
import bluej.parser.JavadocParser;
import bluej.parser.entity.PackageResolver;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.CommentCache;
import bluej.pkgmgr.DocPathEntry;
import bluej.pkgmgr.JavadocResolver;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.Comment;
import bluej.views.View;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ProjectJavadocResolver
implements JavadocResolver {
    private Project project;
    private CommentCache commentCache = new CommentCache();

    public ProjectJavadocResolver(Project project) {
        this.project = project;
    }

    @Override
    public void getJavadoc(Reflective declaring, Collection<? extends ConstructorOrMethodReflective> targetMethods) {
        String comtarget;
        if (targetMethods.isEmpty()) {
            return;
        }
        String declName = declaring.getName();
        Map<String, ConstructorOrMethodReflective> methodSigs = targetMethods.stream().collect(Collectors.toMap(ProjectJavadocResolver::buildSig, m -> m, (a, b) -> a));
        try {
            Class<?> cl = this.project.getClassLoader().loadClass(declName);
            View clView = View.getView(cl);
            List<CallableView> methods = Utility.concat(Arrays.asList(clView.getAllMethods()), Arrays.asList(clView.getConstructors()));
            for (CallableView method : methods) {
                Comment comment;
                String signature = method.getSignature();
                ConstructorOrMethodReflective methodReflective = methodSigs.get(signature);
                if (methodReflective == null || (comment = method.getComment()) == null) continue;
                methodReflective.setJavaDoc(comment.getText());
                ArrayList<String> paramNames = new ArrayList<String>(comment.getParamCount());
                for (int j = 0; j < comment.getParamCount(); ++j) {
                    paramNames.add(comment.getParamName(j));
                }
                methodReflective.setParamNames(paramNames);
                methodSigs.remove(signature);
            }
        }
        catch (ClassNotFoundException cl) {
        }
        catch (LinkageError cl) {
            // empty catch block
        }
        if (methodSigs.isEmpty()) {
            return;
        }
        Properties comments = (Properties)this.commentCache.get(declName);
        if (comments == null) {
            ClassInfo classInfo = this.getClassInfoFromSource(declaring.getModuleName(), declName);
            if (classInfo != null) {
                comments = classInfo.getComments();
            }
            if (comments == null) {
                this.commentCache.put(declName, new Properties());
                return;
            }
            this.commentCache.put(declName, comments);
        }
        int i = 0;
        while ((comtarget = comments.getProperty("comment" + i + ".target")) != null) {
            ConstructorOrMethodReflective methodReflective = methodSigs.get(comtarget);
            if (methodReflective != null) {
                methodReflective.setJavaDoc(comments.getProperty("comment" + i + ".text"));
                String paramNames = comments.getProperty("comment" + i + ".params");
                StringTokenizer tokenizer = new StringTokenizer(paramNames);
                ArrayList<String> paramNamesList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    paramNamesList.add(tokenizer.nextToken());
                }
                methodReflective.setParamNames(paramNamesList);
                methodSigs.remove(comtarget);
            }
            ++i;
        }
        for (ConstructorOrMethodReflective methodReflective : methodSigs.values()) {
            methodReflective.setJavaDoc("");
        }
    }

    @Override
    public boolean getJavadocAsync(ConstructorOrMethodReflective method, JavadocResolver.AsyncCallback callback, Executor executor) {
        Reflective declaring = method.getDeclaringType();
        String declName = declaring.getName();
        String methodSig = ProjectJavadocResolver.buildSig(method);
        try {
            Class<?> cl = this.project.getClassLoader().loadClass(declName);
            View clView = View.getView(cl);
            CallableView[] methods = method instanceof MethodReflective ? clView.getAllMethods() : clView.getConstructors();
            for (int i = 0; i < methods.length; ++i) {
                if (!methodSig.equals(methods[i].getSignature())) continue;
                Comment comment = methods[i].getComment();
                if (comment != null) {
                    method.setJavaDoc(comment.getText());
                    ArrayList<String> paramNames = new ArrayList<String>(comment.getParamCount());
                    for (int j = 0; j < comment.getParamCount(); ++j) {
                        paramNames.add(comment.getParamName(j));
                    }
                    method.setParamNames(paramNames);
                    callback.gotJavadoc(method);
                    return true;
                }
                break;
            }
        }
        catch (ClassNotFoundException cl) {
        }
        catch (LinkageError cl) {
            // empty catch block
        }
        Properties comments = (Properties)this.commentCache.get(declName);
        if (comments == null) {
            comments = this.getCommentsFromSource(declName);
            if (comments == null) {
                callback.gotJavadoc(method);
            }
            this.commentCache.put(declName, comments);
            this.findMethodComment(comments, callback, method, methodSig, true);
            return false;
        }
        this.findMethodComment(comments, callback, method, methodSig, false);
        return true;
    }

    private void findMethodComment(Properties comments, JavadocResolver.AsyncCallback callback, ConstructorOrMethodReflective method, String methodSig, boolean postOnQueue) {
        String comtarget;
        int i = 0;
        while ((comtarget = comments.getProperty("comment" + i + ".target")) != null) {
            if (comtarget.equals(methodSig)) {
                String paramNames = comments.getProperty("comment" + i + ".params");
                String javadoc = comments.getProperty("comment" + i + ".text");
                StringTokenizer tokenizer = new StringTokenizer(paramNames);
                ArrayList<String> paramNamesList = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    paramNamesList.add(tokenizer.nextToken());
                }
                method.setJavaDoc(javadoc);
                method.setParamNames(paramNamesList);
                break;
            }
            ++i;
        }
        if (postOnQueue) {
            callback.gotJavadoc(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassInfo getClassInfoFromSource(String moduleName, String target) {
        List<DocPathEntry> sourcePath = this.project.getSourcePath();
        String pkg = JavaNames.getPrefix(target);
        String entName = target.replace('.', '/') + "." + SourceType.Java.toString().toLowerCase();
        String entNameFs = target.replace('.', File.separatorChar) + "." + SourceType.Java.toString().toLowerCase();
        PackageResolver resolver = new PackageResolver(this.project.getEntityResolver(), pkg);
        for (DocPathEntry pathEntry : sourcePath) {
            File jarFile = pathEntry.getFile();
            if (jarFile.isFile()) {
                Object fullEntryName = pathEntry.getPathPrefix();
                if (((String)fullEntryName).length() != 0 && !((String)fullEntryName).endsWith("/")) {
                    fullEntryName = (String)fullEntryName + "/";
                }
                fullEntryName = (String)fullEntryName + entName;
                Reader r = null;
                try (ZipFile zipFile22 = new ZipFile(jarFile);){
                    ArrayList<Object> possibleEntries = new ArrayList<Object>();
                    possibleEntries.add(fullEntryName);
                    if (moduleName != null) {
                        possibleEntries.add(moduleName + "/" + (String)fullEntryName);
                    }
                    for (String iOException : possibleEntries) {
                        ZipEntry zipEnt = zipFile22.getEntry(iOException);
                        if (zipEnt == null) continue;
                        InputStream zeis = zipFile22.getInputStream(zipEnt);
                        r = new InputStreamReader(zeis, this.project.getProjectCharset());
                        ClassInfo info = JavadocParser.parse(r, resolver, null);
                        if (info == null) {
                            ClassInfo classInfo = null;
                            return classInfo;
                        }
                        ClassInfo classInfo = info;
                        return classInfo;
                    }
                }
                catch (IOException zipFile22) {}
                continue;
                finally {
                    if (r == null) continue;
                    try {
                        r.close();
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!jarFile.isDirectory()) continue;
            File base = jarFile;
            String prefix = pathEntry.getPathPrefix();
            if (prefix != null && !prefix.isEmpty()) {
                base = new File(base, prefix);
            }
            File srcFile = new File(base, entNameFs);
            FileInputStream fis = null;
            try {
                if (!srcFile.canRead()) continue;
                fis = new FileInputStream(srcFile);
                InputStreamReader r = new InputStreamReader((InputStream)fis, this.project.getProjectCharset());
                ClassInfo classInfo = JavadocParser.parse(r, resolver, null);
                ((Reader)r).close();
                if (classInfo == null) {
                    return null;
                }
                return classInfo;
            }
            catch (IOException ioe) {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        String targetName = target.replace('.', '/') + "." + SourceType.Java.toString().toLowerCase();
        URL srcUrl = this.project.getClassLoader().findResource(targetName);
        if (srcUrl != null) {
            try {
                InputStreamReader r = new InputStreamReader(srcUrl.openStream(), this.project.getProjectCharset());
                ClassInfo info = JavadocParser.parse(r, resolver, null);
                if (info != null) {
                    return info;
                }
            }
            catch (IOException ioe) {
                Debug.message("I/O exception while trying to retrieve javadoc for " + target);
            }
        }
        return null;
    }

    private static String buildSig(ConstructorOrMethodReflective method) {
        Object sig = "";
        if (method instanceof MethodReflective) {
            sig = ((MethodReflective)method).getReturnType().getErasedType().toString();
            sig = ((String)sig).replace('$', '.');
            sig = (String)sig + " " + ((MethodReflective)method).getName();
        } else {
            sig = method.getDeclaringType().getSimpleName();
            int lastDot = ((String)(sig = ((String)sig).replace('$', '.'))).lastIndexOf(46);
            if (lastDot != -1) {
                sig = ((String)sig).substring(lastDot + 1);
            }
        }
        sig = (String)sig + "(";
        Iterator<JavaType> i = method.getParamTypes().iterator();
        while (i.hasNext()) {
            JavaType ptype = i.next();
            sig = (String)sig + ptype.getErasedType().toString().replace('$', '.');
            if (!i.hasNext()) continue;
            sig = (String)sig + ", ";
        }
        sig = (String)sig + ")";
        return sig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getCommentsFromSource(String target) {
        List<DocPathEntry> sourcePath = this.project.getSourcePath();
        String pkg = JavaNames.getPrefix(target);
        String entName = target.replace('.', '/') + ".java";
        String entNameFs = target.replace('.', File.separatorChar) + ".java";
        PackageResolver resolver = new PackageResolver(this.project.getEntityResolver(), pkg);
        for (DocPathEntry pathEntry : sourcePath) {
            ClassInfo info;
            File jarFile = pathEntry.getFile();
            if (jarFile.isFile()) {
                Object fullEntryName = pathEntry.getPathPrefix();
                if (((String)fullEntryName).length() != 0 && !((String)fullEntryName).endsWith("/")) {
                    fullEntryName = (String)fullEntryName + "/";
                }
                fullEntryName = (String)fullEntryName + entName;
                Reader r = null;
                try (ZipFile zipFile2 = new ZipFile(jarFile);){
                    ZipEntry zipEnt = zipFile2.getEntry((String)fullEntryName);
                    if (zipEnt == null) continue;
                    InputStream zeis = zipFile2.getInputStream(zipEnt);
                    r = new InputStreamReader(zeis, this.project.getProjectCharset());
                    info = JavadocParser.parse(r, resolver, null);
                    if (info == null) {
                        Properties properties = null;
                        return properties;
                    }
                    Properties properties = info.getComments();
                    return properties;
                }
                catch (IOException zipFile2) {}
                continue;
                finally {
                    if (r == null) continue;
                    try {
                        r.close();
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
            if (!jarFile.isDirectory()) continue;
            File base = jarFile;
            String prefix = pathEntry.getPathPrefix();
            if (prefix != null && !prefix.isEmpty()) {
                base = new File(base, prefix);
            }
            File srcFile = new File(base, entNameFs);
            FileInputStream fis = null;
            try {
                if (!srcFile.canRead()) continue;
                fis = new FileInputStream(srcFile);
                InputStreamReader r = new InputStreamReader((InputStream)fis, this.project.getProjectCharset());
                info = JavadocParser.parse(r, resolver, null);
                ((Reader)r).close();
                if (info == null) {
                    return null;
                }
                return info.getComments();
            }
            catch (IOException ioe) {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        String targetName = target.replace('.', '/') + ".java";
        URL srcUrl = this.project.getClassLoader().findResource(targetName);
        if (srcUrl != null) {
            try {
                InputStreamReader r = new InputStreamReader(srcUrl.openStream(), this.project.getProjectCharset());
                ClassInfo info = JavadocParser.parse(r, resolver, null);
                if (info != null) {
                    return info.getComments();
                }
            }
            catch (IOException ioe) {
                Debug.message("I/O exception while trying to retrieve javadoc for " + target);
            }
        }
        return null;
    }

    @Override
    public String getJavadoc(String moduleName, String className) {
        ClassInfo ci = this.getClassInfoFromSource(moduleName, className);
        if (ci == null) {
            return null;
        }
        return ci.getCommentsAsList().stream().filter(sc -> ci.getName().equals(sc.target)).map(sc -> sc.comment).filter(c -> c != null).findFirst().orElse(null);
    }
}

