/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.GenTypeClass;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.Token;
import bluej.parser.entity.JavaEntity;
import bluej.parser.nodes.ExpressionNode;
import bluej.parser.nodes.InnerNode;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.RBTreeNode;
import bluej.parser.nodes.ReparseableDocument;
import java.util.Iterator;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class ParsedNode
extends RBTreeNode<ParsedNode> {
    public static final int NODETYPE_NONE = 0;
    public static final int NODETYPE_TYPEDEF = 1;
    public static final int NODETYPE_METHODDEF = 2;
    public static final int NODETYPE_ITERATION = 3;
    public static final int NODETYPE_SELECTION = 4;
    public static final int NODETYPE_FIELD = 5;
    public static final int NODETYPE_EXPRESSION = 6;
    public static final int NODETYPE_COMMENT = 7;
    private final NodeTree<ParsedNode> nodeTree = new NodeTree();
    private final ParsedNode parentNode;
    private boolean hasAttachedComment;
    protected boolean complete;
    private boolean isInner = false;
    protected static final int ALL_OK = 0;
    protected static final int NODE_GREW = 1;
    protected static final int NODE_SHRUNK = 2;
    protected static final int REMOVE_NODE = 3;

    ParsedNode(ParsedNode parentNode) {
        this.parentNode = parentNode;
    }

    public Iterator<NodeTree.NodeAndPosition<ParsedNode>> getChildren(int offset) {
        return this.nodeTree.iterator(offset);
    }

    public int getNodeType() {
        return 0;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getName() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public boolean growsForward() {
        return false;
    }

    protected abstract boolean marksOwnEnd();

    public void insertNode(ParsedNode child, int position, int size, NodeStructureListener nodeStructureListener) {
        this.getNodeTree().insertNode(child, position, size);
        nodeStructureListener.nodeAdded(new NodeTree.NodeAndPosition<ParsedNode>(child, position, size));
    }

    public void childChangedName(ParsedNode child, String oldName) {
    }

    public final NodeTree.NodeAndPosition<ParsedNode> findNodeAt(int position, int startpos) {
        return this.nodeTree.findNode(position, startpos);
    }

    public final NodeTree.NodeAndPosition<ParsedNode> findNodeAtOrAfter(int position, int startpos) {
        return this.nodeTree.findNodeAtOrAfter(position, startpos);
    }

    @Override
    public void resize(int newSize) {
        this.getContainingNodeTree().resize(newSize);
    }

    @Override
    public void setSize(int newSize) {
        this.getContainingNodeTree().setSize(newSize);
    }

    public int getOffsetFromParent() {
        if (this.getContainingNodeTree() == null) {
            return 0;
        }
        return this.getContainingNodeTree().getPosition();
    }

    @Override
    public void remove() {
        this.getContainingNodeTree().remove();
    }

    public boolean isContainer() {
        return false;
    }

    public boolean isInner() {
        return this.isInner;
    }

    public void setInner(boolean inner) {
        this.isInner = inner;
    }

    public int getSize() {
        return this.getContainingNodeTree().getNodeSize();
    }

    public abstract int textInserted(ReparseableDocument var1, int var2, int var3, int var4, NodeStructureListener var5);

    public abstract int textRemoved(ReparseableDocument var1, int var2, int var3, int var4, NodeStructureListener var5);

    protected int reparseNode(ReparseableDocument document, int nodePos, int offset, int maxParse, NodeStructureListener listener) {
        return 0;
    }

    public void reparse(ReparseableDocument document, int nodePos, int offset, int maxParse, NodeStructureListener listener) {
        int size = this.getSize();
        int r = this.reparseNode(document, nodePos, offset, maxParse, listener);
        if (r == 3) {
            ParsedNode parent = this.getParentNode();
            parent.removeChild(new NodeTree.NodeAndPosition<ParsedNode>(this, nodePos, this.getSize()), listener);
            document.scheduleReparse(nodePos + size - 1, 0);
        } else if (r == 1 || r == 2) {
            int nsize = this.getSize();
            ParsedNode parent = this.getParentNode();
            if (parent != null) {
                int ppos = nodePos - this.getOffsetFromParent();
                parent.childResized(document, ppos, new NodeTree.NodeAndPosition<ParsedNode>(this, nodePos, nsize));
            }
            document.scheduleReparse(nodePos + nsize, Math.max(size - nsize, 0));
        }
    }

    public abstract TokenAndScope getMarkTokensFor(int var1, int var2, int var3, ReparseableDocument var4);

    public ParsedNode getParentNode() {
        return this.parentNode;
    }

    protected NodeTree<ParsedNode> getNodeTree() {
        return this.nodeTree;
    }

    protected void nodeShortened(int newLength) {
    }

    protected void nodeIncomplete() {
    }

    @OnThread(value=Tag.FXPlatform)
    protected boolean growChild(ReparseableDocument document, NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        return false;
    }

    public void childResized(ReparseableDocument document, int nodePos, NodeTree.NodeAndPosition<ParsedNode> child) {
    }

    @OnThread(value=Tag.FXPlatform)
    public ExpressionTypeInfo getExpressionType(int pos, ReparseableDocument document) {
        return this.getExpressionType(pos, 0, null, document, null);
    }

    @OnThread(value=Tag.FXPlatform)
    protected ExpressionTypeInfo getExpressionType(int pos, int nodePos, JavaEntity defaultType, ReparseableDocument document, ExpressionNode largestPlainExpressionNode) {
        GenTypeClass atype;
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNode(pos, nodePos);
        if (child != null) {
            return child.getNode().getExpressionType(pos, child.getPosition(), defaultType, document, null);
        }
        GenTypeClass genTypeClass = atype = defaultType != null ? defaultType.getType().asClass() : null;
        if (atype == null) {
            return null;
        }
        boolean isStaticCtxt = defaultType.resolveAsType() != null;
        return new ExpressionTypeInfo(atype, atype, null, isStaticCtxt, true);
    }

    public ParsedNode getContainingMethodOrClassNode(int pos) {
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNode(pos, 0);
        if (child != null) {
            return child.getNode().getContainingMethodOrClassNode(pos - child.getPosition());
        }
        if (this.parentNode == null) {
            return null;
        }
        ParsedNode parentNode = this.parentNode;
        while (parentNode.getName() == null || parentNode.getNodeType() != 2 && parentNode.getNodeType() != 1) {
            if (parentNode.parentNode == null) continue;
            parentNode = parentNode.parentNode;
        }
        return parentNode;
    }

    public boolean isCurrentlyInControlStatement(int pos) {
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNode(pos, 0);
        if (child != null) {
            return child.getNode().isCurrentlyInControlStatement(pos - child.getPosition());
        }
        if (this.parentNode == null) {
            return false;
        }
        ParsedNode parentNode = this.parentNode;
        while (parentNode.getNodeType() != 2 && parentNode.getNodeType() != 1 && !(parentNode instanceof InnerNode)) {
            if (parentNode.getNodeType() == 4 || parentNode.getNodeType() == 3) {
                return true;
            }
            if (parentNode.parentNode == null) continue;
            parentNode = parentNode.parentNode;
        }
        return false;
    }

    protected final void removeChild(NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        child.getNode().remove();
        this.childRemoved(child, listener);
    }

    protected void childRemoved(NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        listener.nodeRemoved(child);
        ParsedNode.removeChildren(child, listener);
    }

    protected static void removeChildren(NodeTree.NodeAndPosition<ParsedNode> node, NodeStructureListener listener) {
        Iterator<NodeTree.NodeAndPosition<ParsedNode>> i = node.getNode().getChildren(node.getPosition());
        while (i.hasNext()) {
            NodeTree.NodeAndPosition<ParsedNode> nap = i.next();
            listener.nodeRemoved(nap);
            ParsedNode.removeChildren(nap, listener);
        }
    }

    public boolean isCommentAttached() {
        return this.hasAttachedComment;
    }

    public void setCommentAttached(boolean commentAttached) {
        this.hasAttachedComment = commentAttached;
    }

    public int getAbsoluteEditorPosition() {
        int position = this.getOffsetFromParent();
        for (ParsedNode parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            position += parent.getOffsetFromParent();
        }
        return position;
    }

    public record TokenAndScope(Token tokenLinkedList, int startLatestScope) {
    }
}

