/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.entity;

import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.EntityResolver;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeEntity;

public class PackageResolver
implements EntityResolver {
    private EntityResolver parentResolver;
    private final String pkg;

    public PackageResolver(EntityResolver parentResolver, String pkg) {
        this.parentResolver = parentResolver;
        this.pkg = pkg;
    }

    @Override
    public JavaEntity getValueEntity(String name, Reflective querySource) {
        return this.resolvePackageOrClass(name, querySource);
    }

    @Override
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
        Object fqName = this.pkg.length() == 0 ? name : this.pkg + "." + name;
        TypeEntity tent = this.parentResolver.resolveQualifiedClass((String)fqName);
        if (tent != null) {
            return tent;
        }
        return new PackageEntity(name, this);
    }

    @Override
    public TypeEntity resolveQualifiedClass(String name) {
        return this.parentResolver.resolveQualifiedClass(name);
    }
}

