/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.parser.JavaParserCallbacks;
import bluej.parser.ParseFailure;
import bluej.parser.TokenStream;
import bluej.parser.lexer.JavaLexer;
import bluej.parser.lexer.JavaTokenFilter;
import bluej.parser.lexer.LocatableToken;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class JavaParser
extends JavaParserCallbacks {
    protected JavaTokenFilter tokenStream;
    protected LocatableToken lastToken;
    public static final int TYPEDEF_CLASS = 0;
    public static final int TYPEDEF_INTERFACE = 1;
    public static final int TYPEDEF_ENUM = 2;
    public static final int TYPEDEF_RECORD = 6;
    public static final int TYPEDEF_ANNOTATION = 3;
    public static final int TYPEDEF_ERROR = 4;
    public static final int TYPEDEF_EPIC_FAIL = 5;
    private static int[] statementTokenIndexes = new int[181];
    protected static final int DECL_TYPE_FORINIT = 0;
    protected static final int DECL_TYPE_VAR = 1;
    protected static final int DECL_TYPE_FIELD = 2;
    private static final int TYPE_PRIMITIVE = 0;
    private static final int TYPE_OTHER = 1;
    private static final int TYPE_ERROR = 2;
    private static int[] expressionTokenIndexes;
    private static int[] expressionOpIndexes;

    public static TokenStream getLexer(Reader r) {
        return new JavaLexer(r);
    }

    public static TokenStream getLexer(Reader r, boolean handleComments, boolean handleMultilineStrings) {
        return new JavaLexer(r, handleComments, handleMultilineStrings);
    }

    private static TokenStream getLexer(Reader r, int line, int col, int pos) {
        return new JavaLexer(r, line, col, pos);
    }

    public JavaParser(Reader r) {
        TokenStream lexer = JavaParser.getLexer(r);
        this.tokenStream = new JavaTokenFilter(lexer, this);
    }

    public JavaParser(Reader r, boolean handleComments) {
        TokenStream lexer = JavaParser.getLexer(r, handleComments, true);
        this.tokenStream = new JavaTokenFilter(lexer, this);
    }

    public JavaParser(Reader r, int line, int col, int pos) {
        TokenStream lexer = JavaParser.getLexer(r, line, col, pos);
        this.tokenStream = new JavaTokenFilter(lexer, this);
    }

    public final JavaTokenFilter getTokenStream() {
        return this.tokenStream;
    }

    public final LocatableToken getLastToken() {
        return this.lastToken;
    }

    private void error(String msg) {
        this.errorBehind(msg, this.lastToken);
    }

    private void error(String msg, LocatableToken token) {
        this.error(msg, token.getLine(), token.getColumn(), token.getEndLine(), token.getEndColumn());
    }

    private void errorBefore(String msg, LocatableToken token) {
        this.error(msg, token.getLine(), token.getColumn(), token.getLine(), token.getColumn());
    }

    private void errorBehind(String msg, LocatableToken token) {
        this.error(msg, token.getEndLine(), token.getEndColumn(), token.getEndLine(), token.getEndColumn());
    }

    protected void error(String msg, int beginLine, int beginCol, int endLine, int endCol) {
        throw new ParseFailure("Parse error: (" + beginLine + ":" + beginCol + ") :" + msg);
    }

    public void parseCU() {
        int state = 0;
        while (this.tokenStream.LA(1).getType() != 1) {
            if (this.tokenStream.LA(1).getType() == 63) {
                this.nextToken();
                continue;
            }
            state = this.parseCUpart(state);
        }
        this.finishedCU(state);
    }

    public final boolean isTypeDeclarator(LocatableToken token) {
        return token.getType() == 101 || token.getType() == 103 || token.getType() == 102 || token.getType() == 176;
    }

    public static boolean isPrimitiveType(LocatableToken token) {
        return token.getType() == 78 || token.getType() == 79 || token.getType() == 80 || token.getType() == 81 || token.getType() == 82 || token.getType() == 83 || token.getType() == 85 || token.getType() == 84 || token.getType() == 86;
    }

    protected final LocatableToken nextToken() {
        this.lastToken = this.tokenStream.nextToken();
        return this.lastToken;
    }

    public final int parseCUpart(int state) {
        LocatableToken token = this.nextToken();
        if (token.getType() == 62) {
            if (state != 0) {
                this.error("Only one 'package' statement is allowed", token);
            }
            token = this.parsePackageStmt(token);
            this.reachedCUstate(1);
            state = 1;
        } else if (token.getType() == 64) {
            this.parseImportStatement(token);
            this.reachedCUstate(1);
            state = 1;
        } else if (JavaParser.isModifier(token) || this.isTypeDeclarator(token)) {
            this.gotTopLevelDecl(token);
            this.gotDeclBegin(token);
            this.tokenStream.pushBack(token);
            this.parseModifiers();
            this.parseTypeDef(token);
            this.reachedCUstate(2);
            state = 2;
        } else {
            if (token.getType() == 1) {
                return state;
            }
            this.error("Expected: Type definition (class, interface or enum)", token);
        }
        return state;
    }

    public final LocatableToken parsePackageStmt(LocatableToken token) {
        this.beginPackageStatement(token);
        token = this.nextToken();
        if (token.getType() != 69) {
            this.error("Expected identifier after 'package'");
            return null;
        }
        List<LocatableToken> pkgTokens = this.parseDottedIdent(token);
        this.gotPackage(pkgTokens);
        LocatableToken lastPkgToken = this.lastToken;
        token = this.nextToken();
        if (token.getType() != 63) {
            this.tokenStream.pushBack(token);
            this.error("BJ003", lastPkgToken.getEndLine(), lastPkgToken.getEndColumn(), lastPkgToken.getEndLine(), lastPkgToken.getEndColumn());
            return null;
        }
        this.gotPackageSemi(token);
        return token;
    }

    public final void parseImportStatement() {
        LocatableToken token = this.nextToken();
        if (token.getType() == 64) {
            this.parseImportStatement(token);
        } else {
            this.error("Import statements must start with \"import\".");
        }
    }

    public final void parseImportStatement(LocatableToken importToken) {
        LocatableToken token = importToken;
        this.beginElement(token);
        boolean isStatic = false;
        token = this.tokenStream.nextToken();
        if (token.getType() == 65) {
            isStatic = true;
            token = this.tokenStream.nextToken();
        }
        if (token.getType() != 69) {
            this.tokenStream.pushBack(token);
            this.error("Expecting identifier (package containing element to be imported)");
            this.endElement(token, false);
            return;
        }
        List<LocatableToken> tokens = this.parseDottedIdent(token);
        LocatableToken lastIdentToken = this.lastToken;
        if (this.tokenStream.LA(1).getType() == 68) {
            LocatableToken lastToken = this.nextToken();
            token = this.nextToken();
            if (token.getType() == 63) {
                this.error("Trailing '.' in import statement", lastToken.getLine(), lastToken.getColumn(), lastToken.getEndLine(), lastToken.getEndColumn());
            } else if (token.getType() == 87) {
                lastToken = token;
                token = this.nextToken();
                if (token.getType() != 63) {
                    this.tokenStream.pushBack(token);
                    this.error("Expected ';' following import statement", lastToken.getEndLine(), lastToken.getEndColumn(), lastToken.getEndLine(), lastToken.getEndColumn());
                } else {
                    this.gotWildcardImport(tokens, isStatic, importToken, token);
                    this.gotImportStmtSemi(token);
                }
            } else {
                this.error("Expected package/class identifier, or '*', in import statement.");
                if (this.tokenStream.LA(1).getType() == 63) {
                    this.nextToken();
                }
            }
        } else {
            token = this.nextToken();
            if (token.getType() != 63) {
                this.tokenStream.pushBack(token);
                this.error("Expected ';' following import statement", lastIdentToken.getEndLine(), lastIdentToken.getEndColumn(), lastIdentToken.getEndLine(), lastIdentToken.getEndColumn());
            } else {
                this.gotImport(tokens, isStatic, importToken, token);
                this.gotImportStmtSemi(token);
            }
        }
    }

    public final void parseTypeDef() {
        this.parseModifiers();
        this.parseTypeDef(this.tokenStream.LA(1));
    }

    public final void parseTypeDef(LocatableToken firstToken) {
        int tdType = this.parseTypeDefBegin();
        if (tdType != 5) {
            this.gotTypeDef(firstToken, tdType);
        }
        this.modifiersConsumed();
        if (tdType == 5) {
            this.endDecl(this.tokenStream.LA(1));
            return;
        }
        LocatableToken token = this.tokenStream.nextToken();
        if (token.getType() != 69) {
            this.tokenStream.pushBack(token);
            this.gotTypeDefEnd(token, false);
            this.error("Expected identifier (in type definition)");
            return;
        }
        this.gotTypeDefName(token);
        token = this.parseTypeDefPart2(tdType == 6);
        if (token == null) {
            this.gotTypeDefEnd(this.tokenStream.LA(1), false);
            return;
        }
        this.lastToken = this.parseTypeBody(tdType, token);
        this.gotTypeDefEnd(this.lastToken, this.lastToken.getType() == 100);
    }

    public final LocatableToken parseTypeBody(int tdType, LocatableToken token) {
        this.beginTypeBody(token);
        if (tdType == 2) {
            this.parseEnumConstants();
        }
        this.parseClassBody();
        token = this.nextToken();
        if (token.getType() != 100) {
            this.error("Expected '}' (in class definition)");
        }
        this.endTypeBody(token, token.getType() == 100);
        return token;
    }

    public final int parseTypeDefBegin() {
        boolean isAnnotation;
        this.parseModifiers();
        LocatableToken token = this.nextToken();
        boolean bl = isAnnotation = token.getType() == 95;
        if (isAnnotation) {
            LocatableToken tdToken = this.nextToken();
            if (tdToken.getType() != 102) {
                this.error("Expected 'interface' after '@' in interface definition");
                this.tokenStream.pushBack(tdToken);
                return 5;
            }
            token = tdToken;
        }
        if (this.isTypeDeclarator(token)) {
            int tdType = -1;
            if (token.getType() == 101) {
                tdType = 0;
            } else if (token.getType() == 102) {
                tdType = 1;
                if (isAnnotation) {
                    tdType = 3;
                }
            } else {
                tdType = token.getType() == 176 ? 6 : 2;
            }
            return tdType;
        }
        this.error("Expected type declarator: 'class', 'interface', or 'enum'");
        return 5;
    }

    public final LocatableToken parseTypeDefPart2(boolean isRecord) {
        LocatableToken token = this.nextToken();
        if (token.getType() == 73) {
            this.parseTypeParams();
            token = this.tokenStream.nextToken();
        }
        if (isRecord) {
            if (token.getType() == 96) {
                this.beginRecordParameters(token);
                this.parseParameterList(true);
                token = this.nextToken();
                this.endRecordParameters(token);
                if (token.getType() != 97) {
                    this.error("Expected ')' at end of parameter list (in record declaration)");
                    this.tokenStream.pushBack(token);
                }
                token = this.nextToken();
            } else {
                this.tokenStream.pushBack(token);
                this.error("Expected '{' (in type definition)");
            }
        }
        if (token.getType() == 71) {
            this.beginTypeDefExtends(token);
            do {
                this.parseTypeSpec(true);
            } while ((token = this.nextToken()).getType() == 74);
            if (token.getType() == 68) {
                this.error("Incomplete type specification", token);
                return null;
            }
            this.endTypeDefExtends();
        }
        if (token.getType() == 106) {
            this.beginTypeDefImplements(token);
            do {
                this.parseTypeSpec(true);
            } while ((token = this.nextToken()).getType() == 74);
            if (token.getType() == 68) {
                this.error("Incomplete type specification", token);
                return null;
            }
            this.endTypeDefImplements();
        }
        if (token.getType() == 179) {
            this.beginTypeDefPermits(token);
            do {
                this.parseTypeSpec(true);
            } while ((token = this.nextToken()).getType() == 74);
            if (token.getType() == 68) {
                this.error("Incomplete type specification", token);
                return null;
            }
            this.endTypeDefPermits();
        }
        if (token.getType() == 99) {
            return token;
        }
        this.tokenStream.pushBack(token);
        this.error("Expected '{' (in type definition)");
        return null;
    }

    public final void parseEnumConstants() {
        LocatableToken token = this.nextToken();
        while (token.getType() == 69) {
            token = this.nextToken();
            if (token.getType() == 96) {
                this.parseArgumentList(token);
                token = this.nextToken();
            }
            if (token.getType() == 99) {
                this.beginAnonClassBody(token, true);
                this.parseClassBody();
                token = this.nextToken();
                if (token.getType() != 100) {
                    this.error("Expected '}' at end of enum constant body");
                    this.endAnonClassBody(token, false);
                } else {
                    this.endAnonClassBody(token, true);
                    token = this.nextToken();
                }
            }
            if (token.getType() == 63) {
                return;
            }
            if (token.getType() == 100) {
                this.tokenStream.pushBack(token);
                return;
            }
            if (token.getType() != 74) {
                this.error("Expecting ',' or ';' after enum constant declaration");
                this.tokenStream.pushBack(token);
                return;
            }
            token = this.nextToken();
        }
    }

    public final void parseTypeParams() {
        block4: {
            LocatableToken token;
            DepthRef dr = new DepthRef();
            dr.depth = 1;
            do {
                LocatableToken idToken;
                if ((idToken = this.nextToken()).getType() != 69) {
                    this.error("Expected identifier (in type parameter list)");
                    this.tokenStream.pushBack(idToken);
                    return;
                }
                this.gotTypeParam(idToken);
                token = this.nextToken();
                if (token.getType() != 71) continue;
                do {
                    LinkedList<LocatableToken> boundTokens;
                    if (this.parseTargType(false, boundTokens = new LinkedList<LocatableToken>(), dr)) {
                        this.gotTypeParamBound(boundTokens);
                    }
                    if (dr.depth > 0) continue;
                    return;
                } while ((token = this.nextToken()).getType() == 104);
            } while (token.getType() == 74);
            if (token.getType() == 75) break block4;
            this.error("Expecting '>' at end of type parameter list");
            this.tokenStream.pushBack(token);
        }
    }

    public static boolean isModifier(LocatableToken token) {
        int tokType = token.getType();
        return tokType == 89 || tokType == 88 || tokType == 90 || tokType == 40 || tokType == 39 || tokType == 65 || tokType == 94 || tokType == 92 || tokType == 41 || tokType == 91 || tokType == 93 || tokType == 95 || tokType == 105 || tokType == 177 || tokType == 178;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final List<LocatableToken> parseModifiers() {
        LinkedList<LocatableToken> rval = new LinkedList<LocatableToken>();
        LocatableToken token = this.tokenStream.nextToken();
        while (true) {
            if (!JavaParser.isModifier(token)) {
                this.tokenStream.pushBack(token);
                return rval;
            }
            if (token.getType() == 95) {
                if (this.tokenStream.LA(1).getType() != 69) {
                    this.tokenStream.pushBack(token);
                    return rval;
                }
                this.lastToken = token;
                this.parseAnnotation();
            } else {
                this.gotModifier(token);
            }
            this.lastToken = token;
            rval.add(token);
            token = this.nextToken();
        }
    }

    public final void parseClassBody() {
        LocatableToken token = this.tokenStream.nextToken();
        while (token.getType() != 100) {
            if (token.getType() == 1) {
                this.error("Unexpected end-of-file in type body; missing '}'", token);
                return;
            }
            this.parseClassElement(token);
            token = this.nextToken();
        }
        this.tokenStream.pushBack(token);
    }

    public final void parseClassElement(LocatableToken token) {
        if (token.getType() == 63) {
            return;
        }
        this.gotDeclBegin(token);
        this.tokenStream.pushBack(token);
        LocatableToken hiddenToken = token.getHiddenBefore();
        List<LocatableToken> modifiers = this.parseModifiers();
        LocatableToken firstMod = null;
        if (!modifiers.isEmpty()) {
            firstMod = modifiers.get(0);
        }
        if ((token = this.nextToken()).getType() == 101 || token.getType() == 102 || token.getType() == 103 || token.getType() == 176 || token.getType() == 95) {
            this.gotInnerType(token);
            this.tokenStream.pushBack(token);
            this.parseTypeDef(firstMod != null ? firstMod : token);
        } else if (token.getType() == 99) {
            LocatableToken firstToken = firstMod == null ? token : firstMod;
            this.beginInitBlock(firstToken, token);
            this.modifiersConsumed();
            this.parseStmtBlock();
            token = this.nextToken();
            if (token.getType() != 100) {
                this.error("Expecting '}' (at end of initialisation block)");
                this.tokenStream.pushBack(token);
                this.endInitBlock(token, false);
                this.endElement(token, false);
            } else {
                this.endInitBlock(token, true);
                this.endElement(token, true);
            }
        } else if (token.getType() == 73 || token.getType() == 69 || JavaParser.isPrimitiveType(token)) {
            boolean isConstructor;
            LocatableToken first;
            LocatableToken locatableToken = first = firstMod != null ? firstMod : token;
            if (token.getType() == 73) {
                this.gotMethodTypeParamsBegin();
                this.parseTypeParams();
                this.endMethodTypeParams();
            } else {
                this.tokenStream.pushBack(token);
            }
            boolean bl = isConstructor = this.tokenStream.LA(1).getType() == 69 && this.tokenStream.LA(2).getType() == 96;
            if (!isConstructor && !this.parseTypeSpec(true)) {
                this.endDecl(this.tokenStream.LA(1));
                return;
            }
            LocatableToken idToken = this.tokenStream.nextToken();
            if (idToken.getType() != 69) {
                this.modifiersConsumed();
                this.tokenStream.pushBack(idToken);
                this.errorBefore("Expected identifier (method or field name).", idToken);
                this.endDecl(idToken);
                return;
            }
            token = this.nextToken();
            int ttype = token.getType();
            if (ttype == 66 || ttype == 63 || ttype == 98 || ttype == 74) {
                this.beginFieldDeclarations(first);
                if (ttype == 66) {
                    this.tokenStream.pushBack(token);
                    this.parseArrayDeclarators();
                    token = this.nextToken();
                    ttype = token.getType();
                }
                this.gotField(first, idToken, ttype == 98);
                if (ttype == 63) {
                    this.endField(token, true);
                    this.endFieldDeclarations(token, true);
                } else if (ttype == 98) {
                    this.parseExpression();
                    this.parseSubsequentDeclarations(2, true);
                } else if (ttype == 74) {
                    this.tokenStream.pushBack(token);
                    this.parseSubsequentDeclarations(2, true);
                } else {
                    this.error("Expected ',', '=' or ';' after field declaration");
                    this.tokenStream.pushBack(token);
                    this.endField(token, false);
                    this.endFieldDeclarations(token, false);
                }
                this.modifiersConsumed();
            } else if (ttype == 96) {
                if (isConstructor) {
                    this.gotConstructorDecl(idToken, hiddenToken);
                } else {
                    this.gotMethodDeclaration(idToken, hiddenToken);
                }
                this.modifiersConsumed();
                this.parseMethodParamsBody();
            } else {
                this.modifiersConsumed();
                this.tokenStream.pushBack(token);
                this.error("Expected ';' or '=' or '(' (in field or method declaration).");
                this.endDecl(token);
            }
        } else {
            this.error("Unexpected token \"" + token.getText() + "\" in type declaration body");
            this.endDecl(this.tokenStream.LA(1));
        }
    }

    protected final void parseArrayDeclarators() {
        if (this.tokenStream.LA(1).getType() != 66) {
            return;
        }
        LocatableToken token = this.nextToken();
        while (token.getType() == 66) {
            token = this.nextToken();
            if (token.getType() != 67) {
                this.errorBefore("Expecting ']' (to match '[')", token);
                if (this.tokenStream.LA(1).getType() == 67) {
                    token = this.nextToken();
                } else {
                    this.tokenStream.pushBack(token);
                    return;
                }
            }
            this.gotArrayDeclarator();
            token = this.nextToken();
        }
        this.tokenStream.pushBack(token);
    }

    public final void parseMethodParamsBody() {
        this.parseParameterList(false);
        this.gotAllMethodParameters();
        LocatableToken token = this.nextToken();
        if (token.getType() != 97) {
            this.error("Expected ')' at end of parameter list (in method declaration)");
            this.tokenStream.pushBack(token);
            this.endMethodDecl(token, false);
            return;
        }
        token = this.nextToken();
        if (token.getType() == 108) {
            this.beginThrows(token);
            do {
                this.parseTypeSpec(true);
            } while ((token = this.nextToken()).getType() == 74);
            this.endThrows();
        }
        if (token.getType() == 99) {
            this.beginMethodBody(token);
            this.parseStmtBlock();
            token = this.nextToken();
            if (token.getType() != 100) {
                this.error("Expected '}' at end of method body");
                this.tokenStream.pushBack(token);
                this.endMethodBody(token, false);
                this.endMethodDecl(token, false);
            } else {
                this.endMethodBody(token, true);
                this.endMethodDecl(token, true);
            }
            return;
        }
        if (token.getType() == 105) {
            this.parseExpression();
            token = this.nextToken();
        }
        if (token.getType() != 63) {
            this.tokenStream.pushBack(token);
            this.error("BJ000");
            this.endMethodDecl(token, false);
        } else {
            this.endMethodDecl(token, true);
        }
    }

    public final void parseStmtBlock() {
        while (true) {
            LocatableToken token;
            if ((token = this.nextToken()).getType() == 1 || token.getType() == 100) {
                this.tokenStream.pushBack(token);
                return;
            }
            this.beginElement(token);
            LocatableToken ntoken = this.parseStatement(token, false);
            if (ntoken != null) {
                this.endElement(ntoken, true);
                continue;
            }
            ntoken = this.tokenStream.LA(1);
            this.endElement(this.tokenStream.LA(1), false);
            if (ntoken != token) continue;
            this.nextToken();
            this.error("Invalid beginning of statement.", token);
        }
    }

    public final void parseStatement() {
        this.parseStatement(this.nextToken(), false);
    }

    public final LocatableToken parseStatement(LocatableToken token, boolean allowComma) {
        block22: while (true) {
            switch (statementTokenIndexes[token.getType()]) {
                case 1: {
                    this.gotEmptyStatement();
                    return token;
                }
                case 2: {
                    token = this.nextToken();
                    this.gotReturnStatement(token.getType() != 63);
                    if (token.getType() != 63) {
                        this.tokenStream.pushBack(token);
                        this.parseExpression();
                        token = this.nextToken();
                    }
                    if (token.getType() != 63) {
                        this.tokenStream.pushBack(token);
                        this.error("BJ003");
                        return null;
                    }
                    return token;
                }
                case 3: {
                    return this.parseForStatement(token);
                }
                case 4: {
                    return this.parseWhileStatement(token);
                }
                case 5: {
                    return this.parseIfStatement(token);
                }
                case 6: {
                    return this.parseDoWhileStatement(token);
                }
                case 7: {
                    return this.parseAssertStatement(token);
                }
                case 8: {
                    return this.parseSwitchStatement(token);
                }
                case 9: {
                    this.gotSwitchCase();
                    this.parseExpression(false, false);
                    token = this.nextToken();
                    boolean hadCommas = false;
                    while (token.getType() == 74) {
                        this.parseExpression(false, false);
                        token = this.nextToken();
                        hadCommas = true;
                    }
                    if (token.getType() == 172) {
                        token = this.tokenStream.LA(1);
                        if (token.getType() == 99 || token.getType() == 119) {
                            this.parseStatement();
                        } else {
                            this.parseExpression();
                            token = this.tokenStream.nextToken();
                            if (token.getType() != 63) {
                                this.error("Expecting ';' after case body");
                                this.tokenStream.pushBack(token);
                                return null;
                            }
                        }
                    } else {
                        if (token.getType() != 110) {
                            this.error("Expecting ':' at end of case expression");
                            this.tokenStream.pushBack(token);
                            return null;
                        }
                        if (hadCommas) {
                            this.error("Comma-separated expressions not valid before ':' in case expression");
                            this.tokenStream.pushBack(token);
                            return null;
                        }
                    }
                    return token;
                }
                case 10: {
                    this.gotSwitchDefault();
                    token = this.nextToken();
                    if (token.getType() != 110) {
                        this.error("Expecting ':' at end of case expression");
                        this.tokenStream.pushBack(token);
                        return null;
                    }
                    return token;
                }
                case 11: 
                case 12: {
                    LocatableToken keywordToken = token;
                    token = this.nextToken();
                    if (token.getType() == 69) {
                        token = this.nextToken();
                        this.gotBreakContinue(keywordToken, token);
                    } else {
                        this.gotBreakContinue(keywordToken, null);
                    }
                    if (token.getType() != 63) {
                        this.tokenStream.pushBack(token);
                        this.error("BJ003");
                        return null;
                    }
                    return token;
                }
                case 13: {
                    this.gotThrow(token);
                    this.parseExpression();
                    token = this.nextToken();
                    if (token.getType() != 63) {
                        this.tokenStream.pushBack(token);
                        this.error("BJ003");
                        return null;
                    }
                    return token;
                }
                case 14: {
                    return this.parseTryCatchStmt(token);
                }
                case 15: {
                    LocatableToken ctoken = this.nextToken();
                    if (ctoken.getType() == 110) {
                        return ctoken;
                    }
                    this.tokenStream.pushBack(ctoken);
                    this.tokenStream.pushBack(token);
                    LinkedList<LocatableToken> tlist = new LinkedList();
                    boolean isTypeSpec = this.parseTypeSpec(true, true, tlist);
                    token = this.tokenStream.LA(1);
                    this.pushBackAll(tlist);
                    if (isTypeSpec && token.getType() == 69) {
                        token = (LocatableToken)tlist.get(0);
                        this.gotDeclBegin(token);
                        return this.parseVariableDeclarations(token, true);
                    }
                    this.gotStatementExpression();
                    this.parseExpression();
                    token = this.tokenStream.nextToken();
                    if (token.getType() == 74 && allowComma) {
                        token = this.tokenStream.nextToken();
                        continue block22;
                    }
                    if (token.getType() != 63) {
                        this.tokenStream.pushBack(token);
                        this.error("Expected ';' at end of previous statement");
                        return null;
                    }
                    return token;
                }
                case 16: {
                    this.beginSynchronizedBlock(token);
                    token = this.nextToken();
                    if (token.getType() == 96) {
                        this.parseExpression();
                        token = this.nextToken();
                        if (token.getType() != 97) {
                            this.errorBefore("Expecting ')' at end of expression", token);
                            this.tokenStream.pushBack(token);
                            this.endSynchronizedBlock(token, false);
                            return null;
                        }
                        token = this.tokenStream.nextToken();
                    }
                    if (token.getType() == 99) {
                        this.beginStmtblockBody(token);
                        this.parseStmtBlock();
                        token = this.nextToken();
                        if (token.getType() != 100) {
                            this.error("Expecting '}' at end of synchronized block");
                            this.tokenStream.pushBack(token);
                            this.endStmtblockBody(token, false);
                            this.endSynchronizedBlock(token, false);
                            return null;
                        }
                        this.endStmtblockBody(token, true);
                        this.endSynchronizedBlock(token, true);
                        return token;
                    }
                    this.error("Expecting statement block after 'synchronized'");
                    this.tokenStream.pushBack(token);
                    this.endSynchronizedBlock(token, false);
                    return null;
                }
                case 116: {
                    this.gotYieldStatement();
                    this.parseExpression();
                    token = this.nextToken();
                    if (token.getType() != 63) {
                        this.tokenStream.pushBack(token);
                        this.error("BJ003");
                        return null;
                    }
                    return token;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    this.tokenStream.pushBack(token);
                    this.gotDeclBegin(token);
                    this.parseModifiers();
                    if (this.isTypeDeclarator(this.tokenStream.LA(1)) || this.tokenStream.LA(1).getType() == 95) {
                        this.gotInnerType(this.tokenStream.LA(1));
                        this.parseTypeDef(token);
                    } else {
                        this.parseVariableDeclarations(token, true);
                    }
                    return null;
                }
                case 28: 
                case 29: 
                case 30: {
                    this.tokenStream.pushBack(token);
                    this.gotDeclBegin(token);
                    this.parseTypeDef(token);
                    return null;
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    this.tokenStream.pushBack(token);
                    LinkedList<LocatableToken> tlist = new LinkedList<LocatableToken>();
                    this.parseTypeSpec(false, true, tlist);
                    if (this.tokenStream.LA(1).getType() == 68) {
                        this.pushBackAll(tlist);
                        this.parseExpression();
                        token = this.nextToken();
                        if (token.getType() != 63) {
                            this.error("Expected ';' after expression-statement");
                            return null;
                        }
                        return token;
                    }
                    this.pushBackAll(tlist);
                    this.gotDeclBegin(token);
                    return this.parseVariableDeclarations(token, true);
                }
                case 40: {
                    this.beginStmtblockBody(token);
                    this.parseStmtBlock();
                    token = this.nextToken();
                    if (token.getType() != 100) {
                        this.error("Expecting '}' at end of statement block");
                        if (token.getType() != 97) {
                            this.tokenStream.pushBack(token);
                        }
                        this.endStmtblockBody(token, false);
                        return null;
                    }
                    this.endStmtblockBody(token, true);
                    return token;
                }
            }
            break;
        }
        if (!this.isExpressionTokenType(token.getType())) {
            this.error("Not a valid statement beginning.", token);
            return null;
        }
        this.tokenStream.pushBack(token);
        this.gotStatementExpression();
        this.parseExpression();
        token = this.tokenStream.nextToken();
        if (token.getType() != 63) {
            this.tokenStream.pushBack(token);
            this.error("Expected ';' at end of previous statement");
            return null;
        }
        return token;
    }

    public final LocatableToken parseTryCatchStmt(LocatableToken token) {
        this.beginTryCatchSmt(token, this.tokenStream.LA(1).getType() == 96);
        token = this.nextToken();
        if (token.getType() == 96) {
            do {
                if ((token = this.tokenStream.LA(1)).getType() == 69) {
                    LinkedList<LocatableToken> tlist = new LinkedList<LocatableToken>();
                    boolean isTypeSpec = this.parseTypeSpec(true, true, tlist);
                    token = this.tokenStream.LA(1);
                    this.pushBackAll(tlist);
                    if (isTypeSpec && token.getType() == 69) {
                        this.gotDeclBegin((LocatableToken)tlist.get(0));
                        this.parseVariableDeclarations((LocatableToken)tlist.get(0), false);
                        continue;
                    }
                    this.parseExpression();
                    continue;
                }
                if (JavaParser.isModifier(token)) {
                    this.tokenStream.nextToken();
                    this.parseVariableDeclarations();
                    continue;
                }
                this.parseExpression();
            } while ((token = this.tokenStream.nextToken()).getType() == 63);
            if (token.getType() != 97) {
                this.errorBefore("Missing closing ')' after resources in 'try' statement", token);
            }
            token = this.nextToken();
        }
        if (token.getType() != 99) {
            this.error("Expecting '{' after 'try'");
            this.tokenStream.pushBack(token);
            this.endTryCatchStmt(token, false);
            return null;
        }
        this.beginTryBlock(token);
        this.parseStmtBlock();
        token = this.nextToken();
        if (token.getType() == 100) {
            this.endTryBlock(token, true);
        } else if (token.getType() == 125 || token.getType() == 124) {
            this.tokenStream.pushBack(token);
            this.error("Missing '}' at end of 'try' block");
            this.endTryBlock(token, false);
        } else {
            this.tokenStream.pushBack(token);
            this.error("Missing '}' at end of 'try' block");
            this.endTryBlock(token, false);
            this.endTryCatchStmt(token, false);
            return null;
        }
        int laType = this.tokenStream.LA(1).getType();
        while (laType == 125 || laType == 124) {
            token = this.nextToken();
            this.gotCatchFinally(token);
            if (laType == 125) {
                token = this.nextToken();
                if (token.getType() != 96) {
                    this.error("Expecting '(' after 'catch'");
                    this.tokenStream.pushBack(token);
                    this.endTryCatchStmt(token, false);
                    return null;
                }
                while (true) {
                    if (this.tokenStream.LA(1).getType() == 39) {
                        token = this.nextToken();
                    }
                    this.parseTypeSpec(true);
                    token = this.nextToken();
                    if (token.getType() != 139) break;
                    this.gotMultiCatch(token);
                }
                if (token.getType() != 69) {
                    this.error("Expecting identifier after type (in 'catch' expression)");
                    this.tokenStream.pushBack(token);
                    this.endTryCatchStmt(token, false);
                    return null;
                }
                this.gotCatchVarName(token);
                token = this.nextToken();
                if (token.getType() != 97) {
                    this.error("Expecting ')' after identifier (in 'catch' expression)");
                    this.tokenStream.pushBack(token);
                    this.endTryCatchStmt(token, false);
                    return null;
                }
            }
            if ((token = this.nextToken()).getType() != 99) {
                this.error("Expecting '{' after 'catch'/'finally'");
                this.tokenStream.pushBack(token);
                this.endTryCatchStmt(token, false);
                return null;
            }
            token = this.parseStatement(token, false);
            laType = this.tokenStream.LA(1).getType();
        }
        if (token != null) {
            this.endTryCatchStmt(token, true);
        } else {
            this.endTryCatchStmt(this.tokenStream.LA(1), false);
        }
        return token;
    }

    public final LocatableToken parseAssertStatement(LocatableToken token) {
        this.gotAssert();
        this.parseExpression();
        token = this.tokenStream.nextToken();
        if (token.getType() == 110) {
            this.lastToken = token;
            this.parseExpression();
            token = this.tokenStream.nextToken();
        }
        if (token.getType() != 63) {
            this.error("Expected ';' at end of assertion statement");
            this.tokenStream.pushBack(token);
            return null;
        }
        this.lastToken = token;
        return token;
    }

    public final LocatableToken parseSwitchExpression(LocatableToken token) {
        this.beginSwitchStmt(token, true);
        token = this.nextToken();
        if (token.getType() != 96) {
            this.error("Expected '(' after 'switch'");
            this.tokenStream.pushBack(token);
            this.endSwitchStmt(token, false);
            return null;
        }
        this.parseExpression();
        token = this.nextToken();
        if (token.getType() != 97) {
            this.error("Expected ')' at end of expression (in 'switch(...)')");
            this.tokenStream.pushBack(token);
            this.endSwitchStmt(token, false);
            return null;
        }
        token = this.tokenStream.nextToken();
        if (token.getType() != 99) {
            this.error("Expected '{' after 'switch(...)'");
            this.tokenStream.pushBack(token);
            this.endSwitchStmt(token, false);
            return null;
        }
        this.beginSwitchBlock(token);
        this.parseStmtBlock();
        token = this.nextToken();
        if (token.getType() != 100) {
            this.error("Missing '}' at end of 'switch' statement block");
            this.tokenStream.pushBack(token);
            this.endSwitchBlock(token);
            this.endSwitchStmt(token, false);
            return null;
        }
        this.endSwitchBlock(token);
        this.endSwitchStmt(token, true);
        return token;
    }

    public final LocatableToken parseSwitchStatement(LocatableToken token) {
        this.beginSwitchStmt(token, false);
        token = this.nextToken();
        if (token.getType() != 96) {
            this.error("Expected '(' after 'switch'");
            this.tokenStream.pushBack(token);
            this.endSwitchStmt(token, false);
            return null;
        }
        this.parseExpression();
        token = this.nextToken();
        if (token.getType() != 97) {
            this.error("Expected ')' at end of expression (in 'switch(...)')");
            this.tokenStream.pushBack(token);
            this.endSwitchStmt(token, false);
            return null;
        }
        token = this.tokenStream.nextToken();
        if (token.getType() != 99) {
            this.error("Expected '{' after 'switch(...)'");
            this.tokenStream.pushBack(token);
            this.endSwitchStmt(token, false);
            return null;
        }
        this.beginSwitchBlock(token);
        this.parseStmtBlock();
        token = this.nextToken();
        if (token.getType() != 100) {
            this.error("Missing '}' at end of 'switch' statement block");
            this.tokenStream.pushBack(token);
            this.endSwitchBlock(token);
            this.endSwitchStmt(token, false);
            return null;
        }
        this.endSwitchBlock(token);
        this.endSwitchStmt(token, true);
        return token;
    }

    public final LocatableToken parseDoWhileStatement(LocatableToken token) {
        this.beginDoWhile(token);
        token = this.nextToken();
        LocatableToken ntoken = this.parseStatement(token, false);
        if (ntoken != null || token != this.tokenStream.LA(1)) {
            this.beginDoWhileBody(token);
            if (ntoken == null) {
                this.endDoWhileBody(this.tokenStream.LA(1), false);
            } else {
                this.endDoWhileBody(ntoken, true);
            }
        }
        if ((token = this.nextToken()).getType() != 113) {
            this.error("Expecting 'while' after statement block (in 'do ... while')");
            this.tokenStream.pushBack(token);
            this.endDoWhile(token, false);
            return null;
        }
        token = this.nextToken();
        if (token.getType() != 96) {
            this.error("Expecting '(' after 'while'");
            this.tokenStream.pushBack(token);
            this.endDoWhile(token, false);
            return null;
        }
        this.parseExpression();
        token = this.nextToken();
        if (token.getType() != 97) {
            this.error("Expecting ')' after conditional expression (in 'while' statement)");
            this.tokenStream.pushBack(token);
            this.endDoWhile(token, false);
            return null;
        }
        token = this.nextToken();
        this.endDoWhile(token, true);
        return token;
    }

    public final LocatableToken parseWhileStatement(LocatableToken token) {
        this.beginWhileLoop(token);
        token = this.nextToken();
        if (token.getType() != 96) {
            this.error("Expecting '(' after 'while'");
            this.tokenStream.pushBack(token);
            this.endWhileLoop(token, false);
            return null;
        }
        this.parseExpression();
        token = this.nextToken();
        if (token.getType() != 97) {
            this.error("Expecting ')' after conditional expression (in 'while' statement)");
            this.tokenStream.pushBack(token);
            this.endWhileLoop(token, false);
            return null;
        }
        token = this.nextToken();
        this.beginWhileLoopBody(token);
        token = this.parseStatement(token, false);
        if (token != null) {
            this.endWhileLoopBody(token, true);
            this.endWhileLoop(token, true);
        } else {
            token = this.tokenStream.LA(1);
            this.endWhileLoopBody(token, false);
            this.endWhileLoop(token, false);
            token = null;
        }
        return token;
    }

    public final LocatableToken parseForStatement(LocatableToken forToken) {
        this.beginForLoop(forToken);
        LocatableToken token = this.nextToken();
        if (token.getType() != 96) {
            this.error("Expecting '(' after 'for'");
            this.tokenStream.pushBack(token);
            this.endForLoop(token, false);
            return null;
        }
        if (this.tokenStream.LA(1).getType() != 63) {
            LinkedList<LocatableToken> tlist = new LinkedList<LocatableToken>();
            LocatableToken first = this.tokenStream.LA(1);
            boolean isTypeSpec = false;
            if (JavaParser.isModifier(this.tokenStream.LA(1))) {
                this.parseModifiers();
                isTypeSpec = true;
                this.parseTypeSpec(false, true, tlist);
            } else {
                isTypeSpec = this.parseTypeSpec(true, true, tlist);
            }
            if (isTypeSpec && this.tokenStream.LA(1).getType() == 69) {
                this.beginForInitDecl(first);
                this.gotTypeSpec(tlist);
                LocatableToken idToken = this.nextToken();
                this.gotForInit(first, idToken);
                this.parseArrayDeclarators();
                token = this.nextToken();
                if (token.getType() == 110) {
                    this.determinedForLoop(true, false);
                    this.endForInit(idToken, true);
                    this.endForInitDecls(idToken, true);
                    this.modifiersConsumed();
                    this.parseExpression();
                    token = this.nextToken();
                    if (token.getType() != 97) {
                        this.error("Expecting ')' (in for statement)");
                        this.tokenStream.pushBack(token);
                        this.endForLoop(token, false);
                        return null;
                    }
                    token = this.nextToken();
                    this.beginForLoopBody(token);
                    token = this.parseStatement(token, false);
                    this.endForLoopBody(token);
                    this.endForLoop(token);
                    return token;
                }
                this.determinedForLoop(false, token.getType() == 98);
                if (token.getType() == 98) {
                    this.parseExpression();
                } else {
                    this.tokenStream.pushBack(token);
                }
                if (this.parseSubsequentDeclarations(0, true) == null) {
                    this.endForLoop(this.tokenStream.LA(1), false);
                    this.modifiersConsumed();
                    return null;
                }
                this.modifiersConsumed();
            } else {
                this.pushBackAll(tlist);
                token = this.nextToken();
                this.parseStatement(token, true);
            }
        } else {
            token = this.nextToken();
        }
        boolean semiFollows = this.tokenStream.LA(1).getType() == 63;
        this.gotForTest(!semiFollows);
        if (!semiFollows) {
            this.parseExpression();
        }
        if ((token = this.nextToken()).getType() != 63) {
            this.tokenStream.pushBack(token);
            if (token.getType() == 74) {
                this.error("BJ003", token);
            } else {
                this.error("BJ003");
            }
            this.endForLoop(token, false);
            return null;
        }
        boolean bracketFollows = this.tokenStream.LA(1).getType() == 97;
        this.gotForIncrement(!bracketFollows);
        if (!bracketFollows) {
            this.parseExpression();
            while (this.tokenStream.LA(1).getType() == 74) {
                this.nextToken();
                this.parseExpression();
            }
        }
        if ((token = this.nextToken()).getType() != 97) {
            this.error("Expecting ')' (or ',') after 'for(...'");
            this.tokenStream.pushBack(token);
            this.endForLoop(token, false);
            return null;
        }
        token = this.nextToken();
        if (token.getType() == 100 || token.getType() == 1) {
            this.error("Expecting statement after 'for(...)'");
            this.tokenStream.pushBack(token);
            this.endForLoop(token, false);
            return null;
        }
        this.beginForLoopBody(token);
        token = this.parseStatement(token, false);
        this.endForLoopBody(token);
        this.endForLoop(token);
        return token;
    }

    private void endForLoop(LocatableToken token) {
        if (token == null) {
            this.endForLoop(this.tokenStream.LA(1), false);
        } else {
            this.endForLoop(token, true);
        }
    }

    private void endForLoopBody(LocatableToken token) {
        if (token == null) {
            this.endForLoopBody(this.tokenStream.LA(1), false);
        } else {
            this.endForLoopBody(token, true);
        }
    }

    public final LocatableToken parseIfStatement(LocatableToken token) {
        block6: {
            this.beginIfStmt(token);
            while (true) {
                if ((token = this.nextToken()).getType() != 96) {
                    this.tokenStream.pushBack(token);
                    if (token.getType() == 99) {
                        this.error("BJ002", token);
                    } else {
                        this.errorBefore("BJ001", token);
                    }
                    this.endIfStmt(token, false);
                    return null;
                }
                this.parseExpression();
                token = this.nextToken();
                if (token.getType() != 97) {
                    this.error("Expecting ')' after conditional expression (in 'if' statement)");
                    this.tokenStream.pushBack(token);
                    if (token.getType() != 99) {
                        this.endIfStmt(token, false);
                        return null;
                    }
                }
                token = this.nextToken();
                this.beginIfCondBlock(token);
                token = this.parseStatement(token, false);
                this.endIfCondBlock(token);
                if (this.tokenStream.LA(1).getType() != 112) break block6;
                this.tokenStream.nextToken();
                if (this.tokenStream.LA(1).getType() != 111) break;
                this.gotElseIf(token);
                this.nextToken();
            }
            token = this.nextToken();
            this.beginIfCondBlock(token);
            token = this.parseStatement(token, false);
            this.endIfCondBlock(token);
        }
        this.endIfStmt(token);
        return token;
    }

    private void endIfCondBlock(LocatableToken token) {
        if (token != null) {
            this.endIfCondBlock(token, true);
        } else {
            this.endIfCondBlock(this.tokenStream.LA(1), false);
        }
    }

    private void endIfStmt(LocatableToken token) {
        if (token != null) {
            this.endIfStmt(token, true);
        } else {
            this.endIfStmt(this.tokenStream.LA(1), false);
        }
    }

    public final LocatableToken parseVariableDeclarations() {
        LocatableToken first = this.tokenStream.LA(1);
        this.gotDeclBegin(first);
        return this.parseVariableDeclarations(first, true);
    }

    public final LocatableToken parseVariableDeclarations(LocatableToken first, boolean mustEndWithSemi) {
        this.beginVariableDecl(first);
        this.parseModifiers();
        boolean r = this.parseVariableDeclaration(first);
        if (r) {
            return this.parseSubsequentDeclarations(1, mustEndWithSemi);
        }
        this.endVariableDecls(this.tokenStream.LA(1), false);
        return null;
    }

    protected final LocatableToken parseSubsequentDeclarations(int type, boolean mustEndWithSemi) {
        LocatableToken prevToken = this.lastToken;
        LocatableToken token = this.nextToken();
        while (token.getType() == 74) {
            this.endDeclaration(type, token, false);
            LocatableToken first = token;
            token = this.nextToken();
            if (token.getType() != 69) {
                this.endDeclarationStmt(type, token, false);
                this.error("Expecting variable identifier (or change ',' to ';')");
                return null;
            }
            this.parseArrayDeclarators();
            LocatableToken idtoken = token;
            prevToken = this.lastToken;
            token = this.nextToken();
            this.gotSubsequentDecl(type, first, idtoken, token.getType() == 98);
            if (token.getType() != 98) continue;
            this.parseExpression();
            prevToken = this.lastToken;
            token = this.nextToken();
        }
        if (!mustEndWithSemi) {
            this.tokenStream.pushBack(token);
            this.endDeclaration(type, token, false);
            this.endDeclarationStmt(type, token, false);
            return null;
        }
        if (token.getType() != 63) {
            this.tokenStream.pushBack(token);
            this.errorBehind("BJ003", prevToken);
            this.endDeclaration(type, token, false);
            this.endDeclarationStmt(type, token, false);
            return null;
        }
        this.endDeclaration(type, token, true);
        this.endDeclarationStmt(type, token, true);
        return token;
    }

    private void endDeclaration(int type, LocatableToken token, boolean included) {
        if (type == 2) {
            this.endField(token, included);
        } else if (type == 1) {
            this.endVariable(token, included);
        } else {
            this.endForInit(token, included);
        }
    }

    private void endDeclarationStmt(int type, LocatableToken token, boolean included) {
        if (type == 2) {
            this.endFieldDeclarations(token, included);
        } else if (type == 1) {
            this.endVariableDecls(token, included);
        } else {
            this.endForInitDecls(token, included);
        }
    }

    private void gotSubsequentDecl(int type, LocatableToken firstToken, LocatableToken nameToken, boolean inited) {
        if (type == 2) {
            this.gotSubsequentField(firstToken, nameToken, inited);
        } else if (type == 1) {
            this.gotSubsequentVar(firstToken, nameToken, inited);
        } else {
            this.gotSubsequentForInit(firstToken, nameToken, inited);
        }
    }

    private boolean parseVariableDeclaration(LocatableToken first) {
        LinkedList<LocatableToken> typeSpecTokens = new LinkedList<LocatableToken>();
        if (!this.parseTypeSpec(false, true, typeSpecTokens)) {
            return false;
        }
        this.gotTypeSpec(typeSpecTokens);
        LocatableToken token = this.nextToken();
        if (token.getType() != 69) {
            this.error("Expecting identifier (in variable/field declaration)");
            this.tokenStream.pushBack(token);
            return false;
        }
        this.parseArrayDeclarators();
        LocatableToken idToken = token;
        token = this.nextToken();
        this.gotVariableDecl(first, idToken, token.getType() == 98);
        this.modifiersConsumed();
        if (token.getType() == 98) {
            this.parseExpression();
        } else {
            this.tokenStream.pushBack(token);
        }
        return true;
    }

    public final boolean parseTypeSpec(boolean processArray) {
        LinkedList<LocatableToken> tokens = new LinkedList<LocatableToken>();
        boolean rval = this.parseTypeSpec(false, processArray, tokens);
        if (rval) {
            this.gotTypeSpec(tokens);
        }
        return rval;
    }

    public final boolean parseTypeSpec(boolean speculative, boolean processArray, List<LocatableToken> ttokens) {
        LocatableToken token;
        int ttype = this.parseBaseType(speculative, ttokens);
        if (ttype == 2) {
            return false;
        }
        if (ttype == 0) {
            speculative = false;
        } else {
            token = this.nextToken();
            if (token.getType() == 73) {
                ttokens.add(token);
                DepthRef dr = new DepthRef();
                dr.depth = 1;
                if (!this.parseTargs(speculative, ttokens, dr)) {
                    return false;
                }
            } else {
                this.tokenStream.pushBack(token);
            }
        }
        token = this.nextToken();
        if (token.getType() == 68) {
            if (this.tokenStream.LA(1).getType() == 69) {
                ttokens.add(token);
                return this.parseTypeSpec(speculative, true, ttokens);
            }
            this.tokenStream.pushBack(token);
            return true;
        }
        if (processArray) {
            while (token.getType() == 66 && this.tokenStream.LA(1).getType() == 67) {
                ttokens.add(token);
                token = this.nextToken();
                ttokens.add(token);
                token = this.nextToken();
            }
        }
        this.tokenStream.pushBack(token);
        return true;
    }

    private int parseBaseType(boolean speculative, List<LocatableToken> ttokens) {
        LocatableToken token = this.nextToken();
        if (JavaParser.isPrimitiveType(token)) {
            ttokens.add(token);
            return 0;
        }
        if (token.getType() != 69) {
            if (!speculative) {
                this.error("Expected type identifier");
            }
            this.tokenStream.pushBack(token);
            return 2;
        }
        ttokens.addAll(this.parseDottedIdent(token));
        return 1;
    }

    private boolean parseTargs(boolean speculative, List<LocatableToken> ttokens, DepthRef dr) {
        int beginDepth = dr.depth;
        boolean needBaseType = true;
        while (dr.depth >= beginDepth) {
            LocatableToken token;
            if (this.tokenStream.LA(1).getType() == 70) {
                token = this.nextToken();
                ttokens.add(token);
                token = this.nextToken();
                if (token.getType() == 71 || token.getType() == 72) {
                    ttokens.add(token);
                    needBaseType = true;
                } else {
                    this.tokenStream.pushBack(token);
                    needBaseType = false;
                }
            }
            if (needBaseType) {
                boolean r = this.parseTargType(speculative, ttokens, dr);
                if (!r) {
                    return false;
                }
                if (dr.depth < beginDepth) break;
            }
            if ((token = this.nextToken()).getType() == 75 || token.getType() == 76 || token.getType() == 77) {
                ttokens.add(token);
                if (token.getType() == 75) {
                    --dr.depth;
                    continue;
                }
                if (token.getType() == 76) {
                    dr.depth -= 2;
                    continue;
                }
                if (token.getType() != 77) continue;
                dr.depth -= 3;
                continue;
            }
            if (token.getType() == 74) {
                needBaseType = true;
                ttokens.add(token);
                continue;
            }
            if (!speculative) {
                this.error("Expected '>' to close type parameter list");
            }
            this.tokenStream.pushBack(token);
            return false;
        }
        return true;
    }

    private boolean parseTargType(boolean speculative, List<LocatableToken> ttokens, DepthRef dr) {
        LocatableToken token;
        int beginDepth = dr.depth--;
        if (this.tokenStream.LA(1).getType() == 75) {
            ttokens.add(this.tokenStream.nextToken());
            return true;
        }
        int ttype = this.parseBaseType(speculative, ttokens);
        if (ttype == 2) {
            return false;
        }
        if (ttype == 1) {
            if (this.tokenStream.LA(1).getType() == 73) {
                ++dr.depth;
                ttokens.add(this.nextToken());
                if (!this.parseTargs(speculative, ttokens, dr)) {
                    return false;
                }
                if (dr.depth < beginDepth) {
                    return true;
                }
            }
            if ((token = this.nextToken()).getType() == 68 && this.tokenStream.LA(1).getType() == 69) {
                ttokens.add(token);
                return this.parseTargType(speculative, ttokens, dr);
            }
        } else {
            token = this.nextToken();
        }
        while (token.getType() == 66 && this.tokenStream.LA(1).getType() == 67) {
            ttokens.add(token);
            token = this.nextToken();
            ttokens.add(token);
            token = this.nextToken();
        }
        this.tokenStream.pushBack(token);
        return true;
    }

    public final List<LocatableToken> parseDottedIdent(LocatableToken first) {
        LinkedList<LocatableToken> rval = new LinkedList<LocatableToken>();
        rval.add(first);
        LocatableToken token = this.nextToken();
        while (token.getType() == 68) {
            LocatableToken ntoken = this.nextToken();
            if (ntoken.getType() != 69) {
                this.tokenStream.pushBack(ntoken);
                break;
            }
            rval.add(token);
            rval.add(ntoken);
            token = this.nextToken();
        }
        this.tokenStream.pushBack(token);
        return rval;
    }

    public static boolean isOperator(LocatableToken token) {
        int ttype = token.getType();
        return ttype == 147 || ttype == 148 || ttype == 87 || ttype == 149 || ttype == 66 || ttype == 96 || ttype == 126 || ttype == 128 || ttype == 127 || ttype == 129 || ttype == 68 || ttype == 142 || ttype == 141 || ttype == 73 || ttype == 143 || ttype == 75 || ttype == 144 || ttype == 98 || ttype == 153 || ttype == 154 || ttype == 151 || ttype == 152 || ttype == 139 || ttype == 136 || ttype == 104 || ttype == 134 || ttype == 140 || ttype == 135 || ttype == 137 || ttype == 138 || ttype == 146 || ttype == 133 || ttype == 76 || ttype == 131 || ttype == 77 || ttype == 132 || ttype == 150 || ttype == 130 || ttype == 145;
    }

    public final boolean isBinaryOperator(LocatableToken token) {
        int ttype = token.getType();
        return ttype == 147 || ttype == 148 || ttype == 87 || ttype == 149 || ttype == 150 || ttype == 139 || ttype == 140 || ttype == 104 || ttype == 146 || ttype == 76 || ttype == 77 || ttype == 132 || ttype == 131 || ttype == 133 || ttype == 134 || ttype == 135 || ttype == 136 || ttype == 130 || ttype == 129 || ttype == 128 || ttype == 127 || ttype == 126 || ttype == 98 || ttype == 68 || ttype == 142 || ttype == 141 || ttype == 73 || ttype == 143 || ttype == 75 || ttype == 144 || ttype == 138 || ttype == 137;
    }

    public final boolean isUnaryOperator(LocatableToken token) {
        int ttype = token.getType();
        return ttype == 147 || ttype == 148 || ttype == 154 || ttype == 153 || ttype == 151 || ttype == 152;
    }

    public final void parseAnnotation() {
        LocatableToken token = this.nextToken();
        List<LocatableToken> annName = this.parseDottedIdent(token);
        boolean paramsFollow = this.tokenStream.LA(1).getType() == 96;
        this.gotAnnotation(annName, paramsFollow);
        if (paramsFollow) {
            token = this.tokenStream.nextToken();
            this.parseArgumentList(token);
        }
    }

    private boolean isExpressionTokenType(int ttype) {
        return expressionTokenIndexes[ttype] != 0;
    }

    private void parseLambdaBody() {
        boolean blockFollows = this.tokenStream.LA(1).getType() == 99;
        this.beginLambdaBody(blockFollows, blockFollows ? this.tokenStream.LA(1) : null);
        if (blockFollows) {
            this.beginStmtblockBody(this.nextToken());
            this.parseStmtBlock();
            LocatableToken token = this.nextToken();
            if (token.getType() != 100) {
                this.error("Expecting '}' at end of lambda block");
                this.tokenStream.pushBack(token);
                this.endStmtblockBody(token, false);
                this.endLambdaBody(token);
            } else {
                this.endStmtblockBody(token, true);
                this.endLambdaBody(token);
            }
        } else {
            this.parseExpression(true, true);
            this.endLambdaBody(null);
        }
    }

    public final void parseExpression() {
        this.parseExpression(false, true);
    }

    private final void parseExpression(boolean isLambdaBody, boolean lambdaAllowed) {
        LocatableToken token = this.nextToken();
        this.beginExpression(token, isLambdaBody);
        block18: while (true) {
            int index = expressionTokenIndexes[token.getType()];
            switch (index) {
                case 1: {
                    if (this.tokenStream.LA(1).getType() == 1) {
                        this.gotIdentifierEOF(token);
                        this.endExpression(this.tokenStream.LA(1), true);
                        return;
                    }
                    this.parseNewExpression(token);
                    break;
                }
                case 2: {
                    do {
                        if (this.tokenStream.LA(1).getType() == 100) {
                            token = this.nextToken();
                            break;
                        }
                        this.parseExpression();
                    } while ((token = this.nextToken()).getType() == 74);
                    if (token.getType() == 100) break;
                    this.errorBefore("Expected '}' at end of initialiser list expression", token);
                    this.tokenStream.pushBack(token);
                    break;
                }
                case 3: {
                    if (this.tokenStream.LA(1).getType() == 96) {
                        this.gotMethodCall(token);
                        this.parseArgumentList(this.nextToken());
                        break;
                    }
                    if (this.tokenStream.LA(1).getType() == 172 && lambdaAllowed) {
                        this.nextToken();
                        this.parseLambdaBody();
                        break;
                    }
                    if (this.tokenStream.LA(1).getType() == 68 && this.tokenStream.LA(2).getType() == 69 && this.tokenStream.LA(3).getType() != 96) {
                        this.gotCompoundIdent(token);
                        this.nextToken();
                        token = this.tokenStream.nextToken();
                        while (this.tokenStream.LA(1).getType() == 68 && this.tokenStream.LA(2).getType() == 69 && this.tokenStream.LA(3).getType() != 96 && this.tokenStream.LA(3).getType() != 1) {
                            this.gotCompoundComponent(token);
                            this.nextToken();
                            token = this.tokenStream.nextToken();
                        }
                        if (this.tokenStream.LA(1).getType() == 68) {
                            LocatableToken dotToken = this.nextToken();
                            LocatableToken ntoken = this.nextToken();
                            if (ntoken.getType() == 101) {
                                this.completeCompoundClass(token);
                                this.gotClassLiteral(ntoken);
                                break;
                            }
                            if (ntoken.getType() == 107) {
                                this.completeCompoundClass(token);
                                break;
                            }
                            if (ntoken.getType() == 72) {
                                this.completeCompoundClass(token);
                                break;
                            }
                            this.completeCompoundValue(token);
                            this.tokenStream.pushBack(ntoken);
                            this.tokenStream.pushBack(dotToken);
                            break;
                        }
                        if (this.tokenStream.LA(1).getType() == 1) {
                            this.completeCompoundValueEOF(token);
                            break;
                        }
                        if (this.tokenStream.LA(1).getType() == 66 && this.tokenStream.LA(2).getType() == 67) {
                            this.completeCompoundClass(token);
                            this.parseArrayDeclarators();
                            if (this.tokenStream.LA(1).getType() == 68 && this.tokenStream.LA(2).getType() == 101) {
                                token = this.nextToken();
                                token = this.nextToken();
                                this.gotClassLiteral(token);
                            } else {
                                this.error("Expecting \".class\"");
                            }
                        }
                        this.completeCompoundValue(token);
                        break;
                    }
                    if (this.tokenStream.LA(1).getType() == 68) {
                        this.gotParentIdentifier(token);
                        if (this.tokenStream.LA(2).getType() != 101) break;
                        token = this.nextToken();
                        token = this.nextToken();
                        this.gotClassLiteral(token);
                        break;
                    }
                    if (this.tokenStream.LA(1).getType() == 66 && this.tokenStream.LA(2).getType() == 67) {
                        this.gotArrayTypeIdentifier(token);
                        this.parseArrayDeclarators();
                        if (this.tokenStream.LA(1).getType() == 68 && this.tokenStream.LA(2).getType() == 101) {
                            token = this.nextToken();
                            token = this.nextToken();
                            this.gotClassLiteral(token);
                            break;
                        }
                        this.error("Expecting \".class\"");
                        break;
                    }
                    if (this.tokenStream.LA(1).getType() == 1) {
                        this.gotIdentifierEOF(token);
                        break;
                    }
                    this.gotIdentifier(token);
                    break;
                }
                case 4: 
                case 5: {
                    if (this.tokenStream.LA(1).getType() == 96) {
                        this.gotConstructorCall(token);
                        this.parseArgumentList(this.nextToken());
                        break;
                    }
                    this.gotLiteral(token);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    this.gotLiteral(token);
                    break;
                }
                case 15: {
                    boolean isCast;
                    boolean isPrimitive = JavaParser.isPrimitiveType(this.tokenStream.LA(1));
                    LinkedList<LocatableToken> tlist = new LinkedList<LocatableToken>();
                    boolean isTypeSpec = this.parseTypeSpec(true, true, tlist);
                    int tt2 = this.tokenStream.LA(2).getType();
                    boolean bl = isCast = isTypeSpec && this.tokenStream.LA(1).getType() == 97 && tt2 != 172;
                    if (tt2 != 96) {
                        isCast &= !JavaParser.isOperator(this.tokenStream.LA(2)) || isPrimitive && this.isUnaryOperator(this.tokenStream.LA(2));
                        isCast &= tt2 != 63 && tt2 != 97 && tt2 != 100 && tt2 != 1;
                        isCast &= tt2 != 74 && tt2 != 110 && tt2 != 67;
                        isCast &= tt2 != 70;
                    }
                    if (isCast) {
                        this.gotTypeCast(tlist);
                        token = this.nextToken();
                        token = this.nextToken();
                        continue block18;
                    }
                    boolean isLambda = false;
                    if (isTypeSpec) {
                        if (this.tokenStream.LA(1).getType() == 97 && tt2 == 172) {
                            isLambda = true;
                        }
                        if (!isLambda && this.tokenStream.LA(1).getType() == 69) {
                            isLambda = true;
                        }
                        if (!isLambda && this.tokenStream.LA(1).getType() == 109) {
                            isLambda = true;
                        }
                    }
                    this.pushBackAll(tlist);
                    int tt1 = this.tokenStream.LA(1).getType();
                    tt2 = this.tokenStream.LA(2).getType();
                    if (!isLambda) {
                        if (tt1 == 97 && tt2 == 172) {
                            isLambda = true;
                        } else if (JavaParser.isModifier(this.tokenStream.LA(1))) {
                            isLambda = true;
                        } else if (tt1 == 69 && tt2 == 74) {
                            isLambda = true;
                        }
                    }
                    if (isLambda && lambdaAllowed) {
                        this.parseLambdaParameterList();
                        token = this.nextToken();
                        if (token.getType() == 97) {
                            token = this.nextToken();
                        }
                        if (token.getType() != 172) {
                            this.error("Lambda identifier misplaced or not found");
                            this.endExpression(token, false);
                            return;
                        }
                        this.parseLambdaBody();
                        break;
                    }
                    this.parseExpression();
                    token = this.nextToken();
                    if (token.getType() == 97) break;
                    this.tokenStream.pushBack(token);
                    this.error("Unmatched '(' in expression; expecting ')'");
                    this.endExpression(token, false);
                    return;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    this.gotPrimitiveTypeLiteral(token);
                    this.parseArrayDeclarators();
                    if (this.tokenStream.LA(1).getType() == 68 && this.tokenStream.LA(2).getType() == 101) {
                        token = this.nextToken();
                        token = this.nextToken();
                        this.gotClassLiteral(token);
                        break;
                    }
                    this.error("Expecting \".class\"");
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    this.gotUnaryOperator(token);
                    token = this.nextToken();
                    continue block18;
                }
                case 31: {
                    this.parseSwitchExpression(token);
                    token = this.nextToken();
                    continue block18;
                }
                default: {
                    this.tokenStream.pushBack(token);
                    this.error("Invalid expression token: " + token.getText());
                    this.endExpression(token, true);
                    return;
                }
            }
            block21: while (true) {
                token = this.tokenStream.nextToken();
                switch (expressionOpIndexes[token.getType()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.tokenStream.pushBack(token);
                        this.endExpression(token, false);
                        return;
                    }
                    case 8: {
                        if (this.tokenStream.LA(1).getType() == 67) {
                            token = this.nextToken();
                            continue block21;
                        }
                        this.parseExpression();
                        token = this.nextToken();
                        if (token.getType() != 67) {
                            this.error("Expected ']' after array subscript expression");
                            this.tokenStream.pushBack(token);
                        }
                        this.gotArrayElementAccess();
                        continue block21;
                    }
                    case 9: {
                        this.gotInstanceOfOperator(token);
                        this.parseTypeSpec(true);
                        if (this.tokenStream.LA(1).getType() != 69) continue block21;
                        token = this.nextToken();
                        this.gotInstanceOfVar(token);
                        continue block21;
                    }
                    case 10: {
                        String tokText;
                        LocatableToken opToken = token;
                        token = this.nextToken();
                        if (token.getType() == 1) {
                            this.gotDotEOF(opToken);
                            continue block18;
                        }
                        LocatableToken la1 = this.tokenStream.LA(1);
                        if (la1.getType() == 1 && la1.getColumn() == token.getEndColumn() && la1.getLine() == token.getEndLine() && (tokText = token.getText()) != null && tokText.length() > 0 && Character.isJavaIdentifierStart(tokText.charAt(0))) {
                            this.gotMemberAccessEOF(token);
                            continue block21;
                        }
                        if (token.getType() == 101) continue block21;
                        if (token.getType() == 69) {
                            if (this.tokenStream.LA(1).getType() == 96) {
                                this.gotMemberCall(token, Collections.emptyList());
                                this.parseArgumentList(this.nextToken());
                                continue block21;
                            }
                            this.gotMemberAccess(token);
                            continue block21;
                        }
                        if (token.getType() == 73) {
                            DepthRef dr = new DepthRef();
                            LinkedList<LocatableToken> ttokens = new LinkedList<LocatableToken>();
                            ttokens.add(token);
                            dr.depth = 1;
                            if (!this.parseTargs(false, ttokens, dr)) continue block21;
                            token = this.nextToken();
                            if (token.getType() != 69) {
                                this.error("Expecting method name (in call to generic method)");
                                continue block21;
                            }
                            this.gotMemberCall(token, ttokens);
                            token = this.nextToken();
                            if (token.getType() != 96) {
                                this.error("Expecting '(' after method name");
                                continue block21;
                            }
                            this.parseArgumentList(token);
                            continue block21;
                        }
                        this.gotBinaryOperator(opToken);
                        continue block18;
                    }
                    case 11: {
                        if (token.getType() == 173 && this.tokenStream.LA(1).getType() == 158) {
                            this.nextToken();
                            continue block21;
                        }
                        this.gotBinaryOperator(token);
                        token = this.nextToken();
                        continue block18;
                    }
                }
                if (token.getType() != 151 && token.getType() != 152) break;
                this.gotPostOperator(token);
            }
            if (token.getType() != 70) break;
            this.gotQuestionOperator(token);
            this.parseExpression();
            token = this.nextToken();
            if (token.getType() != 110) {
                this.error("Expecting ':' (in ?: operator)");
                this.tokenStream.pushBack(token);
                this.endExpression(token, true);
                return;
            }
            this.gotQuestionColon(token);
            token = this.nextToken();
        }
        this.tokenStream.pushBack(token);
        this.endExpression(token, false);
    }

    public final LocatableToken parseArrayInitializerList(LocatableToken token) {
        do {
            if (this.tokenStream.LA(1).getType() == 100) {
                token = this.nextToken();
                break;
            }
            this.parseExpression();
        } while ((token = this.nextToken()).getType() == 74);
        if (token.getType() != 100) {
            this.errorBefore("Expected '}' at end of initialiser list expression", token);
            this.tokenStream.pushBack(token);
        }
        return token;
    }

    public final void parseNewExpression(LocatableToken token) {
        this.gotExprNew(token);
        token = this.nextToken();
        if (token.getType() != 69 && !JavaParser.isPrimitiveType(token)) {
            this.tokenStream.pushBack(token);
            this.error("Expected type identifier after \"new\" (in expression)");
            this.endExprNew(token, false);
            return;
        }
        this.tokenStream.pushBack(token);
        this.parseTypeSpec(false);
        token = this.nextToken();
        if (token.getType() == 66) {
            while (true) {
                boolean withDimension = false;
                if (this.tokenStream.LA(1).getType() != 67) {
                    withDimension = true;
                    this.parseExpression();
                }
                if ((token = this.nextToken()).getType() != 67) {
                    this.tokenStream.pushBack(token);
                    this.errorBefore("Expecting ']' after array dimension (in new ... expression)", token);
                    this.endExprNew(token, false);
                    return;
                }
                this.gotNewArrayDeclarator(withDimension);
                if (this.tokenStream.LA(1).getType() != 66) break;
                token = this.nextToken();
            }
            if (this.tokenStream.LA(1).getType() == 99) {
                token = this.nextToken();
                this.beginArrayInitList(token);
                token = this.parseArrayInitializerList(token);
                this.endArrayInitList(token);
                this.endExprNew(token, token.getType() == 100);
                return;
            }
            this.endExprNew(token, true);
            return;
        }
        if (token.getType() != 96) {
            this.tokenStream.pushBack(token);
            this.error("Expected '(' or '[' after type name (in 'new ...' expression)");
            this.endExprNew(token, false);
            return;
        }
        this.parseArgumentList(token);
        if (this.tokenStream.LA(1).getType() == 99) {
            token = this.nextToken();
            this.beginAnonClassBody(token, false);
            this.parseClassBody();
            token = this.nextToken();
            if (token.getType() != 100) {
                this.error("Expected '}' at end of inner class body");
                this.tokenStream.pushBack(token);
                this.tokenStream.pushBack(token);
                this.endAnonClassBody(token, false);
                this.endExprNew(token, false);
                return;
            }
            this.endAnonClassBody(token, true);
        }
        this.endExprNew(token, true);
    }

    public final void parseArgumentList(LocatableToken token) {
        this.beginArgumentList(token);
        token = this.nextToken();
        if (token.getType() != 97) {
            this.tokenStream.pushBack(token);
            do {
                this.parseExpression();
                token = this.nextToken();
                this.endArgument();
            } while (token.getType() == 74);
            if (token.getType() != 97) {
                this.errorBefore("Expecting ',' or ')' (in argument list)", token);
                this.tokenStream.pushBack(token);
            }
        }
        this.endArgumentList(token);
    }

    public final void parseLambdaParameterList() {
        LocatableToken token = this.nextToken();
        while (token.getType() != 97 && token.getType() != 100) {
            this.tokenStream.pushBack(token);
            this.gotLambdaFormalParam();
            List<LocatableToken> rval = this.parseModifiers();
            int tt1 = this.tokenStream.LA(1).getType();
            int tt2 = this.tokenStream.LA(2).getType();
            if (tt1 == 69 && (tt2 == 74 || tt2 == 97)) {
                token = this.nextToken();
                this.gotLambdaFormalName(token);
                token = this.nextToken();
            } else {
                if (!this.parseTypeSpec(false, true, rval)) {
                    this.modifiersConsumed();
                    this.error("Formal lambda parameter specified incorrectly");
                    return;
                }
                this.gotLambdaFormalType(rval);
                token = this.nextToken();
                if (token.getType() == 109) {
                    token = this.nextToken();
                }
                if (token.getType() != 69) {
                    this.modifiersConsumed();
                    this.error("Formal lambda parameter lacks a name");
                    return;
                }
                this.gotLambdaFormalName(token);
                this.parseArrayDeclarators();
                token = this.nextToken();
            }
            this.modifiersConsumed();
            if (token.getType() != 74) break;
            token = this.nextToken();
        }
        this.tokenStream.pushBack(token);
    }

    public final void parseParameterList(boolean areRecordParameters) {
        LocatableToken token = this.nextToken();
        while (token.getType() != 97 && token.getType() != 100) {
            this.tokenStream.pushBack(token);
            LocatableToken first = token;
            this.beginFormalParameter(token);
            this.parseModifiers();
            this.parseTypeSpec(true);
            LocatableToken idToken = this.nextToken();
            LocatableToken varargsToken = null;
            if (idToken.getType() == 109) {
                varargsToken = idToken;
                idToken = this.nextToken();
            }
            if (idToken.getType() != 69) {
                this.error("Expected parameter identifier (in method/record parameter)");
                this.tokenStream.pushBack(idToken);
                return;
            }
            this.parseArrayDeclarators();
            if (areRecordParameters) {
                this.gotRecordParameter(first, idToken, varargsToken);
            } else {
                this.gotMethodParameter(idToken, varargsToken);
            }
            this.modifiersConsumed();
            token = this.nextToken();
            if (token.getType() != 74) break;
            token = this.nextToken();
        }
        this.tokenStream.pushBack(token);
    }

    private void pushBackAll(List<LocatableToken> tokens) {
        ListIterator<LocatableToken> i = tokens.listIterator(tokens.size());
        while (i.hasPrevious()) {
            this.tokenStream.pushBack(i.previous());
        }
    }

    static {
        JavaParser.statementTokenIndexes[63] = 1;
        JavaParser.statementTokenIndexes[117] = 2;
        JavaParser.statementTokenIndexes[121] = 3;
        JavaParser.statementTokenIndexes[113] = 4;
        JavaParser.statementTokenIndexes[111] = 5;
        JavaParser.statementTokenIndexes[114] = 6;
        JavaParser.statementTokenIndexes[120] = 7;
        JavaParser.statementTokenIndexes[118] = 8;
        JavaParser.statementTokenIndexes[122] = 9;
        JavaParser.statementTokenIndexes[105] = 10;
        JavaParser.statementTokenIndexes[116] = 11;
        JavaParser.statementTokenIndexes[115] = 12;
        JavaParser.statementTokenIndexes[119] = 13;
        JavaParser.statementTokenIndexes[123] = 14;
        JavaParser.statementTokenIndexes[69] = 15;
        JavaParser.statementTokenIndexes[93] = 16;
        JavaParser.statementTokenIndexes[174] = 116;
        JavaParser.statementTokenIndexes[89] = 17;
        JavaParser.statementTokenIndexes[88] = 18;
        JavaParser.statementTokenIndexes[90] = 19;
        JavaParser.statementTokenIndexes[40] = 20;
        JavaParser.statementTokenIndexes[39] = 21;
        JavaParser.statementTokenIndexes[65] = 22;
        JavaParser.statementTokenIndexes[94] = 23;
        JavaParser.statementTokenIndexes[92] = 24;
        JavaParser.statementTokenIndexes[41] = 25;
        JavaParser.statementTokenIndexes[91] = 26;
        JavaParser.statementTokenIndexes[95] = 27;
        JavaParser.statementTokenIndexes[101] = 28;
        JavaParser.statementTokenIndexes[103] = 29;
        JavaParser.statementTokenIndexes[102] = 30;
        JavaParser.statementTokenIndexes[78] = 31;
        JavaParser.statementTokenIndexes[79] = 32;
        JavaParser.statementTokenIndexes[80] = 33;
        JavaParser.statementTokenIndexes[81] = 34;
        JavaParser.statementTokenIndexes[82] = 35;
        JavaParser.statementTokenIndexes[83] = 36;
        JavaParser.statementTokenIndexes[85] = 37;
        JavaParser.statementTokenIndexes[84] = 38;
        JavaParser.statementTokenIndexes[86] = 39;
        JavaParser.statementTokenIndexes[99] = 40;
        expressionTokenIndexes = new int[181];
        JavaParser.expressionTokenIndexes[158] = 1;
        JavaParser.expressionTokenIndexes[99] = 2;
        JavaParser.expressionTokenIndexes[69] = 3;
        JavaParser.expressionTokenIndexes[107] = 4;
        JavaParser.expressionTokenIndexes[72] = 5;
        JavaParser.expressionTokenIndexes[161] = 6;
        JavaParser.expressionTokenIndexes[160] = 7;
        JavaParser.expressionTokenIndexes[159] = 8;
        JavaParser.expressionTokenIndexes[163] = 9;
        JavaParser.expressionTokenIndexes[164] = 10;
        JavaParser.expressionTokenIndexes[162] = 11;
        JavaParser.expressionTokenIndexes[157] = 12;
        JavaParser.expressionTokenIndexes[155] = 13;
        JavaParser.expressionTokenIndexes[156] = 14;
        JavaParser.expressionTokenIndexes[96] = 15;
        JavaParser.expressionTokenIndexes[78] = 16;
        JavaParser.expressionTokenIndexes[79] = 17;
        JavaParser.expressionTokenIndexes[80] = 18;
        JavaParser.expressionTokenIndexes[81] = 19;
        JavaParser.expressionTokenIndexes[82] = 20;
        JavaParser.expressionTokenIndexes[83] = 21;
        JavaParser.expressionTokenIndexes[85] = 22;
        JavaParser.expressionTokenIndexes[84] = 23;
        JavaParser.expressionTokenIndexes[86] = 24;
        JavaParser.expressionTokenIndexes[147] = 25;
        JavaParser.expressionTokenIndexes[148] = 26;
        JavaParser.expressionTokenIndexes[154] = 27;
        JavaParser.expressionTokenIndexes[153] = 28;
        JavaParser.expressionTokenIndexes[151] = 29;
        JavaParser.expressionTokenIndexes[152] = 30;
        JavaParser.expressionTokenIndexes[118] = 31;
        expressionOpIndexes = new int[181];
        JavaParser.expressionOpIndexes[97] = 1;
        JavaParser.expressionOpIndexes[63] = 2;
        JavaParser.expressionOpIndexes[67] = 3;
        JavaParser.expressionOpIndexes[74] = 4;
        JavaParser.expressionOpIndexes[110] = 5;
        JavaParser.expressionOpIndexes[1] = 6;
        JavaParser.expressionOpIndexes[100] = 7;
        JavaParser.expressionOpIndexes[66] = 8;
        JavaParser.expressionOpIndexes[145] = 9;
        JavaParser.expressionOpIndexes[68] = 10;
        JavaParser.expressionOpIndexes[147] = 11;
        JavaParser.expressionOpIndexes[148] = 11;
        JavaParser.expressionOpIndexes[87] = 11;
        JavaParser.expressionOpIndexes[149] = 11;
        JavaParser.expressionOpIndexes[150] = 11;
        JavaParser.expressionOpIndexes[139] = 11;
        JavaParser.expressionOpIndexes[140] = 11;
        JavaParser.expressionOpIndexes[104] = 11;
        JavaParser.expressionOpIndexes[146] = 11;
        JavaParser.expressionOpIndexes[76] = 11;
        JavaParser.expressionOpIndexes[77] = 11;
        JavaParser.expressionOpIndexes[132] = 11;
        JavaParser.expressionOpIndexes[131] = 11;
        JavaParser.expressionOpIndexes[133] = 11;
        JavaParser.expressionOpIndexes[134] = 11;
        JavaParser.expressionOpIndexes[135] = 11;
        JavaParser.expressionOpIndexes[136] = 11;
        JavaParser.expressionOpIndexes[130] = 11;
        JavaParser.expressionOpIndexes[129] = 11;
        JavaParser.expressionOpIndexes[128] = 11;
        JavaParser.expressionOpIndexes[127] = 11;
        JavaParser.expressionOpIndexes[126] = 11;
        JavaParser.expressionOpIndexes[98] = 11;
        JavaParser.expressionOpIndexes[142] = 11;
        JavaParser.expressionOpIndexes[141] = 11;
        JavaParser.expressionOpIndexes[73] = 11;
        JavaParser.expressionOpIndexes[143] = 11;
        JavaParser.expressionOpIndexes[75] = 11;
        JavaParser.expressionOpIndexes[144] = 11;
        JavaParser.expressionOpIndexes[138] = 11;
        JavaParser.expressionOpIndexes[137] = 11;
        JavaParser.expressionOpIndexes[173] = 11;
    }

    private class DepthRef {
        int depth;

        private DepthRef() {
        }
    }
}

