/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettingsController;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.TeamAction;
import bluej.pkgmgr.Import;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FXWorker;
import bluej.utility.FileUtility;
import bluej.utility.javafx.FXPlatformConsumer;
import java.io.File;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class CheckoutAction
extends TeamAction {
    public CheckoutAction() {
        super("team.checkout", true);
    }

    @Override
    public void actionPerformed(PkgMgrFrame oldFrame) {
        TeamSettingsController tsc = new TeamSettingsController(new File(".").getAbsoluteFile());
        if (tsc.getTeamSettingsDialog().showAndWait().isPresent()) {
            Repository repository = tsc.trytoEstablishRepository(true);
            if (repository == null) {
                return;
            }
            FXPlatformConsumer<File> finishCheckout = projectDir -> {
                PkgMgrFrame newFrame;
                if (oldFrame.isEmptyFrame()) {
                    newFrame = oldFrame;
                } else {
                    newFrame = PkgMgrFrame.createFrame();
                    newFrame.setVisible(true);
                }
                new CheckoutWorker(newFrame, repository, (File)projectDir, tsc).start();
            };
            File projectDir2 = FileUtility.getSaveProjectFX(oldFrame.getProject(), (Window)oldFrame.getWindow(), Config.getString("team.checkout.DVCS.filechooser.title"));
            if (projectDir2 == null) {
                return;
            }
            if (Package.isPackage(projectDir2)) {
                Debug.message("Attempted to checkout a project into an existing project: " + projectDir2);
                DialogManager.showErrorFX(null, "team-cannot-import-into-existing-project");
                return;
            }
            finishCheckout.accept(projectDir2);
        }
    }

    private class CheckoutWorker
    extends FXWorker {
        private Repository repository;
        private PkgMgrFrame newFrame;
        private File projDir;
        private TeamSettingsController tsc;
        private TeamworkCommandResult response;
        private boolean failed = true;

        public CheckoutWorker(PkgMgrFrame newFrame, Repository repository, File projDir, TeamSettingsController tsc) {
            this.newFrame = newFrame;
            this.repository = repository;
            this.projDir = projDir;
            this.tsc = tsc;
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.newFrame.setStatus(Config.getString("team.checkingout"));
            this.newFrame.startProgress();
            TeamworkCommand checkoutCmd = this.repository.checkout(this.projDir);
            this.response = checkoutCmd.getResult();
            this.failed = this.response.isError();
            this.newFrame.stopProgress();
            if (!this.failed) {
                this.newFrame.setStatus(Config.getString("team.checkedout"));
            }
            this.newFrame.stopProgress();
            return this.response;
        }

        @Override
        public void finished() {
            if (!this.failed) {
                if (!Project.isProject(this.projDir.toString())) {
                    if (!Import.convertNonBlueJ(this.newFrame::getWindow, this.projDir)) {
                        this.cleanup();
                        return;
                    }
                }
                Project project = Project.openProject(this.projDir.toString());
                project.setTeamSettingsController(this.tsc);
                Package initialPackage = project.getPackage(project.getInitialPackageName());
                this.newFrame.openPackage(initialPackage, this.newFrame);
            } else {
                TeamUtils.handleServerResponseFX(this.response, (Window)this.newFrame.getWindow());
                this.cleanup();
            }
        }

        public void cleanup() {
            this.deleteDirectory(this.projDir);
            this.projDir.delete();
            this.newFrame.doClose(true, false);
        }

        private void deleteDirectory(File dir) {
            if (dir != null && dir.listFiles() != null) {
                for (File f : dir.listFiles()) {
                    if (f.isDirectory()) {
                        this.deleteDirectory(f);
                    }
                    f.delete();
                }
            }
        }

        @Override
        public void abort() {
        }
    }
}

