/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.stride;

import bluej.Config;
import bluej.collect.StrideEditReason;
import bluej.editor.stride.FXTabbedEditor;
import bluej.editor.stride.FrameEditorTab;
import bluej.editor.stride.FrameSelection;
import bluej.stride.framedjava.ast.Loader;
import bluej.stride.framedjava.elements.CodeElement;
import bluej.stride.framedjava.frames.CodeFrame;
import bluej.stride.framedjava.frames.StrideCategory;
import bluej.stride.generic.CanvasParent;
import bluej.stride.generic.ExtensionDescription;
import bluej.stride.generic.Frame;
import bluej.stride.generic.FrameCursor;
import bluej.stride.generic.FrameDictionary;
import bluej.stride.generic.FrameFactory;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import bluej.utility.javafx.FXBiConsumer;
import bluej.utility.javafx.FXPlatformRunnable;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.binding.ConcatListBinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

public class FrameCatalogue
extends VBox {
    private final List<Updater> catalogueUpdate = new ArrayList<Updater>();
    private final ObservableList<Node> extensionItems = FXCollections.observableArrayList();
    private final ObservableList<Node> hintItems = FXCollections.observableArrayList();
    private ObservableList catalogBindingList;
    private FXPlatformRunnable cancelUpdateCatalogue;
    private FrameCursor currentCursor;
    private boolean filled = false;
    public static final double CATALOGUE_FRAME_WIDTH = 220.0;
    private final Node exampleHeader = this.makeSectionHeader(Config.getString("frame.catalogue.examples"));

    FrameCatalogue() {
        JavaFXUtil.addStyleClass((Styleable)this, "catalogue");
        this.setFocusTraversable(false);
    }

    @OnThread(value=Tag.FXPlatform)
    private void fillCatalogue(FrameEditorTab editor) {
        if (this.filled || editor == null) {
            return;
        }
        this.filled = true;
        ObservableList standardItems = FXCollections.observableArrayList();
        Node shortcutHeader = this.makeSectionHeader(Config.getString("frame.catalogue.shortcuts"));
        standardItems.add((Object)shortcutHeader);
        this.catalogueUpdate.add((c, code, hasSelection, birdseye) -> {
            shortcutHeader.setVisible(c == null);
            shortcutHeader.setManaged(c == null);
        });
        Node commandHeader = this.makeSectionHeader(Config.getString("frame.catalogue.commands"));
        standardItems.add((Object)commandHeader);
        this.catalogueUpdate.add((c, code, hasSelection, birdseye) -> {
            commandHeader.setVisible(c != null && !hasSelection);
            commandHeader.setManaged(c != null && !hasSelection);
        });
        editor.ignoreEdits(() -> {
            FrameDictionary<StrideCategory> dictionary = editor.getDictionary();
            BorderPane p = new BorderPane();
            p.setMinWidth(220.0);
            p.setPrefWidth(220.0);
            p.setMaxWidth(220.0);
            Scene temp = new Scene((Parent)p);
            Config.addEditorStylesheets(temp);
            Comparator<FrameDictionary.Entry> comparator = Comparator.comparing(FrameDictionary.Entry::getCategory).thenComparing(e -> this.getDisplayShortcut(e.getShortcuts()));
            SnapshotParameters params = new SnapshotParameters();
            params.setFill((Paint)Color.TRANSPARENT);
            for (FrameDictionary.Entry e2 : Utility.iterableStream(dictionary.getAllBlocks().stream().filter(b -> b.isShowingInCatalogue()).sorted(comparator))) {
                Frame f = e2.getFactory().createBlock(editor);
                p.setCenter(f.getNode());
                WritableImage image = p.snapshot(params, null);
                AnchorPane item = new AnchorPane();
                JavaFXUtil.addStyleClass((Styleable)item, "catalogue-item");
                JavaFXUtil.setPseudoclass("bj-catalogue-clickable", true, new Node[]{item});
                item.setMinWidth(220.0);
                item.setMaxWidth(220.0);
                item.setMinHeight(30.0);
                JavaFXUtil.initializeCustomTooltipCatalogue(editor.getParent(), (Node)item, "Click, or press '" + this.keyTooltipName(e2.getShortcuts()) + "' to insert " + e2.getName().toLowerCase() + " frame", Duration.millis((double)1500.0));
                ImageView imageView = new ImageView((Image)image);
                imageView.setPreserveRatio(true);
                Node header = f.getHeaderItems().findFirst().flatMap(h -> h.getComponents().stream().findFirst()).orElse(null);
                if (header != null) {
                    double headerY = header.localToScene(header.getBoundsInLocal()).getMinY();
                    imageView.setViewport(new Rectangle2D(0.0, headerY, 75.0, 18.0));
                } else {
                    imageView.setViewport(new Rectangle2D(0.0, 0.0, 75.0, 18.0));
                }
                imageView.setEffect((Effect)new ColorAdjust(0.0, 0.0, 0.2, 0.0));
                AnchorPane.setBottomAnchor((Node)imageView, (Double)0.0);
                AnchorPane.setRightAnchor((Node)imageView, (Double)0.0);
                item.getChildren().add((Object)imageView);
                Pane keyAndName = this.getKeyAndName(Collections.singletonList(this.getDisplayShortcut(e2.getShortcuts())), e2.getName(), true);
                item.getChildren().addAll((Object[])new Node[]{keyAndName});
                this.setupClick((Node)item, e2.getFactory());
                f.cleanup();
                item.setVisible(false);
                item.setManaged(false);
                standardItems.add((Object)item);
                this.catalogueUpdate.add((c, code, hasSelection, birdseye) -> {
                    boolean show = c != null && c.canInsert() && c.check().canInsert((StrideCategory)((Object)((Object)((Object)e2.getCategory())))) && (!hasSelection || e2.isValidOnSelection());
                    item.setVisible(show);
                    item.setManaged(show);
                    if (hasSelection && show) {
                        commandHeader.setVisible(true);
                        commandHeader.setManaged(true);
                    }
                });
            }
            Node hbox = this.makeTextItem(Arrays.asList("Ctrl", "Space"), Config.getString("frame.catalogue.codecompletion"), false);
            JavaFXUtil.setPseudoclass("bj-catalogue-special", true, hbox);
            standardItems.add((Object)hbox);
            this.catalogueUpdate.add((c, codeCompletion, selection, birdseye) -> {
                hbox.setVisible(codeCompletion == FXTabbedEditor.CodeCompletionState.POSSIBLE);
                hbox.setManaged(codeCompletion == FXTabbedEditor.CodeCompletionState.POSSIBLE);
            });
            hbox.setVisible(false);
            hbox.setManaged(false);
            FXBiConsumer<String, String> addCodeCompletionShortcut = (shortcut, actionName) -> {
                Node content = this.makeTextItem(Collections.singletonList(shortcut), (String)actionName, false);
                standardItems.add((Object)content);
                this.catalogueUpdate.add((c, codeCompletion, selection, birdseye) -> {
                    content.setVisible(codeCompletion == FXTabbedEditor.CodeCompletionState.SHOWING);
                    content.setManaged(codeCompletion == FXTabbedEditor.CodeCompletionState.SHOWING);
                });
            };
            addCodeCompletionShortcut.accept("Esc", Config.getString("frame.catalogue.codecompletion.hide"));
            addCodeCompletionShortcut.accept("\u2191", Config.getString("frame.catalogue.codecompletion.up"));
            addCodeCompletionShortcut.accept("\u2193", Config.getString("frame.catalogue.codecompletion.down"));
            addCodeCompletionShortcut.accept("\u21b5", Config.getString("frame.catalogue.codecompletion.select"));
            FXBiConsumer<String, String> addBirdseyeShortcut = (shortcut, actionName) -> {
                Node content = this.makeTextItem(Collections.singletonList(shortcut), (String)actionName, false);
                standardItems.add((Object)content);
                this.catalogueUpdate.add((c, codeCompletion, selection, view) -> {
                    content.setVisible(view.isBirdseye());
                    content.setManaged(view.isBirdseye());
                });
            };
            addBirdseyeShortcut.accept("Esc", Config.getString("frame.catalogue.birdseye.exit"));
            addBirdseyeShortcut.accept("\u2191", Config.getString("frame.catalogue.birdseye.up"));
            addBirdseyeShortcut.accept("\u2193", Config.getString("frame.catalogue.birdseye.down"));
            addBirdseyeShortcut.accept("\u21b5", Config.getString("frame.catalogue.birdseye.select"));
            Node content = this.makeTextItem(Collections.singletonList("Esc"), Config.getString("frame.catalogue.birdseye.exit"), false);
            standardItems.add((Object)content);
            this.catalogueUpdate.add((c, codeCompletion, selection, view) -> {
                content.setVisible(view == Frame.View.JAVA_PREVIEW);
                content.setManaged(view == Frame.View.JAVA_PREVIEW);
            });
        });
        this.catalogBindingList = FXCollections.observableArrayList((Object[])new ObservableList[]{standardItems, this.extensionItems, this.hintItems});
        ConcatListBinding.bind(this.getChildren(), this.catalogBindingList);
    }

    private Pane getKeyAndName(List<String> shortcutKeys, String title, boolean showingPreview) {
        Object keyAndName;
        HBox keysHBox = new HBox(shortcutKeys.stream().map(shortcut -> {
            Label keyLabel = new Label(shortcut);
            keyLabel.setMouseTransparent(true);
            JavaFXUtil.addStyleClass((Styleable)keyLabel, "catalogue-key");
            if (shortcut.length() > 1) {
                JavaFXUtil.setPseudoclass("bj-wide", true, new Node[]{keyLabel});
                keyLabel.setTextOverrun(OverrunStyle.CLIP);
            }
            return keyLabel;
        }).collect(Utility.intersperse(() -> new Label("+"))).toArray(new Node[0]));
        keysHBox.setSpacing(1.0);
        keysHBox.setFillHeight(false);
        keysHBox.setAlignment(Pos.CENTER_LEFT);
        Label name = new Label(title);
        name.setWrapText(true);
        name.setMaxWidth(showingPreview ? 100.0 : 160.0);
        name.setMouseTransparent(true);
        if (shortcutKeys.size() == 1) {
            keyAndName = new HBox(new Node[]{keysHBox, name}){
                {
                    this.setSpacing(5.0);
                    this.setFillHeight(false);
                    this.setAlignment(Pos.CENTER_LEFT);
                }
            };
        } else {
            keyAndName = new VBox(new Node[]{keysHBox, name}){
                {
                    this.setSpacing(5.0);
                }
            };
            name.setStyle("-fx-padding: 0 0 0 15;");
        }
        AnchorPane.setLeftAnchor((Node)keyAndName, (Double)0.0);
        AnchorPane.setTopAnchor((Node)keyAndName, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)keyAndName, (Double)0.0);
        return keyAndName;
    }

    private void setupClick(Node item, FrameFactory<? extends Frame> factory) {
        item.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (this.currentCursor != null) {
                InteractionManager editor = this.currentCursor.getEditor();
                editor.recordEdits(StrideEditReason.FLUSH);
                FrameSelection selection = this.currentCursor.getEditor().getSelection();
                if (selection.getSelected().isEmpty()) {
                    Object f2 = factory.createBlock(this.currentCursor.getEditor());
                    this.currentCursor.insertBlockAfter((Frame)f2);
                    ((Frame)f2).markFresh();
                    ((Frame)f2).focusWhenJustAdded();
                    editor.recordEdits(StrideEditReason.SINGLE_FRAME_INSERTION_CHEAT);
                } else {
                    List<Frame> selected = selection.getSelected();
                    List<Frame> selectedCopy = Utility.mapList(selected, f -> Loader.loadElement(((CodeElement)((CodeFrame)((Object)f)).getCode()).toXML()).createFrame(this.currentCursor.getEditor()));
                    Object newFrame = factory.createBlock(this.currentCursor.getEditor(), selectedCopy);
                    this.currentCursor.insertBlockBefore((Frame)newFrame);
                    selected.forEach(f -> f.getParentCanvas().removeBlock((Frame)f));
                    selection.clear();
                    ((Frame)newFrame).markFresh();
                    ((Frame)newFrame).focusWhenJustAdded();
                    editor.recordEdits(StrideEditReason.SELECTION_WRAP_CHEAT);
                }
            }
            e.consume();
        });
    }

    private void setupClick(Node item, FrameCursor c, FXRunnable action) {
        item.addEventFilter(MouseEvent.MOUSE_CLICKED, e -> {
            if (this.currentCursor == c) {
                action.run();
            }
            e.consume();
        });
    }

    private String getDisplayShortcut(String shortcut) {
        if (shortcut.equals("\n")) {
            return "\u21b5";
        }
        if (shortcut.equals("\b")) {
            return "\u21a4";
        }
        if (shortcut.equals(" ")) {
            return "\u02fd";
        }
        return shortcut;
    }

    private String keyTooltipName(String shortcut) {
        switch (shortcut) {
            case " ": {
                return "space";
            }
            case "\n": {
                return "return";
            }
            case "\b": {
                return "backspace";
            }
        }
        return shortcut;
    }

    @OnThread(value=Tag.FXPlatform)
    void scheduleUpdateCatalogue(FrameEditorTab editor, FrameCursor c, FXTabbedEditor.CodeCompletionState codeCompletion, boolean selection, Frame.View viewMode, List<ExtensionDescription> altExtensions, List<Hint> hints) {
        this.currentCursor = c;
        if (this.cancelUpdateCatalogue != null) {
            this.cancelUpdateCatalogue.run();
        }
        this.cancelUpdateCatalogue = JavaFXUtil.runAfter(Duration.millis((double)500.0), () -> {
            if (this.getScene().getWindow().isFocused() || codeCompletion == FXTabbedEditor.CodeCompletionState.SHOWING) {
                this.fillCatalogue(editor);
                this.catalogueUpdate.forEach(updater -> updater.update(c, codeCompletion, selection, viewMode));
                this.updateExtensions(selection ? null : c, altExtensions);
                this.replaceHints(hints);
            }
        });
    }

    private void updateExtensions(FrameCursor c, List<ExtensionDescription> altExtensions) {
        this.extensionItems.clear();
        if (c != null) {
            Node item;
            Frame frameBefore = c.getFrameBefore();
            Frame frameAfter = c.getFrameAfter();
            HashSet<Character> keysAlreadyUsed = new HashSet<Character>();
            CanvasParent parent = c.getParentCanvas().getParent();
            if (parent != null && c.canInsert()) {
                for (ExtensionDescription ext : parent.getAvailableExtensions(c.getParentCanvas(), c)) {
                    if (keysAlreadyUsed.contains(Character.valueOf(ext.getShortcutKey())) || !ext.validFor(frameBefore == null ? ExtensionDescription.ExtensionSource.INSIDE_FIRST : ExtensionDescription.ExtensionSource.INSIDE_LATER) || !ext.showInCatalogue()) continue;
                    item = this.makeTextItem(Collections.singletonList(this.getDisplayShortcut("" + ext.getShortcutKey())), ext.getDescription(), true);
                    this.setupClick(item, c, ext::activate);
                    this.extensionItems.add((Object)item);
                    keysAlreadyUsed.add(Character.valueOf(ext.getShortcutKey()));
                }
            }
            if (frameAfter != null && frameAfter.isFrameEnabled()) {
                for (ExtensionDescription ext : frameAfter.getAvailableExtensions(null, null)) {
                    if (keysAlreadyUsed.contains(Character.valueOf(ext.getShortcutKey())) || !ext.validFor(ExtensionDescription.ExtensionSource.BEFORE) || !ext.showInCatalogue()) continue;
                    item = this.makeTextItem(Collections.singletonList(this.getDisplayShortcut("" + ext.getShortcutKey())), ext.getDescription(), true);
                    this.setupClick(item, c, ext::activate);
                    this.extensionItems.add((Object)item);
                    keysAlreadyUsed.add(Character.valueOf(ext.getShortcutKey()));
                }
            }
            if (frameBefore != null && frameBefore.isFrameEnabled()) {
                for (ExtensionDescription ext : frameBefore.getAvailableExtensions(null, null)) {
                    if (keysAlreadyUsed.contains(Character.valueOf(ext.getShortcutKey())) || !ext.validFor(ExtensionDescription.ExtensionSource.AFTER) || !ext.showInCatalogue()) continue;
                    item = this.makeTextItem(Collections.singletonList(this.getDisplayShortcut("" + ext.getShortcutKey())), ext.getDescription(), true);
                    this.setupClick(item, c, ext::activate);
                    this.extensionItems.add((Object)item);
                    keysAlreadyUsed.add(Character.valueOf(ext.getShortcutKey()));
                }
            }
        }
        for (ExtensionDescription ext : altExtensions) {
            if (!ext.validFor(ExtensionDescription.ExtensionSource.MODIFIER) || !ext.showInCatalogue()) continue;
            Node item = this.makeTextItem(Arrays.asList("Ctrl", "Shift", this.getDisplayShortcut("" + ext.getShortcutKey())), ext.getDescription(), true);
            this.setupClick(item, c, ext::activate);
            this.extensionItems.add((Object)item);
        }
    }

    private Node makeTextItem(List<String> shortcut, String description, boolean clickable) {
        AnchorPane item = new AnchorPane();
        JavaFXUtil.addStyleClass((Styleable)item, "catalogue-item");
        JavaFXUtil.setPseudoclass("bj-catalogue-clickable", clickable, new Node[]{item});
        item.setMaxWidth(220.0);
        item.setMinHeight(30.0);
        item.getChildren().add((Object)this.getKeyAndName(shortcut, description, false));
        return item;
    }

    private Node makeHint(Hint h) {
        VBox item = new VBox();
        Label example = new Label(h.exampleCode);
        Label explanation = new Label(h.explanation);
        example.setWrapText(true);
        explanation.setWrapText(true);
        JavaFXUtil.addStyleClass((Styleable)example, "catalogue-example-code");
        JavaFXUtil.addStyleClass((Styleable)explanation, "catalogue-example-description");
        VBox.setMargin((Node)explanation, (Insets)new Insets(3.0, 0.0, 0.0, 20.0));
        item.getChildren().addAll((Object[])new Node[]{example, explanation});
        item.setMaxWidth(220.0);
        item.setMinHeight(30.0);
        JavaFXUtil.addStyleClass((Styleable)example, "catalogue-example");
        return item;
    }

    private void replaceHints(List<Hint> hints) {
        this.hintItems.setAll(Utility.mapList(hints, h -> this.makeHint((Hint)h)));
        if (!this.hintItems.isEmpty()) {
            this.hintItems.add(0, (Object)this.exampleHeader);
        }
    }

    private Node makeSectionHeader(String title) {
        Label l = new Label(title);
        JavaFXUtil.addStyleClass((Styleable)l, "catalogue-header");
        VBox pane = new VBox(new Node[]{l});
        JavaFXUtil.addStyleClass((Styleable)pane, "catalogue-item");
        JavaFXUtil.setPseudoclass("bj-catalogue-header", true, new Node[]{pane});
        pane.setMinWidth(220.0);
        return pane;
    }

    private static interface Updater {
        public void update(FrameCursor var1, FXTabbedEditor.CodeCompletionState var2, boolean var3, Frame.View var4);
    }

    public static class Hint {
        public final String exampleCode;
        public final String explanation;

        public Hint(String exampleCode, String explanation) {
            this.exampleCode = exampleCode;
            this.explanation = explanation;
        }
    }

    public static enum ShowReason {
        UNKNOWN_FRAME_COMMAND("unknown_frame_command"),
        MENU_OR_SHORTCUT("menu_or_shortcut"),
        ARROW("arrow"),
        PROPERTIES("properties");

        private final String text;

        private ShowReason(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

