/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.flow.FlowEditor;
import bluej.editor.flow.FlowErrorManager;
import bluej.prefmgr.PrefMgr;
import bluej.utility.javafx.JavaFXUtil;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class StatusLabel
extends VBox {
    private final Label statusLabel;
    private final Label errorLabel;
    private Status state;
    private int errorCount = 0;

    public StatusLabel(Status initialState, FlowEditor editor, FlowErrorManager errorManager) {
        JavaFXUtil.addStyleClass((Styleable)this, "moe-status-label-wrapper");
        this.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(PrefMgr.FontCSS.EDITOR_SIZE_ONLY));
        this.state = initialState;
        this.statusLabel = new Label();
        this.errorLabel = new Label();
        JavaFXUtil.addStyleClass((Styleable)this.errorLabel, "error-count-label");
        this.getChildren().setAll((Object[])new Node[]{this.statusLabel, this.errorLabel});
        this.updateLabel();
        errorManager.listenForErrorChange(errs -> {
            this.errorCount = errs.size();
            this.updateLabel();
        });
        this.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY) {
                if (this.errorCount > 0) {
                    editor.compileOrShowNextError();
                }
                e.consume();
            }
        });
    }

    public boolean isChanged() {
        return this.state == Status.CHANGED;
    }

    public boolean isReadOnly() {
        return this.state == Status.READONLY;
    }

    public void setState(Status newState) {
        this.state = newState;
        this.updateLabel();
    }

    private void updateLabel() {
        this.statusLabel.setText(this.state.getDisplayText().replace("\n", ""));
        if (this.errorCount > 0) {
            this.errorLabel.setText("Errors: " + this.errorCount);
        } else {
            this.errorLabel.setText("");
        }
        JavaFXUtil.setPseudoclass("bj-status-error", this.errorCount > 0, new Node[]{this});
    }

    public static enum Status {
        READONLY("editor.state.readOnly"),
        SAVED("editor.state.saved"),
        CHANGED("editor.state.changed");

        private final String displayText;

        private Status(String displayKey) {
            this.displayText = Config.getString(displayKey);
        }

        public String getDisplayText() {
            return this.displayText;
        }
    }
}

