/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.flow;

import bluej.Config;
import bluej.editor.flow.ScopeHighlightingPrefDisplay;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class EditorPrefPanel
extends VBox
implements PrefPanelListener {
    private TextField editorFontField;
    private CheckBox highlightingBox;
    private CheckBox autoIndentBox;
    private CheckBox closeCurlyBox;
    private CheckBox lineNumbersBox;
    private CheckBox matchBracketsBox;
    private CheckBox checkFileChangedOnDiskBox;
    private ScopeHighlightingPrefDisplay scopeHighlightingPrefDisplay;
    private TextField textFileExtensionsField;
    private Button textFileExtensionsDefaultButton;

    public EditorPrefPanel() {
        JavaFXUtil.addStyleClass((Styleable)this, "prefmgr-pref-panel");
        this.scopeHighlightingPrefDisplay = new ScopeHighlightingPrefDisplay();
        ArrayList<Node> javaEditorPanel = new ArrayList<Node>();
        GridPane topPanel = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)topPanel, "prefmgr-java-editor-top");
        this.editorFontField = new TextField();
        this.editorFontField.setPrefColumnCount(4);
        topPanel.add(PrefMgrDialog.labelledItem("prefmgr.edit.editorfontsize", (Node)this.editorFontField), 0, 0);
        this.autoIndentBox = new CheckBox(Config.getString("prefmgr.edit.autoindent"));
        topPanel.add((Node)this.autoIndentBox, 1, 0);
        this.closeCurlyBox = new CheckBox(Config.getString("prefmgr.edit.closecurly"));
        topPanel.add((Node)this.closeCurlyBox, 1, 1);
        this.highlightingBox = new CheckBox(Config.getString("prefmgr.edit.usesyntaxhilighting"));
        topPanel.add((Node)this.highlightingBox, 0, 1);
        this.lineNumbersBox = new CheckBox(Config.getString("prefmgr.edit.displaylinenumbers"));
        topPanel.add((Node)this.lineNumbersBox, 0, 2);
        this.matchBracketsBox = new CheckBox(Config.getString("prefmgr.edit.matchBrackets"));
        topPanel.add((Node)this.matchBracketsBox, 1, 2);
        this.checkFileChangedOnDiskBox = new CheckBox(Config.getString("prefmgr.edit.checkfilechangeondisk"));
        topPanel.add((Node)this.checkFileChangedOnDiskBox, 1, 3);
        HBox bottomPanel = new HBox();
        JavaFXUtil.addStyleClass((Styleable)bottomPanel, "prefmgr-java-scope-hbox");
        bottomPanel.getChildren().add((Object)this.scopeHighlightingPrefDisplay.getHighlightStrengthSlider());
        bottomPanel.getChildren().add((Object)this.scopeHighlightingPrefDisplay.getColourPalette());
        javaEditorPanel.add((Node)topPanel);
        javaEditorPanel.add(PrefMgrDialog.headedVBox("prefmgr.edit.colortransparency", Arrays.asList(bottomPanel)));
        this.getChildren().add((Object)PrefMgrDialog.headedVBox("prefmgr.edit.editor.title", javaEditorPanel));
        ArrayList<Node> textEditorPanel = new ArrayList<Node>();
        GridPane textTopPanel = new GridPane();
        JavaFXUtil.addStyleClass((Styleable)textTopPanel, "prefmgr-text-editor-top");
        this.textFileExtensionsField = new TextField();
        this.textFileExtensionsField.setPrefColumnCount(20);
        textTopPanel.add(PrefMgrDialog.labelledItem("prefmgr.edit.textfileextensions", (Node)this.textFileExtensionsField), 0, 0);
        this.textFileExtensionsDefaultButton = new Button(Config.getString("prefmgr.edit.texteditor.defaultFileExtensions"));
        this.textFileExtensionsDefaultButton.setOnAction(event -> this.textFileExtensionsField.setText(".txt, .md"));
        textTopPanel.add((Node)this.textFileExtensionsDefaultButton, 1, 0);
        Label t = new Label(Config.getString("prefmgr.interface.text.restart"));
        textTopPanel.add((Node)t, 0, 1);
        textEditorPanel.add((Node)textTopPanel);
        this.getChildren().add((Object)PrefMgrDialog.headedVBox("prefmgr.edit.editor.texteditor.title", textEditorPanel));
    }

    @Override
    public void beginEditing(Project project) {
        this.editorFontField.setText(String.valueOf(PrefMgr.getEditorFontSize().get()));
        this.highlightingBox.setSelected(PrefMgr.getFlag("bluej.editor.syntaxHilighting"));
        this.closeCurlyBox.setSelected(PrefMgr.getFlag("bluej.editor.autoAddClosingCurly"));
        this.autoIndentBox.setSelected(PrefMgr.getFlag("bluej.editor.autoIndent"));
        this.lineNumbersBox.setSelected(PrefMgr.getFlag("bluej.editor.displayLineNumbers"));
        this.matchBracketsBox.setSelected(PrefMgr.getFlag("bluej.editor.matchBrackets"));
        this.checkFileChangedOnDiskBox.setSelected(PrefMgr.getFlag("bluej.editor.checkDiskFileChanges"));
        this.textFileExtensionsField.setText(PrefMgr.getEditorTextFileExtensionsString());
    }

    @Override
    public void revertEditing(Project project) {
    }

    @Override
    public void commitEditing(Project project) {
        String fontText = this.editorFontField.getText();
        PrefMgr.setFlag("bluej.editor.syntaxHilighting", this.highlightingBox.isSelected());
        PrefMgr.setFlag("bluej.editor.autoIndent", this.autoIndentBox.isSelected());
        PrefMgr.setFlag("bluej.editor.autoAddClosingCurly", this.closeCurlyBox.isSelected());
        PrefMgr.setFlag("bluej.editor.displayLineNumbers", this.lineNumbersBox.isSelected());
        PrefMgr.setFlag("bluej.editor.matchBrackets", this.matchBracketsBox.isSelected());
        PrefMgr.setFlag("bluej.editor.checkDiskFileChanges", this.checkFileChangedOnDiskBox.isSelected());
        int strength = this.scopeHighlightingPrefDisplay.getStrengthValue();
        try {
            PrefMgr.setEditorFontSize(Integer.parseInt(fontText));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PrefMgr.setScopeHighlightStrength(strength);
        PrefMgr.setEditorTextFileExtensions(this.textFileExtensionsField.getText());
    }
}

