/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.base;

import bluej.editor.base.BackgroundItem;
import bluej.utility.Utility;
import bluej.utility.javafx.FXRunnable;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ResizableRectangle;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.binding.StringExpression;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.IndexRange;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FX)
public class TextLine
extends TextFlow {
    private final boolean printing;
    private final Path selectionShape = new Path();
    private final Path findResultShape = new Path();
    private final Path bracketMatchShape = new Path();
    private final Path errorUnderlineShape = new Path();
    private final ArrayList<IndexRange> errorLocations = new ArrayList();
    private List<BackgroundItem> backgroundNodes = Collections.emptyList();
    private List<StyledSegment> latestContent = Collections.emptyList();
    private final Rectangle clip;

    public double getSingleTextHeight() {
        return this.getChildren().stream().filter(n -> n instanceof Text).map(n -> ((Text)n).getBoundsInLocal().getHeight()).findFirst().orElse(this.getHeight());
    }

    public TextLine(boolean printing) {
        this.printing = printing;
        this.getStyleClass().add((Object)"text-line");
        this.setMouseTransparent(true);
        this.selectionShape.getStyleClass().add((Object)"flow-selection");
        this.selectionShape.setManaged(false);
        this.findResultShape.getStyleClass().add((Object)"flow-find-result");
        this.findResultShape.setManaged(false);
        this.bracketMatchShape.getStyleClass().add((Object)"flow-bracket-match");
        this.bracketMatchShape.setManaged(false);
        this.errorUnderlineShape.setStroke((Paint)Color.RED);
        this.errorUnderlineShape.setFill(null);
        this.errorUnderlineShape.setManaged(false);
        this.getChildren().setAll((Object[])new Node[]{this.bracketMatchShape, this.findResultShape, this.selectionShape, this.errorUnderlineShape});
        this.clip = new ResizableRectangle();
        this.clip.widthProperty().bind((ObservableValue)this.widthProperty());
        this.clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)this.clip);
    }

    @OnThread(value=Tag.FX, ignoreParent=true)
    protected void layoutChildren() {
        super.layoutChildren();
        for (Node child : this.getChildren()) {
            if (!(child instanceof BackgroundItem)) continue;
            BackgroundItem backgroundItem = (BackgroundItem)child;
            backgroundItem.resizeRelocate(backgroundItem.x, this.printing ? -1.0 : 0.0, backgroundItem.width, this.getHeight() + (double)(this.printing ? 2 : 0));
        }
    }

    public void hideSelection() {
        this.selectionShape.getElements().clear();
        this.selectionShape.setVisible(false);
    }

    private void runOnceLaidOut(FXRunnable action) {
        if (this.isNeedsLayout()) {
            JavaFXUtil.runAfterNextLayout(this.getScene(), () -> this.runOnceLaidOut(action));
        } else {
            action.run();
        }
    }

    public void showSelection(int start, int end, boolean extendToRight) {
        this.runOnceLaidOut(() -> {
            this.selectionShape.getElements().setAll((Object[])this.extendShape(extendToRight, this.rangeShape(start, end)));
            this.selectionShape.setVisible(true);
        });
    }

    private PathElement[] extendShape(boolean extendToRight, PathElement[] rangeShape) {
        double height = this.getHeight();
        if (rangeShape.length == 5 && rangeShape[2] instanceof LineTo && rangeShape[3] instanceof LineTo) {
            ((LineTo)rangeShape[2]).setY(height);
            ((LineTo)rangeShape[3]).setY(height);
        }
        if (extendToRight) {
            double width = this.getWidth();
            if (rangeShape.length == 5 && rangeShape[1] instanceof LineTo && rangeShape[2] instanceof LineTo) {
                ((LineTo)rangeShape[1]).setX(width - 1.0);
                ((LineTo)rangeShape[2]).setX(width - 1.0);
            } else if (rangeShape.length == 0) {
                double rhs = Utility.findLast(this.getChildren().stream().filter(t -> t instanceof Text).map(n -> n.getBoundsInParent().getMaxX())).orElse(0.0);
                rangeShape = new PathElement[]{new MoveTo(rhs, 0.0), new LineTo(width - 1.0, 0.0), new LineTo(width - 1.0, this.getHeight()), new LineTo(rhs, this.getHeight()), new LineTo(rhs, 0.0)};
            }
        }
        for (PathElement pathElement : rangeShape) {
            if (pathElement instanceof LineTo) {
                LineTo lineTo = (LineTo)pathElement;
                lineTo.setX(this.snapPositionX(lineTo.getX()));
                lineTo.setY(this.snapPositionY(lineTo.getY()));
                continue;
            }
            if (!(pathElement instanceof MoveTo)) continue;
            MoveTo moveTo = (MoveTo)pathElement;
            moveTo.setX(this.snapPositionX(moveTo.getX()));
            moveTo.setY(this.snapPositionY(moveTo.getY()));
        }
        return rangeShape;
    }

    public void setText(List<StyledSegment> text, double xTranslate, boolean fontChanged, StringExpression fontCSS) {
        this.setTranslateX(xTranslate);
        this.clip.setX(-xTranslate);
        text = Lists.newArrayList(StyledSegment.mergeAdjacentIdentical(text));
        if (!fontChanged && this.latestContent.equals(text)) {
            return;
        }
        this.hideSelection();
        this.hideErrorUnderline();
        this.getChildren().clear();
        this.getChildren().addAll(this.backgroundNodes);
        this.getChildren().addAll((Object[])new Node[]{this.bracketMatchShape, this.findResultShape, this.selectionShape});
        for (StyledSegment styledSegment : text) {
            Text t = new Text(styledSegment.text.replace('\u0000', '\u2400'));
            t.setStyle(fontCSS.getValue());
            t.getStyleClass().add((Object)"editor-text");
            t.getStyleClass().addAll(styledSegment.cssClasses);
            this.getChildren().add((Object)t);
        }
        this.getChildren().add((Object)this.errorUnderlineShape);
        this.latestContent = new ArrayList<StyledSegment>(text);
    }

    public void showError(int startColumn, int endColumn) {
        this.errorLocations.add(new IndexRange(startColumn, endColumn));
        this.runOnceLaidOut(() -> {
            this.errorUnderlineShape.getElements().setAll((Collection)this.errorLocations.stream().flatMap(r -> this.makeSquiggle(this.rangeShape(r.getStart(), r.getEnd())).stream()).collect(Collectors.toList()));
            this.errorUnderlineShape.setVisible(!this.errorUnderlineShape.getElements().isEmpty());
        });
    }

    public void showHighlight(HighlightType highlightType, List<int[]> positions) {
        this.runOnceLaidOut(() -> {
            Path shape = highlightType == HighlightType.FIND_RESULT ? this.findResultShape : this.bracketMatchShape;
            shape.getElements().setAll((Object[])((PathElement[])positions.stream().flatMap(p -> Arrays.stream(this.rangeShape(p[0], p[1]))).toArray(PathElement[]::new)));
            shape.setVisible(!shape.getElements().isEmpty());
        });
    }

    private List<PathElement> makeSquiggle(PathElement[] rectShape) {
        ArrayList<PathElement> squiggle = new ArrayList<PathElement>();
        if (rectShape.length == 5 && rectShape[2] instanceof LineTo && rectShape[3] instanceof LineTo) {
            double leftHandX = ((LineTo)rectShape[3]).getX();
            double rightHandX = ((LineTo)rectShape[2]).getX();
            double y = ((LineTo)rectShape[2]).getY() - 1.0;
            double width = Math.max(9.0, rightHandX - leftHandX);
            boolean downStroke = true;
            double x = this.snapPositionX(leftHandX);
            squiggle.add((PathElement)new MoveTo(x, this.snapPositionY(y - 2.0)));
            do {
                squiggle.add((PathElement)new LineTo(this.snapPositionX(x += 3.0), this.snapPositionY(downStroke ? y + 1.0 : y - 2.0)));
                boolean bl = downStroke = !downStroke;
            } while (x < this.snapPositionX(leftHandX + width));
        } else {
            squiggle.addAll(Arrays.asList(rectShape));
        }
        return squiggle;
    }

    public void hideErrorUnderline() {
        this.errorLocations.clear();
        this.errorUnderlineShape.getElements().clear();
        this.errorUnderlineShape.setVisible(false);
    }

    public void setScopeBackgrounds(Collection<BackgroundItem> nodes) {
        if (nodes == null) {
            nodes = Collections.emptyList();
        }
        this.backgroundNodes = new ArrayList<BackgroundItem>(nodes);
        int selectionIndex = this.getChildren().indexOf((Object)this.bracketMatchShape);
        this.getChildren().remove(0, selectionIndex);
        this.getChildren().addAll(0, this.backgroundNodes);
        this.requestLayout();
    }

    public void fontSizeChanged(StringExpression fontCSS) {
        List<StyledSegment> content = this.latestContent;
        this.latestContent = Collections.emptyList();
        this.setText(content, this.getTranslateX(), true, fontCSS);
    }

    @OnThread(value=Tag.FX)
    public static class StyledSegment {
        private final List<String> cssClasses;
        private final String text;
        private final Object customData;

        @OnThread(value=Tag.Any)
        public StyledSegment(List<String> cssClasses, String text) {
            this(cssClasses, text, null);
        }

        @OnThread(value=Tag.Any)
        public StyledSegment(List<String> cssClasses, String text, Object customData) {
            this.cssClasses = cssClasses;
            this.text = text;
            this.customData = customData;
        }

        @OnThread(value=Tag.FX)
        public static Iterable<StyledSegment> mergeAdjacentIdentical(final List<StyledSegment> segments) {
            return new Iterable<StyledSegment>(){

                @Override
                @OnThread(value=Tag.FX, ignoreParent=true)
                public @OnThread(value=Tag.FX, ignoreParent=true) Iterator<StyledSegment> iterator() {
                    return new Iterator<StyledSegment>(){
                        int nextToExamine = 0;

                        @Override
                        public boolean hasNext() {
                            return this.nextToExamine < segments.size();
                        }

                        @Override
                        public StyledSegment next() {
                            StyledSegment next = (StyledSegment)segments.get(this.nextToExamine);
                            ++this.nextToExamine;
                            while (this.nextToExamine < segments.size() && ((StyledSegment)segments.get((int)this.nextToExamine)).cssClasses.equals(next.cssClasses) && Objects.equals(((StyledSegment)segments.get((int)this.nextToExamine)).customData, next.customData)) {
                                next = new StyledSegment(next.cssClasses, next.text + ((StyledSegment)segments.get((int)this.nextToExamine)).text, next.customData);
                                ++this.nextToExamine;
                            }
                            return next;
                        }
                    };
                }
            };
        }

        public String getText() {
            return this.text;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StyledSegment that = (StyledSegment)o;
            return this.cssClasses.equals(that.cssClasses) && Objects.equals(this.customData, that.customData) && this.text.equals(that.text);
        }

        public int hashCode() {
            return Objects.hash(this.cssClasses, this.text, this.customData);
        }

        public List<String> getStyleClasses() {
            return this.cssClasses;
        }

        public Object getCustomData() {
            return this.customData;
        }
    }

    public static enum HighlightType {
        FIND_RESULT,
        BRACKET_MATCH;

    }
}

