/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.Config;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.inspector.FieldInfo;
import bluej.debugmgr.inspector.FieldList;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.testmgr.record.GetInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.javafx.JavaFXUtil;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.css.Styleable;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public abstract class Inspector
extends Stage {
    protected static final String showClassLabel = Config.getString("debugger.inspector.showClass");
    protected static final String inspectLabel = Config.getString("debugger.inspector.inspect");
    protected static final String getLabel = Config.getString("debugger.inspector.get");
    protected static final String close = Config.getString("close");
    protected FieldList fieldList = null;
    protected Button inspectButton;
    protected Button getButton;
    protected DebuggerObject selectedField;
    protected String selectedFieldName;
    protected String selectedFieldType;
    protected InvokerRecord selectedInvokerRecord;
    protected final Package pkg;
    protected final InspectorManager inspectorManager;
    protected final InvokerRecord ir;
    private double initialClickX;
    private double initialClickY;
    private static AtomicInteger nextUniqueId = new AtomicInteger(1);
    private final int uniqueId;
    private static final int MIN_LIST_WIDTH = 150;
    private static final int MAX_LIST_WIDTH = 400;
    private final ResizeListener resizeListener;

    @OnThread(value=Tag.FXPlatform)
    public static String fieldToString(DebuggerField field) {
        int mods = field.getModifiers();
        Object result = "";
        if (Modifier.isPrivate(mods)) {
            result = "private ";
        } else if (Modifier.isPublic(mods)) {
            result = "public ";
        } else if (Modifier.isProtected(mods)) {
            result = "protected ";
        }
        if (field.isHidden()) {
            result = (String)result + "(hidden) ";
        }
        result = (String)result + field.getType().toString(true);
        result = (String)result + " " + field.getName();
        return result;
    }

    protected Inspector(InspectorManager inspectorManager, Package pkg, InvokerRecord ir, StageStyle stageStyle) {
        if (inspectorManager == null) {
            throw new NullPointerException("An inspector must have an InspectorManager.");
        }
        if (pkg == null && ir != null) {
            ir = null;
        }
        JavaFXUtil.addSelfRemovingListener(this.sceneProperty(), Config::addInspectorStylesheets);
        this.initStyle(stageStyle);
        this.inspectorManager = inspectorManager;
        this.pkg = pkg;
        this.ir = ir;
        this.uniqueId = nextUniqueId.incrementAndGet();
        this.setOnCloseRequest(e -> {
            e.consume();
            this.doClose(true);
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.doClose(true);
            }
        });
        this.resizeListener = new ResizeListener(this);
        Timeline autoUpdate = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), e -> this.update(), new KeyValue[0])});
        autoUpdate.setCycleCount(-1);
        this.addEventHandler(WindowEvent.ANY, e -> {
            boolean hidden;
            boolean shown = e.getEventType() == WindowEvent.WINDOW_SHOWN;
            boolean bl = hidden = e.getEventType() == WindowEvent.WINDOW_HIDDEN;
            if (hidden) {
                autoUpdate.stop();
            } else if (shown && this.shouldAutoUpdate()) {
                autoUpdate.playFromStart();
            }
        });
        this.initFieldList();
    }

    protected abstract boolean shouldAutoUpdate();

    private void initFieldList() {
        this.fieldList = new FieldList();
        JavaFXUtil.addChangeListenerPlatform(this.fieldList.selectedIndexProperty(), index -> this.listElementSelected(index.intValue()));
        this.fieldList.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2 && e.getButton() == MouseButton.PRIMARY) {
                this.doInspect();
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE || e.getCode() == KeyCode.ENTER) {
                this.doClose(true);
                e.consume();
            } else if (e.getCode() == KeyCode.SPACE && this.fieldList.isFocused()) {
                this.doInspect();
                e.consume();
            } else if (e.getCode() == KeyCode.UP) {
                this.fieldList.requestFocus();
                this.fieldList.up();
                e.consume();
            } else if (e.getCode() == KeyCode.DOWN) {
                this.fieldList.requestFocus();
                this.fieldList.down();
                e.consume();
            }
        });
    }

    protected boolean isGetEnabled() {
        return this.ir != null;
    }

    public void bringToFront() {
        this.setIconified(false);
        this.toFront();
    }

    protected abstract List<FieldInfo> getListData();

    protected abstract void listElementSelected(int var1);

    protected abstract void remove();

    protected abstract int getPreferredRows();

    public void update() {
        List<FieldInfo> listData = this.getListData();
        int prevSelection = this.fieldList.selectedIndexProperty().get();
        this.fieldList.setData(listData);
        if (!listData.isEmpty()) {
            this.fieldList.select(prevSelection == -1 || prevSelection >= listData.size() ? 0 : prevSelection);
        }
    }

    protected void setCurrentObj(DebuggerObject object, String name, String type) {
        this.selectedField = object;
        this.selectedFieldName = name;
        this.selectedFieldType = type;
    }

    protected void setButtonsEnabled(boolean inspect, boolean get) {
        this.inspectButton.setDisable(!inspect);
        this.getButton.setDisable(!get || !this.isGetEnabled());
    }

    protected void doInspect() {
        if (this.selectedField != null) {
            boolean isPublic = !this.getButton.isDisable();
            ObjectInspectInvokerRecord newIr = new ObjectInspectInvokerRecord(this.selectedFieldName, this.ir);
            this.inspectorManager.getInspectorInstance(this.selectedField, this.selectedFieldName, this.pkg, isPublic ? newIr : null, (Window)this, null);
        }
    }

    protected void doGet() {
        if (this.selectedField != null) {
            GetInvokerRecord getIr = new GetInvokerRecord(this.selectedFieldType, this.selectedFieldName, this.ir);
            DebuggerObject selField = this.selectedField;
            PackageEditor pkgEd = this.pkg.getEditor();
            pkgEd.recordInteraction(getIr);
            pkgEd.raisePutOnBenchEvent((Window)this, selField, selField.getGenType(), getIr, true, Optional.empty());
        }
    }

    public void doClose(boolean handleAssertions) {
        this.hide();
        this.remove();
    }

    protected Button createCloseButton() {
        Button button = new Button(close);
        button.setOnAction(e -> this.doClose(true));
        return button;
    }

    protected Node createInspectAndGetButtons() {
        VBox buttonPanel = new VBox();
        this.inspectButton = new Button(inspectLabel);
        this.inspectButton.setOnAction(e -> this.doInspect());
        this.inspectButton.setDisable(true);
        buttonPanel.getChildren().add((Object)this.inspectButton);
        this.getButton = new Button(getLabel);
        this.getButton.setVisible(!Config.isGreenfoot());
        this.getButton.setDisable(true);
        this.getButton.setOnAction(e -> this.doGet());
        buttonPanel.getChildren().add((Object)this.getButton);
        JavaFXUtil.addStyleClass((Styleable)buttonPanel, "inspector-side-buttons");
        return buttonPanel;
    }

    protected void installListenersForMoveDrag(double curvedCornersMargin) {
        this.resizeListener.setCurvedCorners(curvedCornersMargin);
        this.addEventHandler(MouseEvent.MOUSE_MOVED, this.resizeListener);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.resizeListener);
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, this.resizeListener);
        this.addEventHandler(MouseEvent.MOUSE_EXITED, this.resizeListener);
        this.addEventHandler(MouseEvent.MOUSE_EXITED_TARGET, this.resizeListener);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> {
            this.initialClickX = e.getScreenX() - this.getX();
            this.initialClickY = e.getScreenY() - this.getY();
        });
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> {
            this.setX(e.getScreenX() - this.initialClickX);
            this.setY(e.getScreenY() - this.initialClickY);
        });
    }

    @OnThread(value=Tag.Any)
    public int getUniqueId() {
        return this.uniqueId;
    }

    public void centerOnOwner() {
        this.getScene().getRoot().applyCss();
        this.getScene().getRoot().layout();
        Window owner = this.getOwner();
        if (owner == null) {
            this.centerOnScreen();
            return;
        }
        Scene ownerScene = owner.getScene();
        double titleBarHeight = ownerScene.getY();
        double dialogWidth = this.getScene().getRoot().prefWidth(-1.0);
        double dialogHeight = this.getScene().getRoot().prefHeight(dialogWidth);
        double x = owner.getX() + ownerScene.getWidth() / 2.0 - dialogWidth / 2.0;
        double y = owner.getY() + titleBarHeight / 2.0 + ownerScene.getHeight() / 2.0 - dialogHeight / 2.0;
        this.setX(Math.max(0.0, x));
        this.setY(Math.max(0.0, y));
    }

    public abstract Region getContent();

    static class ResizeListener
    implements EventHandler<MouseEvent> {
        private Stage stage;
        private Cursor cursorEvent = Cursor.DEFAULT;
        private int border = 4;
        private double startX = 0.0;
        private double startY = 0.0;
        private double curvedCornersMargin;

        public ResizeListener(Stage stage) {
            this.stage = stage;
        }

        public void handle(MouseEvent mouseEvent) {
            EventType mouseEventType = mouseEvent.getEventType();
            Scene scene = this.stage.getScene();
            double mouseEventX = mouseEvent.getSceneX();
            double mouseEventY = mouseEvent.getSceneY();
            double sceneWidth = scene.getWidth();
            double sceneHeight = scene.getHeight();
            if (MouseEvent.MOUSE_MOVED.equals(mouseEventType)) {
                double cornerBorder = Math.max(this.curvedCornersMargin, (double)this.border);
                this.cursorEvent = mouseEventX < cornerBorder && mouseEventY < cornerBorder ? Cursor.NW_RESIZE : (mouseEventX < cornerBorder && mouseEventY > sceneHeight - cornerBorder ? Cursor.SW_RESIZE : (mouseEventX > sceneWidth - cornerBorder && mouseEventY < cornerBorder ? Cursor.NE_RESIZE : (mouseEventX > sceneWidth - cornerBorder && mouseEventY > sceneHeight - cornerBorder ? Cursor.SE_RESIZE : (mouseEventX < (double)this.border ? Cursor.W_RESIZE : (mouseEventX > sceneWidth - (double)this.border ? Cursor.E_RESIZE : (mouseEventY < (double)this.border ? Cursor.N_RESIZE : (mouseEventY > sceneHeight - (double)this.border ? Cursor.S_RESIZE : Cursor.DEFAULT)))))));
                scene.setCursor(this.cursorEvent);
            } else if (MouseEvent.MOUSE_EXITED.equals(mouseEventType) || MouseEvent.MOUSE_EXITED_TARGET.equals(mouseEventType)) {
                scene.setCursor(Cursor.DEFAULT);
            } else if (MouseEvent.MOUSE_PRESSED.equals(mouseEventType)) {
                this.startX = this.stage.getWidth() - mouseEventX;
                this.startY = this.stage.getHeight() - mouseEventY;
            } else if (MouseEvent.MOUSE_DRAGGED.equals(mouseEventType) && !Cursor.DEFAULT.equals(this.cursorEvent)) {
                if (!Cursor.W_RESIZE.equals(this.cursorEvent) && !Cursor.E_RESIZE.equals(this.cursorEvent)) {
                    double minHeight;
                    double d = minHeight = this.stage.getMinHeight() > (double)(this.border * 2) ? this.stage.getMinHeight() : (double)(this.border * 2);
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.N_RESIZE.equals(this.cursorEvent) || Cursor.NE_RESIZE.equals(this.cursorEvent)) {
                        if (this.stage.getHeight() > minHeight || mouseEventY < 0.0) {
                            this.stage.setHeight(this.stage.getY() - mouseEvent.getScreenY() + this.stage.getHeight());
                            this.stage.setY(mouseEvent.getScreenY());
                        }
                    } else if (this.stage.getHeight() > minHeight || mouseEventY + this.startY - this.stage.getHeight() > 0.0) {
                        this.stage.setHeight(mouseEventY + this.startY);
                    }
                }
                if (!Cursor.N_RESIZE.equals(this.cursorEvent) && !Cursor.S_RESIZE.equals(this.cursorEvent)) {
                    double minWidth;
                    double d = minWidth = this.stage.getMinWidth() > (double)(this.border * 2) ? this.stage.getMinWidth() : (double)(this.border * 2);
                    if (Cursor.NW_RESIZE.equals(this.cursorEvent) || Cursor.W_RESIZE.equals(this.cursorEvent) || Cursor.SW_RESIZE.equals(this.cursorEvent)) {
                        if (this.stage.getWidth() > minWidth || mouseEventX < 0.0) {
                            this.stage.setWidth(this.stage.getX() - mouseEvent.getScreenX() + this.stage.getWidth());
                            this.stage.setX(mouseEvent.getScreenX());
                        }
                    } else if (this.stage.getWidth() > minWidth || mouseEventX + this.startX - this.stage.getWidth() > 0.0) {
                        this.stage.setWidth(mouseEventX + this.startX);
                    }
                }
                mouseEvent.consume();
            }
        }

        public void setCurvedCorners(double curvedCornersMargin) {
            this.curvedCornersMargin = curvedCornersMargin;
        }
    }
}

