/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.Boot;
import bluej.Config;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerResult;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.RunOnThread;
import bluej.debugger.SourceLocation;
import bluej.debugger.jdi.JdiDebugger;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiVmCreationException;
import bluej.debugger.jdi.NetworkTest;
import bluej.debugger.jdi.VMEventHandler;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.FXPlatformSupplier;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class VMReference {
    static final String SERVER_CLASSNAME = ExecServer.class.getName();
    static final String SERVER_STARTED_METHOD_NAME = "vmStarted";
    static final String SERVER_SUSPEND_METHOD_NAME = "vmSuspend";
    public static final String SERVER_SHOW_TERMINAL_ON_INPUT_NAME = "showTerminalOnInput";
    private static Map<VirtualMachine, VMReference> vmToReferenceMap = new HashMap<VirtualMachine, VMReference>();
    private JdiDebugger owner = null;
    private DebuggerTerminal term;
    private VirtualMachine machine = null;
    private VMEventHandler eventHandler = null;
    private ClassType serverClass = null;
    private JdiThread serverThread = null;
    private boolean serverThreadStarted = false;
    private ThreadReference workerThread = null;
    private boolean workerThreadReady = false;
    private boolean workerThreadReserved = false;
    private @OnThread(value=Tag.Any) IOHandlerThread inputStreamRedirector = null;
    private @OnThread(value=Tag.Any) IOHandlerThread outputStreamRedirector = null;
    private @OnThread(value=Tag.Any) IOHandlerThread errorStreamRedirector = null;
    private ClassLoaderReference currentLoader = null;
    private int exitStatus;
    private @OnThread(value=Tag.Any) ExceptionDescription lastException;
    private boolean queuedForClose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public VirtualMachine localhostSocketLaunch(File initDir, URL[] libraries, DebuggerTerminal term, VirtualMachineManager mgr) {
        Writer dbgStream;
        boolean CONNECT_TRIES = true;
        int CONNECT_WAIT = 500;
        Boot boot = Boot.getInstance();
        List<File> filesPath = Utility.urlsToFiles(boot.getRuntimeUserClassPath());
        List<File> libraryPaths = Utility.urlsToFiles(libraries);
        ArrayList<File> classPath = new ArrayList<File>();
        classPath.addAll(filesPath);
        classPath.addAll(libraryPaths);
        String allClassPath = Utility.toClasspathString(classPath);
        ArrayList<Object> paramList = new ArrayList<Object>(11);
        paramList.add(Config.getJDKExecutablePath(null, "java"));
        paramList.addAll(Config.getDebugVMArgs());
        paramList.add("-classpath");
        paramList.add(allClassPath);
        if (Config.isMacOS()) {
            paramList.add("-Xdock:icon=" + Config.getBlueJIconPath() + "/" + Config.getVMIconsName());
            paramList.add("-Xdock:name=" + Config.getVMDockName());
        }
        int transportIndex = paramList.size();
        String streamEncoding = Config.getPropString("bluej.terminal.encoding", null);
        if (streamEncoding != null) {
            paramList.add("-Dfile.encoding=" + streamEncoding);
        }
        paramList.add(SERVER_CLASSNAME);
        if (streamEncoding != null) {
            paramList.add(streamEncoding);
        }
        String transport = Config.getPropString("bluej.vm.transport", "dt_socket");
        ArrayList<ListeningConnector> connectors = new ArrayList<ListeningConnector>(mgr.listeningConnectors());
        Iterator it = connectors.iterator();
        while (it.hasNext()) {
            ListeningConnector c = (ListeningConnector)it.next();
            if (!c.transport().name().equals(transport)) continue;
            it.remove();
            connectors.add(0, c);
            break;
        }
        Throwable[] failureReasons = new Throwable[connectors.size()];
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < connectors.size(); ++j) {
                ListeningConnector connector = (ListeningConnector)connectors.get(j);
                try {
                    Map<String, Connector.Argument> arguments = connector.defaultArguments();
                    Connector.Argument timeoutArg = arguments.get("timeout");
                    if (timeoutArg != null) {
                        String timeOutVal = Config.getPropString("bluej.vm.connect.timeout", "10000");
                        timeoutArg.setValue(timeOutVal);
                    }
                    String listenAddress = null;
                    if (connector.transport().name().equals("dt_socket") && arguments.containsKey("localAddress")) {
                        listenAddress = InetAddress.getByName(null).getHostAddress();
                        arguments.get("localAddress").setValue(listenAddress);
                    }
                    ListeningConnector listeningConnector = connector;
                    synchronized (listeningConnector) {
                        Process remoteVMprocess;
                        int colonIndex;
                        Object address = connector.startListening(arguments);
                        if (listenAddress != null && (colonIndex = ((String)address).lastIndexOf(58)) != -1) {
                            address = listenAddress + ((String)address).substring(colonIndex);
                        }
                        Debug.log(System.currentTimeMillis() + ": Listening for JDWP connection on address: " + (String)address);
                        paramList.add(transportIndex, "-agentlib:jdwp=transport=" + connector.transport().name() + ",address=" + (String)address);
                        String[] launchParams = paramList.toArray(new String[paramList.size()]);
                        paramList.remove(transportIndex);
                        try {
                            remoteVMprocess = this.launchVM(initDir, launchParams);
                        }
                        catch (Throwable t) {
                            connector.stopListening(arguments);
                            throw t;
                        }
                        try {
                            this.machine = connector.accept(arguments);
                            this.redirectToTerminal(term, remoteVMprocess, streamEncoding);
                        }
                        catch (Throwable t) {
                            this.closeIO();
                            try {
                                int exitCode = remoteVMprocess.exitValue();
                                Debug.log(System.currentTimeMillis() + ": remote VM process has prematurely terminated with exit code: " + exitCode);
                                this.drainOutput(remoteVMprocess);
                            }
                            catch (IllegalThreadStateException illegalThreadStateException) {
                                // empty catch block
                            }
                            remoteVMprocess.destroy();
                            throw t;
                        }
                        finally {
                            connector.stopListening(arguments);
                        }
                    }
                    Debug.log("Connected to debug VM via " + connector.transport().name() + " transport...");
                    this.setupEventHandling();
                    if (this.waitForStartup()) {
                        Debug.log("Communication with debug VM fully established.");
                        return this.machine;
                    }
                    Debug.log("Error: Debug VM not signalling startup.");
                    continue;
                }
                catch (Throwable t) {
                    failureReasons[j] = t;
                }
            }
            try {
                if (i == 0) continue;
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        Writer writer = dbgStream = Debug.getDebugStream();
        synchronized (writer) {
            Debug.message(System.currentTimeMillis() + ": Failed to connect to debug VM. Reasons follow:");
            for (int i = 0; i < connectors.size(); ++i) {
                Debug.message(((ListeningConnector)connectors.get(i)).transport().name() + " transport:");
                PrintWriter pw = new PrintWriter(dbgStream);
                failureReasons[i].printStackTrace(pw);
                pw.flush();
            }
        }
        NetworkTest.doTest();
        return null;
    }

    private void drainOutput(Process remoteVMprocess) {
        InputStreamReader stdout = new InputStreamReader(remoteVMprocess.getInputStream());
        char[] charBuf = new char[2048];
        try {
            InputStreamReader stderr;
            int numRead = stdout.read(charBuf);
            if (numRead != -1) {
                String output = new String(charBuf, 0, numRead);
                Debug.message("Output from remote process stdout: " + output);
            }
            if ((numRead = (stderr = new InputStreamReader(remoteVMprocess.getErrorStream())).read(charBuf)) != -1) {
                String output = new String(charBuf, 0, numRead);
                Debug.message("Output from remote process stderr: " + output);
            }
        }
        catch (IOException ioe) {
            Debug.message("IOException while trying to draing stdout/stderr of remote process: " + ioe.getMessage());
        }
    }

    private void setupEventHandling() {
        EventRequestManager erm = this.machine.eventRequestManager();
        erm.createExceptionRequest(null, false, true).enable();
        erm.createClassPrepareRequest().enable();
        EventRequest tsr = erm.createThreadStartRequest();
        tsr.setSuspendPolicy(0);
        tsr.enable();
        tsr = erm.createThreadDeathRequest();
        tsr.setSuspendPolicy(0);
        tsr.enable();
        this.eventHandler = new VMEventHandler(this, this.machine);
    }

    @OnThread(value=Tag.Any)
    private Process launchVM(File initDir, String[] params) throws IOException {
        Process vmProcess = Runtime.getRuntime().exec(params, null, initDir);
        BufferedReader bro = new BufferedReader(new InputStreamReader(vmProcess.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(vmProcess.getErrorStream()));
        try {
            StringBuffer extraOut = new StringBuffer();
            StringBuffer extraErr = new StringBuffer();
            char[] buf = new char[1024];
            Thread.sleep(200L);
            for (int i = 0; i < 5; ++i) {
                int len;
                Thread.sleep(200L);
                boolean keepReading = false;
                if (bro.ready()) {
                    len = bro.read(buf);
                    if (len != -1) {
                        extraOut.append(buf, 0, len);
                    }
                    keepReading = true;
                }
                if (bre.ready()) {
                    len = bre.read(buf);
                    if (len != -1) {
                        extraErr.append(buf, 0, len);
                    }
                    keepReading = true;
                }
                if (!keepReading) break;
            }
            if (extraOut.length() != 0) {
                Debug.message("Extra output from debug VM on launch:" + extraOut);
            }
            if (extraErr.length() != 0) {
                Debug.message("Error output from debug VM on launch:" + extraErr);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return vmProcess;
    }

    @OnThread(value=Tag.Any)
    private void redirectToTerminal(DebuggerTerminal term, Process vmProcess, String streamEncoding) throws UnsupportedEncodingException {
        InputStreamReader errorReader = null;
        InputStreamReader outReader = null;
        OutputStreamWriter inputWriter = null;
        if (streamEncoding == null) {
            errorReader = new InputStreamReader(vmProcess.getErrorStream());
            outReader = new InputStreamReader(vmProcess.getInputStream());
            inputWriter = new OutputStreamWriter(vmProcess.getOutputStream());
        } else {
            errorReader = new InputStreamReader(vmProcess.getErrorStream(), streamEncoding);
            outReader = new InputStreamReader(vmProcess.getInputStream(), streamEncoding);
            inputWriter = new OutputStreamWriter(vmProcess.getOutputStream(), streamEncoding);
        }
        this.errorStreamRedirector = this.redirectIOStream(errorReader, term.getErrorWriter());
        this.outputStreamRedirector = this.redirectIOStream(outReader, term.getWriter());
        this.inputStreamRedirector = this.redirectIOStream(term.getReader(), inputWriter);
    }

    @OnThread(value=Tag.Any)
    public VMReference(JdiDebugger owner, DebuggerTerminal term, File initialDirectory, URL[] libraries) throws JdiVmCreationException {
        this.owner = owner;
        this.term = term;
        this.machine = this.localhostSocketLaunch(initialDirectory, libraries, term, Bootstrap.virtualMachineManager());
        if (this.machine == null) {
            throw new JdiVmCreationException();
        }
        vmToReferenceMap.put(this.machine, this);
    }

    public synchronized boolean waitForStartup() {
        this.serverThreadStartWait();
        return this.setupServerConnection(this.machine);
    }

    @OnThread(value=Tag.Any)
    public synchronized void close() {
        if (this.machine != null) {
            this.queuedForClose = true;
            this.closeIO();
            try {
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(4));
                this.machine.dispose();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void closeIO() {
        if (this.inputStreamRedirector != null) {
            this.inputStreamRedirector.close();
            this.inputStreamRedirector.interrupt();
        }
        if (this.errorStreamRedirector != null) {
            this.errorStreamRedirector.close();
            this.errorStreamRedirector.interrupt();
        }
        if (this.outputStreamRedirector != null) {
            this.outputStreamRedirector.close();
            this.outputStreamRedirector.interrupt();
        }
    }

    void serverClassPrepared() {
        EventRequestManager erm = this.machine.eventRequestManager();
        List<ClassPrepareRequest> list = erm.classPrepareRequests();
        erm.deleteEventRequests(list);
        try {
            this.serverClass = (ClassType)this.findClassByName(SERVER_CLASSNAME, null);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("can't find class " + SERVER_CLASSNAME + " in debug virtual machine");
        }
        this.serverClassAddBreakpoints();
    }

    private Location findMethodLocation(ReferenceType classType, String methodName) {
        Method method = this.findMethodByName(classType, methodName);
        if (method == null) {
            throw new IllegalStateException("can't find method " + classType.name() + "." + methodName);
        }
        return method.location();
    }

    private void serverClassAddBreakpoints() {
        EventRequestManager erm = this.machine.eventRequestManager();
        BreakpointRequest serverBreakpoint = erm.createBreakpointRequest(this.findMethodLocation(this.serverClass, SERVER_STARTED_METHOD_NAME));
        serverBreakpoint.setSuspendPolicy(1);
        serverBreakpoint.putProperty(SERVER_STARTED_METHOD_NAME, "yes");
        serverBreakpoint.putProperty("dontResume", "yes");
        serverBreakpoint.putProperty("VMReference.PERSIST_BREAKPOINT", "yes");
        serverBreakpoint.enable();
        BreakpointRequest workerBreakpoint = erm.createBreakpointRequest(this.findMethodLocation(this.serverClass, SERVER_SUSPEND_METHOD_NAME));
        workerBreakpoint.setSuspendPolicy(1);
        workerBreakpoint.putProperty(SERVER_SUSPEND_METHOD_NAME, "yes");
        workerBreakpoint.putProperty("dontResume", "yes");
        workerBreakpoint.putProperty("VMReference.PERSIST_BREAKPOINT", "yes");
        workerBreakpoint.enable();
        serverBreakpoint = erm.createBreakpointRequest(this.findMethodLocation(this.serverClass, SERVER_SHOW_TERMINAL_ON_INPUT_NAME));
        serverBreakpoint.setSuspendPolicy(0);
        serverBreakpoint.putProperty(SERVER_SHOW_TERMINAL_ON_INPUT_NAME, "yes");
        serverBreakpoint.putProperty("VMReference.PERSIST_BREAKPOINT", "yes");
        serverBreakpoint.enable();
    }

    private boolean setupServerConnection(VirtualMachine vm) {
        if (this.serverClass == null) {
            Debug.reportError("server class not initialised!");
            return false;
        }
        this.workerThread = (ThreadReference)this.getStaticFieldObject(this.serverClass, "workerThread");
        if (this.serverThread == null || this.workerThread == null) {
            Debug.reportError("Cannot find fields on remote VM");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    ClassLoaderReference newClassLoader(URL[] urls) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.workerThreadReserved = true;
            this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(3));
            StringBuffer newcpath = new StringBuffer(200);
            for (int index = 0; index < urls.length; ++index) {
                newcpath.append(urls[index].toString());
                newcpath.append('\n');
            }
            this.setStaticFieldObject(this.serverClass, "classPath", newcpath.toString());
            this.workerThreadReady = false;
            this.workerThread.resume();
            this.workerThreadFinishWait();
            this.currentLoader = (ClassLoaderReference)this.getStaticFieldObject(this.serverClass, "workerReturn");
            this.workerThreadReserved = false;
            this.workerThread.notify();
            return this.currentLoader;
        }
    }

    public StringReference getMirror(String value) {
        return this.machine.mirrorOf(value);
    }

    @OnThread(value=Tag.NOTVMEventHandler)
    ReferenceType loadClass(String className) throws ClassNotFoundException {
        ReferenceType rt = this.loadClass(className, null);
        if (rt == null) {
            throw new ClassNotFoundException(className);
        }
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.NOTVMEventHandler)
    ReferenceType loadClass(String className, ClassLoaderReference clr) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.workerThreadReserved = true;
            this.setStaticFieldValue(this.serverClass, "classLoader", clr);
            this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(2));
            this.setStaticFieldObject(this.serverClass, "className", className);
            this.workerThreadReady = false;
            this.workerThread.resume();
            this.workerThreadFinishWait();
            ClassObjectReference robject = (ClassObjectReference)this.getStaticFieldObject(this.serverClass, "workerReturn");
            this.workerThreadReserved = false;
            this.workerThread.notify();
            if (robject == null) {
                return null;
            }
            return robject.reflectedType();
        }
    }

    ReferenceType loadInitClass(String className) throws ClassNotFoundException {
        try {
            this.serverThreadStartWait();
            this.setStaticFieldObject(this.serverClass, "classToRun", className);
            this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(5));
            this.serverThreadStarted = false;
            this.resumeServerThread();
            this.serverThreadStartWait();
            ClassObjectReference rval = (ClassObjectReference)this.getStaticFieldObject(this.serverClass, "methodReturn");
            if (rval == null) {
                throw new ClassNotFoundException("Remote class not found: " + className);
            }
            ObjectReference exception = this.getStaticFieldObject(this.serverClass, "exception");
            if (exception != null) {
                this.exceptionEvent(new InvocationException(exception));
            }
            return rval.reflectedType();
        }
        catch (VMDisconnectedException vde) {
            throw new ClassNotFoundException("Remote class not loaded due to VM termination.");
        }
    }

    @OnThread(value=Tag.NOTVMEventHandler)
    public DebuggerResult runShellClass(String className) {
        try {
            ObjectReference exception;
            this.exitStatus = 0;
            this.serverThreadStartWait();
            this.setStaticFieldObject(this.serverClass, "classToRun", className);
            this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(0));
            this.serverThreadStarted = false;
            this.resumeServerThread();
            this.serverThreadStartWait();
            ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
            if (rval == null && (exception = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
                this.exceptionEvent(new InvocationException(exception));
                return new DebuggerResult(this.lastException);
            }
            ObjectReference objR = this.getStaticFieldObject(this.serverClass, "methodReturn");
            return new DebuggerResult(JdiObject.getDebuggerObject(objR));
        }
        catch (VMDisconnectedException e) {
            this.exitStatus = this.getDebuggerExitStatus();
            return new DebuggerResult(this.exitStatus);
        }
        catch (Exception e) {
            Debug.reportError("starting shell class failed: " + e);
            e.printStackTrace();
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription("Internal BlueJ error: unexpected exception in remote VM\n" + e);
            return new DebuggerResult(this.lastException);
        }
    }

    private int getDebuggerExitStatus() {
        return this.queuedForClose ? 4 : 3;
    }

    @OnThread(value=Tag.NOTVMEventHandler)
    public DebuggerResult instantiateClass(String className) {
        ObjectReference obj = null;
        this.exitStatus = 0;
        try {
            obj = this.invokeConstructor(className);
        }
        catch (VMDisconnectedException e) {
            this.exitStatus = this.getDebuggerExitStatus();
            return new DebuggerResult(this.exitStatus);
        }
        catch (Exception e) {
            Debug.reportError("starting shell class failed: " + e);
            e.printStackTrace();
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription("Internal BlueJ error: unexpected exception in remote VM\n" + e);
        }
        if (obj == null) {
            return new DebuggerResult(this.lastException);
        }
        ObjectReference objFinal = obj;
        return new DebuggerResult(JdiObject.getDebuggerObject(objFinal));
    }

    @OnThread(value=Tag.NOTVMEventHandler)
    public DebuggerResult instantiateClass(String className, String[] paramTypes, ObjectReference[] args) {
        ObjectReference obj = null;
        this.exitStatus = 0;
        try {
            obj = this.invokeConstructor(className, paramTypes, args);
        }
        catch (VMDisconnectedException e) {
            this.exitStatus = this.getDebuggerExitStatus();
            return new DebuggerResult(this.exitStatus);
        }
        catch (Exception e) {
            Debug.reportError("starting shell class failed: " + e);
            e.printStackTrace();
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription("Internal BlueJ error: unexpected exception in remote VM\n" + e);
        }
        if (obj == null) {
            return new DebuggerResult(this.lastException);
        }
        ObjectReference objFinal = obj;
        return new DebuggerResult(JdiObject.getDebuggerObject(objFinal));
    }

    @OnThread(value=Tag.Any)
    public void emitThreadEvent(JdiThread thread, boolean halted) {
        this.eventHandler.emitThreadEvent(thread, halted);
    }

    public ExceptionDescription getException() {
        return this.lastException;
    }

    public void vmStartEvent(VMStartEvent vmse) {
        this.serverThreadStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.VMEventHandler)
    public void vmDisconnectEvent() {
        Object object = this;
        synchronized (object) {
            this.owner.vmDisconnect();
            this.exitStatus = this.getDebuggerExitStatus();
            if (!this.serverThreadStarted) {
                this.notifyAll();
            }
        }
        if (this.workerThread != null) {
            object = this.workerThread;
            synchronized (object) {
                if (!this.workerThreadReady) {
                    this.workerThread.notifyAll();
                }
            }
        }
        object = vmToReferenceMap;
        synchronized (object) {
            vmToReferenceMap.remove(this.machine);
        }
    }

    @OnThread(value=Tag.VMEventHandler)
    public void threadStartEvent(ThreadStartEvent tse) {
        this.owner.threadStart(tse.thread());
    }

    @OnThread(value=Tag.VMEventHandler)
    public void threadDeathEvent(ThreadDeathEvent tde) {
        ThreadReference tr = tde.thread();
        this.owner.threadDeath(tr);
    }

    @OnThread(value=Tag.VMEventHandler)
    public void threadHaltedEvent(JdiThread thread) {
        this.owner.threadHalted(thread);
    }

    @OnThread(value=Tag.VMEventHandler)
    public void threadResumedEvent(JdiThread thread) {
        this.owner.threadResumed(thread);
    }

    public void exceptionEvent(ExceptionEvent exc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value safeInvoke(ObjectReference o, Method m, List<? extends Value> args) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            Value v = null;
            try {
                v = o.invokeMethod(this.workerThread, m, args, 1);
            }
            catch (ClassNotLoadedException classNotLoadedException) {
            }
            catch (InvalidTypeException invalidTypeException) {
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            }
            catch (InvocationException invocationException) {
                // empty catch block
            }
            return v;
        }
    }

    public void exceptionEvent(InvocationException exc) {
        Field msgField;
        LinkedList empty = new LinkedList();
        ObjectReference remoteException = exc.exception();
        StringReference msgVal = (StringReference)remoteException.getValue(msgField = remoteException.referenceType().fieldByName("detailMessage"));
        String exceptionText = msgVal == null ? null : msgVal.value();
        String excClass = exc.exception().type().name();
        ReferenceType remoteType = exc.exception().referenceType();
        List<Method> getStackTraceMethods = remoteType.methodsByName("getStackTrace");
        Method getStackTrace = getStackTraceMethods.get(0);
        ArrayReference stackValue = (ArrayReference)this.safeInvoke(exc.exception(), getStackTrace, empty);
        ObjectReference[] stackt = stackValue.getValues().toArray(new ObjectReference[0]);
        LinkedList<SourceLocation> stack = new LinkedList<SourceLocation>();
        if (stackt.length > 0) {
            ReferenceType StackTraceElementType = (ReferenceType)stackt[0].type();
            Method getClassName = StackTraceElementType.methodsByName("getClassName").get(0);
            Method getFileName = StackTraceElementType.methodsByName("getFileName").get(0);
            Method getLineNum = StackTraceElementType.methodsByName("getLineNumber").get(0);
            Method getMethodName = StackTraceElementType.methodsByName("getMethodName").get(0);
            for (int i = 0; i < stackt.length; ++i) {
                Value classNameV = this.safeInvoke(stackt[i], getClassName, empty);
                Value fileNameV = this.safeInvoke(stackt[i], getFileName, empty);
                Value methodNameV = this.safeInvoke(stackt[i], getMethodName, empty);
                Value lineNumV = this.safeInvoke(stackt[i], getLineNum, empty);
                String className = ((StringReference)classNameV).value();
                String fileName = null;
                if (fileNameV != null) {
                    fileName = ((StringReference)fileNameV).value();
                }
                String methodName = ((StringReference)methodNameV).value();
                int lineNumber = ((IntegerValue)lineNumV).value();
                stack.add(new SourceLocation(className, fileName, methodName, lineNumber));
            }
        }
        this.exitStatus = 2;
        this.lastException = new ExceptionDescription(excClass, exceptionText, stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.VMEventHandler)
    public void breakpointEvent(LocatableEvent event, int debuggerEventType, boolean skipUpdate) {
        if (event.request().getProperty(SERVER_STARTED_METHOD_NAME) != null) {
            VMReference vMReference = this;
            synchronized (vMReference) {
                this.serverThreadStarted = true;
                this.serverThread = this.owner.findThread(event.thread());
                this.owner.raiseStateChangeEvent(2);
                this.notifyAll();
            }
        }
        if (event.request().getProperty(SERVER_SUSPEND_METHOD_NAME) != null) {
            if (this.workerThread == null) {
                this.workerThread = event.thread();
            }
            ThreadReference threadReference = this.workerThread;
            synchronized (threadReference) {
                this.workerThreadReady = true;
                this.workerThread.notifyAll();
            }
        }
        if (event.request().getProperty(SERVER_SHOW_TERMINAL_ON_INPUT_NAME) != null) {
            this.term.showOnInput();
        } else {
            String fileName;
            if (this.serverThread.sameThread(event.thread())) {
                this.owner.raiseStateChangeEvent(4);
            }
            Location location = event.location();
            String className = location.declaringType().name();
            try {
                fileName = location.sourceName();
            }
            catch (AbsentInformationException e) {
                fileName = null;
            }
            if (fileName != null && fileName.startsWith("__SHELL") || className != null && className.startsWith("bluej.runtime.")) {
                event.thread().resume();
                return;
            }
            this.owner.breakpoint(event.thread(), debuggerEventType, skipUpdate, this.makeBreakpointProperties(event.request()));
        }
    }

    private DebuggerEvent.BreakpointProperties makeBreakpointProperties(final EventRequest request) {
        if (request == null) {
            return null;
        }
        return new DebuggerEvent.BreakpointProperties(){

            @Override
            @OnThread(value=Tag.Any)
            public Object get(Object key) {
                return request.getProperty(key);
            }
        };
    }

    @OnThread(value=Tag.VMEventHandler)
    public boolean screenBreakpointEvent(LocatableEvent event, int debuggerEventType) {
        DebuggerEvent.BreakpointProperties props = this.makeBreakpointProperties(event.request());
        for (String special : Arrays.asList(SERVER_STARTED_METHOD_NAME, SERVER_SUSPEND_METHOD_NAME, SERVER_SHOW_TERMINAL_ON_INPUT_NAME)) {
            if (props.get(special) == null) continue;
            return true;
        }
        return this.owner.screenBreakpoint(event.thread(), debuggerEventType, props);
    }

    @OnThread(value=Tag.FXPlatform)
    private Location loadClassesAndFindLine(String className, int line) {
        ReferenceType remoteClass = null;
        try {
            remoteClass = this.loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        ArrayList<ReferenceType> allTypesInFile = new ArrayList<ReferenceType>();
        this.buildNestedTypes(remoteClass, allTypesInFile);
        for (ReferenceType r : allTypesInFile) {
            try {
                List<Location> list = r.locationsOfLine(line);
                if (list.size() <= 0) continue;
                return list.get(0);
            }
            catch (AbsentInformationException absentInformationException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNestedTypes(ReferenceType rootType, List<ReferenceType> l) {
        try {
            ThreadReference threadReference = this.workerThread;
            synchronized (threadReference) {
                this.workerThreadReadyWait();
                this.workerThreadReserved = true;
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(5));
                this.setStaticFieldObject(this.serverClass, "className", rootType.name());
                this.workerThreadReady = false;
                this.workerThread.resume();
                this.workerThreadFinishWait();
                ObjectReference or = this.getStaticFieldObject(this.serverClass, "workerReturn");
                this.workerThreadReserved = false;
                this.workerThread.notify();
                ArrayReference inners = (ArrayReference)or;
                for (ClassObjectReference classObjectReference : inners.getValues()) {
                    ReferenceType rt = classObjectReference.reflectedType();
                    if (!rt.isPrepared()) continue;
                    l.add(rt);
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (VMMismatchException vMMismatchException) {
            // empty catch block
        }
    }

    @OnThread(value=Tag.FXPlatform)
    boolean setBreakpoint(String className, int line, Map<String, String> properties) {
        Location location = this.loadClassesAndFindLine(className, line);
        if (location == null) {
            return false;
        }
        EventRequestManager erm = this.machine.eventRequestManager();
        BreakpointRequest bpreq = erm.createBreakpointRequest(location);
        bpreq.setSuspendPolicy(1);
        bpreq.putProperty("dontResume", "yes");
        if (properties != null) {
            for (Map.Entry<String, String> property : properties.entrySet()) {
                bpreq.putProperty(property.getKey(), property.getValue());
            }
        }
        bpreq.enable();
        return true;
    }

    String setBreakpoint(ReferenceType classType, int line, Map<String, String> properties) {
        try {
            List<Location> locations = classType.locationsOfLine(line);
            if (locations.isEmpty()) {
                return Config.getString("debugger.jdiDebugger.noCodeMsg");
            }
            this.setBreakpoint(locations.get(0), properties);
            return null;
        }
        catch (AbsentInformationException aie) {
            return Config.getString("debugger.jdiDebugger.noCodeMsg");
        }
    }

    void setBreakpoint(Location location, Map<String, String> properties) {
        EventRequestManager erm = this.machine.eventRequestManager();
        BreakpointRequest bpreq = erm.createBreakpointRequest(location);
        bpreq.setSuspendPolicy(1);
        bpreq.putProperty("dontResume", "yes");
        if (properties != null) {
            for (Map.Entry<String, String> property : properties.entrySet()) {
                bpreq.putProperty(property.getKey(), property.getValue());
            }
        }
        bpreq.enable();
    }

    @OnThread(value=Tag.FXPlatform)
    boolean setBreakpoint(String className, String methodName, Map<String, String> properties) {
        try {
            this.loadClass(className);
            ClassType classType = (ClassType)this.findClassByName(className);
            Location loc = this.findMethodLocation(classType, methodName);
            return this.setBreakpoint(className, loc.lineNumber(), properties);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    boolean setBreakpoint(ReferenceType classType, String methodName, Map<String, String> properties) {
        Location loc = this.findMethodLocation(classType, methodName);
        this.setBreakpoint(loc, properties);
        return true;
    }

    @OnThread(value=Tag.FXPlatform)
    boolean clearBreakpoint(String className, int line) {
        Location location = this.loadClassesAndFindLine(className, line);
        if (location == null) {
            return false;
        }
        return this.clearBreakpoint(location);
    }

    boolean clearBreakpoint(String className, String methodName) {
        try {
            ClassType classType = (ClassType)this.findClassByName(className);
            Location loc = this.findMethodLocation(classType, methodName);
            return this.clearBreakpoint(loc);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    boolean clearBreakpoint(ReferenceType classType, String methodName) {
        Location loc = this.findMethodLocation(classType, methodName);
        return this.clearBreakpoint(loc);
    }

    boolean clearBreakpoint(Location location) {
        EventRequestManager erm = this.machine.eventRequestManager();
        List<BreakpointRequest> list = erm.breakpointRequests();
        for (int i = 0; i < list.size(); ++i) {
            BreakpointRequest bp = list.get(i);
            if (!bp.location().equals(location)) continue;
            erm.deleteEventRequest(bp);
        }
        return false;
    }

    public void clearAllBreakpoints() {
        EventRequestManager erm = this.machine.eventRequestManager();
        LinkedList<BreakpointRequest> breaks = new LinkedList<BreakpointRequest>();
        List<BreakpointRequest> allBreakpoints = erm.breakpointRequests();
        for (BreakpointRequest bp : allBreakpoints) {
            if (bp.getProperty("VMReference.PERSIST_BREAKPOINT") != null) continue;
            breaks.add(bp);
        }
        erm.deleteEventRequests(breaks);
    }

    public void clearBreakpointsForClass(String className) {
        EventRequestManager erm = this.machine.eventRequestManager();
        List<BreakpointRequest> allBreakpoints = erm.breakpointRequests();
        Iterator<BreakpointRequest> it = allBreakpoints.iterator();
        LinkedList<BreakpointRequest> toDelete = new LinkedList<BreakpointRequest>();
        while (it.hasNext()) {
            BreakpointRequest bp = it.next();
            ReferenceType bpType = bp.location().declaringType();
            if (!bpType.name().equals(className) || bp.getProperty("VMReference.PERSIST_BREAKPOINT") != null) continue;
            toDelete.add(bp);
        }
        erm.deleteEventRequests(toDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverThreadStartWait() {
        VMReference vMReference = this;
        synchronized (vMReference) {
            try {
                while (!this.serverThreadStarted) {
                    if (this.exitStatus == 4 || this.exitStatus == 3) {
                        throw new VMDisconnectedException();
                    }
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeServerThread() {
        VMEventHandler vMEventHandler = this.eventHandler;
        synchronized (vMEventHandler) {
            this.serverThread.contServerThread();
            this.owner.raiseStateChangeEvent(3);
        }
    }

    private void workerThreadReadyWait() {
        try {
            while (!this.workerThreadReady || this.workerThreadReserved) {
                if (this.exitStatus == 4 || this.exitStatus == 3) {
                    throw new VMDisconnectedException();
                }
                this.workerThread.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void workerThreadFinishWait() {
        try {
            while (!this.workerThreadReady) {
                if (this.exitStatus == 4 || this.exitStatus == 3) {
                    throw new VMDisconnectedException();
                }
                this.workerThread.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public FXPlatformSupplier<DebuggerResult> launchFXApp(String className) {
        ObjectReference obj = null;
        this.exitStatus = 0;
        try {
            obj = this.launchFXAppHelper(className);
        }
        catch (VMDisconnectedException e) {
            this.exitStatus = this.getDebuggerExitStatus();
            return () -> new DebuggerResult(this.exitStatus);
        }
        catch (Exception e) {
            Debug.reportError("Launch FX app failed: " + e);
            e.printStackTrace();
            this.exitStatus = 2;
            this.lastException = new ExceptionDescription("Internal BlueJ error: unexpected exception in remote VM\n" + e);
        }
        if (obj == null) {
            return () -> new DebuggerResult(this.lastException);
        }
        ObjectReference objFinal = obj;
        return () -> new DebuggerResult(JdiObject.getDebuggerObject(objFinal));
    }

    private ObjectReference launchFXAppHelper(String className) {
        ObjectReference exception;
        this.serverThreadStartWait();
        this.setStaticFieldObject(this.serverClass, "classToRun", className);
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(8));
        this.serverThreadStarted = false;
        this.resumeServerThread();
        this.serverThreadStartWait();
        ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
        if (rval == null && (exception = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
            this.exceptionEvent(new InvocationException(exception));
        }
        return rval;
    }

    private ObjectReference invokeConstructor(String className) {
        ObjectReference exception;
        this.serverThreadStartWait();
        this.setStaticFieldObject(this.serverClass, "classToRun", className);
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(6));
        this.serverThreadStarted = false;
        this.resumeServerThread();
        this.serverThreadStartWait();
        ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
        if (rval == null && (exception = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
            this.exceptionEvent(new InvocationException(exception));
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.NOTVMEventHandler)
    private ObjectReference invokeConstructor(String className, String[] paramTypes, ObjectReference[] args) {
        this.serverThreadStartWait();
        boolean needsMachineResume = false;
        try {
            ObjectReference exception;
            int length = paramTypes.length;
            if (args.length != length) {
                throw new IllegalArgumentException();
            }
            ArrayType objectArray = (ArrayType)this.loadClass("[Ljava.lang.Object;");
            ArrayType stringArray = (ArrayType)this.loadClass("[Ljava.lang.String;");
            this.machine.suspend();
            needsMachineResume = true;
            ArrayReference argsArray = objectArray.newInstance(length);
            ArrayReference typesArray = stringArray.newInstance(length);
            while (true) {
                try {
                    argsArray.disableCollection();
                }
                catch (ObjectCollectedException oce) {
                    argsArray = objectArray.newInstance(length);
                    continue;
                }
                break;
            }
            while (true) {
                try {
                    typesArray.disableCollection();
                }
                catch (ObjectCollectedException oce) {
                    typesArray = stringArray.newInstance(length);
                    continue;
                }
                break;
            }
            for (int i = 0; i < length; ++i) {
                StringReference s = this.machine.mirrorOf(paramTypes[i]);
                typesArray.setValue(i, (Value)s);
                argsArray.setValue(i, (Value)args[i]);
            }
            this.setStaticFieldValue(this.serverClass, "parameterTypes", typesArray);
            this.setStaticFieldValue(this.serverClass, "arguments", argsArray);
            typesArray.enableCollection();
            argsArray.enableCollection();
            this.setStaticFieldObject(this.serverClass, "classToRun", className);
            this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(7));
            this.machine.resume();
            needsMachineResume = false;
            this.serverThreadStarted = false;
            this.resumeServerThread();
            this.serverThreadStartWait();
            ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
            if (rval == null && (exception = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
                this.exceptionEvent(new InvocationException(exception));
            }
            ObjectReference objectReference = rval;
            return objectReference;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ClassNotLoadedException classNotLoadedException) {
        }
        catch (InvalidTypeException invalidTypeException) {
        }
        finally {
            if (needsMachineResume) {
                this.machine.resume();
            }
        }
        return null;
    }

    public Value invokeTestSetup(String cl) throws InvocationException {
        ObjectReference e;
        this.serverThreadStartWait();
        this.setStaticFieldObject(this.serverClass, "classToRun", cl);
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(1));
        this.serverThreadStarted = false;
        this.resumeServerThread();
        this.serverThreadStartWait();
        ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
        if (rval == null && (e = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
            this.exceptionEvent(new InvocationException(e));
            throw new InvocationException(e);
        }
        return rval;
    }

    public Value invokeRunTest(String cl, String method) throws InvocationException {
        ObjectReference e;
        this.serverThreadStartWait();
        this.setStaticFieldObject(this.serverClass, "classToRun", cl);
        this.setStaticFieldObject(this.serverClass, "methodToRun", method);
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(2));
        this.serverThreadStarted = false;
        this.resumeServerThread();
        this.serverThreadStartWait();
        ObjectReference rval = this.getStaticFieldObject(this.serverClass, "methodReturn");
        if (rval == null && (e = this.getStaticFieldObject(this.serverClass, "exception")) != null) {
            this.exceptionEvent(new InvocationException(e));
            throw new InvocationException(e);
        }
        return rval;
    }

    void disposeWindows() {
        this.serverThreadStartWait();
        this.setStaticFieldValue(this.serverClass, "execAction", this.machine.mirrorOf(3));
        this.serverThreadStarted = false;
        this.resumeServerThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addObject(String scopeId, String instanceName, ObjectReference object) {
        try {
            ThreadReference threadReference = this.workerThread;
            synchronized (threadReference) {
                this.workerThreadReadyWait();
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(1));
                this.setStaticFieldObject(this.serverClass, "objectName", instanceName);
                this.setStaticFieldValue(this.serverClass, "object", object);
                this.setStaticFieldObject(this.serverClass, "scopeId", scopeId);
                this.workerThreadReady = false;
                this.workerThread.resume();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (VMMismatchException vMMismatchException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeObject(String scopeId, String instanceName) {
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            try {
                this.workerThreadReadyWait();
                this.setStaticFieldValue(this.serverClass, "workerAction", this.machine.mirrorOf(0));
                this.setStaticFieldObject(this.serverClass, "objectName", instanceName);
                this.setStaticFieldObject(this.serverClass, "scopeId", scopeId);
                this.workerThreadReady = false;
                this.workerThread.resume();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    static boolean isAtMainBreakpoint(ThreadReference tr) {
        try {
            return tr.isAtBreakpoint() && SERVER_CLASSNAME.equals(tr.frame(0).location().declaringType().name());
        }
        catch (IncompatibleThreadStateException e) {
            return false;
        }
    }

    ObjectReference getStaticFieldObject(ClassType cl, String fieldName) {
        Field resultField = cl.fieldByName(fieldName);
        if (resultField == null) {
            throw new IllegalArgumentException("getting field " + fieldName + " resulted in no fields");
        }
        return (ObjectReference)cl.getValue(resultField);
    }

    void setStaticFieldValue(ClassType cl, String fieldName, Value value) {
        Field field = cl.fieldByName(fieldName);
        try {
            cl.setValue(field, value);
        }
        catch (InvalidTypeException invalidTypeException) {
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
    }

    void setStaticFieldObject(ClassType cl, String fieldName, String value) {
        try {
            StringReference s = null;
            if (value != null) {
                s = this.machine.mirrorOf(value);
                s.disableCollection();
            }
            this.setStaticFieldValue(cl, fieldName, s);
            if (value != null) {
                s.enableCollection();
            }
        }
        catch (ObjectCollectedException oce) {
            this.machine.suspend();
            if (value != null) {
                StringReference s = this.machine.mirrorOf(value);
                this.setStaticFieldValue(cl, fieldName, s);
            }
            this.machine.resume();
        }
    }

    private ReferenceType findClassByName(String className, ClassLoaderReference clr) throws ClassNotFoundException {
        List<ReferenceType> list = this.machine.classesByName(className);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() > 1) {
            for (ReferenceType cl : list) {
                if (cl.classLoader() != clr) continue;
                return cl;
            }
        }
        throw new ClassNotFoundException(className);
    }

    public ReferenceType findClassByName(String className) throws ClassNotFoundException {
        return this.findClassByName(className, this.currentLoader);
    }

    Method findMethodByName(ReferenceType type, String methodName) {
        List<Method> list = type.methodsByName(methodName);
        if (list.size() != 1) {
            throw new IllegalArgumentException("getting method " + methodName + " resulted in " + list.size() + " methods");
        }
        return list.get(0);
    }

    private IOHandlerThread redirectIOStream(Reader reader, Writer writer) {
        IOHandlerThread thr = new IOHandlerThread(reader, writer);
        thr.setPriority(9);
        thr.start();
        return thr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunOnThread(RunOnThread runOnThread) {
        if (Config.isGreenfoot()) {
            return;
        }
        int fieldValue = switch (runOnThread) {
            case RunOnThread.FX -> 1;
            case RunOnThread.SWING -> 2;
            default -> 0;
        };
        ThreadReference threadReference = this.workerThread;
        synchronized (threadReference) {
            this.workerThreadReadyWait();
            this.setStaticFieldValue(this.serverClass, "threadToRunOn", this.machine.mirrorOf(fieldValue));
        }
    }

    @OnThread(value=Tag.Any)
    public void runOnEventHandler(Debugger.EventHandlerRunnable runnable) {
        this.eventHandler.queueRunnable(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VMReference getVmForMachine(VirtualMachine mc) {
        Map<VirtualMachine, VMReference> map = vmToReferenceMap;
        synchronized (map) {
            return vmToReferenceMap.get(mc);
        }
    }

    private class IOHandlerThread
    extends Thread {
        private Reader reader;
        private Writer writer;
        private volatile boolean keepRunning;

        @OnThread(value=Tag.Any)
        IOHandlerThread(Reader reader, Writer writer) {
            super("BlueJ I/O Handler");
            this.keepRunning = true;
            this.reader = reader;
            this.writer = writer;
            this.setPriority(1);
        }

        @OnThread(value=Tag.Any)
        public void close() {
            this.keepRunning = false;
        }

        @Override
        public void run() {
            try {
                char[] chbuf = new char[4096];
                while (this.keepRunning) {
                    int numchars = this.reader.read(chbuf);
                    if (numchars == -1) {
                        this.keepRunning = false;
                        continue;
                    }
                    if (!this.keepRunning) continue;
                    this.writer.write(chbuf, 0, numchars);
                    if (this.reader.ready()) continue;
                    this.writer.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

