/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.IntersectionType;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class GenTypeSolid
extends JavaType {
    @Override
    public abstract String toString(NameTransform var1);

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public abstract boolean isInterface();

    @OnThread(value=Tag.FXPlatform)
    public abstract void erasedSuperTypes(Set<Reflective> var1);

    @OnThread(value=Tag.FXPlatform)
    public abstract GenTypeClass[] getReferenceSupertypes();

    @Override
    @OnThread(value=Tag.FXPlatform)
    public abstract void getParamsFromTemplate(Map<String, GenTypeParameter> var1, GenTypeParameter var2);

    public GenTypeSolid[] getUpperBounds() {
        return this.getIntersectionTypes();
    }

    @Override
    public GenTypeSolid getUpperBound() {
        return this;
    }

    @Override
    public GenTypeSolid getLowerBound() {
        return this;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaType getCapture() {
        return this;
    }

    @Override
    public GenTypeSolid asSolid() {
        return this;
    }

    @Override
    public boolean isWildcard() {
        return false;
    }

    @OnThread(value=Tag.FXPlatform)
    public static GenTypeSolid lub(GenTypeSolid[] ubounds) {
        Stack<GenTypeClass[]> btstack = new Stack<GenTypeClass[]>();
        return GenTypeSolid.lub(ubounds, btstack);
    }

    @OnThread(value=Tag.FXPlatform)
    private static GenTypeSolid lub(GenTypeSolid[] ubounds, Stack<GenTypeClass[]> lubBt) {
        ArrayList<GenTypeClass> l = new ArrayList<GenTypeClass>();
        Reflective[] mec = GenTypeSolid.minimalErasedCandidateSet(ubounds);
        for (int i = 0; i < mec.length; ++i) {
            l.add(GenTypeSolid.Candidate(mec[i], ubounds, lubBt));
        }
        GenTypeSolid[] intersecting = l.toArray(new GenTypeSolid[l.size()]);
        return IntersectionType.getIntersection(intersecting);
    }

    @OnThread(value=Tag.FXPlatform)
    private static GenTypeClass Candidate(Reflective t, GenTypeSolid[] ubounds, Stack<GenTypeClass[]> lubBt) {
        GenTypeClass[] ri = GenTypeSolid.relevantInvocations(t, ubounds);
        return GenTypeSolid.leastContainingInvocation(ri, lubBt);
    }

    /*
     * WARNING - void declaration
     */
    @OnThread(value=Tag.FXPlatform)
    private static GenTypeClass leastContainingInvocation(GenTypeClass[] types, Stack<GenTypeClass[]> lubBt) {
        void var4_6;
        int i;
        boolean breakRecursion = false;
        for (GenTypeSolid[] genTypeSolidArray : lubBt) {
            for (i = 0; i < genTypeSolidArray.length && genTypeSolidArray[i].equals(types[i]); ++i) {
            }
            breakRecursion = i == genTypeSolidArray.length;
        }
        lubBt.push(types);
        GenTypeClass genTypeClass = types[0];
        for (i = 1; i < types.length; ++i) {
            GenTypeClass genTypeClass2 = GenTypeSolid.leastContainingInvocation((GenTypeClass)var4_6, types[i], lubBt, breakRecursion);
        }
        lubBt.pop();
        return var4_6;
    }

    @OnThread(value=Tag.FXPlatform)
    private static GenTypeClass leastContainingInvocation(GenTypeClass a, GenTypeClass b, Stack<GenTypeClass[]> lubBt, boolean breakRecursion) {
        if (!a.getReflective().getName().equals(b.getReflective().getName())) {
            throw new IllegalArgumentException("Class types must be the same.");
        }
        if (a.isRaw() || b.isRaw()) {
            return a.isRaw() ? a : b;
        }
        int arrCount = 0;
        GenTypeClass origA = a;
        while (a.getArrayComponent() != null) {
            a = a.getArrayComponent().asClass();
            b = b.getArrayComponent().asClass();
            if (a == null) {
                return origA;
            }
            ++arrCount;
        }
        ArrayList<GenTypeUnbounded> lc = new ArrayList<GenTypeUnbounded>();
        Iterator<? extends GenTypeParameter> i = a.getTypeParamList().iterator();
        Iterator<? extends GenTypeParameter> j = b.getTypeParamList().iterator();
        GenTypeClass oa = a.getOuterType();
        GenTypeClass ob = b.getOuterType();
        GenTypeClass oc = null;
        if (oa != null && ob != null) {
            oc = GenTypeSolid.leastContainingInvocation(oa, ob, lubBt, breakRecursion);
        }
        while (i.hasNext()) {
            GenTypeParameter atype = i.next();
            GenTypeParameter btype = j.next();
            GenTypeParameter rtype = !breakRecursion ? GenTypeSolid.leastContainingTypeArgument(atype, btype, lubBt) : new GenTypeUnbounded();
            lc.add((GenTypeUnbounded)rtype);
        }
        GenTypeClass rval = new GenTypeClass(a.getReflective(), lc, oc);
        while (arrCount-- > 0) {
            rval = rval.getArray();
        }
        return rval;
    }

    @OnThread(value=Tag.FXPlatform)
    private static GenTypeParameter leastContainingTypeArgument(GenTypeParameter a, GenTypeParameter b, Stack<GenTypeClass[]> lubBt) {
        GenTypeSolid ac = a.asSolid();
        GenTypeSolid bc = b.asSolid();
        if (ac != null && bc != null) {
            if (ac.equals(bc)) {
                return ac;
            }
            return new GenTypeWildcard(GenTypeSolid.lub(new GenTypeSolid[]{ac, bc}, lubBt), null);
        }
        if (ac != null || bc != null) {
            GenTypeSolid lbound;
            if (ac == null) {
                ac = bc;
                b = a;
            }
            if ((lbound = b.getLowerBound()) != null) {
                return new GenTypeWildcard(null, IntersectionType.getIntersection(lbound, ac));
            }
        }
        GenTypeSolid lboundsa = a.getLowerBound();
        GenTypeSolid lboundsb = b.getLowerBound();
        if (lboundsa != null && lboundsb != null) {
            return new GenTypeWildcard(null, IntersectionType.getIntersection(lboundsa, lboundsb));
        }
        if (lboundsa != null || lboundsb != null) {
            if (a.equals(b)) {
                return a;
            }
            return new GenTypeUnbounded();
        }
        GenTypeSolid uboundsa = a.getUpperBound().asSolid();
        GenTypeSolid uboundsb = b.getUpperBound().asSolid();
        GenTypeSolid[] args = new GenTypeSolid[]{uboundsa, uboundsb};
        return GenTypeSolid.lub(args);
    }

    @OnThread(value=Tag.FXPlatform)
    private static Reflective[] minimalErasedCandidateSet(GenTypeSolid[] types) {
        HashSet<Reflective> rset = new HashSet<Reflective>();
        types[0].erasedSuperTypes(rset);
        for (int i = 1; i < types.length; ++i) {
            HashSet<Reflective> rset2 = new HashSet<Reflective>();
            types[i].erasedSuperTypes(rset2);
            Iterator j = rset2.iterator();
            while (j.hasNext()) {
                if (rset.contains(j.next())) continue;
                j.remove();
            }
            rset = rset2;
        }
        Iterator i = rset.iterator();
        block2: while (i.hasNext()) {
            Iterator j = rset.iterator();
            Reflective ri = (Reflective)i.next();
            while (j.hasNext()) {
                Reflective ji = (Reflective)j.next();
                if (ri == ji || !ri.isAssignableFrom(ji)) continue;
                i.remove();
                continue block2;
            }
        }
        Reflective[] rval = new Reflective[rset.size()];
        rset.toArray(rval);
        return rval;
    }

    @OnThread(value=Tag.FXPlatform)
    private static GenTypeClass[] relevantInvocations(Reflective r, GenTypeSolid[] ubounds) {
        ArrayList<GenTypeClass> rlist = new ArrayList<GenTypeClass>();
        for (int i = 0; i < ubounds.length; ++i) {
            GenTypeClass[] blist = ubounds[i].getReferenceSupertypes();
            for (int j = 0; j < blist.length; ++j) {
                rlist.add(blist[j].mapToSuper(r.getName()));
            }
        }
        return rlist.toArray(new GenTypeClass[rlist.size()]);
    }

    public GenTypeSolid[] getIntersectionTypes() {
        return new GenTypeSolid[]{this};
    }
}

