/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import bluej.Config;
import java.io.File;
import java.util.ArrayList;

public class Version {
    private int breakingNumber;
    private int nonBreakingNumber;
    private int internalNumber;
    private boolean badVersion = false;

    public Version(String versionString) {
        String candidate;
        String[] endSplit;
        if (versionString == null) {
            this.badVersion = true;
            return;
        }
        String[] split = versionString.split("\\.");
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        String lastString = null;
        for (String s : split) {
            try {
                numbers.add(Integer.parseInt(s));
            }
            catch (NumberFormatException nfe) {
                lastString = s;
                break;
            }
        }
        if (numbers.size() < 3 && lastString != null && (endSplit = lastString.split("[^0-9]+")).length > 0 && lastString.startsWith(candidate = endSplit[0])) {
            numbers.add(Integer.parseInt(candidate));
        }
        if (numbers.size() == 3) {
            this.breakingNumber = (Integer)numbers.get(0);
            this.nonBreakingNumber = (Integer)numbers.get(1);
            this.internalNumber = (Integer)numbers.get(2);
        } else {
            this.badVersion = true;
        }
    }

    public boolean isOlderAndBreaking(Version other) {
        return this.breakingNumber < other.breakingNumber || this.badVersion || other.badVersion;
    }

    public boolean crosses300Boundary(Version other) {
        return this.breakingNumber < other.breakingNumber && this.breakingNumber < 3 && other.breakingNumber >= 3;
    }

    public boolean isNonBreaking(Version other) {
        return this.nonBreakingNumber != other.nonBreakingNumber || this.badVersion || other.badVersion;
    }

    public boolean isInternal(Version other) {
        return this.internalNumber != other.internalNumber || this.badVersion || other.badVersion;
    }

    public boolean isBad() {
        return this.badVersion;
    }

    public String toString() {
        return this.breakingNumber + "." + this.nonBreakingNumber + "." + this.internalNumber;
    }

    public String getChangesMessage(Version apiVersion) {
        StringBuffer message = new StringBuffer(Config.getString((String)"project.version.older.part1") + this + Config.getString((String)"project.version.older.part2") + apiVersion + Config.getString((String)"project.version.older.part3") + "\n\n");
        int changeNumber = 1;
        String changesString = Config.getString((String)("project.version.changes." + changeNumber), (String)"EMPTY").trim();
        while (!changesString.equals("EMPTY")) {
            int spaceIndex = changesString.indexOf(32);
            if (spaceIndex < 5) {
                return "";
            }
            String versionString = changesString.substring(0, spaceIndex);
            Version changeVersion = new Version(versionString);
            if (this.isOlderAndBreaking(changeVersion)) {
                String text = changesString.substring(spaceIndex + 1);
                message.append(text + "\n");
            }
            changesString = Config.getString((String)("project.version.changes." + ++changeNumber), (String)"EMPTY");
        }
        return message.toString();
    }

    public String getBadMessage() {
        return Config.getString((String)"project.version.none");
    }

    public String getNewerMessage() {
        return Config.getString((String)"project.version.newer.part1") + this + Config.getString((String)"project.version.newer.part2");
    }

    public String getNotGreenfootMessage(File projectDir) {
        return Config.getString((String)"project.version.notGreenfoot") + projectDir;
    }
}

