/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import bluej.Boot;
import bluej.Config;
import greenfoot.Color;
import greenfoot.GreenfootImage;
import greenfoot.UserInfo;
import greenfoot.core.ImageCache;
import greenfoot.platforms.GreenfootUtilDelegate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GreenfootUtil {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private static GreenfootUtilDelegate delegate;
    private static ImageCache imageCache;
    private static boolean haveCheckedForMp3;
    private static boolean mp3available;

    @OnThread(value=Tag.Any)
    public static void initialise(GreenfootUtilDelegate newDelegate) {
        delegate = newDelegate;
        imageCache = ImageCache.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) {
        if (!src.isFile() || dst.isDirectory()) {
            return;
        }
        dst.getParentFile().mkdirs();
        if (dst.exists()) {
            dst.delete();
        }
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buffer = new byte[8192];
            int read = 0;
            while (read != -1) {
                os.write(buffer, 0, read);
                read = is.read(buffer);
            }
            os.flush();
            is.close();
            os.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @OnThread(value=Tag.Any)
    public static Iterable<String> getSoundFiles() {
        return delegate.getSoundFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getURL(String filename, String dir) throws FileNotFoundException {
        if (filename == null) {
            throw new NullPointerException("Filename must not be null.");
        }
        URL url = delegate.getResource(dir + "/" + filename);
        if (url == null) {
            url = delegate.getResource(filename);
        }
        if (url == null) {
            File f = new File(filename);
            try {
                if (f.canRead()) {
                    url = f.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (url == null) {
            InputStream s = null;
            try {
                url = new URL(filename);
                s = url.openStream();
                s.close();
            }
            catch (MalformedURLException e) {
                url = null;
            }
            catch (IOException e) {
                url = null;
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        GreenfootUtil.checkCase(url);
        if (url == null) {
            throw new FileNotFoundException("Could not find file: " + filename);
        }
        return url;
    }

    private static void checkCase(URL url) {
        if (url != null) {
            String errMsg = null;
            try {
                File f = new File(url.toURI());
                String givenName = f.getName();
                String realName = f.getCanonicalFile().getName();
                if (!realName.equals(givenName) && realName.equalsIgnoreCase(givenName)) {
                    errMsg = "Filename '" + givenName + "' has the wrong case. It should be: '" + realName + "'";
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (errMsg != null) {
                throw new IllegalArgumentException(errMsg);
            }
        }
    }

    public static String getGreenfootLogoPath() {
        return delegate.getGreenfootLogoPath();
    }

    public static boolean canBeInstantiated(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (cls.isEnum() || cls.isInterface()) {
            return false;
        }
        return !Modifier.isAbstract(cls.getModifiers());
    }

    public static Set<File> get3rdPartyLibs() {
        File bluejLibDir = Config.getBlueJLibDir();
        String[] thirdPartyLibs = Boot.GREENFOOT_EXPORT_JARS;
        TreeSet<File> jars = new TreeSet<File>();
        for (String lib : thirdPartyLibs) {
            jars.add(new File(bluejLibDir, lib));
        }
        return jars;
    }

    public static boolean isMp3LibAvailable() {
        if (!haveCheckedForMp3) {
            URL url = delegate.getResource("javazoom/jl/decoder/BitstreamException.class");
            mp3available = url != null;
            haveCheckedForMp3 = true;
        }
        return mp3available;
    }

    public static File createNumberedFile(File dir, String name, String type) throws IOException {
        File f = new File(dir, name + "." + type);
        int number = 1;
        while (!f.createNewFile()) {
            String numberString = null;
            numberString = number < 10 ? "0" + number : "" + number;
            f = new File(dir, name + numberString + "." + type);
            ++number;
        }
        return f;
    }

    @OnThread(value=Tag.Simulation)
    public static GreenfootImage getGreenfootImage(String className, String imageName) {
        GreenfootImage image = null;
        if (imageName == null) {
            return image;
        }
        if (GreenfootUtil.isInvalidImageFilename(imageName)) {
            return image;
        }
        if (className.equals("Actor")) {
            return new GreenfootImage(GreenfootUtil.getGreenfootLogoPath());
        }
        try {
            image = new GreenfootImage(imageName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return image;
    }

    public static void removeCachedImage(String className) {
        imageCache.removeCachedImage(className);
    }

    public static boolean addCachedImage(String name, GreenfootImage image) {
        return imageCache.addCachedImage(name, image);
    }

    public static GreenfootImage getCachedImage(String name) {
        return imageCache.getCachedImage(name);
    }

    public static boolean isInvalidImageFilename(String fileName) {
        return imageCache.isNullCachedImage(fileName);
    }

    public static String removeExtension(String full) {
        int n = full.lastIndexOf(46);
        if (n == -1) {
            return full;
        }
        return full.substring(0, n);
    }

    @OnThread(value=Tag.Simulation)
    public static boolean isStorageSupported() {
        return delegate.isStorageSupported();
    }

    @OnThread(value=Tag.Simulation)
    public static UserInfo getCurrentUserInfo() {
        return delegate.getCurrentUserInfo();
    }

    @OnThread(value=Tag.Simulation)
    public static boolean storeCurrentUserInfo(UserInfo data) {
        if (data.getUserName().equals(GreenfootUtil.getUserName())) {
            return delegate.storeCurrentUserInfo(data);
        }
        System.err.println("Attempted to store the data for another user, \"" + data.getUserName() + "\" (i.e. a user other than the current user, \"" + GreenfootUtil.getUserName() + "\")");
        return false;
    }

    @OnThread(value=Tag.Simulation)
    public static List<UserInfo> getTopUserInfo(int limit) {
        return delegate.getTopUserInfo(limit);
    }

    @OnThread(value=Tag.Simulation)
    public static GreenfootImage getUserImage(String userName) {
        if (userName == null || userName.equals("")) {
            userName = GreenfootUtil.getUserName();
        }
        GreenfootImage r = null;
        if (userName != null) {
            r = delegate.getUserImage(userName);
        }
        if (r == null) {
            r = new GreenfootImage(50, 50);
            r.setColor(Color.DARK_GRAY);
            r.fill();
            int CHARS_PER_LINE = 6;
            StringBuilder wrappedName = new StringBuilder();
            if (userName == null) {
                userName = "";
            }
            for (int i = 0; i < userName.length(); i += 6) {
                wrappedName.append(userName.substring(i, Math.min(userName.length(), i + 6))).append("\n");
            }
            GreenfootImage textImage = new GreenfootImage(wrappedName.toString(), 15, Color.WHITE, Color.DARK_GRAY);
            r.drawImage(textImage, Math.max(0, (50 - textImage.getWidth()) / 2), Math.max(0, (50 - textImage.getHeight()) / 2));
        }
        return r;
    }

    @OnThread(value=Tag.Simulation)
    public static String getUserName() {
        return delegate.getUserName();
    }

    @OnThread(value=Tag.Simulation)
    public static List<UserInfo> getNearbyUserData(int maxAmount) {
        return delegate.getNearbyUserInfo(maxAmount);
    }

    static {
        haveCheckedForMp3 = false;
        mp3available = false;
    }
}

