/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.soundrecorder;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.pkgmgr.Project;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ResizableCanvas;
import greenfoot.guifx.soundrecorder.SaveState;
import greenfoot.sound.MemoryAudioInputStream;
import greenfoot.sound.Sound;
import greenfoot.sound.SoundPlaybackListener;
import greenfoot.sound.SoundPreferencePanel;
import greenfoot.sound.SoundRecorder;
import greenfoot.sound.SoundStream;
import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class SoundRecorderControls
extends Stage {
    private Player player = new Player();
    private SoundRecorder recorder = new SoundRecorder();
    private boolean selectionActive = false;
    private boolean selectionDrawing = false;
    private double selectionBegin;
    private double selectionEnd;
    private boolean playing = false;
    private long playbackPosition;
    private boolean recording = false;
    private AtomicReference<List<byte[]>> currentRecording;
    private SoundPanel soundPanel = new SoundPanel();
    private SaveState saveState = new SaveState((Window)this, this.recorder);
    private final String playLabel = Config.getString((String)"soundRecorder.play");
    private final String playSelectionLabel = Config.getString((String)"soundRecorder.playSelection");
    private final String stopPlayLabel = Config.getString((String)"soundRecorder.stopPlay");
    private final String recordLabel = Config.getString((String)"soundRecorder.record");
    private final String stopRecordLabel = Config.getString((String)"soundRecorder.stopRecord");
    private Button trim = new Button(Config.getString((String)"soundRecorder.trim"));
    private Button playStop = new Button(this.playLabel);
    private Button recordStop = new Button(this.recordLabel);
    private final SimpleBooleanProperty showingProperty = new SimpleBooleanProperty(false);
    private SoundPreferencePanel soundPreferencePanel;

    public SoundRecorderControls(Project project) {
        this.setWidth(450.0);
        this.setHeight(400.0);
        this.setMinWidth(450.0);
        this.setMinHeight(400.0);
        this.setTitle(Config.getString((String)"soundRecorder.title"));
        Image icon = BlueJTheme.getApplicationFxIcon((String)"greenfoot", (boolean)false);
        if (icon != null) {
            this.getIcons().add((Object)icon);
        }
        this.setOnShown(e -> {
            this.soundPreferencePanel.beginEditing(null);
            this.showingProperty.set(true);
        });
        this.setOnHidden(e -> this.showingProperty.set(false));
        this.buildUI();
        this.setProject(project);
    }

    private void buildUI() {
        this.soundPreferencePanel = new SoundPreferencePanel();
        BorderPane soundAndControls = new BorderPane((Node)this.soundPanel, (Node)this.soundPreferencePanel, null, (Node)this.buildControlBox(), null);
        soundAndControls.setPadding(new Insets(12.0));
        BorderPane.setMargin((Node)this.soundPanel, (Insets)new Insets(12.0, 12.0, 12.0, 12.0));
        soundAndControls.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGRAY, new CornerRadii(5.0, 5.0, 5.0, 5.0, false), null)}));
        VBox.setVgrow((Node)soundAndControls, (Priority)Priority.ALWAYS);
        Button closeButton = new Button(Config.getString((String)"soundRecorder.close"));
        JavaFXUtil.addChangeListener((ObservableValue)this.saveState.savedProperty(), newValue -> closeButton.setText(Config.getString((String)(newValue != false ? "soundRecorder.close" : "soundRecorder.close.without.saving"))));
        closeButton.setOnAction(event -> {
            this.stopRecording();
            this.soundPreferencePanel.commitEditing(null);
            this.close();
        });
        this.setOnCloseRequest(event -> {
            this.stopRecording();
            this.soundPreferencePanel.commitEditing(null);
        });
        VBox contentPane = new VBox(20.0);
        contentPane.setAlignment(Pos.CENTER);
        contentPane.setPadding(new Insets(12.0));
        contentPane.getChildren().addAll((Object[])new Node[]{soundAndControls, this.saveState.buildSaveBox(), closeButton});
        this.setScene(new Scene((Parent)contentPane));
    }

    public void setProject(Project project) {
        this.saveState.setProjectSoundDir(SoundRecorderControls.getSoundDir(project));
    }

    private Pane buildControlBox() {
        this.recordStop.setFocusTraversable(false);
        this.recordStop.setOnAction(event -> {
            if (!this.recording) {
                this.currentRecording = this.recorder.startRecording(this.soundPreferencePanel.getInputMixer());
                this.recordStop.setText(this.stopRecordLabel);
                this.playStop.setDisable(true);
                this.recording = true;
                new Timer().scheduleAtFixedRate(new TimerTask(){
                    List<byte[]> lastValue = null;

                    @Override
                    public void run() {
                        List<byte[]> curValue = SoundRecorderControls.this.currentRecording.get();
                        if (curValue != this.lastValue) {
                            Platform.runLater(SoundRecorderControls.this.soundPanel::paintComponent);
                        }
                        if (this.lastValue != null && curValue == null) {
                            this.cancel();
                        }
                        this.lastValue = curValue;
                    }
                }, 100L, 200L);
            } else {
                this.stopRecording();
            }
        });
        this.trim.setDisable(true);
        this.trim.setFocusTraversable(false);
        this.trim.setOnAction(event -> {
            this.recorder.trim(Math.min(this.selectionBegin, this.selectionEnd), Math.max(this.selectionBegin, this.selectionEnd));
            this.saveState.changed(true);
            this.selectionActive = false;
            this.updateButtons();
            this.soundPanel.paintComponent();
        });
        this.playStop.setDisable(true);
        this.playStop.setFocusTraversable(false);
        this.playStop.setOnAction(event -> this.player.act());
        HBox controls = new HBox(10.0);
        controls.setAlignment(Pos.CENTER);
        controls.getChildren().addAll((Object[])new Node[]{this.recordStop, this.playStop, this.trim});
        return controls;
    }

    private static File getSoundDir(Project project) {
        if (project != null) {
            return new File(project.getProjectDir(), "sounds");
        }
        return null;
    }

    private void updateButtons() {
        this.trim.setDisable(!this.selectionActive);
        this.playStop.setText(this.selectionActive ? this.playSelectionLabel : this.playLabel);
    }

    private int getSelectionStartOffset() {
        double start = Math.min(this.selectionBegin, this.selectionEnd);
        float length = this.recorder.getRawSound().length;
        return (int)(start * (double)length);
    }

    private int getSelectionFinishOffset() {
        double finish = Math.max(this.selectionBegin, this.selectionEnd);
        float length = this.recorder.getRawSound().length;
        return (int)(finish * (double)length);
    }

    private void stopRecording() {
        if (this.recording) {
            this.recorder.stopRecording();
            this.playStop.setDisable(false);
            this.saveState.changed(true);
            this.soundPanel.paintComponent();
            this.recordStop.setText(this.recordLabel);
            this.recording = false;
        }
    }

    public SimpleBooleanProperty getShowingProperty() {
        return this.showingProperty;
    }

    private class Player
    implements SoundPlaybackListener {
        private final Timer timer = new Timer();
        private TimerTask repaintWhilePlaying;
        private SoundStream stream;

        private Player() {
        }

        @OnThread(value=Tag.FXPlatform)
        public void act() {
            if (SoundRecorderControls.this.playing) {
                if (this.stream != null) {
                    this.stream.stop();
                }
            } else {
                MemoryAudioInputStream memoryStream;
                int start;
                if (SoundRecorderControls.this.selectionActive) {
                    start = SoundRecorderControls.this.getSelectionStartOffset();
                    int len = SoundRecorderControls.this.getSelectionFinishOffset() - start;
                    memoryStream = new MemoryAudioInputStream(SoundRecorderControls.this.recorder.getRawSound(), start, len, SoundRecorderControls.this.recorder.getFormat());
                } else {
                    start = 0;
                    memoryStream = new MemoryAudioInputStream(SoundRecorderControls.this.recorder.getRawSound(), SoundRecorderControls.this.recorder.getFormat());
                }
                SoundRecorderControls.this.soundPreferencePanel.commitEditing(null);
                this.stream = new SoundStream(memoryStream, this);
                SoundRecorderControls.this.playing = true;
                SoundRecorderControls.this.playbackPosition = start;
                this.stream.play();
                SoundRecorderControls.this.playStop.setText(SoundRecorderControls.this.stopPlayLabel);
                SoundRecorderControls.this.recordStop.setDisable(true);
                this.repaintWhilePlaying = new TimerTask(){

                    @Override
                    public void run() {
                        SoundRecorderControls.this.playbackPosition = (long)start + Player.this.stream.getLongFramePosition();
                        Platform.runLater(SoundRecorderControls.this.soundPanel::paintComponent);
                    }
                };
                this.timer.scheduleAtFixedRate(this.repaintWhilePlaying, 50L, 100L);
            }
        }

        @Override
        @OnThread(value=Tag.Any)
        public void playbackPaused(Sound sound) {
        }

        @Override
        @OnThread(value=Tag.Any)
        public void playbackStarted(Sound sound) {
        }

        @Override
        @OnThread(value=Tag.Any)
        public void playbackStopped(Sound sound) {
            Platform.runLater(() -> {
                SoundRecorderControls.this.updateButtons();
                SoundRecorderControls.this.recordStop.setDisable(false);
                this.repaintWhilePlaying.cancel();
                SoundRecorderControls.this.playing = false;
                SoundRecorderControls.this.soundPanel.paintComponent();
            });
        }

        @Override
        @OnThread(value=Tag.Any)
        public void soundClosed(Sound sound) {
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private class SoundPanel
    extends ResizableCanvas {
        private SoundPanel() {
            this.addEventHandler(MouseEvent.MOUSE_PRESSED, this::mousePressed);
            this.addEventHandler(MouseEvent.MOUSE_RELEASED, this::mouseReleased);
            this.addEventHandler(MouseEvent.MOUSE_DRAGGED, this::mouseDragged);
            this.onResize = this::paintComponent;
        }

        protected void paintComponent() {
            GraphicsContext g = this.getGraphicsContext2D();
            double width = this.getWidth();
            double height = this.getHeight();
            double middle = height / 2.0;
            double halfHeight = height / 2.0;
            byte[] sound = SoundRecorderControls.this.recorder.getRawSound();
            g.setFill((Paint)Color.BLACK);
            g.fillRect(0.0, 0.0, width, height);
            if (SoundRecorderControls.this.recording || sound != null && sound.length > 0) {
                if (SoundRecorderControls.this.selectionActive) {
                    g.setFill((Paint)Color.GRAY);
                    g.fillRect(Math.min(SoundRecorderControls.this.selectionBegin, SoundRecorderControls.this.selectionEnd) * width, 0.0, Math.abs(SoundRecorderControls.this.selectionBegin - SoundRecorderControls.this.selectionEnd) * width, height);
                }
                byte[][] rec = null;
                int recLength = 0;
                if (SoundRecorderControls.this.recording) {
                    List<byte[]> recList = SoundRecorderControls.this.currentRecording.get();
                    if (recList != null) {
                        for (byte[] chunk : rec = (byte[][])recList.toArray((T[])new byte[0][])) {
                            int chunkLength = chunk == null ? 0 : chunk.length;
                            recLength += chunkLength;
                        }
                    }
                } else {
                    recLength = sound.length;
                }
                int curRecChunk = 0;
                int prevChunksLength = 0;
                int i = 0;
                while ((double)i < width) {
                    float pos = (float)i / (float)width;
                    float f = 0.0f;
                    if (rec != null) {
                        index = (int)(pos * (float)recLength);
                        if (recLength == 0 || index >= recLength) {
                            f = 0.0f;
                        } else {
                            while (index >= prevChunksLength + rec[curRecChunk].length) {
                                prevChunksLength += rec[curRecChunk].length;
                                ++curRecChunk;
                            }
                            f = (float)rec[curRecChunk][index - prevChunksLength] / 128.0f;
                        }
                    } else if (sound != null) {
                        index = (int)(pos * (float)sound.length);
                        f = (float)sound[index] / 128.0f;
                    }
                    int waveHeight = (int)(halfHeight * (double)f * (double)0.9f);
                    g.setStroke((Paint)(this.inSelection(pos) ? Color.YELLOW : Color.LIME));
                    g.strokeLine((double)i, middle - (double)waveHeight, (double)i, middle + (double)waveHeight);
                    ++i;
                }
                if (SoundRecorderControls.this.playing) {
                    g.setStroke((Paint)Color.RED);
                    float playPosRel = (float)SoundRecorderControls.this.playbackPosition / (float)recLength;
                    int pos = (int)(playPosRel * (float)width);
                    g.strokeLine((double)pos, 0.0, (double)pos, height);
                }
            }
        }

        private boolean inSelection(float f) {
            return SoundRecorderControls.this.selectionActive && (double)f >= Math.min(SoundRecorderControls.this.selectionBegin, SoundRecorderControls.this.selectionEnd) && (double)f <= Math.max(SoundRecorderControls.this.selectionBegin, SoundRecorderControls.this.selectionEnd);
        }

        public void mousePressed(MouseEvent e) {
            if (SoundRecorderControls.this.recorder.getRawSound() != null) {
                SoundRecorderControls.this.selectionActive = false;
                SoundRecorderControls.this.selectionDrawing = true;
                SoundRecorderControls.this.selectionEnd = SoundRecorderControls.this.selectionBegin = this.calculatePosition(e.getX());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (SoundRecorderControls.this.selectionDrawing) {
                SoundRecorderControls.this.selectionDrawing = false;
                SoundRecorderControls.this.selectionEnd = this.calculatePosition(e.getX());
                if (SoundRecorderControls.this.selectionBegin == SoundRecorderControls.this.selectionEnd) {
                    SoundRecorderControls.this.selectionActive = false;
                }
                this.paintComponent();
            }
            SoundRecorderControls.this.updateButtons();
        }

        public void mouseDragged(MouseEvent e) {
            if (SoundRecorderControls.this.selectionDrawing) {
                SoundRecorderControls.this.selectionEnd = this.calculatePosition(e.getX());
                SoundRecorderControls.this.selectionActive = true;
                this.paintComponent();
            }
        }

        private double calculatePosition(double x) {
            double pos = x / this.getWidth();
            pos = Math.max(0.0, pos);
            pos = Math.min(1.0, pos);
            return pos;
        }
    }
}

