/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.export;

import bluej.Config;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.guifx.export.ImageEditCanvas;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;

public class ImageEditPane
extends HBox {
    private ImageEditCanvas imageCanvas;
    private double lastX;
    private double lastY;
    private Slider zoomSlider;
    private int width;
    private int height;
    private ImageView bigLabel;
    private ImageView smallLabel;
    private boolean enableImageControls = true;
    private boolean haveImage;

    public ImageEditPane(int width, int height) {
        this.width = width;
        this.height = height;
        this.setPrefSize(width + 2, height + 2);
        this.getStyleClass().add((Object)"image-edit-pane");
        this.buildUI();
    }

    public void setImage(Image snapShot) {
        double oldMinScale = this.imageCanvas.getMinimumScale();
        this.imageCanvas.setImage(snapShot);
        double newMinScale = this.imageCanvas.getMinimumScale();
        if (!this.haveImage || Math.abs(newMinScale - oldMinScale) > 1.0E-7) {
            this.imageCanvas.fit();
            this.zoomSlider.setValue(this.imageCanvas.getScale());
        }
        if (!this.haveImage) {
            this.haveImage = true;
            this.enableImageEditPanel(this.enableImageControls);
        }
    }

    private void buildUI() {
        this.imageCanvas = new ImageEditCanvas(this.width, this.height, null);
        this.imageCanvas.setCursor(Cursor.HAND);
        this.imageCanvas.setOnMouseDragged(this::mouseDragged);
        this.imageCanvas.setOnMousePressed(this::mousePressed);
        this.imageCanvas.setOnMouseReleased(this::mouseReleased);
        this.imageCanvas.setOnScroll(this::mouseScroll);
        Pane sliderPane = this.createSliderPane();
        BorderPane border = new BorderPane((Node)this.imageCanvas);
        border.getStyleClass().add((Object)"image-canvas");
        this.getChildren().addAll((Object[])new Node[]{border, sliderPane});
    }

    private Pane createSliderPane() {
        this.zoomSlider = new Slider();
        this.zoomSlider.setOrientation(Orientation.VERTICAL);
        this.zoomSlider.setPrefHeight(this.imageCanvas.getHeight());
        this.zoomSlider.setMin(this.imageCanvas.getMinimumScale());
        this.zoomSlider.setMax(1.0);
        JavaFXUtil.addChangeListener((ObservableValue)this.zoomSlider.valueProperty(), scale -> this.imageCanvas.setScale(scale.doubleValue()));
        Image image = JavaFXUtil.loadImage((String)(Config.getGreenfootLibDir().getAbsolutePath() + "/imagelib/other/greenfoot.png"));
        this.bigLabel = new ImageView(image);
        this.bigLabel.setScaleX(1.2);
        this.bigLabel.setScaleY(1.2);
        this.smallLabel = new ImageView(image);
        this.smallLabel.setScaleX(0.8);
        this.smallLabel.setScaleY(0.8);
        AnchorPane anchorPane = new AnchorPane(new Node[]{this.zoomSlider, this.bigLabel, this.smallLabel});
        AnchorPane.setLeftAnchor((Node)this.zoomSlider, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.bigLabel, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.bigLabel, (Double)20.0);
        AnchorPane.setBottomAnchor((Node)this.smallLabel, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.smallLabel, (Double)20.0);
        return anchorPane;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.imageCanvas.isDisabled()) {
            return;
        }
        if (e.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.imageCanvas.setCursor(Cursor.MOVE);
            double dx = e.getX() - this.lastX;
            double dy = e.getY() - this.lastY;
            this.imageCanvas.move(dx, dy);
            this.lastX = e.getX();
            this.lastY = e.getY();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.imageCanvas.isDisabled()) {
            return;
        }
        if (e.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.lastX = e.getX();
            this.lastY = e.getY();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.imageCanvas.isDisabled()) {
            return;
        }
        if (e.getButton().equals((Object)MouseButton.PRIMARY)) {
            this.imageCanvas.setCursor(Cursor.HAND);
        }
    }

    public void mouseScroll(ScrollEvent e) {
        if (this.imageCanvas.isDisabled()) {
            return;
        }
        double scroll = e.getDeltaY() / 100.0;
        this.zoomSlider.setValue(this.zoomSlider.getValue() - scroll);
    }

    public Image getImage() {
        if (!this.haveImage) {
            return null;
        }
        return JavaFXUtil.createImage((int)this.width, (int)this.height, graphicsContext -> this.imageCanvas.paintImage((GraphicsContext)graphicsContext));
    }

    public void enableImageEditPanel(boolean enabled) {
        this.enableImageControls = enabled;
        if (!enabled || this.haveImage) {
            this.zoomSlider.setDisable(!enabled);
            this.imageCanvas.setDisable(!enabled);
        }
    }
}

