/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.export;

import bluej.Config;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.FXWorker;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.export.Exporter;
import greenfoot.export.ScenarioSaver;
import greenfoot.export.mygame.ExistingScenarioChecker;
import greenfoot.export.mygame.ExportInfo;
import greenfoot.export.mygame.MyGameClient;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.guifx.export.ExportDialog;
import greenfoot.guifx.export.ExportTab;
import greenfoot.guifx.export.ImageEditPane;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.SwingUtilities;
import org.apache.http.conn.ConnectTimeoutException;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ExportPublishTab
extends ExportTab {
    private static final int IMAGE_WIDTH = 120;
    private static final int IMAGE_HEIGHT = 70;
    private static final String serverURL = ExportPublishTab.ensureTrailingSlash(Config.getPropString((String)"greenfoot.gameserver.address", (String)"https://www.greenfoot.org/"));
    private static final String createAccountUrl = Config.getPropString((String)"greenfoot.gameserver.createAccount.address", (String)"https://www.greenfoot.org/users/new");
    private static final String serverName = Config.getPropString((String)"greenfoot.gameserver.name", (String)"Greenfoot Website");
    private static final String helpLine = Config.getString((String)"export.publish.help") + " " + serverName;
    private static final String WITH_SOURCE_TAG = "with-source";
    private final Label emptyLabel = new Label();
    private final Label titleLabel = new Label(Config.getString((String)"export.publish.title"));
    private final Label updateLabel = new Label(Config.getString((String)"export.publish.update"));
    private final Label shortDescriptionLabel = new Label(Config.getString((String)"export.publish.shortDescription"));
    private final Label longDescriptionLabel = new Label(Config.getString((String)"export.publish.longDescription"));
    private TextField titleField;
    private TextField shortDescriptionField;
    private TextArea longDescriptionArea;
    private TextArea updateArea;
    private TextField urlField;
    private TextField userNameField;
    private PasswordField passwordField;
    private ImageEditPane imagePane;
    private CheckBox includeSource;
    private CheckBox keepScenarioScreenshot;
    private GridPane titleAndDescPane;
    private ScrollPane updatePane;
    private ScrollPane description;
    private CheckBox[] popTags = new CheckBox[7];
    private TextArea tagArea;
    private Project project;
    private boolean firstActivation = true;
    private String publishedUserName;
    private ExistingScenarioChecker scenarioChecker;
    private boolean update = false;
    private final ExportDialog exportDialog;
    private final ScenarioSaver scenarioSaver;
    private BooleanBinding userNameValidity;
    private BooleanBinding passwordValidity;
    private BooleanBinding titleValidity;

    public ExportPublishTab(Project project, ExportDialog exportDialog, ScenarioSaver scenarioSaver, ScenarioInfo scenarioInfo) {
        super(scenarioInfo, "export-publish.png");
        this.project = project;
        this.exportDialog = exportDialog;
        this.scenarioSaver = scenarioSaver;
        this.buildContentPane();
        this.applySharedStyle();
        this.getContent().getStyleClass().add((Object)"export-publish-tab");
        this.userNameValidity = this.userNameField.textProperty().isNotEmpty();
        this.passwordValidity = this.passwordField.textProperty().isNotEmpty();
        this.titleValidity = this.titleField.textProperty().isNotEmpty();
        this.validProperty.bind((ObservableValue)this.userNameValidity.and((ObservableBooleanValue)this.passwordValidity).and((ObservableBooleanValue)this.titleValidity));
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.selectedProperty(), selected -> this.activated());
    }

    @Override
    public Exporter.ExportFunction getFunction() {
        return Exporter.ExportFunction.PUBLISH;
    }

    public Image getImage() {
        return this.imagePane.getImage();
    }

    public void setImage(Image snapShot) {
        this.imagePane.setImage(snapShot);
    }

    public String getTitle() {
        if (this.titleField != null) {
            return this.titleField.getText();
        }
        return null;
    }

    public String getShortDescription() {
        return this.shortDescriptionField.getText();
    }

    public String getLongDescription() {
        return this.longDescriptionArea.getText();
    }

    public String getURL() {
        return this.urlField.getText();
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    private String getUpdateDescription() {
        return this.updateArea != null ? this.updateArea.getText() : null;
    }

    public String getPassword() {
        return this.passwordField.getText();
    }

    public boolean isIncludeSource() {
        return this.includeSource.isSelected();
    }

    private boolean isKeepSavedScreenshot() {
        return this.update && this.keepScenarioScreenshot.isSelected();
    }

    private void processTags(List<String> tags) {
        for (CheckBox popTag : this.popTags) {
            if (!tags.contains(popTag.getText())) continue;
            popTag.setSelected(true);
        }
        String newTags = tags.stream().filter(tag -> !WITH_SOURCE_TAG.equals(tag)).filter(tag -> !this.getPopTagsTexts().contains(tag)).collect(Collectors.joining(System.getProperty("line.separator")));
        this.tagArea.setText(newTags);
    }

    private List<String> getPopTagsTexts() {
        return Stream.of(this.popTags).map(Labeled::getText).collect(Collectors.toList());
    }

    private void buildContentPane() {
        Label publishInfoLabel = new Label(Config.getString((String)"export.publish.info") + " " + serverName);
        publishInfoLabel.getStyleClass().add((Object)"intro-label");
        BorderPane.setAlignment((Node)publishInfoLabel, (Pos)Pos.CENTER);
        BorderPane infoPane = new BorderPane((Node)this.createScenarioPane(), (Node)publishInfoLabel, (Node)this.getTagDisplay(), null, null);
        infoPane.getStyleClass().add((Object)"info-pane");
        this.setContent((Node)new VBox(new Node[]{this.getHelpBox(), infoPane, this.getLoginPane()}));
    }

    private Pane getLoginPane() {
        Label loginLabel = new Label(Config.getString((String)"export.publish.login"));
        loginLabel.getStyleClass().add((Object)"intro-label");
        Label usernameLabel = new Label(Config.getString((String)"export.publish.username"));
        this.userNameField = new TextField();
        this.userNameField.setPrefColumnCount(10);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.userNameField.focusedProperty(), focused -> {
            if (!focused.booleanValue()) {
                this.checkForExistingScenario();
            }
        });
        Label passwordLabel = new Label(Config.getString((String)"export.publish.password"));
        this.passwordField = new PasswordField();
        this.passwordField.setPrefColumnCount(10);
        Hyperlink createAccountLabel = new Hyperlink(Config.getString((String)"export.publish.createAccount"));
        createAccountLabel.getStyleClass().add((Object)"create-account-label");
        createAccountLabel.setOnAction(event -> SwingUtilities.invokeLater(() -> Utility.openWebBrowser((String)createAccountUrl)));
        HBox loginPane = new HBox(new Node[]{loginLabel, usernameLabel, this.userNameField, passwordLabel, this.passwordField, createAccountLabel});
        loginPane.getStyleClass().add((Object)"login-pane");
        return loginPane;
    }

    private Pane getHelpBox() {
        Hyperlink serverLink = new Hyperlink(serverURL);
        serverLink.setOnAction(event -> SwingUtilities.invokeLater(() -> Utility.openWebBrowser((String)serverURL)));
        HBox helpBox = new HBox(new Node[]{new Label(helpLine + " ("), serverLink, new Label(")")});
        helpBox.getStyleClass().add((Object)"help-box");
        return helpBox;
    }

    private void setPopularTags(List<String> tags) {
        int i;
        if (tags == null) {
            this.popTags[0].setText("Unavailable");
            for (int i2 = 1; i2 < this.popTags.length; ++i2) {
                this.popTags[i2].setText("");
            }
            return;
        }
        int minLength = this.popTags.length < tags.size() ? this.popTags.length : tags.size();
        for (i = 0; i < minLength; ++i) {
            CheckBox checkBox = this.popTags[i];
            checkBox.setText(tags.get(i));
            checkBox.setDisable(false);
            this.processTags(this.getTags());
        }
        for (i = minLength; i < this.popTags.length; ++i) {
            this.popTags[i].setText("");
        }
    }

    public List<String> getTags() {
        ArrayList tagList = Arrays.stream(this.popTags).filter(CheckBox::isSelected).map(Labeled::getText).collect(Collectors.toCollection(ArrayList::new));
        tagList.addAll(Arrays.asList(this.tagArea.getText().split("\\s+")));
        if (this.isIncludeSource() && !tagList.contains(WITH_SOURCE_TAG)) {
            tagList.add(WITH_SOURCE_TAG);
        } else if (!this.isIncludeSource()) {
            tagList.remove(WITH_SOURCE_TAG);
        }
        return tagList;
    }

    private void loadStoredScenarioInfo() {
        this.titleField.setText(this.scenarioInfo.getTitle());
        this.shortDescriptionField.setText(this.scenarioInfo.getShortDescription());
        this.longDescriptionArea.setText(this.scenarioInfo.getLongDescription());
        this.urlField.setText(this.scenarioInfo.getUrl());
        this.processTags(this.scenarioInfo.getTags());
        this.lockScenario.setSelected(this.scenarioInfo.isLocked());
        this.includeSource.setSelected(this.scenarioInfo.isIncludeSource());
        this.setUpdate(!this.scenarioInfo.getTitle().isEmpty());
    }

    @Override
    protected void updateInfoFromFields() {
        this.scenarioInfo.setTitle(this.getTitle());
        this.scenarioInfo.setShortDescription(this.getShortDescription());
        this.scenarioInfo.setLongDescription(this.getLongDescription());
        this.scenarioInfo.setUrl(this.getURL());
        this.scenarioInfo.setTags(this.getTags());
        this.scenarioInfo.setLocked(this.isLockScenario());
        this.scenarioInfo.setIncludeSource(this.isIncludeSource());
    }

    @Override
    protected ExportInfo getExportInfo() {
        ExportInfo info = new ExportInfo(this.scenarioInfo);
        info.setUpdateDescription(this.getUpdateDescription());
        info.setUserName(this.getUserName());
        info.setPassword(this.getPassword());
        info.setImage(this.getImage());
        info.setKeepSavedScreenshot(this.isKeepSavedScreenshot());
        info.setUpdate(this.isUpdate());
        return info;
    }

    private void checkForExistingScenario() {
        String userName = this.getUserName();
        String title = this.getTitle();
        if (userName == null || userName.equals("")) {
            return;
        }
        if (title == null || title.equals("")) {
            return;
        }
        if (this.scenarioChecker == null) {
            this.scenarioChecker = new ExistingScenarioChecker(){

                @Override
                public void scenarioExistenceCheckFailed(Exception reason) {
                }

                @Override
                public void scenarioExistenceChecked(ScenarioInfo info) {
                    ExportPublishTab.this.setUpdate(info != null);
                }
            };
        }
        this.scenarioChecker.startScenarioExistenceCheck(serverURL, userName, title);
    }

    private void activated() {
        if (this.firstActivation) {
            this.firstActivation = false;
            this.userNameField.setText(Config.getPropString((String)"publish.username", (String)""));
            this.loadStoredScenarioInfo();
            this.checkForExistingScenario();
            FXWorker commonTagsLoader = new FXWorker(){

                public void finished() {
                    ExportPublishTab.this.setPopularTags((List)this.getValue());
                }

                @OnThread(value=Tag.FXPlatform)
                public void abort() {
                }

                public Object construct() {
                    MyGameClient client = new MyGameClient(null);
                    List<String> tags = null;
                    try {
                        Object hostAddress = serverURL;
                        if (!((String)hostAddress).endsWith("/")) {
                            hostAddress = (String)hostAddress + "/";
                        }
                        if ((tags = client.getCommonTags((String)hostAddress, ExportPublishTab.this.popTags.length + 1)).contains(ExportPublishTab.WITH_SOURCE_TAG)) {
                            tags.remove(ExportPublishTab.WITH_SOURCE_TAG);
                        } else if (!tags.isEmpty()) {
                            tags.remove(tags.size() - 1);
                        }
                    }
                    catch (ConnectTimeoutException hostAddress) {
                    }
                    catch (IOException e) {
                        Debug.reportError((String)"Error while publishing scenario", (Throwable)e);
                    }
                    return tags;
                }
            };
            commonTagsLoader.start();
        }
        this.setExportButtonText();
    }

    private void setExportButtonText() {
        this.exportDialog.setExportButtonText(Config.getString((String)(this.update ? "export.dialog.update" : "export.dialog.share")));
    }

    @Override
    public boolean prePublish() {
        super.prePublish();
        this.publishedUserName = this.getUserName();
        return true;
    }

    @Override
    public void postPublish(boolean success) {
        if (success) {
            this.scenarioSaver.doSave();
            Config.putPropString((String)"publish.username", (String)this.publishedUserName);
            this.setUpdate(true);
        }
    }

    private static String ensureTrailingSlash(String hostname) {
        if (hostname.endsWith("/")) {
            return hostname;
        }
        return hostname + "/";
    }

    private Pane createScenarioPane() {
        this.titleAndDescPane = new GridPane();
        this.titleAndDescPane.getStyleClass().add((Object)"title-desc-pane");
        ColumnConstraints column1 = new ColumnConstraints();
        column1.setPrefWidth(130.0);
        column1.setHalignment(HPos.RIGHT);
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setPrefWidth(220.0);
        column2.setHgrow(Priority.ALWAYS);
        column2.setHalignment(HPos.CENTER);
        this.titleAndDescPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        VBox iconTextPane = new VBox(new Node[]{new Label(Config.getString((String)"export.publish.image1")), new Label(Config.getString((String)"export.publish.image2"))});
        iconTextPane.getStyleClass().add((Object)"icon-text-pane");
        this.imagePane = new ImageEditPane(120, 70);
        this.titleAndDescPane.addRow(0, new Node[]{iconTextPane, this.imagePane});
        this.keepScenarioScreenshot = new CheckBox(Config.getString((String)"export.snapshot.label"));
        this.keepScenarioScreenshot.setSelected(true);
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.keepScenarioScreenshot.selectedProperty(), selected -> this.imagePane.enableImageEditPanel(selected == false));
        this.titleField = new TextField(this.getTitle() != null ? this.getTitle() : this.project.getProjectName());
        JavaFXUtil.addChangeListenerPlatform((ObservableValue)this.titleField.focusedProperty(), focused -> {
            if (!focused.booleanValue()) {
                this.checkForExistingScenario();
            }
        });
        this.updateLabel.setAlignment(Pos.TOP_LEFT);
        this.updateArea = new TextArea();
        this.updateArea.setPrefRowCount(5);
        this.updateArea.setWrapText(true);
        this.updatePane = new ScrollPane((Node)this.updateArea);
        this.updatePane.setFitToWidth(true);
        GridPane.setVgrow((Node)this.updatePane, (Priority)Priority.ALWAYS);
        this.shortDescriptionField = new TextField();
        this.shortDescriptionLabel.setAlignment(Pos.TOP_LEFT);
        this.longDescriptionArea = new TextArea();
        this.longDescriptionArea.setPrefRowCount(5);
        this.longDescriptionArea.setWrapText(true);
        this.description = new ScrollPane((Node)this.longDescriptionArea);
        this.description.setFitToWidth(true);
        GridPane.setVgrow((Node)this.description, (Priority)Priority.ALWAYS);
        this.chooseNewOrUpdatedScenarioFields();
        Label publishUrlLabel = new Label(Config.getString((String)"export.publish.url"));
        this.urlField = new TextField();
        this.titleAndDescPane.addRow(4, new Node[]{publishUrlLabel, this.urlField});
        this.includeSource = new CheckBox(Config.getString((String)"export.publish.includeSource"));
        this.includeSource.setSelected(false);
        HBox sourceAndLockPane = new HBox(new Node[]{this.includeSource, this.lockScenario});
        sourceAndLockPane.getStyleClass().add((Object)"source-lock-pane");
        VBox scenarioPane = new VBox(new Node[]{this.titleAndDescPane, sourceAndLockPane});
        scenarioPane.getStyleClass().add((Object)"scenario-pane");
        return scenarioPane;
    }

    private void chooseNewOrUpdatedScenarioFields() {
        this.titleAndDescPane.getChildren().removeAll((Object[])new Node[]{this.titleLabel, this.titleField});
        if (this.update) {
            this.titleAndDescPane.getChildren().removeAll((Object[])new Node[]{this.shortDescriptionLabel, this.shortDescriptionField, this.longDescriptionLabel, this.description});
            this.titleAndDescPane.addRow(1, new Node[]{this.emptyLabel, this.keepScenarioScreenshot});
            this.titleAndDescPane.addRow(2, new Node[]{this.titleLabel, this.titleField});
            this.titleAndDescPane.addRow(3, new Node[]{this.updateLabel, this.updatePane});
        } else {
            this.titleAndDescPane.getChildren().removeAll((Object[])new Node[]{this.emptyLabel, this.keepScenarioScreenshot, this.updateLabel, this.updatePane});
            this.titleAndDescPane.addRow(1, new Node[]{this.titleLabel, this.titleField});
            this.titleAndDescPane.addRow(2, new Node[]{this.shortDescriptionLabel, this.shortDescriptionField});
            this.titleAndDescPane.addRow(3, new Node[]{this.longDescriptionLabel, this.description});
        }
        this.imagePane.enableImageEditPanel(!this.update || !this.keepScenarioScreenshot.isSelected());
    }

    private Pane getTagDisplay() {
        Label popLabel = new Label(Config.getString((String)"export.publish.tags.popular"));
        VBox popPane = new VBox(new Node[]{popLabel});
        popPane.getStyleClass().add((Object)"pop-pane");
        for (int i = 0; i < this.popTags.length; ++i) {
            CheckBox popTag = new CheckBox(Config.getString((String)"export.publish.tags.loading"));
            popTag.setDisable(true);
            this.popTags[i] = popTag;
        }
        popPane.getChildren().addAll((Object[])this.popTags);
        this.tagArea = new TextArea();
        ScrollPane tagScroller = new ScrollPane((Node)this.tagArea);
        tagScroller.setPrefSize(125.0, 100.0);
        tagScroller.setFitToWidth(true);
        tagScroller.setFitToHeight(true);
        VBox textPane = new VBox(new Node[]{new Label(Config.getString((String)"export.publish.tags.additional1")), new Label(Config.getString((String)"export.publish.tags.additional2")), tagScroller});
        VBox tagPane = new VBox(new Node[]{popPane, textPane});
        tagPane.getStyleClass().add((Object)"tag-pane");
        return tagPane;
    }

    public boolean isUpdate() {
        return this.update;
    }

    private void setUpdate(boolean isUpdate) {
        if (this.update != isUpdate) {
            this.update = isUpdate;
            this.setExportButtonText();
            this.chooseNewOrUpdatedScenarioFields();
        }
    }
}

