/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.export;

import bluej.Boot;
import bluej.Config;
import bluej.utility.Utility;
import greenfoot.export.Exporter;
import greenfoot.export.mygame.ExportInfo;
import greenfoot.export.mygame.ScenarioInfo;
import greenfoot.guifx.export.ExportLocalTab;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ExportAppTab
extends ExportLocalTab {
    public ExportAppTab(Window parent, ScenarioInfo scenarioInfo, String scenarioName, File defaultExportDir) {
        super(parent, scenarioInfo, scenarioName, defaultExportDir, "app", ".jar");
    }

    @Override
    public Exporter.ExportFunction getFunction() {
        return Exporter.ExportFunction.APP;
    }

    @Override
    protected void buildContentPane(File targetFile) {
        super.buildContentPane(targetFile);
        String sep = Config.isWinOS() ? ";" : ":";
        String javaAndClasspathBefore = "\"" + Config.getJDKExecutablePath(null, (String)"java") + "\" -cp \"" + Utility.urlsToFiles((URL[])Boot.getInstance().getRuntimeUserClassPath()).stream().filter(f -> f.getName().startsWith("javafx")).map(f -> f.getAbsolutePath()).collect(Collectors.joining(sep)) + sep;
        String javaAndClasspathAfter = " greenfoot.export.GreenfootScenarioApplication";
        Hyperlink moreInfo = new Hyperlink(Config.getString((String)"export.app.more"));
        moreInfo.setOnAction(event -> SwingUtilities.invokeLater(() -> Utility.openWebBrowser((String)"https://www.greenfoot.org/doc/run_standalone")));
        Label commandLineExplanation = new Label("Command to run scenario on this machine:");
        TextArea commandLineBox = new TextArea();
        commandLineBox.setWrapText(true);
        commandLineBox.setEditable(false);
        commandLineBox.textProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{javaAndClasspathBefore, this.targetDirField.textProperty(), javaAndClasspathAfter}));
        Button copyButton = new Button(Config.getString((String)"editor.copyLabel"));
        copyButton.setOnAction(e -> Clipboard.getSystemClipboard().setContent(Map.of(DataFormat.PLAIN_TEXT, commandLineBox.getSelectedText().isEmpty() ? commandLineBox.getText() : commandLineBox.getSelectedText())));
        BorderPane.setAlignment((Node)copyButton, (Pos)Pos.CENTER);
        BorderPane.setMargin((Node)copyButton, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        BorderPane borderPane = new BorderPane((Node)commandLineBox, (Node)commandLineExplanation, (Node)copyButton, (Node)moreInfo, null);
        ((Pane)this.getContent()).getChildren().addAll((Object[])new Node[]{borderPane, this.lockScenario, this.hideControls});
    }

    @Override
    protected ExportInfo getExportInfo() {
        ExportInfo info = super.getExportInfo();
        info.setLocked(this.isLockScenario());
        info.setHideControls(this.isHideControls());
        return info;
    }
}

