/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.guifx.classes;

import bluej.Config;
import bluej.debugger.gentype.Reflective;
import bluej.editor.Editor;
import bluej.extensions2.SourceType;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.actions.ConvertToJavaAction;
import bluej.pkgmgr.target.actions.ConvertToStrideAction;
import bluej.pkgmgr.target.actions.InspectAction;
import bluej.pkgmgr.target.role.UnitTestClassRole;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import bluej.utility.javafx.AbstractOperation;
import bluej.utility.javafx.FXPlatformConsumer;
import bluej.utility.javafx.JavaFXUtil;
import greenfoot.guifx.GreenfootStage;
import greenfoot.guifx.classes.ClassDisplay;
import greenfoot.guifx.classes.GClassDiagram;
import greenfoot.guifx.classes.GClassNode;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.image.Image;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class LocalGClassNode
extends GClassNode
implements DependentTarget.TargetListener,
AbstractOperation.ContextualItem<LocalGClassNode> {
    private final GClassDiagram.GClassType type;
    private GClassDiagram classDiagram;
    private final ClassTarget classTarget;
    private String imageFilename;

    public LocalGClassNode(GClassDiagram classDiagram, ClassTarget classTarget, List<GClassNode> subClasses, GClassDiagram.GClassType type) {
        super(LocalGClassNode.getImageForClass(classTarget, type), subClasses, classDiagram.getSelectionManager());
        this.imageFilename = classTarget.getPackage().getLastSavedProperties().getProperty("class." + classTarget.getQualifiedName() + ".image");
        this.classDiagram = classDiagram;
        this.classTarget = classTarget;
        this.type = type;
        this.setImageForEditor();
    }

    @Override
    public String getQualifiedName() {
        return this.classTarget.getQualifiedName();
    }

    @Override
    public String getDisplayName() {
        return this.classTarget.getBaseName();
    }

    private static Image getImageForClass(ClassTarget classTarget, GClassDiagram.GClassType type) {
        if (type == GClassDiagram.GClassType.OTHER) {
            return null;
        }
        return JavaFXUtil.loadImage((File)LocalGClassNode.getImageFilename(classTarget));
    }

    private static File getImageFilename(ClassTarget ct) {
        String className = ct.getQualifiedName();
        Reflective type = ct.getTypeReflective();
        Package pkg = ct.getPackage();
        do {
            String imageFileName;
            if ((imageFileName = pkg.getLastSavedProperties().getProperty("class." + className + ".image")) != null) {
                File imageDir = new File(pkg.getProject().getProjectDir(), "images");
                return new File(imageDir, imageFileName);
            }
            if (type == null) continue;
            String string = className = (type = (Reflective)type.getSuperTypesR().stream().filter(t -> !t.isInterface()).findFirst().orElse(null)) != null ? type.getName() : null;
        } while (type != null);
        return null;
    }

    @Override
    protected void setupClassDisplay(GreenfootStage greenfootStage, ClassDisplay display) {
        display.setOnContextMenuRequested(e -> {
            e.consume();
            this.showContextMenu(greenfootStage, display, (ContextMenuEvent)e);
        });
        display.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2) {
                this.classTarget.open();
            }
        });
        this.classTarget.addListener((DependentTarget.TargetListener)this);
        this.stateChanged(this.classTarget.getState());
    }

    public void editorOpened() {
        this.setImageForEditor();
    }

    private void setImageForEditor() {
        Editor editor = this.classTarget.getEditorIfOpen();
        if (editor != null) {
            editor.setHeaderImage(this.image);
        }
    }

    @Override
    protected void setImage(Image newImage) {
        super.setImage(newImage);
        this.setImageForEditor();
    }

    public void stateChanged(DependentTarget.State newState) {
        this.display.setStripePattern((Paint)(switch (newState) {
            case DependentTarget.State.NEEDS_COMPILE -> ClassTarget.getGreyStripeFill();
            case DependentTarget.State.HAS_ERROR -> ClassTarget.getRedStripeFill();
            default -> Color.TRANSPARENT;
        }));
        if (newState != DependentTarget.State.COMPILED) {
            this.classDiagram.getGreenfootStage().classModified();
        }
    }

    public void renamed(String newName) {
        this.classDiagram.getGreenfootStage().saveAndMirrorClassImageFilename(newName, this.getImageFilename());
        this.classDiagram.recalculateGroups();
    }

    @Override
    public void tidyup() {
        super.tidyup();
        this.classTarget.removeListener((DependentTarget.TargetListener)this);
    }

    @OnThread(value=Tag.FXPlatform)
    private void showContextMenu(GreenfootStage greenfootStage, ClassDisplay display, ContextMenuEvent e) {
        if (this.curContextMenu != null) {
            this.curContextMenu.hide();
            this.curContextMenu = null;
            this.classDiagram.hideContextMenu();
        }
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getScene().setOnMouseMoved(ev -> greenfootStage.setLatestMousePosOnScreen(ev.getScreenX(), ev.getScreenY()));
        contextMenu.getItems().addAll((Collection)AbstractOperation.SortedMenuItem.sortAndAddDividers((ObservableList)AbstractOperation.getMenuItems(List.of(this), (boolean)true).getItems(), List.of()));
        this.classDiagram.getSelectionManager().select(display);
        contextMenu.show((Node)display, e.getScreenX(), e.getScreenY());
        this.curContextMenu = contextMenu;
    }

    public List<AbstractOperation<LocalGClassNode>> getContextOperations() {
        Class cl = null;
        if (this.classTarget.isCompiled()) {
            cl = this.classTarget.getPackage().loadClass(this.classTarget.getQualifiedName());
        }
        ArrayList<AbstractOperation<LocalGClassNode>> ops = new ArrayList<AbstractOperation<LocalGClassNode>>();
        if (cl != null) {
            ops.addAll(this.proxyAll(this.classTarget.getRole().getClassConstructorOperations(this.classTarget, cl)));
            ops.addAll(this.proxyAll(this.classTarget.getRole().getClassStaticOperations(this.classTarget, cl)));
        } else {
            ops.add(this.proxy((AbstractOperation<? super ClassTarget>)new UnitTestClassRole.DummyDisabledOperation(Config.getString((String)"classPopup.needsCompile"), AbstractOperation.MenuItemOrder.COMPILE)));
        }
        if (this.classTarget.hasSourceCode() || this.classTarget.getDocumentationFile().exists()) {
            ops.add(GClassDiagram.contextInbuiltOp("open", Config.getString((String)(this.classTarget.hasSourceCode() ? "edit.class" : "show.apidoc")), AbstractOperation.MenuItemOrder.EDIT, (FXPlatformConsumer<LocalGClassNode>)((FXPlatformConsumer)n -> n.classTarget.open())));
        }
        if (this.type == GClassDiagram.GClassType.ACTOR || this.type == GClassDiagram.GClassType.WORLD) {
            ops.add(GClassDiagram.contextInbuiltOp("setImage", Config.getString((String)"select.image"), AbstractOperation.MenuItemOrder.SET_IMAGE, (FXPlatformConsumer<LocalGClassNode>)((FXPlatformConsumer)n -> n.classDiagram.getGreenfootStage().setImageFor((LocalGClassNode)n))));
        }
        if (cl != null) {
            ops.add(this.proxy((AbstractOperation<? super ClassTarget>)new InspectAction((Node)this.display)));
        }
        if (this.classTarget.hasSourceCode()) {
            ops.add(GClassDiagram.contextInbuiltOp("duplicate", Config.getString((String)"duplicate.class"), AbstractOperation.MenuItemOrder.DUPLICATE, (FXPlatformConsumer<LocalGClassNode>)((FXPlatformConsumer)n -> n.classDiagram.getGreenfootStage().duplicateClass((LocalGClassNode)n, n.classTarget))));
        }
        ops.add(GClassDiagram.contextInbuiltOp("remove", Config.getString((String)"remove.class"), AbstractOperation.MenuItemOrder.REMOVE, (FXPlatformConsumer<LocalGClassNode>)((FXPlatformConsumer)n -> {
            if (DialogManager.askQuestionFX((Window)n.classDiagram.getGreenfootStage().getScene().getWindow(), (String)"really-remove-class") == 0) {
                n.classTarget.remove();
                n.classDiagram.recalculateGroups();
                n.classDiagram.getGreenfootStage().fireWorldRemovedCheck(n.classTarget);
            }
        })));
        if (this.classTarget.getSourceType() == SourceType.Stride) {
            ops.add(this.proxy((AbstractOperation<? super ClassTarget>)new ConvertToJavaAction((Window)this.classDiagram.getGreenfootStage())));
        } else if (this.classTarget.getSourceType() == SourceType.Java && this.classTarget.getRole() != null && this.classTarget.getRole().canConvertToStride()) {
            ops.add(this.proxy((AbstractOperation<? super ClassTarget>)new ConvertToStrideAction((Window)this.classDiagram.getGreenfootStage())));
        }
        boolean isFinal = false;
        if (cl != null) {
            isFinal = Modifier.isFinal(cl.getModifiers());
        } else {
            Reflective ctReflective = this.classTarget.getTypeReflective();
            if (ctReflective != null) {
                isFinal = ctReflective.isFinal();
            }
        }
        if (!isFinal) {
            ops.add(GClassDiagram.contextInbuiltOp("newSubclass", Config.getString((String)"new.sub.class"), AbstractOperation.MenuItemOrder.NEW_SUBCLASS, (FXPlatformConsumer<LocalGClassNode>)((FXPlatformConsumer)n -> n.classDiagram.getGreenfootStage().newSubClassOf(n.classTarget.getQualifiedName(), n.type))));
        }
        return ops;
    }

    @Override
    public String getImageFilename() {
        return this.imageFilename;
    }

    public void setImageFilename(String newImageFilename) {
        this.imageFilename = newImageFilename;
        if (newImageFilename != null) {
            File imageDir = new File(this.classTarget.getPackage().getProject().getProjectDir(), "images");
            File imageFile = new File(imageDir, this.imageFilename);
            this.setImage(JavaFXUtil.loadImage((File)imageFile));
        } else {
            this.setImage(null);
        }
    }

    public ClassTarget getClassTarget() {
        return this.classTarget;
    }

    private AbstractOperation<LocalGClassNode> proxy(final AbstractOperation<? super ClassTarget> op) {
        return new AbstractOperation<LocalGClassNode>(op.getIdentifier(), op.combine(), op.getShortcut()){

            public void activate(List<LocalGClassNode> localGClassNodes) {
                op.activate(Utility.mapList(localGClassNodes, n -> n.classTarget));
            }

            public List<AbstractOperation.ItemLabel> getLabels() {
                return op.getLabels();
            }

            public List<String> getStyleClasses() {
                return op.getStyleClasses();
            }
        };
    }

    private List<AbstractOperation<LocalGClassNode>> proxyAll(List<? extends AbstractOperation<? super ClassTarget>> ops) {
        return Utility.mapList(ops, this::proxy);
    }
}

