/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input.mouse;

import greenfoot.Actor;
import greenfoot.MouseInfo;
import greenfoot.MouseInfoVisitor;
import greenfoot.World;
import greenfoot.gui.input.mouse.WorldLocator;
import java.util.Arrays;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
class MouseEventData {
    private MouseInfo mouseInfo;
    private MouseInfo mouseDragEndedInfo;
    private MouseInfo mouseClickedInfo;
    private MouseInfo mousePressedInfo;
    private MouseInfo mouseDraggedInfo;
    private MouseInfo mouseMovedInfo;
    private MouseEventData dragStartedBy;

    MouseEventData() {
    }

    public void init() {
        this.mousePressedInfo = null;
        this.mouseClickedInfo = null;
        this.mouseDraggedInfo = null;
        this.mouseDragEndedInfo = null;
        this.mouseMovedInfo = null;
        if (this.mouseInfo != null) {
            MouseInfo blankedMouseInfo = MouseInfoVisitor.newMouseInfo();
            MouseInfoVisitor.setLoc(blankedMouseInfo, this.mouseInfo.getX(), this.mouseInfo.getY(), MouseInfoVisitor.getPx(this.mouseInfo), MouseInfoVisitor.getPy(this.mouseInfo));
            this.mouseInfo = blankedMouseInfo;
        }
    }

    public MouseInfo getMouseInfo() {
        return this.mouseInfo;
    }

    public boolean isMousePressed() {
        return this.mousePressedInfo != null;
    }

    public boolean isMousePressedOn(Object obj) {
        return this.checkObject(obj, this.mousePressedInfo);
    }

    public void mousePressed(int x, int y, int px, int py, int button) {
        this.init();
        this.mouseInfo = this.mousePressedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y, px, py);
    }

    public boolean isMouseClickedOn(Object obj) {
        if (obj != null && this.isMousePressed() && !this.isMousePressedOn(obj)) {
            return false;
        }
        return this.checkObject(obj, this.mouseClickedInfo);
    }

    public boolean isMouseClicked() {
        return this.mouseClickedInfo != null;
    }

    public void mouseClicked(int x, int y, int px, int py, int button, int clickCount) {
        MouseInfo tempPressedInfo = this.mousePressedInfo;
        this.init();
        this.mousePressedInfo = tempPressedInfo;
        this.mouseInfo = this.mouseClickedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y, px, py);
        MouseInfoVisitor.setClickCount(this.mouseInfo, clickCount);
    }

    public boolean isMouseDragged() {
        return this.mouseDraggedInfo != null;
    }

    public boolean isMouseDraggedOn(Object obj) {
        return this.checkObject(obj, this.mouseDraggedInfo);
    }

    public void mouseDragged(int x, int y, int px, int py, int button, Actor actor) {
        this.init();
        this.mouseInfo = this.mouseDraggedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y, px, py);
        MouseInfoVisitor.setActor(this.mouseInfo, actor);
    }

    public boolean isMouseDragEnded() {
        return this.mouseDragEndedInfo != null;
    }

    public boolean isMouseDragEndedOn(Object obj) {
        return this.checkObject(obj, this.mouseDragEndedInfo);
    }

    public void mouseDragEnded(int x, int y, int px, int py, int button, MouseEventData dragStartData) {
        MouseInfo tempPressedInfo = this.mousePressedInfo;
        MouseInfo tempClickedInfo = this.mouseClickedInfo;
        this.init();
        this.mousePressedInfo = tempPressedInfo;
        this.mouseClickedInfo = tempClickedInfo;
        this.mouseInfo = this.mouseDragEndedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setButton(this.mouseInfo, button);
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y, px, py);
        MouseInfoVisitor.setActor(this.mouseInfo, dragStartData.getActor());
        this.dragStartedBy = dragStartData;
    }

    public void mouseExited() {
        this.mouseInfo = this.mouseDraggedInfo;
        this.mouseMovedInfo = null;
    }

    public boolean isMouseMoved() {
        return this.mouseMovedInfo != null;
    }

    public boolean isMouseMovedOn(Object obj) {
        return this.checkObject(obj, this.mouseMovedInfo);
    }

    public void mouseMoved(int x, int y, int px, int py) {
        this.init();
        this.mouseInfo = this.mouseMovedInfo = MouseInfoVisitor.newMouseInfo();
        MouseInfoVisitor.setLoc(this.mouseInfo, x, y, px, py);
    }

    public Actor getActor() {
        if (this.mouseInfo == null) {
            return null;
        }
        return this.mouseInfo.getActor();
    }

    public int getButton() {
        if (this.mouseInfo == null) {
            return 0;
        }
        return this.mouseInfo.getButton();
    }

    private boolean checkObject(Object obj, MouseInfo info) {
        if (info == null) {
            return false;
        }
        Actor actor = info.getActor();
        return obj == null || obj instanceof World && actor == null || actor == obj;
    }

    public String toString() {
        Object s = "MouseEventData ";
        if (this.mouseInfo != null) {
            s = (String)s + this.mouseInfo.toString();
        }
        if (this.mousePressedInfo != null) {
            s = (String)s + " pressed";
        }
        if (this.mouseClickedInfo != null) {
            s = (String)s + " clicked";
        }
        if (this.mouseDraggedInfo != null) {
            s = (String)s + " dragged";
        }
        if (this.mouseDragEndedInfo != null) {
            s = (String)s + " dragEnded";
        }
        if (this.mouseMovedInfo != null) {
            s = (String)s + " moved";
        }
        return s;
    }

    @OnThread(value=Tag.Simulation)
    public void setActors(WorldLocator locator) {
        for (MouseInfo info : Arrays.asList(this.mouseInfo, this.mouseClickedInfo, this.mouseDragEndedInfo, this.mouseMovedInfo, this.mousePressedInfo, this.mouseDraggedInfo)) {
            if (info == null || info.getActor() != null) continue;
            int x = MouseInfoVisitor.getPx(info);
            int y = MouseInfoVisitor.getPy(info);
            MouseInfoVisitor.setActor(info, locator.getTopMostActorAt(x, y));
        }
    }

    public void setDragStartActor(MouseEventData dragStartData) {
        if (this.mouseDragEndedInfo != null && this.dragStartedBy == dragStartData) {
            MouseInfoVisitor.setActor(this.mouseDragEndedInfo, dragStartData.getActor());
        }
    }
}

