/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.export.mygame;

import bluej.Config;
import greenfoot.event.PublishEvent;
import greenfoot.event.PublishListener;
import greenfoot.export.mygame.ExportInfo;
import greenfoot.export.mygame.ProgressTrackingPart;
import greenfoot.export.mygame.ScenarioInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MyGameClient {
    private PublishListener listener;

    public MyGameClient(PublishListener listener) {
        this.listener = listener;
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.NoOpLog");
    }

    public final MyGameClient submit(String hostAddress, String uid, String password, String jarFileName, File sourceFile, File screenshotFile, int width, int height, ExportInfo info) throws IOException {
        Object defProxy;
        String[] authDetails;
        DefaultHttpClient httpClient = this.getHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)20000);
        HttpPost postMethod = new HttpPost(hostAddress + "account/authenticate");
        MultipartEntity postParams = new MultipartEntity();
        Charset utf8 = StandardCharsets.UTF_8;
        postParams.addPart(new FormBodyPart("user[username]", (ContentBody)new StringBody(uid, utf8)));
        postParams.addPart(new FormBodyPart("user[password]", (ContentBody)new StringBody(password, utf8)));
        postMethod.setEntity((HttpEntity)postParams);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)postMethod);
        int response = httpResponse.getStatusLine().getStatusCode();
        if (response == 407 && this.listener != null && (authDetails = this.listener.needProxyAuth()) != null && (defProxy = httpClient.getParams().getParameter("http.route.default-proxy")) instanceof HttpHost) {
            HttpHost proxy = (HttpHost)defProxy;
            AuthScope authScope = new AuthScope(proxy.getHostName(), proxy.getPort());
            UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(authDetails[0], authDetails[1]);
            httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)proxyCreds);
            httpResponse = httpClient.execute((HttpUriRequest)postMethod);
            response = httpResponse.getStatusLine().getStatusCode();
        }
        if (response > 400) {
            this.error(Config.getString((String)"export.publish.errorResponse") + " - " + response);
            httpClient.getConnectionManager().shutdown();
            return this;
        }
        if (!this.handleResponse(httpResponse)) {
            httpClient.getConnectionManager().shutdown();
            return this;
        }
        EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        List<String> tagsList = info.getTags();
        boolean hasSource = sourceFile != null;
        HashMap<String, String> partsMap = new HashMap<String, String>();
        if (info.isUpdate()) {
            partsMap.put("scenario[update_description]", info.getUpdateDescription());
        } else {
            partsMap.put("scenario[long_description]", info.getLongDescription());
            partsMap.put("scenario[short_description]", info.getShortDescription());
        }
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart(new FormBodyPart("scenario[title]", (ContentBody)new StringBody(info.getTitle(), utf8)));
        mpe.addPart(new FormBodyPart("scenario[main_class]", (ContentBody)new StringBody("greenfoot.export.GreenfootScenarioViewer", utf8)));
        mpe.addPart(new FormBodyPart("scenario[width]", (ContentBody)new StringBody("" + width, utf8)));
        mpe.addPart(new FormBodyPart("scenario[height]", (ContentBody)new StringBody("" + height, utf8)));
        mpe.addPart(new FormBodyPart("scenario[url]", (ContentBody)new StringBody(info.getUrl(), utf8)));
        mpe.addPart((FormBodyPart)new ProgressTrackingPart("scenario[uploaded_data]", new File(jarFileName), this));
        for (String key : partsMap.keySet()) {
            mpe.addPart(new FormBodyPart(key, (ContentBody)new StringBody((String)partsMap.get(key), utf8)));
        }
        if (hasSource) {
            mpe.addPart((FormBodyPart)new ProgressTrackingPart("scenario[source_data]", sourceFile, this));
        }
        if (screenshotFile != null) {
            mpe.addPart((FormBodyPart)new ProgressTrackingPart("scenario[screenshot_data]", screenshotFile, this));
        }
        int tagNum = 0;
        for (String tag : tagsList) {
            mpe.addPart(new FormBodyPart("scenario[tag" + tagNum++ + "]", (ContentBody)new StringBody(tag, utf8)));
        }
        postMethod = new HttpPost(hostAddress + "upload-scenario");
        postMethod.setEntity((HttpEntity)mpe);
        httpResponse = httpClient.execute((HttpUriRequest)postMethod);
        response = httpResponse.getStatusLine().getStatusCode();
        if (response > 400) {
            this.error(Config.getString((String)"export.publish.errorResponse") + " - " + response);
            httpClient.getConnectionManager().shutdown();
            return this;
        }
        if (!this.handleResponse(httpResponse)) {
            httpClient.getConnectionManager().shutdown();
            return this;
        }
        EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        this.listener.uploadComplete(new PublishEvent(1));
        httpClient.getConnectionManager().shutdown();
        return this;
    }

    private boolean handleResponse(HttpResponse postMethod) {
        Header statusHeader = postMethod.getLastHeader("X-mygame-status");
        if (statusHeader == null) {
            this.error(Config.getString((String)"export.publish.errorResponse"));
            return false;
        }
        String responseString = statusHeader.getValue();
        int spaceIndex = responseString.indexOf(" ");
        if (spaceIndex == -1) {
            this.error(Config.getString((String)"export.publish.errorResponse"));
            return false;
        }
        try {
            int statusCode = Integer.parseInt(responseString.substring(0, spaceIndex));
            switch (statusCode) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.error(Config.getString((String)"export.publish.errorPassword"));
                    return false;
                }
                case 2: {
                    this.error(Config.getString((String)"export.publish.errorTooLarge"));
                    return false;
                }
            }
            this.error(responseString.substring(spaceIndex + 1));
            return false;
        }
        catch (NumberFormatException nfe) {
            this.error(Config.getString((String)"export.publish.errorResponse"));
            return false;
        }
    }

    private DefaultHttpClient getHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
        DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)params);
        String proxyHost = Config.getPropString((String)"proxy.host", null);
        String proxyPortStr = Config.getPropString((String)"proxy.port", null);
        if (proxyHost != null && proxyHost.length() != 0 && proxyPortStr != null) {
            int proxyPort = 80;
            try {
                proxyPort = Integer.parseInt(proxyPortStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort, "http");
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            String proxyUser = Config.getPropString((String)"proxy.user", null);
            String proxyPass = Config.getPropString((String)"proxy.password", null);
            if (proxyUser != null) {
                AuthScope authScope = new AuthScope(proxyHost, proxyPort);
                UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUser, proxyPass);
                httpClient.getCredentialsProvider().setCredentials(authScope, (Credentials)proxyCreds);
            }
        }
        return httpClient;
    }

    public boolean checkExistingScenario(String hostAddress, String uid, String gameName, ScenarioInfo info) throws IOException {
        DefaultHttpClient client = this.getHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)20000);
        String encodedName = URLEncoder.encode(gameName, "UTF-8");
        encodedName = encodedName.replace("+", "%20");
        HttpGet getMethod = new HttpGet(hostAddress + "user/" + uid + "/check_scenario/" + encodedName);
        HttpResponse httpResponse = client.execute((HttpUriRequest)getMethod);
        int response = httpResponse.getStatusLine().getStatusCode();
        if (response > 400) {
            throw new IOException("HTTP error response " + response + " from server.");
        }
        Header statusHeader = httpResponse.getLastHeader("X-mygame-scenario");
        if (statusHeader == null) {
            throw new IOException("X-mygame-scenario header missing from server response");
        }
        if (!statusHeader.getValue().equals("0 FOUND")) {
            return false;
        }
        if (info != null) {
            InputStream responseStream = httpResponse.getEntity().getContent();
            this.parseScenarioXml(info, responseStream);
            info.setTitle(gameName);
        }
        return true;
    }

    private void parseScenarioXml(ScenarioInfo info, InputStream xmlStream) throws IOException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            Document doc = dbuilder.parse(xmlStream);
            Element root = doc.getDocumentElement();
            if (root == null || !root.getTagName().equals("scenario")) {
                return;
            }
            NodeList children = root.getChildNodes();
            block17: for (int i = 0; i < children.getLength(); ++i) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() != 1) continue;
                Element element = (Element)childNode;
                switch (element.getTagName()) {
                    case "shortdescription": {
                        info.setShortDescription(element.getTextContent());
                        continue block17;
                    }
                    case "longdescription": {
                        info.setLongDescription(element.getTextContent());
                        continue block17;
                    }
                    case "taglist": {
                        info.setTags(this.parseTagListXmlElement(element));
                        continue block17;
                    }
                    case "webpage": {
                        info.setUrl(element.getTextContent());
                        continue block17;
                    }
                    case "hassource": {
                        info.setIncludeSource(element.getTextContent().equals("true"));
                    }
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private List<String> parseTagListXmlElement(Element element) {
        ArrayList<String> tags = new ArrayList<String>();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals("tag")) continue;
            tags.add(element.getTextContent());
        }
        return tags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getCommonTags(String hostAddress, int maxNumberOfTags) throws UnknownHostException, IOException {
        HttpGet getMethod;
        DefaultHttpClient client = this.getHttpClient();
        HttpResponse httpResponse = client.execute((HttpUriRequest)(getMethod = new HttpGet(hostAddress + "common-tags/" + maxNumberOfTags)));
        int response = httpResponse.getStatusLine().getStatusCode();
        if (response > 400) {
            throw new IOException("HTTP error response " + response + " from server.");
        }
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document doc = documentBuilder.parse(responseStream);
            Element root = doc.getDocumentElement();
            if (root == null || !root.getTagName().equals("taglist")) {
                List<String> list2 = Collections.emptyList();
                return list2;
            }
            List<String> list = this.parseTagListXmlElement(root);
            return list;
        }
        catch (ParserConfigurationException | SAXException exception) {
            return Collections.emptyList();
        }
    }

    private void error(String s) {
        this.listener.errorRecieved(new PublishEvent(s, 0));
    }

    public void progress(int bytes) {
        this.listener.progressMade(new PublishEvent(bytes, 2));
    }

    public String[] promptProxyAuth() {
        return this.listener.needProxyAuth();
    }
}

