/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx.binding;

import bluej.utility.javafx.MultiListener;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class DeepListBinding<DEST> {
    private final ObservableList<DEST> dest;
    private final MultiListener<ObservableList<?>> multiListener;

    public DeepListBinding(ObservableList<DEST> dest) {
        this.dest = dest;
        ListChangeListener listener = c -> this.update();
        this.multiListener = new MultiListener<ObservableList>(l -> {
            l.addListener(listener);
            return () -> l.removeListener(listener);
        });
    }

    public void startListening() {
        this.update();
    }

    protected abstract Stream<ObservableList<?>> getListenTargets();

    protected abstract Stream<DEST> calculateValues();

    protected void update() {
        this.multiListener.listenOnlyTo(this.getListenTargets());
        this.dest.setAll((Collection)this.calculateValues().collect(Collectors.toList()));
    }
}

