/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility.javafx;

import bluej.utility.javafx.FXPlatformRunnable;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.util.Duration;

public class SharedTransition {
    private final List<FXPlatformRunnable> onStopped = new ArrayList<FXPlatformRunnable>();
    private final DoubleProperty progress = new SimpleDoubleProperty(0.0);
    private final DoubleExpression opposite = this.progress.negate().add(1.0);
    private Timeline timeline;
    private boolean runStopped;

    public DoubleExpression getProgress() {
        return this.progress;
    }

    public DoubleExpression getOppositeProgress() {
        return this.opposite;
    }

    public void addOnStopped(FXPlatformRunnable stopped) {
        this.onStopped.add(stopped);
    }

    public void animateOver(Duration duration) {
        if (this.timeline != null) {
            throw new IllegalStateException("Cannot animate SharedTransition more than one time");
        }
        this.timeline = new Timeline(new KeyFrame[]{new KeyFrame(duration, e -> {
            if (!this.runStopped) {
                this.runStopped = true;
                this.onStopped.forEach(FXPlatformRunnable::run);
            }
        }, new KeyValue[]{new KeyValue((WritableValue)this.progress, (Object)1.0, Interpolator.EASE_BOTH)})});
        this.timeline.play();
    }

    public void stop() {
        if (this.timeline == null) {
            throw new IllegalStateException("Cannot stop SharedTransition before it is started");
        }
        this.timeline.stop();
        this.progress.set(1.0);
        if (!this.runStopped) {
            this.runStopped = true;
            this.onStopped.forEach(FXPlatformRunnable::run);
        }
    }
}

